package com.ejie.ab59.service.configuracionInicioOficio;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.dao.configuracionInicioOficio.RelIniOfiAlcResDao;
import com.ejie.ab59.model.configuracionInicioOficio.RelIniOfiAlcRes;
import com.ejie.ab59.model.tablasMaestras.ConfIniOfi;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * RelIniOfiAlcResServiceImpl  
 * 
 *  
 */

@Service(value = "relIniOfiAlcResService")
public class RelIniOfiAlcResServiceImpl implements RelIniOfiAlcResService {

	@Autowired
	private RelIniOfiAlcResDao relIniOfiAlcResDao;

	/**
	 * Inserts a single row in the RelIniOfiAlcRes table.
	 *
	 * @param relIniOfiAlcRes
	 *            RelIniOfiAlcRes
	 * @return RelIniOfiAlcRes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RelIniOfiAlcRes add(RelIniOfiAlcRes relIniOfiAlcRes) {
		return this.relIniOfiAlcResDao.add(relIniOfiAlcRes);
	}

	/**
	 * Updates a single row in the RelIniOfiAlcRes table.
	 *
	 * @param relIniOfiAlcRes
	 *            RelIniOfiAlcRes
	 * @return RelIniOfiAlcRes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RelIniOfiAlcRes update(RelIniOfiAlcRes relIniOfiAlcRes) {
		return this.relIniOfiAlcResDao.update(relIniOfiAlcRes);
	}

	/**
	 * Finds a single row in the RelIniOfiAlcRes table.
	 *
	 * @param relIniOfiAlcRes
	 *            RelIniOfiAlcRes
	 * @return RelIniOfiAlcRes
	 */
	public RelIniOfiAlcRes find(RelIniOfiAlcRes relIniOfiAlcRes) {
		return (RelIniOfiAlcRes) this.relIniOfiAlcResDao.find(relIniOfiAlcRes);
	}

	/**
	 * Deletes a single row in the RelIniOfiAlcRes table.
	 *
	 * @param relIniOfiAlcRes
	 *            RelIniOfiAlcRes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(RelIniOfiAlcRes relIniOfiAlcRes) {
		this.relIniOfiAlcResDao.remove(relIniOfiAlcRes);
	}

	/**
	 * Deletes a single row in the RelIniOfiAlcRes table.
	 *
	 * @param relIniOfiAlcRes
	 *            RelIniOfiAlcRes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeByConfIniOfi(ConfIniOfi confIniOfi) {
		this.relIniOfiAlcResDao.removeByConfIniOfi(confIniOfi);
	}

	/**
	 * Finds a list of rows in the ConfIniOfi table.
	 *
	 * @param relIniOfiAlcRes
	 *            RelIniOfiAlcRes
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<ConfIniOfi>
	 */
	public List<RelIniOfiAlcRes> findAll(RelIniOfiAlcRes relIniOfiAlcRes, TableRequestDto tableRequestDto) {
		return (List<RelIniOfiAlcRes>) this.relIniOfiAlcResDao.findAll(relIniOfiAlcRes, tableRequestDto);
	}

	@Override
	public TableResponseDto<RelIniOfiAlcRes> filter(RelIniOfiAlcRes filterRelIniOfiAlcRes,
			TableRequestDto tableRequestDto) {

		List<RelIniOfiAlcRes> listaRelIniOfiAlcRes = this.relIniOfiAlcResDao.findAll(filterRelIniOfiAlcRes,
				tableRequestDto);
		Long recordNum = this.relIniOfiAlcResDao
				.findAllCount(filterRelIniOfiAlcRes != null ? filterRelIniOfiAlcRes : new RelIniOfiAlcRes());

		return new TableResponseDto<RelIniOfiAlcRes>(tableRequestDto, recordNum, listaRelIniOfiAlcRes);

	}

}
