package com.ejie.ab59.service.configuracionInicioOficio;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.clientesWS.ab61WebService.Firmantes;
import com.ejie.ab59.dao.configuracionInicioOficio.FirmantesDao;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * FirmantesServiceImpl  
 * 
 *  
 */

@Service(value = "firmantesService")
public class FirmantesServiceImpl implements FirmantesService {

	@Autowired
	private FirmantesDao firmantesDao;

	/**
	 * Inserts a single row in the Firmantes table.
	 *
	 * @param firmantes
	 *            Firmantes
	 * @return Firmantes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Firmantes add(Firmantes firmantes) {
		return this.firmantesDao.add(firmantes);
	}

	/**
	 * Updates a single row in the Firmantes table.
	 *
	 * @param firmantes
	 *            Firmantes
	 * @return Firmantes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Firmantes update(Firmantes firmantes) {
		return this.firmantesDao.update(firmantes);
	}

	/**
	 * Finds a single row in the Firmantes table.
	 *
	 * @param firmantes
	 *            Firmantes
	 * @return Firmantes
	 */
	public Firmantes find(Firmantes firmantes) {
		return (Firmantes) this.firmantesDao.find(firmantes);
	}

	/**
	 * Deletes a single row in the Firmantes table.
	 *
	 * @param firmantes
	 *            Firmantes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Firmantes firmantes) {
		this.firmantesDao.remove(firmantes);
	}

	/**
	 * Finds a list of rows in the Firmantes table.
	 *
	 * @param firmantes
	 *            Firmantes
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Firmantes>
	 */
	public List<Firmantes> findAll(Firmantes firmantes, TableRequestDto tableRequestDto) {
		return (List<Firmantes>) this.firmantesDao.findAll(firmantes, tableRequestDto);
	}

	/**
	 * Filter method in the Firmantes table.
	 *
	 * @param filterFirmantes
	 *            Firmantes
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Firmantes>
	 */
	public TableResponseDto<Firmantes> filter(Firmantes filterFirmantes, TableRequestDto tableRequestDto,
			Boolean startsWith) {

		List<Firmantes> listaTiposFinalizacion = this.firmantesDao.findAll(filterFirmantes, tableRequestDto);
		Long recordNum = this.firmantesDao.findAllCount(filterFirmantes != null ? filterFirmantes : new Firmantes());

		return new TableResponseDto<Firmantes>(tableRequestDto, recordNum, listaTiposFinalizacion);
	}

}
