package com.ejie.ab59.service.configuracionInicioOficio;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.dao.configuracionInicioOficio.AlcancesResolucionDao;
import com.ejie.ab59.model.configuracionInicioOficio.AlcancesResolucion;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * AlcancesResolucionServiceImpl  
 * 
 *  
 */

@Service(value = "alcancesResolucionService")
public class AlcancesResolucionServiceImpl implements AlcancesResolucionService {

	@Autowired
	private AlcancesResolucionDao alcancesResolucionDao;

	/**
	 * Updates a single row in the AlcancesResolucion table.
	 *
	 * @param alcancesResolucion
	 *            AlcancesResolucion
	 * @return AlcancesResolucion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AlcancesResolucion update(AlcancesResolucion alcancesResolucion) {
		return this.alcancesResolucionDao.update(alcancesResolucion);
	}

	/**
	 * Finds a single row in the AlcancesResolucion table.
	 *
	 * @param alcancesResolucion
	 *            AlcancesResolucion
	 * @return AlcancesResolucion
	 */
	public AlcancesResolucion find(AlcancesResolucion alcancesResolucion) {
		return (AlcancesResolucion) this.alcancesResolucionDao.find(alcancesResolucion);
	}

	/**
	 * Deletes a single row in the AlcancesResolucion table.
	 *
	 * @param alcancesResolucion
	 *            AlcancesResolucion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(AlcancesResolucion alcancesResolucion) {
		this.alcancesResolucionDao.remove(alcancesResolucion);
	}

	/**
	 * Finds a list of rows in the AlcancesResolucion table.
	 *
	 * @param alcancesResolucion
	 *            AlcancesResolucion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<AlcancesResolucion>
	 */
	public List<AlcancesResolucion> findAll(AlcancesResolucion alcancesResolucion, TableRequestDto tableRequestDto) {
		return (List<AlcancesResolucion>) this.alcancesResolucionDao.findAll(alcancesResolucion, tableRequestDto);
	}

	@Override
	public TableResponseDto<AlcancesResolucion> filter(AlcancesResolucion filterAlcancesResolucion,
			TableRequestDto tableRequestDto) {

		List<AlcancesResolucion> listaTiposFinalizacion = this.alcancesResolucionDao.findAll(filterAlcancesResolucion,
				tableRequestDto);
		Long recordNum = this.alcancesResolucionDao
				.findAllCount(filterAlcancesResolucion != null ? filterAlcancesResolucion : new AlcancesResolucion());

		return new TableResponseDto<AlcancesResolucion>(tableRequestDto, recordNum, listaTiposFinalizacion);

	}

}
