package com.ejie.ab59.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab59.dao.pagos.SituacionExpedienteDao;
import com.ejie.ab59.model.pagos.SituacionExpediente;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * SituacionExpedienteServiceImpl  
 * 
 *  
 */

@Service(value = "situacionExpedienteService")
public class SituacionExpedienteServiceImpl implements SituacionExpedienteService {

	@Autowired
	private SituacionExpedienteDao situacionExpedienteDao;

	public SituacionExpediente add(SituacionExpediente situacionExpediente) {
		return situacionExpedienteDao.add(situacionExpediente);
	}

	public SituacionExpediente update(SituacionExpediente situacionExpediente) {
		return situacionExpedienteDao.update(situacionExpediente);
	}

	public SituacionExpediente find(SituacionExpediente situacionExpediente) {
		return this.situacionExpedienteDao.find(situacionExpediente);
	}

	public List<SituacionExpediente> findAllLike(SituacionExpediente situacionExpediente,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		return this.situacionExpedienteDao.findAllLike(situacionExpediente, tableRequestDto, startsWith);
	}

	public TableResponseDto<SituacionExpediente> filter(SituacionExpediente filterSituacionExpediente,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		List<SituacionExpediente> listaSituacionExpediente = this.situacionExpedienteDao
				.findAllLike(filterSituacionExpediente, tableRequestDto, false);

		Long recordNum = this.situacionExpedienteDao.findAllLikeCount(
				filterSituacionExpediente != null ? filterSituacionExpediente : new SituacionExpediente(), false);

		TableResponseDto<SituacionExpediente> usuarioDto = new TableResponseDto<SituacionExpediente>(tableRequestDto,
				recordNum, listaSituacionExpediente);

		return usuarioDto;
	}
}
