package com.ejie.ab59.service;

import java.io.StringWriter;
import java.util.Vector;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;

import n38a.exe.N38APISesion;
import n38c.exe.N38API;

/**
 * 
 * PerfilServiceImpl
 * 
 *  
 *
 */
@Service(value = "perfilService")
public class PerfilServiceImpl implements PerfilService {

	private static final Logger logger = LoggerFactory.getLogger(PerfilServiceImpl.class);

	@Override()
	public Vector<String> getPerfilPuesto(String codicoPuesto, String aplicacion) {

		try {

			N38APISesion miApiSesion = new N38APISesion();
			Document docAPISesionApp = miApiSesion.n38APISesionCrearApp(aplicacion.toUpperCase());
			N38API mm = new N38API(docAPISesionApp);
			Document document = mm.n38ItemPuestoGrupos(codicoPuesto);
			DOMSource domSource = new DOMSource(document);
			StringWriter writer = new StringWriter();
			StreamResult result = new StreamResult(writer);
			Transformer transformer = TransformerFactory.newInstance().newTransformer();
			transformer.transform(domSource, result);

			String xml = writer.toString();

			writer.close();

			if (xml.isEmpty()) {
				return null;
//			}else if (xml.contains(Perfil.ADMINISTRADOR.getNodoCodigoPerfilPF())) {
////				return Perfil.ADMINISTRADOR;
//			} else if (xml.contains(Perfil.REGISTRO_DATOS.getNodoCodigoPerfilPF())) {
////				return Perfil.REGISTRO_DATOS;
			} else {
				return null;
			}
		} catch (TransformerConfigurationException e) {
			logger.error("TransformerConfigurationException ", e);
			return null;
		} catch (TransformerFactoryConfigurationError e) {
			logger.error("TransformerConfigurationException ", e);
			return null;
		} catch (Exception e) {
			logger.error("Exception ", e);
			return null;
		}
	}
}
