package com.ejie.ab59.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.dao.pagos.LiquidacionesDao;
import com.ejie.ab59.model.pagos.Liquidaciones;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * LiquidacionesServiceImpl  
 * 
 *  
 */

@Service(value = "liquidacionesService")
public class LiquidacionesServiceImpl implements LiquidacionesService {

	@Autowired
	private LiquidacionesDao liquidacionesDao;

	@Transactional(rollbackFor = Throwable.class)
	public Liquidaciones add(Liquidaciones liquidaciones) {
		return this.liquidacionesDao.add(liquidaciones);
	}

	@Transactional(rollbackFor = Throwable.class)
	public Liquidaciones update(Liquidaciones liquidaciones) {
		return this.liquidacionesDao.update(liquidaciones);
	}

	public Liquidaciones find(Liquidaciones liquidaciones) {
		return this.liquidacionesDao.find(liquidaciones);
	}

	@Transactional(rollbackFor = Throwable.class)
	public void remove(Liquidaciones liquidaciones) {
		this.liquidacionesDao.remove(liquidaciones);
	}

	public List<Liquidaciones> findAll(Liquidaciones liquidaciones, TableRequestDto tableRequestDto) {
		return this.liquidacionesDao.findAll(liquidaciones, tableRequestDto);
	}

	public List<Liquidaciones> findAllLike(Liquidaciones liquidaciones, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		return this.liquidacionesDao.findAllLike(liquidaciones, tableRequestDto, startsWith);
	}

	public TableResponseDto<Liquidaciones> filter(Liquidaciones filterLiquidaciones, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		List<Liquidaciones> listaLiquidaciones = this.liquidacionesDao.findAllLike(filterLiquidaciones, tableRequestDto,
				false);

		Long recordNum = this.liquidacionesDao
				.findAllLikeCount(filterLiquidaciones != null ? filterLiquidaciones : new Liquidaciones(), false);

		TableResponseDto<Liquidaciones> usuarioDto = new TableResponseDto<Liquidaciones>(tableRequestDto, recordNum,
				listaLiquidaciones);

		return usuarioDto;
	}
}
