package com.ejie.ab59.model.tablasMaestras;

import java.util.Date;

import com.ejie.ab59.model.procedimientos.Procedimientos;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * 
 *  
 *
 */

public class TiposFinalizacion implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Long idTipoFinalizacion;
	private String descripcionCastellano;
	private String descripcionEuskera;
	private Date fechaRegistro;
	private String usuarioRegistro;
	private Date fechaUltmodificacion;
	private String usuarioUltmodificacion;
	private Procedimientos procedimiento;
	private Integer baja;

	// Para saber si es de turismo, comercio, consumo...
	private Integer idDireccion;

	/**
	 * Method 'TiposFinalizacion'.
	 */
	public TiposFinalizacion() {
	}

	/**
	 * Method 'TiposFinalizacion'.
	 * 
	 * @param idTipoFinalizacion
	 *            Long
	 */
	public TiposFinalizacion(Long idTipoFinalizacion) {
		this.idTipoFinalizacion = idTipoFinalizacion;
	}

	/**
	 * Method 'TiposFinalizacion'.
	 * 
	 * @param idTipoFinalizacion
	 *            Long
	 * @param descripcionCastellano
	 *            String
	 * @param descripcionEuskera
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param fechaUltmodificacion
	 *            Date
	 * @param usuarioUltmodificacion
	 *            String
	 */
	public TiposFinalizacion(Long idTipoFinalizacion, String descripcionCastellano, String descripcionEuskera,
			Date fechaRegistro, String usuarioRegistro, Date fechaUltmodificacion, String usuarioUltmodificacion) {

		this.idTipoFinalizacion = idTipoFinalizacion;
		this.descripcionCastellano = descripcionCastellano;
		this.descripcionEuskera = descripcionEuskera;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.fechaUltmodificacion = fechaUltmodificacion;
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	/**
	 * Method 'getIdTipoFinalizacion'.
	 *
	 * @return Long
	 */

	public Long getIdTipoFinalizacion() {
		return this.idTipoFinalizacion;
	}

	/**
	 * Method 'setIdTipoFinalizacion'.
	 *
	 * @param idTipoFinalizacion
	 *            Long
	 * @return
	 */

	public void setIdTipoFinalizacion(Long idTipoFinalizacion) {
		this.idTipoFinalizacion = idTipoFinalizacion;
	}

	/**
	 * Method 'getDescripcionCastellano'.
	 *
	 * @return String
	 */

	public String getDescripcionCastellano() {
		return this.descripcionCastellano;
	}

	/**
	 * Method 'setDescripcionCastellano'.
	 *
	 * @param descripcionCastellano
	 *            String
	 * @return
	 */

	public void setDescripcionCastellano(String descripcionCastellano) {
		this.descripcionCastellano = descripcionCastellano;
	}

	/**
	 * Method 'getDescripcionEuskera'.
	 *
	 * @return String
	 */

	public String getDescripcionEuskera() {
		return this.descripcionEuskera;
	}

	/**
	 * Method 'setDescripcionEuskera'.
	 *
	 * @param descripcionEuskera
	 *            String
	 * @return
	 */

	public void setDescripcionEuskera(String descripcionEuskera) {
		this.descripcionEuskera = descripcionEuskera;
	}

	/**
	 * Method 'getFechaRegistro'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	/**
	 * Method 'setFechaRegistro'.
	 *
	 * @param fechaRegistro
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'getFechaUltmodificacion'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaUltmodificacion() {
		return this.fechaUltmodificacion;
	}

	/**
	 * Method 'setFechaUltmodificacion'.
	 *
	 * @param fechaUltmodificacion
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaUltmodificacion(Date fechaUltmodificacion) {
		this.fechaUltmodificacion = fechaUltmodificacion;
	}

	/**
	 * Method 'getUsuarioUltmodificacion'.
	 *
	 * @return String
	 */

	public String getUsuarioUltmodificacion() {
		return this.usuarioUltmodificacion;
	}

	/**
	 * Method 'setUsuarioUltmodificacion'.
	 *
	 * @param usuarioUltmodificacion
	 *            String
	 * @return
	 */

	public void setUsuarioUltmodificacion(String usuarioUltmodificacion) {
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	public Procedimientos getProcedimiento() {
		return procedimiento;
	}

	public void setProcedimiento(Procedimientos procedimiento) {
		this.procedimiento = procedimiento;
	}

	public Integer getBaja() {
		return baja;
	}

	public void setBaja(Integer baja) {
		this.baja = baja;
	}

	public Integer getIdDireccion() {
		return idDireccion;
	}

	public void setIdDireccion(Integer idDireccion) {
		this.idDireccion = idDireccion;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idTipoFinalizacion: ").append(this.idTipoFinalizacion).append(" ]");
		result.append(", [ descripcionCastellano: ").append(this.descripcionCastellano).append(" ]");
		result.append(", [ descripcionEuskra: ").append(this.descripcionEuskera).append(" ]");
		result.append(", [ fechaRegistro: ").append(this.fechaRegistro).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append(", [ fechaUltmodificacion: ").append(this.fechaUltmodificacion).append(" ]");
		result.append(", [ usuarioUltmodificacion: ").append(this.usuarioUltmodificacion).append(" ]");
		result.append("}");
		return result.toString();
	}

}
