package com.ejie.ab59.model.tablasMaestras;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.ab59.clientesWS.ab61WebService.Firmantes;
import com.ejie.ab59.clientesWS.ab61WebService.Prescripcion;
import com.ejie.ab59.model.configuracionInicioOficio.AlcancesResolucion;

import com.ejie.ab59.model.procedimientos.Procedimientos;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * ConfIniOfi  
 * 
 *  
 */

public class ConfIniOfi implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Long idConfiguracion;
	private Procedimientos procedimiento;
	private Boolean publicarTablon;
	private Integer plazotablon;
	private String tipoPlazoTablon;
	private String tipoRedaccionTablon;
	private String codigoDepartExpiente;
	private Firmantes firmantes;
	private String usuarioRegistro;
	private String usuarioUltmodificacion;
	private List<AlcancesResolucion> listaAlcancesResolucion = new ArrayList<AlcancesResolucion>();
	private String idsAlcancesResolcuion;

	private String codigoDepExp;
	private Firmantes firmante;
	private Prescripcion prescripcion;
	private Date fechaAcuerdoInicio;
	private Integer plazoResolucion;
	private String tipoPlazoResolucion;

	/**
	 * Method 'ConfIniOfi'.
	 */
	public ConfIniOfi() {
	}

	/**
	 * Method 'ConfIniOfi'.
	 * 
	 * @param idConfiguracion
	 *            Long
	 */
	public ConfIniOfi(Long idConfiguracion) {
		this.idConfiguracion = idConfiguracion;
	}

	public ConfIniOfi(Integer idProcedimiento) {
		this.setProcedimiento(new Procedimientos(idProcedimiento));
	}

	public ConfIniOfi(Long idConfiguracion, Procedimientos procedimiento, Boolean publicarTablon, Integer plazotablon,
			String tipoPlazoTablon, String tipoRedaccionTablon, Integer plazoResolucion, String tipoPlazoResolucion,
			Date fechaAcuerdoInicio, String codigoDepartExpiente, String usuarioRegistro, String usuarioUltmodificacion,
			Firmantes firmantes) {
		this.idConfiguracion = idConfiguracion;
		this.procedimiento = procedimiento;
		this.publicarTablon = publicarTablon;
		this.plazotablon = plazotablon;
		this.tipoPlazoTablon = tipoPlazoTablon;
		this.tipoRedaccionTablon = tipoRedaccionTablon;
		this.plazoResolucion = plazoResolucion;
		this.tipoPlazoResolucion = tipoPlazoResolucion;
		this.fechaAcuerdoInicio = fechaAcuerdoInicio;
		this.codigoDepartExpiente = codigoDepartExpiente;
		this.usuarioRegistro = usuarioRegistro;
		this.usuarioUltmodificacion = usuarioUltmodificacion;
		this.firmantes = firmantes;
	}

	/**
	 * Method 'getIdConfiguracion'.
	 *
	 * @return Long
	 */

	public Long getIdConfiguracion() {
		return this.idConfiguracion;
	}

	/**
	 * Method 'setIdConfiguracion'.
	 *
	 * @param idConfiguracion
	 *            Long
	 * @return
	 */

	public void setIdConfiguracion(Long idConfiguracion) {
		this.idConfiguracion = idConfiguracion;
	}

	/**
	 * Method 'getProcedimiento'.
	 *
	 * @return Integer
	 */

	public Procedimientos getProcedimiento() {
		return this.procedimiento;
	}

	/**
	 * Method 'setProcedimiento'.
	 *
	 * @param procedimiento
	 *            Procedimientos
	 * @return
	 */

	public void setProcedimiento(Procedimientos procedimiento) {
		this.procedimiento = procedimiento;
	}

	/**
	 * Method 'getPublicarTablon'.
	 *
	 * @return Integer
	 */

	public Boolean getPublicarTablon() {
		return this.publicarTablon;
	}

	/**
	 * Method 'setPublicarTablon'.
	 *
	 * @param publicarTablon
	 *            Integer
	 * @return
	 */

	public void setPublicarTablon(Boolean publicarTablon) {
		this.publicarTablon = publicarTablon;
	}

	/**
	 * Method 'getPlazotablon'.
	 *
	 * @return Integer
	 */

	public Integer getPlazotablon() {
		return this.plazotablon;
	}

	/**
	 * Method 'setPlazotablon'.
	 *
	 * @param plazotablon
	 *            Integer
	 * @return
	 */

	public void setPlazotablon(Integer plazotablon) {
		this.plazotablon = plazotablon;
	}

	/**
	 * Method 'getTipoPlazoTablon'.
	 *
	 * @return String
	 */

	public String getTipoPlazoTablon() {
		return this.tipoPlazoTablon;
	}

	/**
	 * Method 'setTipoPlazoTablon'.
	 *
	 * @param tipoPlazoTablon
	 *            String
	 * @return
	 */

	public void setTipoPlazoTablon(String tipoPlazoTablon) {
		this.tipoPlazoTablon = tipoPlazoTablon;
	}

	/**
	 * Method 'getTipoRedaccionTablon'.
	 *
	 * @return String
	 */

	public String getTipoRedaccionTablon() {
		return this.tipoRedaccionTablon;
	}

	/**
	 * Method 'setTipoRedaccionTablon'.
	 *
	 * @param tipoRedaccionTablon
	 *            String
	 * @return
	 */

	public void setTipoRedaccionTablon(String tipoRedaccionTablon) {
		this.tipoRedaccionTablon = tipoRedaccionTablon;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'getUsuarioUltmodificacion'.
	 *
	 * @return String
	 */

	public String getUsuarioUltmodificacion() {
		return this.usuarioUltmodificacion;
	}

	/**
	 * Method 'setUsuarioUltmodificacion'.
	 *
	 * @param usuarioUltmodificacion
	 *            String
	 * @return
	 */

	public void setUsuarioUltmodificacion(String usuarioUltmodificacion) {
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	public String getCodigoDepExp() {
		return codigoDepExp;
	}

	public void setCodigoDepExp(String codigoDepExp) {
		this.codigoDepExp = codigoDepExp;
	}

	public Firmantes getFirmante() {
		return firmante;
	}

	public void setFirmante(Firmantes firmante) {
		this.firmante = firmante;
	}

	public Prescripcion getPrescripcion() {
		return prescripcion;
	}

	public void setPrescripcion(Prescripcion prescripcion) {
		this.prescripcion = prescripcion;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaAcuerdoInicio() {
		return fechaAcuerdoInicio;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaAcuerdoInicio(Date fechaAcuerdoInicio) {
		this.fechaAcuerdoInicio = fechaAcuerdoInicio;
	}

	public Integer getPlazoResolucion() {
		return plazoResolucion;
	}

	public void setPlazoResolucion(Integer plazoResolucion) {
		this.plazoResolucion = plazoResolucion;
	}

	public String getTipoPlazoResolucion() {
		return tipoPlazoResolucion;
	}

	public void setTipoPlazoResolucion(String tipoPlazoResolucion) {
		this.tipoPlazoResolucion = tipoPlazoResolucion;
	}

	public Firmantes getFirmantes() {
		return firmantes;
	}

	public void setFirmantes(Firmantes firmantes) {
		this.firmantes = firmantes;
	}

	public String getCodigoDepartExpiente() {
		return codigoDepartExpiente;
	}

	public void setCodigoDepartExpiente(String codigoDepartExpiente) {
		this.codigoDepartExpiente = codigoDepartExpiente;
	}

	public List<AlcancesResolucion> getListaAlcancesResolucion() {
		return listaAlcancesResolucion;
	}

	public void setListaAlcancesResolucion(List<AlcancesResolucion> listaAlcancesResolucion) {
		this.listaAlcancesResolucion = listaAlcancesResolucion;
	}

	public String getIdsAlcancesResolcuion() {
		return idsAlcancesResolcuion;
	}

	public void setIdsAlcancesResolcuion(String idsAlcancesResolcuion) {
		this.idsAlcancesResolcuion = idsAlcancesResolcuion;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idConfiguracion: ").append(this.idConfiguracion).append(" ]");
		result.append(", [ idProcedimiento: ")
				.append(this.procedimiento != null ? this.procedimiento.getIdProcedimiento() : 0).append(" ]");
		result.append(", [ publicarTablon: ").append(this.publicarTablon).append(" ]");
		result.append(", [ plazotablon: ").append(this.plazotablon).append(" ]");
		result.append(", [ tipoPlazoTablon: ").append(this.tipoPlazoTablon).append(" ]");
		result.append(", [ tipoRedaccionTablon: ").append(this.tipoRedaccionTablon).append(" ]");
		result.append(", [ plazoResolucion: ").append(this.plazoResolucion).append(" ]");
		result.append(", [ tipoPlazoResolucion: ").append(this.tipoPlazoResolucion).append(" ]");
		result.append(", [ fechaAcuerdoInicio: ").append(this.fechaAcuerdoInicio).append(" ]");
		result.append(", [ codigoDepartExpiente: ").append(this.codigoDepartExpiente).append(" ]");
		result.append(", [ firmante: ").append(this.firmantes != null ? this.firmantes.getIdFirmante() : 0)
				.append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append(", [ usuarioUltmodificacion: ").append(this.usuarioUltmodificacion).append(" ]");
		result.append("}");
		return result.toString();
	}

}
