package com.ejie.ab59.model.tablasMaestras;

import java.math.BigDecimal;

import com.ejie.ab59.comun.UtilDate;
import com.ejie.ab59.model.procedimientos.Procedimientos;

/**
 * Calificaciones  
 * 
 *  
 */

public class Calificaciones implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Long idCalificacion;
	private String descripcionCastellano;
	private String descripcionEuskera;
	private Long plazo;
	private Integer gravedad;
	private String usuarioRegistro;
	private String usuarioUltmodificacion;
	private Procedimientos procedimiento;
	private BigDecimal importe;

	/**
	 * Method 'Calificaciones'.
	 */
	public Calificaciones() {
	}

	/**
	 * Method 'Calificaciones'.
	 * 
	 * @param idCalificacion
	 *            Long
	 */
	public Calificaciones(Long idCalificacion) {
		this.idCalificacion = idCalificacion;
	}

	/**
	 * Method 'Calificaciones'.
	 * 
	 * @param idCalificacion
	 *            Long
	 * @param descripcionCastellano
	 *            String
	 * @param descripcionEuskera
	 *            String
	 * @param plazo
	 *            Long
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param fechaUltmodificacion
	 *            Date
	 * @param usuarioUltmodificacion
	 *            String
	 */
	public Calificaciones(Long idCalificacion, String descripcionCastellano, String descripcionEuskera, Long plazo,
			String usuarioRegistro, String usuarioUltmodificacion) {

		this.idCalificacion = idCalificacion;
		this.descripcionCastellano = descripcionCastellano;
		this.descripcionEuskera = descripcionEuskera;
		this.plazo = plazo;
		this.usuarioRegistro = usuarioRegistro;
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	/**
	 * Method 'getIdCalificacion'.
	 *
	 * @return Long
	 */

	public Long getIdCalificacion() {
		return this.idCalificacion;
	}

	/**
	 * Method 'setIdCalificacion'.
	 *
	 * @param idCalificacion
	 *            Long
	 * @return
	 */

	public void setIdCalificacion(Long idCalificacion) {
		this.idCalificacion = idCalificacion;
	}

	/**
	 * Method 'getDescripcionCastellano'.
	 *
	 * @return String
	 */

	public String getDescripcionCastellano() {
		return this.descripcionCastellano;
	}

	/**
	 * Method 'setDescripcionCastellano'.
	 *
	 * @param descripcionCastellano
	 *            String
	 * @return
	 */

	public void setDescripcionCastellano(String descripcionCastellano) {
		this.descripcionCastellano = descripcionCastellano;
	}

	/**
	 * Method 'getDescripcionEuskera'.
	 *
	 * @return String
	 */

	public String getDescripcionEuskera() {
		return this.descripcionEuskera;
	}

	/**
	 * Method 'setDescripcionEuskera'.
	 *
	 * @param descripcionEuskera
	 *            String
	 * @return
	 */

	public void setDescripcionEuskera(String descripcionEuskera) {
		this.descripcionEuskera = descripcionEuskera;
	}

	/**
	 * Method 'getPlazo'.
	 *
	 * @return Long
	 */

	public Long getPlazo() {
		return this.plazo;
	}

	/**
	 * Method 'setPlazo'.
	 *
	 * @param plazo
	 *            Long
	 * @return
	 */

	public void setPlazo(Long plazo) {
		this.plazo = plazo;
	}

	/**
	 * @return the gravedad
	 */
	public Integer getGravedad() {
		return this.gravedad;
	}

	/**
	 * @param gravedad
	 *            the gravedad to set
	 */
	public void setGravedad(Integer gravedad) {
		this.gravedad = gravedad;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'getUsuarioUltmodificacion'.
	 *
	 * @return String
	 */

	public String getUsuarioUltmodificacion() {
		return this.usuarioUltmodificacion;
	}

	/**
	 * Method 'setUsuarioUltmodificacion'.
	 *
	 * @param usuarioUltmodificacion
	 *            String
	 * @return
	 */

	public void setUsuarioUltmodificacion(String usuarioUltmodificacion) {
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	public Procedimientos getProcedimiento() {
		return procedimiento;
	}

	public void setProcedimiento(Procedimientos procedimiento) {
		this.procedimiento = procedimiento;
	}

	public BigDecimal getImporte() {
		return importe;
	}

	public void setImporte(BigDecimal importe) {
		this.importe = importe;
	}

	public String getImporteMask() {
		return UtilDate.formatearMiles(this.importe);
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idCalificacion: ").append(this.idCalificacion).append(" ]");
		result.append(", [ descripcionCastellano: ").append(this.descripcionCastellano).append(" ]");
		result.append(", [ descripcionEuskera: ").append(this.descripcionEuskera).append(" ]");
		result.append(", [ plazo: ").append(this.plazo).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append(", [ usuarioUltmodificacion: ").append(this.usuarioUltmodificacion).append(" ]");
		result.append("}");
		return result.toString();
	}

}
