package com.ejie.ab59.model.sanciones;

import java.math.BigDecimal;
import java.util.Date;

import com.ejie.ab59.comun.UtilDate;
import com.ejie.ab59.model.expedientes.DatosDirecciones;
import com.ejie.ab59.model.expedientes.Expedientes;
import com.ejie.ab59.model.tablasMaestras.Instructores;
import com.ejie.ab59.model.tablasMaestras.TiposFinalizacion;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * Sanciones  
 * 
 *  
 */

public class Sanciones implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Integer idSancion;
	private Expedientes expediente;
	private DatosDirecciones direccion;
	private String observacionesCastellano;
	private String observacionesEuskera;
	private BigDecimal importeSancion;
	private BigDecimal importeResolucion;
	private Date fechaEnvioAseJur;
	private Instructores instructor;
	private Date fechaRecConAdm;
	private Date fechaNotRecConAdm;
	private Date fechaResRecConAdm;
	private TiposFinalizacion tipoFinalizacion;
	private Date fechaSancionFirme;
	private Date fechaRegistro;
	private String usuarioRegistro;
	private Date fechaUltmodificacion;
	private String usuarioUltmodificacion;
	private ControlFechas controlFechas;

	private Integer importeSancionDesde;
	private Integer importeSancionHasta;
	private Date fechaAcuseAcuerdoIncoacionDesde;
	private Date fechaAcuseAcuerdoIncoacionHasta;
	private Date fechaSancionFirmeDesde;
	private Date fechaSancionFirmeHasta;

	private Integer expedientesSinPropuesta;
	private Integer expedientesCerrados;

	/**
	 * Method 'Sanciones'.
	 */
	public Sanciones() {
	}

	/**
	 * Method 'Sanciones'.
	 * 
	 * @param idSancion
	 *            Integer
	 */
	public Sanciones(Integer idSancion) {
		this.idSancion = idSancion;
	}

	/**
	 * Method 'Sanciones'.
	 * 
	 * @param idSancion
	 *            Integer
	 * @param expediente
	 *            Expedientes
	 * @param observacionesCastellano
	 *            String
	 * @param observacionesEuskera
	 *            String
	 * @param importeSancion
	 *            BigDecimal
	 * @param fechaEnvioAseJur
	 *            Date
	 * @param instructor
	 *            Instructores
	 * @param fechaRecConAdm
	 *            Date
	 * @param tipoFinalizacion
	 *            TiposFinalizacion
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param fechaUltmodificacion
	 *            Date
	 * @param usuarioUltmodificacion
	 *            String
	 */
	public Sanciones(Integer idSancion, Expedientes expediente, String observacionesCastellano,
			String observacionesEuskera, BigDecimal importeSancion, Date fechaEnvioAseJur, Instructores instructor,
			Date fechaRecConAdm, TiposFinalizacion tipoFinalizacion, Date fechaRegistro, String usuarioRegistro,
			Date fechaUltmodificacion, String usuarioUltmodificacion) {

		this.idSancion = idSancion;
		this.expediente = expediente;
		this.observacionesCastellano = observacionesCastellano;
		this.observacionesEuskera = observacionesEuskera;
		this.importeSancion = importeSancion;
		this.fechaEnvioAseJur = fechaEnvioAseJur;
		this.instructor = instructor;
		this.fechaRecConAdm = fechaRecConAdm;
		this.tipoFinalizacion = tipoFinalizacion;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.fechaUltmodificacion = fechaUltmodificacion;
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	/**
	 * Method 'getIdSancion'.
	 *
	 * @return Integer
	 */

	public Integer getIdSancion() {
		return this.idSancion;
	}

	/**
	 * Method 'setIdSancion'.
	 *
	 * @param idSancion
	 *            Integer
	 * @return
	 */

	public void setIdSancion(Integer idSancion) {
		this.idSancion = idSancion;
	}

	/**
	 * Method 'getExpediente'.
	 *
	 * @return Expedientes
	 */

	public Expedientes getExpediente() {
		return this.expediente;
	}

	/**
	 * Method 'setExpediente'.
	 *
	 * @param expediente
	 *            Expedientes
	 * @return
	 */

	public void setExpediente(Expedientes expediente) {
		this.expediente = expediente;
	}

	/**
	 * Method 'getObservacionesCastellano'.
	 *
	 * @return String
	 */

	public String getObservacionesCastellano() {
		return this.observacionesCastellano;
	}

	/**
	 * Method 'setObservacionesCastellano'.
	 *
	 * @param observacionesCastellano
	 *            String
	 * @return
	 */

	public void setObservacionesCastellano(String observacionesCastellano) {
		this.observacionesCastellano = observacionesCastellano;
	}

	/**
	 * Method 'getObservacionesEuskera'.
	 *
	 * @return String
	 */

	public String getObservacionesEuskera() {
		return this.observacionesEuskera;
	}

	/**
	 * Method 'setObservacionesEuskera'.
	 *
	 * @param observacionesEuskera
	 *            String
	 * @return
	 */

	public void setObservacionesEuskera(String observacionesEuskera) {
		this.observacionesEuskera = observacionesEuskera;
	}

	/**
	 * Method 'getImporteSancion'.
	 *
	 * @return BigDecimal
	 */
	public BigDecimal getImporteSancion() {
		return this.importeSancion;
	}

	/**
	 * Method 'setImporteSancion'.
	 *
	 * @param importeSancion
	 *            BigDecimal
	 * @return
	 */
	public void setImporteSancion(BigDecimal importeSancion) {
		this.importeSancion = importeSancion;
	}

	/**
	 * Method 'getFechaEnvioAseJur'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaEnvioAseJur() {
		return this.fechaEnvioAseJur;
	}

	/**
	 * Method 'setFechaEnvioAseJur'.
	 *
	 * @param fechaEnvioAseJur
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaEnvioAseJur(Date fechaEnvioAseJur) {
		this.fechaEnvioAseJur = fechaEnvioAseJur;
	}

	/**
	 * Method 'getInstructor'.
	 *
	 * @return Instructores
	 */

	public Instructores getInstructor() {
		return this.instructor;
	}

	/**
	 * Method 'setInstructor'.
	 *
	 * @param instructor
	 *            Instructores
	 * @return
	 */

	public void setInstructor(Instructores instructor) {
		this.instructor = instructor;
	}

	/**
	 * Method 'getFechaRecConAdm'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRecConAdm() {
		return this.fechaRecConAdm;
	}

	/**
	 * Method 'setFechaRecConAdm'.
	 *
	 * @param fechaRecConAdm
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRecConAdm(Date fechaRecConAdm) {
		this.fechaRecConAdm = fechaRecConAdm;
	}

	/**
	 * Method 'getTipoFinalizacion'.
	 *
	 * @return TiposFinalizacion
	 */

	public TiposFinalizacion getTipoFinalizacion() {
		return this.tipoFinalizacion;
	}

	/**
	 * Method 'setTipoFinalizacion'.
	 *
	 * @param tipoFinalizacion
	 *            TiposFinalizacion
	 * @return
	 */

	public void setTipoFinalizacion(TiposFinalizacion tipoFinalizacion) {
		this.tipoFinalizacion = tipoFinalizacion;
	}

	/**
	 * @return the direccion
	 */
	public DatosDirecciones getDireccion() {
		return this.direccion;
	}

	/**
	 * @param direccion
	 *            the direccion to set
	 */
	public void setDireccion(DatosDirecciones direccion) {
		this.direccion = direccion;
	}

	/**
	 * @return the importeResolucion
	 */
	public BigDecimal getImporteResolucion() {
		return importeResolucion;
	}

	/**
	 * @param importeResolucion
	 *            the importeResolucion to set
	 */
	public void setImporteResolucion(BigDecimal importeResolucion) {
		this.importeResolucion = importeResolucion;
	}

	/**
	 * @return the fechaNotRecConAdm
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaNotRecConAdm() {
		return this.fechaNotRecConAdm;
	}

	/**
	 * @param fechaNotRecConAdm
	 *            the fechaNotRecConAdm to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaNotRecConAdm(Date fechaNotRecConAdm) {
		this.fechaNotRecConAdm = fechaNotRecConAdm;
	}

	/**
	 * @return the fechaResRecConAdm
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaResRecConAdm() {
		return this.fechaResRecConAdm;
	}

	/**
	 * @param fechaResRecConAdm
	 *            the fechaResRecConAdm to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaResRecConAdm(Date fechaResRecConAdm) {
		this.fechaResRecConAdm = fechaResRecConAdm;
	}

	/**
	 * @return the fechaSancionFirme
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaSancionFirme() {
		return this.fechaSancionFirme;
	}

	/**
	 * @param fechaSancionFirme
	 *            the fechaSancionFirme to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaSancionFirme(Date fechaSancionFirme) {
		this.fechaSancionFirme = fechaSancionFirme;
	}

	/**
	 * Method 'getFechaRegistro'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	/**
	 * Method 'setFechaRegistro'.
	 *
	 * @param fechaRegistro
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'getFechaUltmodificacion'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaUltmodificacion() {
		return this.fechaUltmodificacion;
	}

	/**
	 * Method 'setFechaUltmodificacion'.
	 *
	 * @param fechaUltmodificacion
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaUltmodificacion(Date fechaUltmodificacion) {
		this.fechaUltmodificacion = fechaUltmodificacion;
	}

	/**
	 * Method 'getUsuarioUltmodificacion'.
	 *
	 * @return String
	 */

	public String getUsuarioUltmodificacion() {
		return this.usuarioUltmodificacion;
	}

	/**
	 * Method 'setUsuarioUltmodificacion'.
	 *
	 * @param usuarioUltmodificacion
	 *            String
	 * @return
	 */

	public void setUsuarioUltmodificacion(String usuarioUltmodificacion) {
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	/**
	 * @return the controlFechas
	 */
	public ControlFechas getControlFechas() {
		return controlFechas;
	}

	/**
	 * @param controlFechas
	 *            the controlFechas to set
	 */
	public void setControlFechas(ControlFechas controlFechas) {
		this.controlFechas = controlFechas;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idSancion: ").append(this.idSancion).append(" ]");
		result.append(", [ idExpediente: ").append(this.expediente).append(" ]");
		result.append(", [ observacionesCastellano: ").append(this.observacionesCastellano).append(" ]");
		result.append(", [ observacionesEuskera: ").append(this.observacionesEuskera).append(" ]");
		result.append(", [ importeSancion: ").append(this.importeSancion).append(" ]");
		result.append(", [ fechaEnvioAseJur: ").append(this.fechaEnvioAseJur).append(" ]");
		result.append(", [ Instructor: ").append(this.instructor).append(" ]");
		result.append(", [ fechaRecConAdm: ").append(this.fechaRecConAdm).append(" ]");
		result.append(", [ idTipoFinalizacion: ").append(this.tipoFinalizacion).append(" ]");
		result.append(", [ fechaRegistro: ").append(this.fechaRegistro).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append(", [ fechaUltmodificacion: ").append(this.fechaUltmodificacion).append(" ]");
		result.append(", [ usuarioUltmodificacion: ").append(this.usuarioUltmodificacion).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * @return the importeSancionDesde
	 */
	public Integer getImporteSancionDesde() {
		return importeSancionDesde;
	}

	/**
	 * @param importeSancionDesde
	 *            the importeSancionDesde to set
	 */
	public void setImporteSancionDesde(Integer importeSancionDesde) {
		this.importeSancionDesde = importeSancionDesde;
	}

	/**
	 * @return the importeSancionHasta
	 */
	public Integer getImporteSancionHasta() {
		return importeSancionHasta;
	}

	/**
	 * @param importeSancionHasta
	 *            the importeSancionHasta to set
	 */
	public void setImporteSancionHasta(Integer importeSancionHasta) {
		this.importeSancionHasta = importeSancionHasta;
	}

	/**
	 * @return the fechaAcuseAcuerdoIncoacionDesde
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaAcuseAcuerdoIncoacionDesde() {
		return this.fechaAcuseAcuerdoIncoacionDesde;
	}

	/**
	 * @param fechaAcuseAcuerdoIncoacionDesde
	 *            the fechaAcuseAcuerdoIncoacionDesde to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaAcuseAcuerdoIncoacionDesde(Date fechaAcuseAcuerdoIncoacionDesde) {
		this.fechaAcuseAcuerdoIncoacionDesde = fechaAcuseAcuerdoIncoacionDesde;
	}

	/**
	 * @return the fechaAcuseAcuerdoIncoacionHasta
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaAcuseAcuerdoIncoacionHasta() {
		return this.fechaAcuseAcuerdoIncoacionHasta;
	}

	/**
	 * @param fechaAcuseAcuerdoIncoacionHasta
	 *            the fechaAcuseAcuerdoIncoacionHasta to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaAcuseAcuerdoIncoacionHasta(Date fechaAcuseAcuerdoIncoacionHasta) {
		this.fechaAcuseAcuerdoIncoacionHasta = fechaAcuseAcuerdoIncoacionHasta;
	}

	/**
	 * @return the fechaSancionFirmeDesde
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaSancionFirmeDesde() {
		return this.fechaSancionFirmeDesde;
	}

	/**
	 * @param fechaSancionFirmeDesde
	 *            the fechaSancionFirmeDesde to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaSancionFirmeDesde(Date fechaSancionFirmeDesde) {
		this.fechaSancionFirmeDesde = fechaSancionFirmeDesde;
	}

	/**
	 * @return the fechaSancionFirmeHasta
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaSancionFirmeHasta() {
		return this.fechaSancionFirmeHasta;
	}

	/**
	 * @param fechaSancionFirmeHasta
	 *            the fechaSancionFirmeHasta to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaSancionFirmeHasta(Date fechaSancionFirmeHasta) {
		this.fechaSancionFirmeHasta = fechaSancionFirmeHasta;
	}

	public Integer getExpedientesSinPropuesta() {
		return expedientesSinPropuesta;
	}

	public void setExpedientesSinPropuesta(Integer expedientesSinPropuesta) {
		this.expedientesSinPropuesta = expedientesSinPropuesta;
	}

	public Integer getExpedientesCerrados() {
		return expedientesCerrados;
	}

	public void setExpedientesCerrados(Integer expedientesCerrados) {
		this.expedientesCerrados = expedientesCerrados;
	}

	public String getImporteSancionMask() {
		return UtilDate.formatearMiles(importeSancion);
	}

	public String getImporteResolucionMask() {
		return UtilDate.formatearMiles(importeResolucion);
	}
}
