package com.ejie.ab59.model.sanciones;

import java.math.BigDecimal;
import java.util.Date;

import com.ejie.ab59.comun.UtilDate;
import com.ejie.ab59.model.tablasMaestras.Infracciones;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * 
 *  
 *
 */

public class RelArtInfSan implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Integer idRelArtInfSan;
	private Infracciones infraccion;
	private Sanciones sancion;
	private BigDecimal importeSancionArt;
	private BigDecimal importeResolucionArt;
	private BigDecimal importePago;
	private Date fechaHecho;
	private String descripcionHecho;
	private Date fechaPrescripcion;
	private Date fechaRegistro;
	private String usuarioRegistro;
	private Date fechaUltModificacion;
	private String usuarioUltModificacion;

	private BigDecimal totalSancion;
	private BigDecimal totalResolucion;

	private String idDerechosInf;
	private String articulosDerechosInf;
	private String descripcionDerechosInfCas;
	private String descripcionDerechosInfEus;


	public RelArtInfSan() {
	}
	
	public RelArtInfSan(Integer idRelArtInfSan) {
		this.idRelArtInfSan = idRelArtInfSan;
	}

	public RelArtInfSan(Integer idRelArtInfSan, Infracciones infraccion, Sanciones sancion,
			BigDecimal importeSancionArt, BigDecimal importeResolucionArt, Date fechaRegistro, String usuarioRegistro) {

		this.idRelArtInfSan = idRelArtInfSan;
		this.infraccion = infraccion;
		this.sancion = sancion;
		this.importeSancionArt = importeSancionArt;
		this.importeResolucionArt = importeResolucionArt;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
	}

	public Integer getIdRelArtInfSan() {
		return this.idRelArtInfSan;
	}

	public void setIdRelArtInfSan(Integer idRelArtInfSan) {
		this.idRelArtInfSan = idRelArtInfSan;
	}

	public Infracciones getInfraccion() {
		return this.infraccion;
	}

	public void setInfraccion(Infracciones infraccion) {
		this.infraccion = infraccion;
	}

	public Sanciones getSancion() {
		return this.sancion;
	}

	public void setSancion(Sanciones sancion) {
		this.sancion = sancion;
	}

	public BigDecimal getImporteSancionArt() {
		return this.importeSancionArt;
	}

	public void setImporteSancionArt(BigDecimal importeSancionArt) {
		this.importeSancionArt = importeSancionArt;
	}

	public BigDecimal getImporteResolucionArt() {
		return this.importeResolucionArt;
	}

	public void setImporteResolucionArt(BigDecimal importeResolucionArt) {
		this.importeResolucionArt = importeResolucionArt;
	}

	public BigDecimal getImportePago() {
		return this.importePago;
	}

	public void setImportePago(BigDecimal importePago) {
		this.importePago = importePago;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaHecho() {
		return this.fechaHecho;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaHecho(Date fechaHecho) {
		this.fechaHecho = fechaHecho;
	}

	public String getDescripcionHecho() {
		return descripcionHecho;
	}

	public void setDescripcionHecho(String descripcionHecho) {
		this.descripcionHecho = descripcionHecho;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaPrescripcion() {
		return this.fechaPrescripcion;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaPrescripcion(Date fechaPrescripcion) {
		this.fechaPrescripcion = fechaPrescripcion;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaUltModificacion() {
		return this.fechaUltModificacion;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaUltModificacion(Date fechaUltModificacion) {
		this.fechaUltModificacion = fechaUltModificacion;
	}

	public String getUsuarioUltModificacion() {
		return this.usuarioUltModificacion;
	}

	public void setUsuarioUltModificacion(String usuarioUltModificacion) {
		this.usuarioUltModificacion = usuarioUltModificacion;
	}

	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idRelArtInfSan: ").append(this.idRelArtInfSan).append(" ]");
		result.append(", [ infraccion: ").append(this.infraccion).append(" ]");
		result.append(", [ sancion: ").append(this.sancion).append(" ]");
		result.append(", [ importeSancionArt: ").append(this.importeSancionArt).append(" ]");
		result.append(", [ importeResolucionArt: ").append(this.importeResolucionArt).append(" ]");
		result.append(", [ importePago: ").append(this.importePago).append(" ]");
		result.append(", [ fechaHecho: ").append(this.fechaHecho).append(" ]");
		result.append(", [ descripcionHecho: ").append(this.descripcionHecho).append(" ]");
		result.append(", [ fechaPrescripcion: ").append(this.fechaPrescripcion).append(" ]");
		result.append(", [ fechaRegistro: ").append(this.fechaRegistro).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append("}");
		return result.toString();
	}

	public BigDecimal getTotalSancion() {
		return this.totalSancion;
	}

	public void setTotalSancion(BigDecimal totalSancion) {
		this.totalSancion = totalSancion;
	}

	public BigDecimal getTotalResolucion() {
		return this.totalResolucion;
	}

	public void setTotalResolucion(BigDecimal totalResolucion) {
		this.totalResolucion = totalResolucion;
	}

	public String getIdDerechosInf() {
		return this.idDerechosInf;
	}

	public void setIdDerechosInf(String idDerechosInf) {
		this.idDerechosInf = idDerechosInf;
	}

	public String getArticulosDerechosInf() {
		return this.articulosDerechosInf;
	}

	public void setArticulosDerechosInf(String articulosDerechosInf) {
		this.articulosDerechosInf = articulosDerechosInf;
	}

	public String getDescripcionDerechosInfCas() {
		return this.descripcionDerechosInfCas;
	}

	public void setDescripcionDerechosInfCas(String descripcionDerechosInfCas) {
		this.descripcionDerechosInfCas = descripcionDerechosInfCas;
	}

	public String getDescripcionDerechosInfEus() {
		return this.descripcionDerechosInfEus;
	}

	public void setDescripcionDerechosInfEus(String descripcionDerechosInfEus) {
		this.descripcionDerechosInfEus = descripcionDerechosInfEus;
	}
	
	public String getImporteSancionArtMask() {
		return UtilDate.formatearMiles(this.importeSancionArt);
	}

	public String getImporteResolucionArtMask() {
		return UtilDate.formatearMiles(this.importeResolucionArt);
	}
	
	public String getImportePagoMask() {
		return UtilDate.formatearMiles(this.importePago);
	}
	
	public String getTotalSancionMask() {
		return UtilDate.formatearMiles(this.totalSancion);
	}
	
	public String getTotalResolucionMask() {
		return UtilDate.formatearMiles(this.totalResolucion);
	}
}
