package com.ejie.ab59.model.propuestasSancion;

import java.util.Date;

import com.ejie.ab59.model.expedientes.DatosDirecciones;
import com.ejie.ab59.model.expedientes.Expedientes;
import com.ejie.ab59.model.propuestasSancion.EstadosProSan;
import com.ejie.ab59.model.tablasMaestras.Calificaciones;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * PropuestasSancion  
 * 
 *  
 */

public class PropuestasSancion implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Integer idPropuestaSancion;
	private String identificadorInspeccion;
	private Expedientes expedienteOrigen;
	private String idTipoEstablecimiento;
	private Integer idOrigenProSancion;
	private String notasRespOfi;
	private String usuarioRegistro;
	private String notas;
	private Integer estado;
	private String usuarioUltmodificacion;
	private Date fechaPropuestaOT;
	private Date fechaValidacion;
	private Date fechaRechazo;
	private Date fechaRequerimiento;
	private Date fechaRegistro;
	
	private Integer idInfraccionFind;

	private DatosDirecciones datosDirecciones;
	private Integer idSancionFind;
	private Date fechaHechoFind;
	private Calificaciones calificacionFind;

	private Integer asociadoSancion;

	private Integer idTercero;
	private Integer idDireccion;
	private Expedientes expedienteSancionador;

	private String identificadorProSan;
	public String folderId;

	private EstadosProSan estadoProSan;

	/**
	 * Method 'PropuestasSancion'.
	 */
	public PropuestasSancion() {
	}

	/**
	 * Method 'PropuestasSancion'.
	 * 
	 * @param idPropuestaSancion
	 *            Integer
	 */
	public PropuestasSancion(Integer idPropuestaSancion) {
		this.idPropuestaSancion = idPropuestaSancion;
	}

	/**
	 * Method 'PropuestasSancion'.
	 * 
	 * @param idPropuestaSancion
	 *            Integer
	 * @param identificadorInspeccion
	 *            String
	 * @param expedienteOrigen
	 *            Expedientes
	 * @param idTipoEstablecimiento
	 *            String
	 * @param idOrigenProSancion
	 *            Integer
	 * @param notasRespOfi
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param notas
	 *            String
	 * @param estado
	 *            Integer
	 * @param fechaUltmodificacion
	 *            Date
	 * @param usuarioUltmodificacion
	 *            String
	 */
	public PropuestasSancion(Integer idPropuestaSancion, String identificadorInspeccion, Expedientes expedienteOrigen,
			String idTipoEstablecimiento, Integer idOrigenProSancion, String notasRespOfi, String usuarioRegistro,
			String notas, Integer estado, String usuarioUltmodificacion) {

		this.idPropuestaSancion = idPropuestaSancion;
		this.identificadorInspeccion = identificadorInspeccion;
		this.expedienteOrigen = expedienteOrigen;
		this.idTipoEstablecimiento = idTipoEstablecimiento;
		this.idOrigenProSancion = idOrigenProSancion;
		this.notasRespOfi = notasRespOfi;
		this.usuarioRegistro = usuarioRegistro;
		this.notas = notas;
		this.estado = estado;
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	/**
	 * Method 'getIdPropuestaSancion'.
	 *
	 * @return Integer
	 */

	public Integer getIdPropuestaSancion() {
		return this.idPropuestaSancion;
	}

	/**
	 * Method 'setIdPropuestaSancion'.
	 *
	 * @param idPropuestaSancion
	 *            Integer
	 * @return
	 */

	public void setIdPropuestaSancion(Integer idPropuestaSancion) {
		this.idPropuestaSancion = idPropuestaSancion;
	}

	/**
	 * Method 'getIdentificadorInspeccion'.
	 *
	 * @return String
	 */

	public String getIdentificadorInspeccion() {
		return this.identificadorInspeccion;
	}

	/**
	 * Method 'setIdentificadorInspeccion'.
	 *
	 * @param identificadorInspeccion
	 *            String
	 * @return
	 */

	public void setIdentificadorInspeccion(String identificadorInspeccion) {
		this.identificadorInspeccion = identificadorInspeccion;
	}

	/**
	 * Method 'getExpedienteOrigen'.
	 *
	 * @return Expedientes
	 */

	public Expedientes getExpedienteOrigen() {
		return this.expedienteOrigen;
	}

	/**
	 * Method 'setExpedienteOrigen'.
	 *
	 * @param expedienteOrigen
	 *            Expedientes
	 * @return
	 */

	public void setExpedienteOrigen(Expedientes expedienteOrigen) {
		this.expedienteOrigen = expedienteOrigen;
	}

	/**
	 * Method 'getIdTipoEstablecimiento'.
	 *
	 * @return String
	 */

	public String getIdTipoEstablecimiento() {
		return this.idTipoEstablecimiento;
	}

	/**
	 * Method 'setIdTipoEstablecimiento'.
	 *
	 * @param idTipoEstablecimiento
	 *            String
	 * @return
	 */

	public void setIdTipoEstablecimiento(String idTipoEstablecimiento) {
		this.idTipoEstablecimiento = idTipoEstablecimiento;
	}

	/**
	 * Method 'getIdOrigenProSancion'.
	 *
	 * @return Integer
	 */

	public Integer getIdOrigenProSancion() {
		return this.idOrigenProSancion;
	}

	/**
	 * Method 'setIdOrigenProSancion'.
	 *
	 * @param idOrigenProSancion
	 *            Integer
	 * @return
	 */

	public void setIdOrigenProSancion(Integer idOrigenProSancion) {
		this.idOrigenProSancion = idOrigenProSancion;
	}

	/**
	 * Method 'getNotasRespOfi'.
	 *
	 * @return String
	 */

	public String getNotasRespOfi() {
		return this.notasRespOfi;
	}

	/**
	 * Method 'setNotasRespOfi'.
	 *
	 * @param notasRespOfi
	 *            String
	 * @return
	 */

	public void setNotasRespOfi(String notasRespOfi) {
		this.notasRespOfi = notasRespOfi;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'getNotas'.
	 *
	 * @return String
	 */

	public String getNotas() {
		return this.notas;
	}

	/**
	 * Method 'setNotas'.
	 *
	 * @param notas
	 *            String
	 * @return
	 */

	public void setNotas(String notas) {
		this.notas = notas;
	}

	/**
	 * Method 'getEstado'.
	 *
	 * @return Integer
	 */

	public Integer getEstado() {
		return this.estado;
	}

	/**
	 * Method 'setEstado'.
	 *
	 * @param estado
	 *            Integer
	 * @return
	 */

	public void setEstado(Integer estado) {
		this.estado = estado;
	}

	/**
	 * Method 'getUsuarioUltmodificacion'.
	 *
	 * @return String
	 */

	public String getUsuarioUltmodificacion() {
		return this.usuarioUltmodificacion;
	}

	/**
	 * Method 'setUsuarioUltmodificacion'.
	 *
	 * @param usuarioUltmodificacion
	 *            String
	 * @return
	 */

	public void setUsuarioUltmodificacion(String usuarioUltmodificacion) {
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	/**
	 * @return the fechaPropuestaOT
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaPropuestaOT() {
		return fechaPropuestaOT;
	}

	/**
	 * @param fechaPropuestaOT
	 *            the fechaPropuestaOT to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaPropuestaOT(Date fechaPropuestaOT) {
		this.fechaPropuestaOT = fechaPropuestaOT;
	}

	/**
	 * @return the fechaValidacion
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaValidacion() {
		return fechaValidacion;
	}

	/**
	 * @param fechaValidacion
	 *            the fechaValidacion to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaValidacion(Date fechaValidacion) {
		this.fechaValidacion = fechaValidacion;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRechazo() {
		return fechaRechazo;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRechazo(Date fechaRechazo) {
		this.fechaRechazo = fechaRechazo;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRequerimiento() {
		return fechaRequerimiento;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRequerimiento(Date fechaRequerimiento) {
		this.fechaRequerimiento = fechaRequerimiento;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idPropuestaSancion: ").append(this.idPropuestaSancion).append(" ]");
		result.append(", [ identificadorInspeccion: ").append(this.identificadorInspeccion).append(" ]");
		result.append(", [ idExpedienteOrigen: ").append(this.expedienteOrigen).append(" ]");
		result.append(", [ idTipoEstablecimiento: ").append(this.idTipoEstablecimiento).append(" ]");
		result.append(", [ idOrigenProSancion: ").append(this.idOrigenProSancion).append(" ]");
		result.append(", [ notasRespOfi: ").append(this.notasRespOfi).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append(", [ notas: ").append(this.notas).append(" ]");
		result.append(", [ estado: ").append(this.estado).append(" ]");
		result.append(", [ usuarioUltmodificacion: ").append(this.usuarioUltmodificacion).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * @return the idSancionFind
	 */
	public Integer getIdSancionFind() {
		return this.idSancionFind;
	}

	/**
	 * @param idSancionFind
	 *            the idSancionFind to set
	 */
	public void setIdSancionFind(Integer idSancionFind) {
		this.idSancionFind = idSancionFind;
	}

	/**
	 * @return the idInfraccionFind
	 */
	public Integer getIdInfraccionFind() {
		return this.idInfraccionFind;
	}

	/**
	 * @param idInfraccionFind
	 *            the idInfraccionFind to set
	 */
	public void setIdInfraccionFind(Integer idInfraccionFind) {
		this.idInfraccionFind = idInfraccionFind;
	}

	/**
	 * @return the fechaHechoFind
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaHechoFind() {
		return fechaHechoFind;
	}

	/**
	 * @param fechaHechoFind
	 *            the fechaHechoFind to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaHechoFind(Date fechaHechoFind) {
		this.fechaHechoFind = fechaHechoFind;
	}

	/**
	 * @return the calificacionFind
	 */
	public Calificaciones getCalificacionFind() {
		return calificacionFind;
	}

	/**
	 * @param calificacionFind
	 *            the calificacionFind to set
	 */
	public void setCalificacionFind(Calificaciones calificacionFind) {
		this.calificacionFind = calificacionFind;
	}

	/**
	 * @return the datosDirecciones
	 */
	public DatosDirecciones getDatosDirecciones() {
		return this.datosDirecciones;
	}

	/**
	 * @param datosDirecciones
	 *            the datosDirecciones to set
	 */
	public void setDatosDirecciones(DatosDirecciones datosDirecciones) {
		this.datosDirecciones = datosDirecciones;
	}

	/**
	 * @return the asociadoSancion
	 */
	public Integer getAsociadoSancion() {
		return this.asociadoSancion;
	}

	/**
	 * @param asociadoSancion
	 *            the asociadoSancion to set
	 */
	public void setAsociadoSancion(Integer asociadoSancion) {
		this.asociadoSancion = asociadoSancion;
	}

	/**
	 * @return the idTercero
	 */
	public Integer getIdTercero() {
		return idTercero;
	}

	/**
	 * @param idTercero
	 *            the idTercero to set
	 */
	public void setIdTercero(Integer idTercero) {
		this.idTercero = idTercero;
	}

	/**
	 * @return the idDireccion
	 */
	public Integer getIdDireccion() {
		return idDireccion;
	}

	/**
	 * @param idDireccion
	 *            the idDireccion to set
	 */
	public void setIdDireccion(Integer idDireccion) {
		this.idDireccion = idDireccion;
	}

	public Expedientes getExpedienteSancionador() {
		return expedienteSancionador;
	}

	public void setExpedienteSancionador(Expedientes expedienteSancionador) {
		this.expedienteSancionador = expedienteSancionador;
	}

	public String getIdentificadorProSan() {
		return identificadorProSan;
	}

	public void setIdentificadorProSan(String identificadorProSan) {
		this.identificadorProSan = identificadorProSan;
	}

	public String getFolderId() {
		return folderId;
	}

	public void setFolderId(String folderId) {
		this.folderId = folderId;
	}

	public EstadosProSan getEstadoProSan() {
		return estadoProSan;
	}

	public void setEstadoProSan(EstadosProSan estadoProSan) {
		this.estadoProSan = estadoProSan;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return fechaRegistro;
	}
	
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}
}
