package com.ejie.ab59.model.propuestasSancion;

import java.util.Date;

import com.bea.core.repackaged.springframework.context.i18n.LocaleContextHolder;
import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.model.procedimientos.Procedimientos;

public class EstadosProSan implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Integer idEstadoProSan;
	private Procedimientos procedimiento;
	private String descripcionCastellano;
	private String descripcionEuskera;
	private Date fechaRegistro;
	private String usuarioRegistro;
	private Integer porDefecto;
	private Integer proteger;

	// Para saber si es de turismo, comercio, consumo...
	private Integer idDireccion;

	/**
	 * Method 'EstadosProSan'.
	 */
	public EstadosProSan() {
	}

	/**
	 * Method 'EstadosProSan'.
	 * 
	 * @param idEstadoProSan
	 *            Integer
	 */
	public EstadosProSan(Integer idEstadoProSan) {
		this.idEstadoProSan = idEstadoProSan;
	}

	/**
	 * Method 'EstadosProSan'.
	 * 
	 * @param idEstadoProSan
	 *            Integer
	 * @param procedimiento
	 *            Procedimientos
	 * @param descripcionCastellano
	 *            String
	 * @param descripcionEuskera
	 *            String
	 * 
	 */
	public EstadosProSan(Integer idEstadoProSan, Procedimientos procedimiento, String descripcionCastellano,
			String descripcionEuskera) {

		this.idEstadoProSan = idEstadoProSan;
		this.procedimiento = procedimiento;
		this.descripcionCastellano = descripcionCastellano;
		this.descripcionEuskera = descripcionEuskera;
	}

	public Integer getIdEstadoProSan() {
		return idEstadoProSan;
	}

	public void setIdEstadoProSan(Integer idEstadoProSan) {
		this.idEstadoProSan = idEstadoProSan;
	}

	public Procedimientos getProcedimiento() {
		return procedimiento;
	}

	public void setProcedimiento(Procedimientos procedimiento) {
		this.procedimiento = procedimiento;
	}

	public String getDescripcionCastellano() {
		return descripcionCastellano;
	}

	public void setDescripcionCastellano(String descripcionCastellano) {
		this.descripcionCastellano = descripcionCastellano;
	}

	public String getDescripcionEuskera() {
		return descripcionEuskera;
	}

	public void setDescripcionEuskera(String descripcionEuskera) {
		this.descripcionEuskera = descripcionEuskera;
	}

	public Date getFechaRegistro() {
		return fechaRegistro;
	}

	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	public String getUsuarioRegistro() {
		return usuarioRegistro;
	}

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	public Integer getIdDireccion() {
		return idDireccion;
	}

	public void setIdDireccion(Integer idDireccion) {
		this.idDireccion = idDireccion;
	}

	public Integer getPorDefecto() {
		return porDefecto;
	}

	public void setPorDefecto(Integer porDefecto) {
		this.porDefecto = porDefecto;
	}

	public Integer getProteger() {
		return proteger;
	}

	public void setProteger(Integer proteger) {
		this.proteger = proteger;
	}

	public String getDescripcionDecorator() {
		if (LocaleContextHolder.getLocale().getLanguage().equalsIgnoreCase(Constantes.EUSKERA)) {
			return this.descripcionEuskera;
		} else {
			return this.descripcionCastellano;
		}
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idEstadoProSan: ").append(this.idEstadoProSan).append(" ]");
		result.append(" [ procedimiento: ").append(this.procedimiento).append(" ]");
		result.append(", [ descripcionCastellano: ").append(this.descripcionCastellano).append(" ]");
		result.append(", [ descripcionEuskera: ").append(this.descripcionEuskera).append(" ]");
		result.append(", [ fechaRegistro: ").append(this.fechaRegistro).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append("}");
		return result.toString();
	}

}
