package com.ejie.ab59.model.procedimientos;

import org.springframework.context.i18n.LocaleContextHolder;

public class Procedimientos implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Integer idProcedimiento;
	private Direcciones direcciones;
	private Integer idArea;

	private String descripcionEs;
	private String descripcionEu;
	private String codProcedureId;
	private String camposTituloExpediente;
	private String usuarioRegistro;
	private String descripcionConCodProcedure;

	private Aplicaciones aplicacion;
	private Integer inicioOficio;

	/**
	 * Method 'Procedimientos'.
	 */
	public Procedimientos() {
	}

	/**
	 * Method 'Procedimientos'.
	 * 
	 * @param idProcedimiento
	 *            Integer
	 */
	public Procedimientos(Integer idProcedimiento) {
		this.idProcedimiento = idProcedimiento;
	}

	/**
	 * Method 'Procedimientos'.
	 * 
	 * @param idProcedimiento
	 *            Integer
	 * @param codProcedureId
	 *            String
	 * @param folderId
	 *            String
	 * @param folderNumber
	 *            String
	 * @param camposTituloExpediente
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param direcciones
	 *            Direcciones
	 * @param idArea
	 *            Integer
	 */
	public Procedimientos(Integer idProcedimiento, String codProcedureId, String camposTituloExpediente,
			String usuarioRegistro, Direcciones direcciones, Integer idArea) {

		this.idProcedimiento = idProcedimiento;
		this.direcciones = direcciones;
		this.idArea = idArea;
		this.codProcedureId = codProcedureId;
		this.camposTituloExpediente = camposTituloExpediente;
		this.usuarioRegistro = usuarioRegistro;
	}

	public Procedimientos(Integer idProcedimiento, String codProcedureId, String camposTituloExpediente,
			String usuarioRegistro, Direcciones direcciones, Integer idArea, String descripcionEs,
			String descripcionEu) {

		this.idProcedimiento = idProcedimiento;
		this.direcciones = direcciones;
		this.idArea = idArea;
		this.codProcedureId = codProcedureId;
		this.camposTituloExpediente = camposTituloExpediente;
		this.usuarioRegistro = usuarioRegistro;
		this.descripcionEs = descripcionEs;
		this.descripcionEu = descripcionEu;
	}

	public Procedimientos(int idProcedimiento, String codProcedureId, String descripcionEs, String descripcionEu) {

		this.idProcedimiento = idProcedimiento;
		this.codProcedureId = codProcedureId;
		this.descripcionEs = descripcionEs;
		this.descripcionEu = descripcionEu;

	}

	public Procedimientos(Integer idProcedimiento, String codProcedureId, String camposTituloExpediente,
			String usuarioRegistro, Direcciones direcciones, String descripcionEs, String descripcionEu,
			Aplicaciones aplicacion) {

		this.idProcedimiento = idProcedimiento;
		this.direcciones = direcciones;
		this.codProcedureId = codProcedureId;
		this.camposTituloExpediente = camposTituloExpediente;
		this.usuarioRegistro = usuarioRegistro;
		this.descripcionEs = descripcionEs;
		this.descripcionEu = descripcionEu;
		this.aplicacion = aplicacion;
	}

	/**
	 * Method 'getIdProcedimiento'.
	 *
	 * @return Integer
	 */

	public Integer getIdProcedimiento() {
		return this.idProcedimiento;
	}

	/**
	 * Method 'setIdProcedimiento'.
	 *
	 * @param idProcedimiento
	 *            Integer
	 * @return
	 */

	public void setIdProcedimiento(Integer idProcedimiento) {
		this.idProcedimiento = idProcedimiento;
	}

	/**
	 * Method 'getDirecciones'.
	 *
	 * @return Direcciones
	 */

	public Direcciones getDirecciones() {
		return this.direcciones;
	}

	/**
	 * Method 'setDirecciones'.
	 *
	 * @param direcciones
	 *            Direcciones
	 * @return
	 */

	public void setDirecciones(Direcciones direcciones) {
		this.direcciones = direcciones;
	}

	/**
	 * @return the idArea
	 */
	public Integer getIdArea() {
		return this.idArea;
	}

	/**
	 * @param idArea
	 *            the idArea to set
	 */
	public void setIdArea(Integer idArea) {
		this.idArea = idArea;
	}

	/**
	 * 
	 * /** Method 'getCodProcedureId'.
	 *
	 * @return String
	 */

	public String getCodProcedureId() {
		return this.codProcedureId;
	}

	/**
	 * Method 'setCodProcedureId'.
	 *
	 * @param codProcedureId
	 *            String
	 * @return
	 */

	public void setCodProcedureId(String codProcedureId) {
		this.codProcedureId = codProcedureId;
	}

	/**
	 * Method 'getCamposTituloExpediente'.
	 *
	 * @return String
	 */

	public String getCamposTituloExpediente() {
		return this.camposTituloExpediente;
	}

	/**
	 * Method 'setCamposTituloExpediente'.
	 *
	 * @param camposTituloExpediente
	 *            String
	 * @return
	 */

	public void setCamposTituloExpediente(String camposTituloExpediente) {
		this.camposTituloExpediente = camposTituloExpediente;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	public String getDescripcionEs() {
		return descripcionEs;
	}

	public void setDescripcionEs(String descripcionEs) {
		this.descripcionEs = descripcionEs;
	}

	public String getDescripcionEu() {
		return descripcionEu;
	}

	public void setDescripcionEu(String descripcionEu) {
		this.descripcionEu = descripcionEu;
	}

	/**
	 * @return the descripcionCastellano
	 */
	public String getDescripcionConCodProcedure() {
		String idioma = LocaleContextHolder.getLocale().getLanguage();
		if ("es".equalsIgnoreCase(idioma)) {
			this.descripcionConCodProcedure = "(" + this.codProcedureId + ") : " + this.descripcionEs;
		} else {
			this.descripcionConCodProcedure = "(" + this.codProcedureId + ") : " + this.descripcionEu;
		}

		return this.descripcionConCodProcedure;
	}

	public void setDescripcionConCodProcedure(String descripcionConCodProcedure) {
		this.descripcionConCodProcedure = descripcionConCodProcedure;
	}

	// /**
	// * @return the expedienteSancion
	// */
	// public Integer getExpedienteSancion() {
	// return this.expedienteSancion;
	// }
	//
	// /**
	// * @param expedienteSancion
	// * the expedienteSancion to set
	// */
	// public void setExpedienteSancion(Integer expedienteSancion) {
	// this.expedienteSancion = expedienteSancion;
	// }

	/**
	 * @return the aplicacion
	 */
	public Aplicaciones getAplicacion() {
		return this.aplicacion;
	}

	/**
	 * @param aplicacion
	 *            the aplicacion to set
	 */
	public void setAplicacion(Aplicaciones aplicacion) {
		this.aplicacion = aplicacion;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idProcedimiento: ").append(this.idProcedimiento).append(" ]");
		result.append(", [ codProcedureId: ").append(this.codProcedureId).append(" ]");
		result.append(", [ camposTituloExpediente: ").append(this.camposTituloExpediente).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append("}");
		return result.toString();
	}

	public Integer getInicioOficio() {
		return inicioOficio;
	}

	public void setInicioOficio(Integer inicioOficio) {
		this.inicioOficio = inicioOficio;
	}

}
