package com.ejie.ab59.model.pagos;

import java.math.BigDecimal;
import java.util.Date;

import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.comun.UtilDate;
import com.ejie.ab59.model.expedientes.Expedientes;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * Liquidaciones  
 * 
 *  
 */

public class Liquidaciones implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Integer idLiquidacionPago;
	private Expedientes expediente;
	private String referenciaPago;
	private BigDecimal importe;
	private String codigoPago;
	private Date fechaPago;
	private String usuarioRegistro;
	private String usuarioUltmodificacion;
	private Integer estado;
	private Integer tipoPago;
	private Integer idTipoLiquidacion;
	private Date fechaEnvio;

	public Liquidaciones() {
	}

	public Liquidaciones(Integer idLiquidacionPago) {
		this.idLiquidacionPago = idLiquidacionPago;
	}

	public Integer getIdLiquidacionPago() {
		return this.idLiquidacionPago;
	}

	public void setIdLiquidacionPago(Integer idLiquidacionPago) {
		this.idLiquidacionPago = idLiquidacionPago;
	}

	public Expedientes getExpediente() {
		return this.expediente;
	}

	public void setExpediente(Expedientes expediente) {
		this.expediente = expediente;
	}

	public String getReferenciaPago() {
		return this.referenciaPago;
	}

	public void setReferenciaPago(String referenciaPago) {
		this.referenciaPago = referenciaPago;
	}

	public BigDecimal getImporte() {
		return this.importe;
	}

	public void setImporte(BigDecimal importe) {
		this.importe = importe;
	}

	public String getCodigoPago() {
		return this.codigoPago;
	}

	public void setCodigoPago(String codigoPago) {
		this.codigoPago = codigoPago;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaPago() {
		return this.fechaPago;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaPago(Date fechaPago) {
		this.fechaPago = fechaPago;
	}

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	public String getUsuarioUltmodificacion() {
		return this.usuarioUltmodificacion;
	}

	public void setUsuarioUltmodificacion(String usuarioUltmodificacion) {
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	public Integer getEstado() {
		return this.estado;
	}

	public void setEstado(Integer estado) {
		this.estado = estado;
	}

	public Integer getTipoPago() {
		return this.tipoPago;
	}

	public void setTipoPago(Integer tipoPago) {
		this.tipoPago = tipoPago;
	}

	public Integer getIdTipoLiquidacion() {
		return this.idTipoLiquidacion;
	}

	public void setIdTipoLiquidacion(Integer idTipoLiquidacion) {
		this.idTipoLiquidacion = idTipoLiquidacion;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaEnvio() {
		return this.fechaEnvio;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaEnvio(Date fechaEnvio) {
		this.fechaEnvio = fechaEnvio;
	}

	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idLiquidacionPago: ").append(this.idLiquidacionPago).append(" ]");
		result.append(", [ idExpediente: ").append(this.expediente != null ? this.expediente.getIdExpediente() : "null")
				.append(" ]");
		result.append(", [ referenciaPago: ").append(this.referenciaPago).append(" ]");
		result.append(", [ importe: ").append(this.importe).append(" ]");
		result.append(", [ codigoPago: ").append(this.codigoPago).append(" ]");
		result.append(", [ fechaPago: ").append(this.fechaPago).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append(", [ usuarioUltmodificacion: ").append(this.usuarioUltmodificacion).append(" ]");
		result.append(", [ estado: ").append(this.estado).append(" ]");
		result.append(", [ tipoPago: ").append(this.tipoPago).append(" ]");
		result.append(", [ idTipoLiquidacion: ").append(this.idTipoLiquidacion).append(" ]");
		result.append(", [ fechaEnvio: ").append(this.fechaEnvio).append(" ]");
		result.append("}");
		return result.toString();
	}

	public String getImporteMask() {
		return UtilDate.formatearMiles(importe);
	}

	public String getEstadoDecorator() {
		String retorno = "";
		if (this.estado != null) {
			if (this.estado.equals(Constantes.EstadosLiquidacion.SIN_ENVIAR)) {
				retorno = Constantes.EstadosLiquidacion.SIN_ENVIAR_STR;
			} else if (this.estado.equals(Constantes.EstadosLiquidacion.ENVIADA)) {
				retorno = Constantes.EstadosLiquidacion.ENVIADA_STR;
			} else if (this.estado.equals(Constantes.EstadosLiquidacion.PAGADA)) {
				retorno = Constantes.EstadosLiquidacion.PAGADA_STR;
			} else if (this.estado.equals(Constantes.EstadosLiquidacion.CANCELADA)) {
				retorno = Constantes.EstadosLiquidacion.CANCELADA_STR;
			}
		}
		return retorno;
	}
}
