package com.ejie.ab59.model.expedientes;

import java.util.List;

import org.springframework.context.i18n.LocaleContextHolder;

/**
 * 
 *  
 *
 */

public class RelExpTer implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Integer idRelExpTer;
	private Expedientes expediente;
	private DatosTerceros datosTercero;
	private TiposTercero tipoTercero;
	private String participantId;
	private String usuarioRegistro;
	private String usuarioUltmodificacion;
	private SubtipoTercero subtipoTercero;

	private List<Long> listIdSubtipoTercero;
	private List<String> listParticipantId;

	private Integer orden;

	private DatosDirecciones ubicacionDireccionPostal;
	private String tipoParticipanteCastellano;
	private String tipoParticipanteEuskera;
	private List<DatosTerceros> listaDatosTerceros;
	private String tipoParticipacionCastellano;
	private String tipoParticipacionEuskera;
	private String subtipoParticipacionCastellano;
	private String subtipoParticipacionEuskera;
	private Integer idTipoParticipacion;
	private Integer idSubtipoParticipacion;

	/**
	 * Method 'RelExpTer'.
	 */
	public RelExpTer() {
	}

	/**
	 * Method 'RelExpTer'.
	 * 
	 * @param idRelExpTer
	 *            Integer
	 */
	public RelExpTer(Integer idRelExpTer) {
		this.idRelExpTer = idRelExpTer;
	}

	/**
	 * @return the idRelExpTer
	 */
	public Integer getIdRelExpTer() {
		return this.idRelExpTer;
	}

	/**
	 * @param idRelExpTer
	 *            the idRelExpTer to set
	 */
	public void setIdRelExpTer(Integer idRelExpTer) {
		this.idRelExpTer = idRelExpTer;
	}

	/**
	 * @return the expediente
	 */
	public Expedientes getExpediente() {
		return this.expediente;
	}

	/**
	 * @param expediente
	 *            the expediente to set
	 */
	public void setExpediente(Expedientes expediente) {
		this.expediente = expediente;
	}

	/**
	 * @return the datosTercero
	 */
	public DatosTerceros getDatosTercero() {
		return this.datosTercero;
	}

	/**
	 * @param datosTercero
	 *            the datosTercero to set
	 */
	public void setDatosTercero(DatosTerceros datosTercero) {
		this.datosTercero = datosTercero;
	}

	/**
	 * @return the tipoTercero
	 */
	public TiposTercero getTipoTercero() {
		return this.tipoTercero;
	}

	/**
	 * @param tipoTercero
	 *            the tipoTercero to set
	 */
	public void setTipoTercero(TiposTercero tipoTercero) {
		this.tipoTercero = tipoTercero;
	}

	/**
	 * @return the participantId
	 */
	public String getParticipantId() {
		return this.participantId;
	}

	/**
	 * @param participantId
	 *            the participantId to set
	 */
	public void setParticipantId(String participantId) {
		this.participantId = participantId;
	}

	/**
	 * @return the usuarioRegistro
	 */
	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * @param usuarioRegistro
	 *            the usuarioRegistro to set
	 */
	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * @return the usuarioUltmodificacion
	 */
	public String getUsuarioUltmodificacion() {
		return this.usuarioUltmodificacion;
	}

	/**
	 * @param usuarioUltmodificacion
	 *            the usuarioUltmodificacion to set
	 */
	public void setUsuarioUltmodificacion(String usuarioUltmodificacion) {
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	/**
	 * @return the subtipoTercero
	 */
	public SubtipoTercero getSubtipoTercero() {
		return this.subtipoTercero;
	}

	/**
	 * @param subtipoTercero
	 *            the subtipoTercero to set
	 */
	public void setSubtipoTercero(SubtipoTercero subtipoTercero) {
		this.subtipoTercero = subtipoTercero;
	}

	/**
	 * Intended only for logging and debugging.
	 *
	 * Here, the contents of every main field are placed into the result.
	 *
	 * @return this.String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append("[idRelExpTer: ").append(this.idRelExpTer).append(" ]");
		result.append(", [idExpediente: ").append(this.expediente).append(" ]");
		result.append(", [datosTercero: ").append(this.datosTercero).append("]");
		result.append(", [idTipoTercero: ").append(this.tipoTercero).append("]");
		result.append(", [participantId: ").append(this.participantId).append("]");
		result.append(", [usuarioRegistro=").append(this.usuarioRegistro).append("]");
		result.append(", [usuarioUltmodificacion: ").append(this.usuarioUltmodificacion).append("]");
		result.append("}");
		return result.toString();
	}

	/**
	 * @return the orden
	 */
	public Integer getOrden() {
		return this.orden;
	}

	/**
	 * @param orden
	 *            the orden to set
	 */
	public void setOrden(Integer orden) {
		this.orden = orden;
	}

	public DatosDirecciones getUbicacionDireccionPostal() {
		return this.ubicacionDireccionPostal;
	}

	public void setUbicacionDireccionPostal(DatosDirecciones ubicacionDireccionPostal) {
		this.ubicacionDireccionPostal = ubicacionDireccionPostal;
	}

	public String getTipoParticipanteCastellano() {
		return this.tipoParticipanteCastellano;
	}

	public void setTipoParticipanteCastellano(String tipoParticipanteCastellano) {
		this.tipoParticipanteCastellano = tipoParticipanteCastellano;
	}

	public String getTipoParticipanteEuskera() {
		return this.tipoParticipanteEuskera;
	}

	public void setTipoParticipanteEuskera(String tipoParticipanteEuskera) {
		this.tipoParticipanteEuskera = tipoParticipanteEuskera;
	}

	public List<DatosTerceros> getListaDatosTerceros() {
		return this.listaDatosTerceros;
	}

	public void setListaDatosTerceros(List<DatosTerceros> listaDatosTerceros) {
		this.listaDatosTerceros = listaDatosTerceros;
	}

	public String getTipoParticipacionCastellano() {
		return this.tipoParticipacionCastellano;
	}

	public void setTipoParticipacionCastellano(String tipoParticipacionCastellano) {
		this.tipoParticipacionCastellano = tipoParticipacionCastellano;
	}

	public String getTipoParticipacionEuskera() {
		return this.tipoParticipacionEuskera;
	}

	public void setTipoParticipacionEuskera(String tipoParticipacionEuskera) {
		this.tipoParticipacionEuskera = tipoParticipacionEuskera;
	}

	public String getTipoParticipacionDecorator() {
		String idioma = LocaleContextHolder.getLocale().getLanguage();
		if ("es".equalsIgnoreCase(idioma)) {
			return this.tipoParticipacionCastellano;
		} else {
			return this.tipoParticipacionEuskera;
		}
	}

	public String getTipoParticipante() {
		String idioma = LocaleContextHolder.getLocale().getLanguage();
		if ("es".equalsIgnoreCase(idioma)) {
			return this.tipoParticipanteCastellano;
		} else {
			return this.tipoParticipanteEuskera;
		}
	}

	public String getSubtipoParticipacionCastellano() {
		return this.subtipoParticipacionCastellano;
	}

	public void setSubtipoParticipacionCastellano(String subtipoParticipacionCastellano) {
		this.subtipoParticipacionCastellano = subtipoParticipacionCastellano;
	}

	public String getSubtipoParticipacionEuskera() {
		return this.subtipoParticipacionEuskera;
	}

	public void setSubtipoParticipacionEuskera(String subtipoParticipacionEuskera) {
		this.subtipoParticipacionEuskera = subtipoParticipacionEuskera;
	}

	public String getSubTipoParticipacionDecorator() {
		String idioma = LocaleContextHolder.getLocale().getLanguage();
		if ("es".equalsIgnoreCase(idioma)) {
			return this.subtipoParticipacionCastellano;
		} else {
			return this.subtipoParticipacionEuskera;
		}
	}

	public Integer getIdTipoParticipacion() {
		return this.idTipoParticipacion;
	}

	public void setIdTipoParticipacion(Integer idTipoParticipacion) {
		this.idTipoParticipacion = idTipoParticipacion;
	}

	public Integer getIdSubtipoParticipacion() {
		return this.idSubtipoParticipacion;
	}

	public void setIdSubtipoParticipacion(Integer idSubtipoParticipacion) {
		this.idSubtipoParticipacion = idSubtipoParticipacion;
	}

	/**
	 * @return the listIdSubtipoTercero
	 */
	public List<Long> getListIdSubtipoTercero() {
		return this.listIdSubtipoTercero;
	}

	/**
	 * @param listIdSubtipoTercero
	 *            the listIdSubtipoTercero to set
	 */
	public void setListIdSubtipoTercero(List<Long> listIdSubtipoTercero) {
		this.listIdSubtipoTercero = listIdSubtipoTercero;
	}

	public List<String> getListParticipantId() {
		return listParticipantId;
	}

	public void setListParticipantId(List<String> listParticipantId) {
		this.listParticipantId = listParticipantId;
	}

}
