package com.ejie.ab59.model.expedientes;

import java.util.Date;

import com.ejie.ab59.model.procedimientos.Procedimientos;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * Expedientes  
 * 
 *  
 */

public class Expedientes implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Integer idExpediente;
	private Expedientes expedienteOrigen;
	private Procedimientos procedimiento;
	private Long idTerritorioHistorico;
	private String folderId;
	private String folderNumber;
	private String titulo;
	private String usuarioRegistro;
	private Long idProvinciaFiscal;
	private String usuarioUltmodificacion;

	private DatosDirecciones datosDirecciones;
	private DatosTerceros datosTerceros;
	private String tipoEmpTer;
	private Date fechaExpediente;

	/**
	 * Method 'Expedientes'.
	 */
	public Expedientes() {
	}

	/**
	 * Method 'Expedientes'.
	 * 
	 * @param idExpediente
	 *            Integer
	 */
	public Expedientes(Integer idExpediente) {
		this.idExpediente = idExpediente;
	}

	/**
	 * Method 'Expedientes'.
	 * 
	 * @param idExpediente
	 *            Integer
	 * @param procedimiento
	 *            Procedimientos
	 * @param idTerritorioHistorico
	 *            Long
	 * @param folderId
	 *            String
	 * @param folderNumber
	 *            String
	 * @param titulo
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param idProvinciaFiscal
	 *            Long
	 * @param fechaUltmodificacion
	 *            Date
	 * @param usuarioUltmodificacion
	 *            String
	 * @param expedienteOrigen
	 *            Expedientes
	 */
	public Expedientes(Integer idExpediente, Procedimientos procedimiento, Long idTerritorioHistorico, String folderId,
			String folderNumber, String titulo, Date fechaRegistro, String usuarioRegistro, Long idProvinciaFiscal,
			Date fechaUltmodificacion, String usuarioUltmodificacion, Expedientes expedienteOrigen) {
		this.idExpediente = idExpediente;
		this.expedienteOrigen = expedienteOrigen;
		this.procedimiento = procedimiento;
		this.idTerritorioHistorico = idTerritorioHistorico;
		this.folderId = folderId;
		this.folderNumber = folderNumber;
		this.titulo = titulo;
		this.usuarioRegistro = usuarioRegistro;
		this.idProvinciaFiscal = idProvinciaFiscal;
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	/**
	 * Method 'getIdExpediente'.
	 *
	 * @return Integer
	 */

	public Integer getIdExpediente() {
		return this.idExpediente;
	}

	/**
	 * Method 'setIdExpediente'.
	 *
	 * @param idExpediente
	 *            Integer
	 * @return
	 */

	public void setIdExpediente(Integer idExpediente) {
		this.idExpediente = idExpediente;
	}

	/**
	 * Method 'getExpedientes'.
	 *
	 * @return Expedientes
	 */
	@JsonIgnore

	public Expedientes getExpedienteOrigen() {
		return this.expedienteOrigen;
	}

	/**
	 * Method 'setExpedientes'.
	 *
	 * @param expedienteOrigen
	 *            Expedientes
	 * @return
	 */

	public void setExpedienteOrigen(Expedientes expedienteOrigen) {
		this.expedienteOrigen = expedienteOrigen;
	}

	/**
	 * @return the procedimiento
	 */
	public Procedimientos getProcedimiento() {
		return this.procedimiento;
	}

	/**
	 * @param procedimiento
	 *            the procedimiento to set
	 */
	public void setProcedimiento(Procedimientos procedimiento) {
		this.procedimiento = procedimiento;
	}

	/**
	 * Method 'getIdTerritorioHistorico'.
	 *
	 * @return Long
	 */

	public Long getIdTerritorioHistorico() {
		return this.idTerritorioHistorico;
	}

	/**
	 * Method 'setIdTerritorioHistorico'.
	 *
	 * @param idTerritorioHistorico
	 *            Long
	 * @return
	 */

	public void setIdTerritorioHistorico(Long idTerritorioHistorico) {
		this.idTerritorioHistorico = idTerritorioHistorico;
	}

	/**
	 * Method 'getFolderId'.
	 *
	 * @return String
	 */

	public String getFolderId() {
		return this.folderId;
	}

	/**
	 * Method 'setFolderId'.
	 *
	 * @param folderId
	 *            String
	 * @return
	 */

	public void setFolderId(String folderId) {
		this.folderId = folderId;
	}

	/**
	 * Method 'getFolderNumber'.
	 *
	 * @return String
	 */

	public String getFolderNumber() {
		return this.folderNumber;
	}

	/**
	 * Method 'setFolderNumber'.
	 *
	 * @param folderNumber
	 *            String
	 * @return
	 */

	public void setFolderNumber(String folderNumber) {
		this.folderNumber = folderNumber;
	}

	/**
	 * Method 'getTitulo'.
	 *
	 * @return String
	 */

	public String getTitulo() {
		return this.titulo;
	}

	/**
	 * Method 'setTitulo'.
	 *
	 * @param titulo
	 *            String
	 * @return
	 */

	public void setTitulo(String titulo) {
		this.titulo = titulo;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'getIdProvinciaFiscal'.
	 *
	 * @return Long
	 */

	public Long getIdProvinciaFiscal() {
		return this.idProvinciaFiscal;
	}

	/**
	 * Method 'setIdProvinciaFiscal'.
	 *
	 * @param idProvinciaFiscal
	 *            Long
	 * @return
	 */

	public void setIdProvinciaFiscal(Long idProvinciaFiscal) {
		this.idProvinciaFiscal = idProvinciaFiscal;
	}

	/**
	 * Method 'getUsuarioUltmodificacion'.
	 *
	 * @return String
	 */

	public String getUsuarioUltmodificacion() {
		return this.usuarioUltmodificacion;
	}

	/**
	 * Method 'setUsuarioUltmodificacion'.
	 *
	 * @param usuarioUltmodificacion
	 *            String
	 * @return
	 */

	public void setUsuarioUltmodificacion(String usuarioUltmodificacion) {
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	/**
	 * @return the datosDirecciones
	 */
	public DatosDirecciones getDatosDirecciones() {
		return this.datosDirecciones;
	}

	/**
	 * @param datosDirecciones
	 *            the datosDirecciones to set
	 */
	public void setDatosDirecciones(DatosDirecciones datosDirecciones) {
		this.datosDirecciones = datosDirecciones;
	}

	public DatosTerceros getDatosTerceros() {
		return datosTerceros;
	}

	public void setDatosTerceros(DatosTerceros datosTerceros) {
		this.datosTerceros = datosTerceros;
	}

	public String getTipoEmpTer() {
		return tipoEmpTer;
	}

	public void setTipoEmpTer(String tipoEmpTer) {
		this.tipoEmpTer = tipoEmpTer;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaExpediente() {
		return fechaExpediente;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaExpediente(Date fechaExpediente) {
		this.fechaExpediente = fechaExpediente;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idExpediente: ").append(this.idExpediente).append(" ]");
		result.append(", [ idProcedimiento: ").append(this.procedimiento).append(" ]");
		result.append(", [ idTerritorioHistorico: ").append(this.idTerritorioHistorico).append(" ]");
		result.append(", [ folderId: ").append(this.folderId).append(" ]");
		result.append(", [ folderNumber: ").append(this.folderNumber).append(" ]");
		result.append(", [ titulo: ").append(this.titulo).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append(", [ idProvinciaFiscal: ").append(this.idProvinciaFiscal).append(" ]");
		result.append(", [ usuarioUltmodificacion: ").append(this.usuarioUltmodificacion).append(" ]");
		result.append("}");
		return result.toString();
	}

}
