package com.ejie.ab59.model.expedientes;

import java.util.ArrayList;
import java.util.List;

/**
 * DatosTerceros  
 * 
 *  
 */

public class DatosTerceros implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Integer idTercero;
	private String documento;
	private TiposDocumento tipoDocumento;
	private String nombre;
	private String apellido1;
	private String apellido2;
	private Sexo sexo;
	private Long telefono;
	private String email;
	private Integer idioma;
	private Integer tipoParticipante;
	private Integer idRepresentante;
	private String usuarioRegistro;
	private String usuarioUltmodificacion;

	private String nombreTitular;

	private List<CanalesAviso> canalesAvisos = new ArrayList<CanalesAviso>();

	private DatosDirecciones datosDirecciones;

	/**
	 * Method 'DatosTerceros'.
	 */
	public DatosTerceros() {
	}

	/**
	 * Method 'DatosTerceros'.
	 * 
	 * @param idTercero
	 *            Integer
	 */
	public DatosTerceros(Integer idTercero) {
		this.idTercero = idTercero;
	}

	/**
	 * @return the idTercero
	 */
	public Integer getIdTercero() {
		return this.idTercero;
	}

	/**
	 * @param idTercero
	 *            the idTercero to set
	 */
	public void setIdTercero(Integer idTercero) {
		this.idTercero = idTercero;
	}

	/**
	 * @return the documento
	 */
	public String getDocumento() {
		return this.documento;
	}

	/**
	 * @param documento
	 *            the documento to set
	 */
	public void setDocumento(String documento) {
		this.documento = documento;
	}

	/**
	 * @return the tipoDocumento
	 */
	public TiposDocumento getTipoDocumento() {
		return this.tipoDocumento;
	}

	/**
	 * @param tipoDocumento
	 *            the tipoDocumento to set
	 */
	public void setTipoDocumento(TiposDocumento tipoDocumento) {
		this.tipoDocumento = tipoDocumento;
	}

	/**
	 * @return the nombre
	 */
	public String getNombre() {
		return this.nombre;
	}

	/**
	 * @param nombre
	 *            the nombre to set
	 */
	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * @return the apellido1
	 */
	public String getApellido1() {
		return this.apellido1;
	}

	/**
	 * @param apellido1
	 *            the apellido1 to set
	 */
	public void setApellido1(String apellido1) {
		this.apellido1 = apellido1;
	}

	/**
	 * @return the apellido2
	 */
	public String getApellido2() {
		return this.apellido2;
	}

	/**
	 * @param apellido2
	 *            the apellido2 to set
	 */
	public void setApellido2(String apellido2) {
		this.apellido2 = apellido2;
	}

	/**
	 * @return the idSexo
	 */
	public Sexo getSexo() {
		return this.sexo;
	}

	/**
	 * @param idSexo
	 *            the idSexo to set
	 */
	public void setSexo(Sexo sexo) {
		this.sexo = sexo;
	}

	/**
	 * @return the telefono
	 */
	public Long getTelefono() {
		return this.telefono;
	}

	/**
	 * @param telefono
	 *            the telefono to set
	 */
	public void setTelefono(Long telefono) {
		this.telefono = telefono;
	}

	/**
	 * @return the email
	 */
	public String getEmail() {
		return this.email;
	}

	/**
	 * @param email
	 *            the email to set
	 */
	public void setEmail(String email) {
		this.email = email;
	}

	/**
	 * @return the idioma
	 */
	public Integer getIdioma() {
		return this.idioma;
	}

	/**
	 * @param idioma
	 *            the idioma to set
	 */
	public void setIdioma(Integer idioma) {
		this.idioma = idioma;
	}

	/**
	 * @return the tipoParticipante
	 */
	public Integer getTipoParticipante() {
		return this.tipoParticipante;
	}

	/**
	 * @param tipoParticipante
	 *            the tipoParticipante to set
	 */
	public void setTipoParticipante(Integer tipoParticipante) {
		this.tipoParticipante = tipoParticipante;
	}

	/**
	 * @return the idRepresentante
	 */
	public Integer getIdRepresentante() {
		return this.idRepresentante;
	}

	/**
	 * @param idRepresentante
	 *            the idRepresentante to set
	 */
	public void setIdRepresentante(Integer idRepresentante) {
		this.idRepresentante = idRepresentante;
	}

	/**
	 * @return the usuarioRegistro
	 */
	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * @param usuarioRegistro
	 *            the usuarioRegistro to set
	 */
	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * @return the usuarioUltmodificacion
	 */
	public String getUsuarioUltmodificacion() {
		return this.usuarioUltmodificacion;
	}

	/**
	 * @param usuarioUltmodificacion
	 *            the usuarioUltmodificacion to set
	 */
	public void setUsuarioUltmodificacion(String usuarioUltmodificacion) {
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idTercero: ").append(this.idTercero).append(" ]");
		result.append(", [ documento: ").append(this.documento).append(" ]");
		result.append(", [ tipoDocumento: ").append(this.tipoDocumento).append(" ]");
		result.append(", [ nombre: ").append(this.nombre).append(" ]");
		result.append(", [ apellido1: ").append(this.apellido1).append(" ]");
		result.append(", [ apellido2: ").append(this.apellido2).append(" ]");
		result.append(", [ telefono: ").append(this.telefono).append(" ]");
		result.append(", [ email: ").append(this.email).append(" ]");
		result.append(", [ idioma: ").append(this.idioma).append(" ]");
		result.append(", [ tipoParticipante: ").append(this.tipoParticipante).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append(", [ usuarioUltmodificacion: ").append(this.usuarioUltmodificacion).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * @return the nombreTitular
	 */
	public String getNombreTitular() {

		if (this.apellido1 != null && this.apellido2 != null) {
			this.nombreTitular = this.nombre + " " + this.apellido1 + " " + this.apellido2;
		} else if (this.apellido1 != null) {
			this.nombreTitular = this.nombre + " " + this.apellido1;
		} else if (this.apellido2 != null) {
			this.nombreTitular = this.nombre + " " + this.apellido2;
		} else {
			this.nombreTitular = this.nombre;
		}

		return this.nombreTitular;
	}

	/**
	 * @param nombreTitular
	 *            the nombreTitular to set
	 */
	public void setNombreTitular(String nombreTitular) {
		this.nombreTitular = nombreTitular;
	}

	/**
	 * @return the canalesAvisos
	 */
	public List<CanalesAviso> getCanalesAvisos() {
		return canalesAvisos;
	}

	/**
	 * @param canalesAvisos
	 *            the canalesAvisos to set
	 */
	public void setCanalesAvisos(List<CanalesAviso> canalesAvisos) {
		this.canalesAvisos = canalesAvisos;
	}

	/**
	 * @return the datosTerceros
	 */
	public DatosDirecciones getDatosDirecciones() {
		return this.datosDirecciones;
	}

	/**
	 * @param datosTerceros
	 *            the datosTerceros to set
	 */
	public void setDatosDirecciones(DatosDirecciones datosDirecciones) {
		this.datosDirecciones = datosDirecciones;
	}
}
