package com.ejie.ab59.model.expedientes;

import com.ejie.ab59.model.nora.T17Localidad;
import com.ejie.ab59.model.nora.T17Municipio;
import com.ejie.ab59.model.nora.T17Pais;
import com.ejie.ab59.model.nora.T17Provincia;

/**
 * DatosDirecciones  
 * 
 *  
 */

public class DatosDirecciones implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Integer idDireccion;
	private TiposDireccion tipoDireccion;
	private String direccion;
	private String numero;
	private String escalera;
	private String piso;
	private String letra;
	private String codigoPostal;
	private T17Pais pais;
	private T17Provincia provincia;
	private T17Municipio municipio;
	private T17Localidad localidad;
	private String establecimiento;
	private String descripcionCiudad;
	private String descripcionProvincia;
	private Integer idProvincia;
	private String identificadorEstablecimiento;
	private String identificadorEstablecimientoUno;
	private String identificadorEstablecimientoDos;
	private String identificadorEstablecimientoTres;
	private String usuarioRegistro;
	private String usuarioUltmodificacion;

	private String ubicacionEstablecimiento;
	private String descripcionMunicipio;
	private String descripcionLocalidad;
	private String municipioLocalidad;

	/**
	 * Method 'DatosDirecciones'.
	 */
	public DatosDirecciones() {
	}

	/**
	 * Method 'DatosDirecciones'.
	 * 
	 * @param idDireccion
	 *            Integer
	 */
	public DatosDirecciones(Integer idDireccion) {
		this.idDireccion = idDireccion;
	}

	/**
	 * @return the idDireccion
	 */
	public Integer getIdDireccion() {
		return this.idDireccion;
	}

	/**
	 * @param idDireccion
	 *            the idDireccion to set
	 */
	public void setIdDireccion(Integer idDireccion) {
		this.idDireccion = idDireccion;
	}

	/**
	 * @return the tipoDireccion
	 */
	public TiposDireccion getTipoDireccion() {
		return this.tipoDireccion;
	}

	/**
	 * @param tipoDireccion
	 *            the tipoDireccion to set
	 */
	public void setTipoDireccion(TiposDireccion tipoDireccion) {
		this.tipoDireccion = tipoDireccion;
	}

	/**
	 * @return the direccion
	 */
	public String getDireccion() {
		return this.direccion;
	}

	/**
	 * @param direccion
	 *            the direccion to set
	 */
	public void setDireccion(String direccion) {
		this.direccion = direccion;
	}

	/**
	 * @return the numero
	 */
	public String getNumero() {
		return this.numero;
	}

	/**
	 * @param numero
	 *            the numero to set
	 */
	public void setNumero(String numero) {
		this.numero = numero;
	}

	/**
	 * @return the escalera
	 */
	public String getEscalera() {
		return this.escalera;
	}

	/**
	 * @param escalera
	 *            the escalera to set
	 */
	public void setEscalera(String escalera) {
		this.escalera = escalera;
	}

	/**
	 * @return the piso
	 */
	public String getPiso() {
		return this.piso;
	}

	/**
	 * @param piso
	 *            the piso to set
	 */
	public void setPiso(String piso) {
		this.piso = piso;
	}

	/**
	 * @return the letra
	 */
	public String getLetra() {
		return this.letra;
	}

	/**
	 * @param letra
	 *            the letra to set
	 */
	public void setLetra(String letra) {
		this.letra = letra;
	}

	/**
	 * @return the codigoPostal
	 */
	public String getCodigoPostal() {
		return this.codigoPostal;
	}

	/**
	 * @param codigoPostal
	 *            the codigoPostal to set
	 */
	public void setCodigoPostal(String codigoPostal) {
		this.codigoPostal = codigoPostal;
	}

	/**
	 * @return the pais
	 */
	public T17Pais getPais() {
		return this.pais;
	}

	/**
	 * @param pais
	 *            the pais to set
	 */
	public void setPais(T17Pais pais) {
		this.pais = pais;
	}

	/**
	 * @return the provincia
	 */
	public T17Provincia getProvincia() {
		return this.provincia;
	}

	/**
	 * @param provincia
	 *            the provincia to set
	 */
	public void setProvincia(T17Provincia provincia) {
		this.provincia = provincia;
	}

	/**
	 * @return the municipio
	 */
	public T17Municipio getMunicipio() {
		return this.municipio;
	}

	/**
	 * @param municipio
	 *            the municipio to set
	 */
	public void setMunicipio(T17Municipio municipio) {
		this.municipio = municipio;
	}

	/**
	 * @return the localidad
	 */
	public T17Localidad getLocalidad() {
		return this.localidad;
	}

	/**
	 * @param localidad
	 *            the localidad to set
	 */
	public void setLocalidad(T17Localidad localidad) {
		this.localidad = localidad;
	}

	/**
	 * @return the establecimiento
	 */
	public String getEstablecimiento() {
		return this.establecimiento;
	}

	/**
	 * @param establecimiento
	 *            the establecimiento to set
	 */
	public void setEstablecimiento(String establecimiento) {
		this.establecimiento = establecimiento;
	}

	/**
	 * @return the descripcionCiudad
	 */
	public String getDescripcionCiudad() {
		return this.descripcionCiudad;
	}

	/**
	 * @param descripcionCiudad
	 *            the descripcionCiudad to set
	 */
	public void setDescripcionCiudad(String descripcionCiudad) {
		this.descripcionCiudad = descripcionCiudad;
	}

	/**
	 * @return the descripcionProvincia
	 */
	public String getDescripcionProvincia() {
		return this.descripcionProvincia;
	}

	/**
	 * @param descripcionProvincia
	 *            the descripcionProvincia to set
	 */
	public void setDescripcionProvincia(String descripcionProvincia) {
		this.descripcionProvincia = descripcionProvincia;
	}

	/**
	 * @return the identificadorEstablecimiento
	 */
	public String getIdentificadorEstablecimiento() {
		return this.identificadorEstablecimiento;
	}

	/**
	 * @param identificadorEstablecimiento
	 *            the identificadorEstablecimiento to set
	 */
	public void setIdentificadorEstablecimiento(String identificadorEstablecimiento) {
		this.identificadorEstablecimiento = identificadorEstablecimiento;
		if (null != this.identificadorEstablecimiento && this.identificadorEstablecimiento.length() == 8
				&& !"".equals(identificadorEstablecimiento)) {
			this.identificadorEstablecimientoUno = identificadorEstablecimiento.substring(0, 1);
			this.identificadorEstablecimientoDos = identificadorEstablecimiento.substring(1, 3);
			this.identificadorEstablecimientoTres = identificadorEstablecimiento.substring(3, 8);
		} else {
			this.identificadorEstablecimiento = "";
		}
	}

	/**
	 * @return the identificadorEstablecimientoUno
	 */
	public String getIdentificadorEstablecimientoUno() {
		return this.identificadorEstablecimientoUno;
	}

	/**
	 * @param identificadorEstablecimientoUno
	 *            the identificadorEstablecimientoUno to set
	 */
	public void setIdentificadorEstablecimientoUno(String identificadorEstablecimientoUno) {
		this.identificadorEstablecimientoUno = identificadorEstablecimientoUno;
	}

	/**
	 * @return the identificadorEstablecimientoDos
	 */
	public String getIdentificadorEstablecimientoDos() {
		return this.identificadorEstablecimientoDos;
	}

	/**
	 * @param identificadorEstablecimientoDos
	 *            the identificadorEstablecimientoDos to set
	 */
	public void setIdentificadorEstablecimientoDos(String identificadorEstablecimientoDos) {
		this.identificadorEstablecimientoDos = identificadorEstablecimientoDos;
	}

	/**
	 * @return the identificadorEstablecimientoTres
	 */
	public String getIdentificadorEstablecimientoTres() {
		return this.identificadorEstablecimientoTres;
	}

	/**
	 * @param identificadorEstablecimientoTres
	 *            the identificadorEstablecimientoTres to set
	 */
	public void setIdentificadorEstablecimientoTres(String identificadorEstablecimientoTres) {
		this.identificadorEstablecimientoTres = identificadorEstablecimientoTres;
	}

	/**
	 * @return the usuarioRegistro
	 */
	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * @param usuarioRegistro
	 *            the usuarioRegistro to set
	 */
	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * @return the usuarioUltmodificacion
	 */
	public String getUsuarioUltmodificacion() {
		return this.usuarioUltmodificacion;
	}

	/**
	 * @param usuarioUltmodificacion
	 *            the usuarioUltmodificacion to set
	 */
	public void setUsuarioUltmodificacion(String usuarioUltmodificacion) {
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	/**
	 * @return the ubicacionEstablecimiento
	 */
	public String getUbicacionEstablecimiento() {
		this.ubicacionEstablecimiento = this.getDireccion();
		if (this.getNumero() != null) {
			this.ubicacionEstablecimiento += " " + this.getNumero();
		}
		if (this.getEscalera() != null) {
			this.ubicacionEstablecimiento += " " + this.getEscalera();
		}
		if (this.getPiso() != null) {
			this.ubicacionEstablecimiento += " " + this.getPiso();
		}
		if (this.getLetra() != null) {
			this.ubicacionEstablecimiento += " " + this.getLetra();
		}

		return this.ubicacionEstablecimiento;
	}

	/**
	 * @return the ubicacionEstablecimiento
	 */
	public String getUbicacionEstablecimientoCP() {

		if (this.getDireccion() != null) {
			this.ubicacionEstablecimiento += this.getDireccion();
		} else {
			this.ubicacionEstablecimiento = "";
		}

		if (this.getNumero() != null) {
			this.ubicacionEstablecimiento += " " + this.getNumero();
		}
		if (this.getEscalera() != null) {
			this.ubicacionEstablecimiento += " " + this.getEscalera();
		}
		if (this.getPiso() != null) {
			this.ubicacionEstablecimiento += " " + this.getPiso();
		}
		if (this.getLetra() != null) {
			this.ubicacionEstablecimiento += " " + this.getLetra();
		}

		if (this.descripcionMunicipio != null) {
			this.ubicacionEstablecimiento += " (" + this.descripcionMunicipio + ")";
		}

		return this.ubicacionEstablecimiento;
	}

	/**
	 * @param ubicacionEstablecimiento
	 *            the ubicacionEstablecimiento to set
	 */
	public void setUbicacionEstablecimiento(String ubicacionEstablecimiento) {
		this.ubicacionEstablecimiento = ubicacionEstablecimiento;
	}

	/**
	 * @return the descripcionMunicipio
	 */
	public String getDescripcionMunicipio() {
		return this.descripcionMunicipio;
	}

	/**
	 * @param descripcionMunicipio
	 *            the descripcionMunicipio to set
	 */
	public void setDescripcionMunicipio(String descripcionMunicipio) {
		this.descripcionMunicipio = descripcionMunicipio;
	}

	/**
	 * @return the descripcionLocalidad
	 */
	public String getDescripcionLocalidad() {
		return this.descripcionLocalidad;
	}

	/**
	 * @param descripcionLocalidad
	 *            the descripcionLocalidad to set
	 */
	public void setDescripcionLocalidad(String descripcionLocalidad) {
		this.descripcionLocalidad = descripcionLocalidad;
	}

	/**
	 * @return the municipioLocalidad
	 */
	public String getMunicipioLocalidad() {
		this.municipioLocalidad = this.getDescripcionMunicipio();
		if (this.getDescripcionLocalidad() != null) {
			this.municipioLocalidad += " (" + this.getDescripcionLocalidad() + ")";
		}
		return this.municipioLocalidad;
	}

	/**
	 * @param municipioLocalidad
	 *            the municipioLocalidad to set
	 */
	public void setMunicipioLocalidad(String municipioLocalidad) {
		this.municipioLocalidad = municipioLocalidad;
	}

	public Integer getIdProvincia() {
		return idProvincia;
	}

	public void setIdProvincia(Integer idProvincia) {
		this.idProvincia = idProvincia;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "DatosDirecciones [idDireccion=" + idDireccion + ", direccion=" + direccion + ", numero=" + numero
				+ ", escalera=" + escalera + ", piso=" + piso + ", letra=" + letra + ", codigoPostal=" + codigoPostal
				+ ", pais=" + pais + ", provincia=" + provincia + ", municipio=" + municipio + ", localidad="
				+ localidad + ", establecimiento=" + establecimiento + ", descripcionCiudad=" + descripcionCiudad
				+ ", descripcionProvincia=" + descripcionProvincia + ", identificadorEstablecimiento="
				+ identificadorEstablecimiento + ", identificadorEstablecimientoUno=" + identificadorEstablecimientoUno
				+ ", identificadorEstablecimientoDos=" + identificadorEstablecimientoDos
				+ ", identificadorEstablecimientoTres=" + identificadorEstablecimientoTres + ", usuarioRegistro="
				+ usuarioRegistro + ", usuarioUltmodificacion=" + usuarioUltmodificacion + ", ubicacionEstablecimiento="
				+ ubicacionEstablecimiento + ", descripcionMunicipio=" + descripcionMunicipio
				+ ", descripcionLocalidad=" + descripcionLocalidad + ", municipioLocalidad=" + municipioLocalidad + "]";
	}

}
