package com.ejie.ab59.dao.tablasMaestras;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.model.procedimientos.Procedimientos;
import com.ejie.ab59.model.tablasMaestras.TiposFinalizacion;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class TiposFinalizacionDaoImpl implements TiposFinalizacionDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDTIPOFINALIZACION", "DESCRIPCIONCASTELLANO",
			"DESCRIPCIONEUSKERA", "FECHAREGISTRO", "USUARIOREGISTRO", "FECHAULTMODIFICACION", "USUARIOULTMODIFICACION",
			"PROCEDIMIENTODESCES", "PROCEDIMIENTODESCEU" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<TiposFinalizacion> rwMap = new RowMapper<TiposFinalizacion>() {
		public TiposFinalizacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			TiposFinalizacion tipoFinalizacion = new TiposFinalizacion();
			tipoFinalizacion.setIdTipoFinalizacion(resultSet.getLong("IDTIPOFINALIZACION"));
			tipoFinalizacion.setDescripcionCastellano(resultSet.getString("DESCRIPCIONCASTELLANO"));
			tipoFinalizacion.setDescripcionEuskera(resultSet.getString("DESCRIPCIONEUSKERA"));

			Procedimientos procedimiento = new Procedimientos();
			procedimiento.setIdProcedimiento(resultSet.getInt("IDPROCEDIMIENTO"));
			procedimiento.setDescripcionEs(resultSet.getString("PROCEDIMIENTODESCES"));
			procedimiento.setDescripcionEu(resultSet.getString("PROCEDIMIENTODESCEU"));
			tipoFinalizacion.setProcedimiento(procedimiento);

			return tipoFinalizacion;
		}
	};

	private RowMapper<TiposFinalizacion> rwMapCombo = new RowMapper<TiposFinalizacion>() {
		public TiposFinalizacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			TiposFinalizacion tipoFinalizacion = new TiposFinalizacion();
			tipoFinalizacion.setIdTipoFinalizacion(resultSet.getLong("IDTIPOFINALIZACION"));
			tipoFinalizacion.setDescripcionCastellano(resultSet.getString("DESCRIPCIONCASTELLANO"));
			tipoFinalizacion.setDescripcionEuskera(resultSet.getString("DESCRIPCIONEUSKERA"));

			return tipoFinalizacion;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the TiposFinalizacion table.
	 *
	 * @param tipoFinalizacion
	 *            TiposFinalizacion
	 * @return TiposFinalizacion
	 */
	public TiposFinalizacion add(TiposFinalizacion tipoFinalizacion) {
		String query = "INSERT INTO TIPOS_FINALIZACION (ID_TIPO_FINALIZACION, DESCRIPCION_CASTELLANO, DESCRIPCION_EUSKERA, FECHA_REGISTRO, USUARIO_REGISTRO, ID_PROCEDIMIENTO, BAJA) VALUES (?,?,?,?,?,?,?)";

		tipoFinalizacion.setIdTipoFinalizacion(
				this.jdbcTemplate.queryForObject("SELECT AB59.S_AB5912T00.NEXTVAL FROM DUAL", Long.class));

		this.jdbcTemplate.update(query, tipoFinalizacion.getIdTipoFinalizacion(),
				tipoFinalizacion.getDescripcionCastellano(), tipoFinalizacion.getDescripcionEuskera(),
				tipoFinalizacion.getFechaRegistro(), tipoFinalizacion.getUsuarioRegistro(),
				tipoFinalizacion.getProcedimiento().getIdProcedimiento(), tipoFinalizacion.getBaja());
		return tipoFinalizacion;
	}

	/**
	 * Updates a single row in the TiposFinalizacion table.
	 *
	 * @param tipoFinalizacion
	 *            TiposFinalizacion
	 * @return TiposFinalizacion
	 */
	public TiposFinalizacion update(TiposFinalizacion tipoFinalizacion) {
		String query = "UPDATE TIPOS_FINALIZACION SET DESCRIPCION_CASTELLANO = ?, DESCRIPCION_EUSKERA = ?, FECHA_ULTMODIFICACION = ?, USUARIO_ULTMODIFICACION = ?, ID_PROCEDIMIENTO = ? WHERE ID_TIPO_FINALIZACION = ?";
		this.jdbcTemplate.update(query, tipoFinalizacion.getDescripcionCastellano(),
				tipoFinalizacion.getDescripcionEuskera(), tipoFinalizacion.getFechaUltmodificacion(),
				tipoFinalizacion.getUsuarioUltmodificacion(), tipoFinalizacion.getProcedimiento().getIdProcedimiento(),
				tipoFinalizacion.getIdTipoFinalizacion());
		return tipoFinalizacion;
	}

	@Override
	public void remove(TiposFinalizacion tipoFinalizacion) {
		String query = "UPDATE TIPOS_FINALIZACION SET BAJA = ?, FECHA_ULTMODIFICACION = ?, USUARIO_ULTMODIFICACION = ? WHERE ID_TIPO_FINALIZACION = ?";
		this.jdbcTemplate.update(query, tipoFinalizacion.getBaja(), tipoFinalizacion.getFechaUltmodificacion(),
				tipoFinalizacion.getUsuarioUltmodificacion(), tipoFinalizacion.getIdTipoFinalizacion());
	}

	/**
	 * Finds a single row in the TiposFinalizacion table.
	 *
	 * @param tipoFinalizacion
	 *            TiposFinalizacion
	 * @return TiposFinalizacion
	 */
	@Transactional(readOnly = true)
	public TiposFinalizacion find(TiposFinalizacion tipoFinalizacion) {
		String query = "SELECT t12.ID_TIPO_FINALIZACION IDTIPOFINALIZACION, t12.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t12.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA, T6101.ID_PROCEDIMIENTO IDPROCEDIMIENTO, T6101.DESCRIPCION_CASTELLANO PROCEDIMIENTODESCES, T6101.DESCRIPCION_EUSKERA PROCEDIMIENTODESCEU FROM TIPOS_FINALIZACION t12, PROCEDIMIENTOS T6101  WHERE t12.ID_TIPO_FINALIZACION = ? AND t12.ID_PROCEDIMIENTO = t6101.ID_PROCEDIMIENTO  ";

		List<TiposFinalizacion> tiposFinalizacionList = this.jdbcTemplate.query(query, this.rwMap,
				tipoFinalizacion.getIdTipoFinalizacion());
		return DataAccessUtils.uniqueResult(tiposFinalizacionList);
	}

	/**
	 * Finds a list of rows in the TiposFinalizacion table.
	 *
	 * @param tiposFinalizacion
	 *            TiposFinalizacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TiposFinalizacion>
	 */
	@Transactional(readOnly = true)
	public List<TiposFinalizacion> findAll(TiposFinalizacion tiposFinalizacion, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder();

		query.append(
				"SELECT  t12.ID_TIPO_FINALIZACION IDTIPOFINALIZACION, t12.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t12.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA, T6101.ID_PROCEDIMIENTO IDPROCEDIMIENTO, T6101.DESCRIPCION_CASTELLANO PROCEDIMIENTODESCES, T6101.DESCRIPCION_EUSKERA PROCEDIMIENTODESCEU");
		query.append(" FROM TIPOS_FINALIZACION t12, PROCEDIMIENTOS T6101 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tiposFinalizacion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t12.ID_PROCEDIMIENTO = t6101.ID_PROCEDIMIENTO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query,
					TiposFinalizacionDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the TiposFinalizacion table.
	 *
	 * @param tiposFinalizacion
	 *            TiposFinalizacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(TiposFinalizacion tiposFinalizacion) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TIPOS_FINALIZACION t12, PROCEDIMIENTOS T6101 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tiposFinalizacion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t12.ID_PROCEDIMIENTO = t6101.ID_PROCEDIMIENTO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TiposFinalizacion entity
	 *
	 * @param tiposFinalizacion
	 *            TiposFinalizacion Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(TiposFinalizacion tiposFinalizacion) {

		StringBuilder where = new StringBuilder(TiposFinalizacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tiposFinalizacion != null && tiposFinalizacion.getIdTipoFinalizacion() != null) {
			where.append(" AND t12.ID_TIPO_FINALIZACION = ?");
			params.add(tiposFinalizacion.getIdTipoFinalizacion());
		}
		if (tiposFinalizacion != null && tiposFinalizacion.getDescripcionCastellano() != null) {
			where.append(" AND t12.DESCRIPCION_CASTELLANO = ?");
			params.add(tiposFinalizacion.getDescripcionCastellano());
		}
		if (tiposFinalizacion != null && tiposFinalizacion.getDescripcionEuskera() != null) {
			where.append(" AND t12.DESCRICION_EUSKERA = ?");
			params.add(tiposFinalizacion.getDescripcionEuskera());
		}
		if (tiposFinalizacion != null && tiposFinalizacion.getProcedimiento() != null
				&& tiposFinalizacion.getProcedimiento().getIdProcedimiento() != null) {
			where.append(" AND t6101.ID_PROCEDIMIENTO = ?");
			params.add(tiposFinalizacion.getProcedimiento().getIdProcedimiento());
		}
		if (tiposFinalizacion != null && tiposFinalizacion.getBaja() != null) {
			where.append(" AND t12.BAJA = ?");
			params.add(tiposFinalizacion.getBaja());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Finds a list of rows in the TiposFinalizacion table.
	 *
	 * @param tiposFinalizacion
	 *            TiposFinalizacion
	 * 
	 * @return List<TiposFinalizacion>
	 */
	@Transactional(readOnly = true)
	public List<TiposFinalizacion> cargarCombo(TiposFinalizacion tiposFinalizacion) {
		StringBuilder query = new StringBuilder();
		query.append(
				"SELECT  ID_TIPO_FINALIZACION IDTIPOFINALIZACION, DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA");
		query.append(" FROM TIPOS_FINALIZACION");
		List<Object> params = new ArrayList<Object>();
		if (tiposFinalizacion != null && tiposFinalizacion.getProcedimiento() != null
				&& tiposFinalizacion.getProcedimiento().getIdProcedimiento() != null) {
			query.append(" WHERE ID_PROCEDIMIENTO = ?");
			params.add(tiposFinalizacion.getProcedimiento().getIdProcedimiento());
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMapCombo, params.toArray());
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
