package com.ejie.ab59.dao.tablasMaestras;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.model.tablasMaestras.Derechos;
import com.ejie.ab59.model.tablasMaestras.RelInfDer;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableManagerJerarquia;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * RelInfDerDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class RelInfDerDaoImpl implements RelInfDerDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDRELINFDER", "IDINFRACCION", "IDDERECHO",
			"FECHAREGISTRO", "USUARIOREGISTRO" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<RelInfDer> rwMap = new RowMapper<RelInfDer>() {
		public RelInfDer mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new RelInfDer(resultSet.getInt("IDRELINFDER"), resultSet.getInt("IDINFRACCION"),
					resultSet.getInt("IDDERECHO"), resultSet.getDate("FECHAREGISTRO"),
					resultSet.getString("USUARIOREGISTRO"));
		}
	};

	private RowMapper<RelInfDer> rwMapPK = new RowMapper<RelInfDer>() {
		public RelInfDer mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new RelInfDer(resultSet.getInt("IDRELINFDER"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<RelInfDer>> rwMapJerarquia = new RowMapper<JerarquiaDto<RelInfDer>>() {
		public JerarquiaDto<RelInfDer> mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			RelInfDer relinfder = new RelInfDer(resultSet.getInt("IDRELINFDER"), resultSet.getInt("IDINFRACCION"),
					resultSet.getInt("IDDERECHO"), resultSet.getDate("FECHAREGISTRO"),
					resultSet.getString("USUARIOREGISTRO"));

			JerarquiaDto<RelInfDer> jerarquia = new JerarquiaDto<RelInfDer>();
			jerarquia.setModel(relinfder);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the RelInfDer table.
	 *
	 * @param relinfder
	 *            RelInfDer
	 * @return RelInfDer
	 */
	public RelInfDer add(RelInfDer relinfder) {

		int idRelInfDer = this.jdbcTemplate.queryForObject("SELECT AB59.S_AB5917T00.NEXTVAL FROM DUAL", Integer.class);
		relinfder.setIdRelInfDer(idRelInfDer);

		String query = "INSERT INTO REL_INF_DER (ID_REL_INF_DER, ID_INFRACCION, ID_DERECHO, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (?,?,?,sysdate,?)";
		this.jdbcTemplate.update(query, relinfder.getIdRelInfDer(), relinfder.getIdInfraccion(),
				relinfder.getIdDerecho(), relinfder.getUsuarioRegistro());
		return relinfder;
	}

	/**
	 * Updates a single row in the RelInfDer table.
	 *
	 * @param relinfder
	 *            RelInfDer
	 * @return RelInfDer
	 */
	public RelInfDer update(RelInfDer relinfder) {
		String query = "UPDATE REL_INF_DER SET ID_INFRACCION=?, ID_DERECHO=?, FECHA_REGISTRO=?, USUARIO_REGISTRO=? WHERE ID_REL_INF_DER=?";
		this.jdbcTemplate.update(query, relinfder.getIdInfraccion(), relinfder.getIdDerecho(),
				relinfder.getFechaRegistro(), relinfder.getUsuarioRegistro(), relinfder.getIdRelInfDer());
		return relinfder;
	}

	/**
	 * Finds a single row in the RelInfDer table.
	 *
	 * @param relinfder
	 *            RelInfDer
	 * @return RelInfDer
	 */
	@Transactional(readOnly = true)
	public RelInfDer find(RelInfDer relinfder) {
		String query = "SELECT t1.ID_REL_INF_DER IDRELINFDER, t1.ID_INFRACCION IDINFRACCION, t1.ID_DERECHO IDDERECHO, t1.FECHA_REGISTRO FECHAREGISTRO, t1.USUARIO_REGISTRO USUARIOREGISTRO FROM REL_INF_DER t1  WHERE t1.ID_REL_INF_DER = ?  ";

		List<RelInfDer> relinfderList = this.jdbcTemplate.query(query, this.rwMap, relinfder.getIdRelInfDer());
		return (RelInfDer) DataAccessUtils.uniqueResult(relinfderList);
	}

	/**
	 * Removes a single row in the RelInfDer table.
	 *
	 * @param relinfder
	 *            RelInfDer
	 * @return
	 */
	public void remove(RelInfDer relinfder) {
		String query = "DELETE FROM REL_INF_DER WHERE ID_REL_INF_DER=?";
		this.jdbcTemplate.update(query, relinfder.getIdRelInfDer());
	}

	@Override
	public void removeByIdDerecho(Derechos derechos) {
		String query = "DELETE FROM REL_INF_DER WHERE ID_DERECHO = ?";
		this.jdbcTemplate.update(query, derechos.getIdDerecho());
	}

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	public List<RelInfDer> getMultiple(RelInfDer filterRelInfDer, TableRequestDto tableRequestDto, Boolean startsWith) {

		// Where clause & Params
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterRelInfDer, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbMultipleSQL = TableManager.getSelectMultipleQuery(tableRequestDto, RelInfDer.class, params,
				"ID_REL_INF_DER");

		return this.jdbcTemplate.query(sbMultipleSQL.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds a list of rows in the RelInfDer table.
	 *
	 * @param relinfder
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<RelInfDer>
	 */
	@Transactional(readOnly = true)
	public List<RelInfDer> findAll(RelInfDer relinfder, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_REL_INF_DER IDRELINFDER,t1.ID_INFRACCION IDINFRACCION,t1.ID_DERECHO IDDERECHO,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		query.append("FROM REL_INF_DER t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(relinfder);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, RelInfDerDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<RelInfDer>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the RelInfDer table using like.
	 *
	 * @param relinfder
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<RelInfDer>
	 */
	@Transactional(readOnly = true)
	public List<RelInfDer> findAllLike(RelInfDer relinfder, TableRequestDto tableRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_REL_INF_DER IDRELINFDER,t1.ID_INFRACCION IDINFRACCION,t1.ID_DERECHO IDDERECHO,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		query.append("FROM REL_INF_DER t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(relinfder, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, RelInfDerDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<RelInfDer>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the RelInfDer table.
	 *
	 * @param relinfder
	 *            RelInfDer
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(RelInfDer relinfder) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM REL_INF_DER t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(relinfder);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Counts rows in the RelInfDer table using like.
	 *
	 * @param relinfder
	 *            RelInfDer
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(RelInfDer relinfder, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM REL_INF_DER t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(relinfder, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Reorder the data list of RelInfDer selected for rup_table
	 *
	 * @param relinfder
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<RelInfDer>>
	 */
	@Override
	public List<TableRowDto<RelInfDer>> reorderSelection(RelInfDer relinfder, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_REL_INF_DER IDRELINFDER,t1.ID_INFRACCION IDINFRACCION,t1.ID_DERECHO IDDERECHO,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		// FROM
		query.append("FROM REL_INF_DER t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(relinfder, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = TableManager.getReorderQuery(query, tableRequestDto, RelInfDer.class,
				filterParamList, "IDRELINFDER");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<RelInfDer>(this.rwMapPK, tableRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 *
	 * @param filterParams
	 *            RelInfDer
	 * @param searchParams
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<RelInfDer>>
	 */
	@Override
	public List<TableRowDto<RelInfDer>> search(RelInfDer filterParams, RelInfDer searchParams,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_REL_INF_DER IDRELINFDER,t1.ID_INFRACCION IDINFRACCION,t1.ID_DERECHO IDDERECHO,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		// FROM
		query.append("FROM REL_INF_DER t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = TableManager.getSearchQuery(query, tableRequestDto, RelInfDer.class,
				filterParamList, searchSQL, searchParamList, from_alias, "IDRELINFDER");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<RelInfDer>(this.rwMapPK, tableRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 *
	 * @param filterrelinfder
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(RelInfDer filterrelinfder, TableRequestDto tableRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_REL_INF_DER IDRELINFDER,t1.ID_INFRACCION IDINFRACCION,t1.ID_DERECHO IDDERECHO,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		// FROM
		query.append("FROM REL_INF_DER t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterrelinfder, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = TableManager.getRemoveMultipleQuery(tableRequestDto, RelInfDer.class, query,
				params, "IDRELINFDER");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical RelInfDer table.
	 *
	 * @param filterRelInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<RelInfDer>>
	 */
	@Override
	public List<JerarquiaDto<RelInfDer>> findAllLikeJerarquia(RelInfDer filterRelInfDer,
			TableRequestDto tableRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_REL_INF_DER IDRELINFDER,t1.ID_INFRACCION IDINFRACCION,t1.ID_DERECHO IDDERECHO,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM REL_INF_DER t1 ");
		List<String> from = new ArrayList<String>();
		from.add("REL_INF_DER");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterRelInfDer, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = TableManagerJerarquia.getQuery(tableRequestDto, query, mapaWhere, "IDRELINFDER", "ID_PADRE", "NOMBRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = TableManagerJerarquia.getQuery(tableRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (tableRequestDto != null) {
			query = TableManagerJerarquia.getPaginationQuery(tableRequestDto, query,
					RelInfDerDaoImpl.ORDER_BY_WHITE_LIST);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterRelInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(RelInfDer filterRelInfDer, TableRequestDto tableRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM REL_INF_DER t1 ");
		List<String> from = new ArrayList<String>();
		from.add("REL_INF_DER");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterRelInfDer, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryCount(tableRequestDto, mapaWhere, "IDRELINFDER", "ID_PADRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryCount(tableRequestDto, mapaWhere, "ID",
		// "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterRelInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<RelInfDer>>
	 */
	@Override
	public List<TableRowDto<RelInfDer>> findAllChild(RelInfDer filterRelInfDer, TableRequestDto tableRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM REL_INF_DER t1 ");
		List<String> from = new ArrayList<String>();
		from.add("REL_INF_DER");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterRelInfDer, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryChildren(tableRequestDto, mapaWhere, "IDRELINFDER",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryChildren(tableRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<RelInfDer>(this.rwMapPK, "IDRELINFDER"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the RelInfDer entity
	 *
	 * @param relinfder
	 *            RelInfDer Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(RelInfDer relinfder) {

		StringBuilder where = new StringBuilder(RelInfDerDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (relinfder != null && relinfder.getIdRelInfDer() != null) {
			where.append(" AND t1.ID_REL_INF_DER = ?");
			params.add(relinfder.getIdRelInfDer());
		}
		if (relinfder != null && relinfder.getIdInfraccion() != null) {
			where.append(" AND t1.ID_INFRACCION = ?");
			params.add(relinfder.getIdInfraccion());
		}
		if (relinfder != null && relinfder.getIdDerecho() != null) {
			where.append(" AND t1.ID_DERECHO = ?");
			params.add(relinfder.getIdDerecho());
		}
		if (relinfder != null && relinfder.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(relinfder.getFechaRegistro());
		}
		if (relinfder != null && relinfder.getUsuarioRegistro() != null) {
			where.append(" AND t1.USUARIO_REGISTRO = ?");
			params.add(relinfder.getUsuarioRegistro());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the RelInfDer entity
	 *
	 * @param relinfder
	 *            RelInfDer Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(RelInfDer relinfder, Boolean startsWith) {

		StringBuilder where = new StringBuilder(RelInfDerDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (relinfder != null && relinfder.getIdRelInfDer() != null) {
			where.append(" AND t1.ID_REL_INF_DER = ?");
			params.add(relinfder.getIdRelInfDer());
		}
		if (relinfder != null && relinfder.getIdInfraccion() != null) {
			where.append(" AND t1.ID_INFRACCION = ?");
			params.add(relinfder.getIdInfraccion());
		}
		if (relinfder != null && relinfder.getIdDerecho() != null) {
			where.append(" AND t1.ID_DERECHO = ?");
			params.add(relinfder.getIdDerecho());
		}
		if (relinfder != null && relinfder.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(relinfder.getFechaRegistro());
		}
		if (relinfder != null && relinfder.getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t1.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(relinfder.getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + relinfder.getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_REGISTRO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

}
