package com.ejie.ab59.dao.tablasMaestras;

import com.ejie.ab59.model.tablasMaestras.Derechos;
import com.ejie.ab59.model.tablasMaestras.RelInfDer;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;

/**
 * RelInfDerDao  
 * 
 *  
 */

public interface RelInfDerDao {

	/**
	 * Inserts a single row in the RelInfDer table.
	 *
	 * @param relinfder
	 *            RelInfDer
	 * @return RelInfDer
	 */
	RelInfDer add(RelInfDer relinfder);

	/**
	 * Updates a single row in the RelInfDer table.
	 *
	 * @param relinfder
	 *            RelInfDer
	 * @return RelInfDer
	 */
	RelInfDer update(RelInfDer relinfder);

	/**
	 * Finds a single row in the RelInfDer table.
	 *
	 * @param relinfder
	 *            RelInfDer
	 * @return RelInfDer
	 */
	RelInfDer find(RelInfDer relinfder);

	/**
	 * Removes a single row in the RelInfDer table.
	 *
	 * @param relinfder
	 *            RelInfDer
	 */
	void remove(RelInfDer relinfder);

	/**
	 * Finds a List of rows in the RelInfDer table.
	 *
	 * @param relinfder
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<RelInfDer> findAll(RelInfDer relinfder, TableRequestDto tableRequestDto);

	/**
	 * Finds rows in the RelInfDer table using like.
	 *
	 * @param relinfder
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<RelInfDer> findAllLike(RelInfDer relinfder, TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the RelInfDer table.
	 *
	 * @param filterRelInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(RelInfDer filterRelInfDer, TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the RelInfDer table using like.
	 *
	 * @param relinfder
	 *            RelInfDer
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(RelInfDer relinfder, Boolean startsWith);

	/**
	 * Counts rows in the RelInfDer table.
	 *
	 * @param relinfder
	 *            RelInfDer
	 * @return Long
	 */
	Long findAllCount(RelInfDer relinfder);

	/**
	 * Reorder selection.
	 *
	 * @param filterRelInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<RelInfDer>>
	 */
	List<TableRowDto<RelInfDer>> reorderSelection(RelInfDer filterRelInfDer, TableRequestDto tableRequestDto,
			Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 *
	 * @param filterRelInfDer
	 *            RelInfDer
	 * @param searchRelInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<RelInfDer>>
	 */
	List<TableRowDto<RelInfDer>> search(RelInfDer filterRelInfDer, RelInfDer searchRelInfDer,
			TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical RelInfDer table.
	 *
	 * @param filterRelInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<RelInfDer>>
	 */
	List<JerarquiaDto<RelInfDer>> findAllLikeJerarquia(RelInfDer filterRelInfDer, TableRequestDto tableRequestDto);

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterRelInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	Long findAllLikeCountJerarquia(RelInfDer filterRelInfDer, TableRequestDto tableRequestDto);

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterRelInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<RelInfDer>>
	 */
	List<TableRowDto<RelInfDer>> findAllChild(RelInfDer filterRelInfDer, TableRequestDto tableRequestDto);

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	List<RelInfDer> getMultiple(RelInfDer filterRelInfDer, TableRequestDto tableRequestDto, Boolean startsWith);

	void removeByIdDerecho(Derechos derechos);

}
