package com.ejie.ab59.dao.tablasMaestras;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.model.tablasMaestras.Instructores;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class InstructoresDaoImpl implements InstructoresDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDINSTRUCTOR", "NOMBREINSTRUCTOR", "BAJA",
			"FECHAREGISTRO", "USUARIOREGISTRO", "FECHAULTMODIFICACION", "USUARIOULTMODIFICACION" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Instructores> rwMap = new RowMapper<Instructores>() {
		public Instructores mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Instructores instructor = new Instructores();
			instructor.setIdInstructor(resultSet.getLong("IDINSTRUCTOR"));
			instructor.setNombreInstructor(resultSet.getString("NOMBREINSTRUCTOR"));

			return instructor;
		}
	};

	private RowMapper<Instructores> rwMapCombo = new RowMapper<Instructores>() {
		public Instructores mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Instructores instructor = new Instructores();
			instructor.setIdInstructor(resultSet.getLong("IDINSTRUCTOR"));
			instructor.setNombreInstructor(resultSet.getString("NOMBREINSTRUCTOR"));

			return instructor;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Instructores table.
	 *
	 * @param instructor
	 *            Instructores
	 * @return Instructores
	 */
	public Instructores add(Instructores instructor) {
		String query = "INSERT INTO INSTRUCTORES (ID_INSTRUCTOR, NOMBRE_INSTRUCTOR, BAJA, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (?,?,?,?,?)";

		instructor.setIdInstructor(
				this.jdbcTemplate.queryForObject("SELECT AB59.S_AB5907T00.NEXTVAL FROM DUAL", Long.class));

		this.jdbcTemplate.update(query, instructor.getIdInstructor(), instructor.getNombreInstructor(),
				instructor.getBaja(), instructor.getFechaRegistro(), instructor.getUsuarioRegistro());
		return instructor;
	}

	/**
	 * Updates a single row in the Instructores table.
	 *
	 * @param instructor
	 *            Instructores
	 * @return Instructores
	 */
	public Instructores update(Instructores instructor) {
		String query = "UPDATE INSTRUCTORES SET NOMBRE_INSTRUCTOR = ?, FECHA_ULTMODIFICACION = ?, USUARIO_ULTMODIFICACION = ? WHERE ID_INSTRUCTOR = ?";
		this.jdbcTemplate.update(query, instructor.getNombreInstructor(), instructor.getFechaUltmodificacion(),
				instructor.getUsuarioUltmodificacion(), instructor.getIdInstructor());
		return instructor;
	}

	/**
	 * Baja lógica del registro.
	 *
	 * @param instructor
	 *            Instructores
	 * @return Instructores
	 */
	public void remove(Instructores instructor) {
		String query = "UPDATE INSTRUCTORES SET BAJA = ?, FECHA_ULTMODIFICACION = ?, USUARIO_ULTMODIFICACION = ? WHERE ID_INSTRUCTOR = ?";
		this.jdbcTemplate.update(query, instructor.getBaja(), instructor.getFechaUltmodificacion(),
				instructor.getUsuarioUltmodificacion(), instructor.getIdInstructor());

	}

	/**
	 * Finds a single row in the Instructores table.
	 *
	 * @param instructor
	 *            Instructores
	 * @return Instructores
	 */
	@Transactional(readOnly = true)
	public Instructores find(Instructores instructor) {
		String query = "SELECT t07.ID_INSTRUCTOR IDINSTRUCTOR, t07.NOMBRE_INSTRUCTOR NOMBREINSTRUCTOR FROM INSTRUCTORES t07  WHERE t07.ID_INSTRUCTOR = ?  ";

		List<Instructores> instructoresList = this.jdbcTemplate.query(query, this.rwMap, instructor.getIdInstructor());
		return (Instructores) DataAccessUtils.uniqueResult(instructoresList);
	}

	/**
	 * Finds a list of rows in the Instructores table.
	 *
	 * @param instructores
	 *            Instructores
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Instructores>
	 */
	@Transactional(readOnly = true)
	public List<Instructores> findAll(Instructores instructores, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder();

		query.append("SELECT  t07.ID_INSTRUCTOR IDINSTRUCTOR, t07.NOMBRE_INSTRUCTOR NOMBREINSTRUCTOR");
		query.append(" FROM INSTRUCTORES t07 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(instructores);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, InstructoresDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Instructores table.
	 *
	 * @param instructores
	 *            Instructores
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Instructores instructores) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM INSTRUCTORES t07 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(instructores);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Instructores entity
	 *
	 * @param instructores
	 *            Instructores Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Instructores instructores) {

		StringBuilder where = new StringBuilder(InstructoresDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (instructores != null && instructores.getIdInstructor() != null) {
			where.append(" AND t07.ID_INSTRUCTOR = ?");
			params.add(instructores.getIdInstructor());
		}
		if (instructores != null && instructores.getNombreInstructor() != null) {
			where.append(" AND t07.NOMBRE_INSTRUCTOR = ?");
			params.add(instructores.getNombreInstructor());
		}
		if (instructores != null && instructores.getBaja() != null) {
			where.append(" AND t07.BAJA = ?");
			params.add(instructores.getBaja());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Finds a list of rows in the Instructores table.
	 *
	 * @param instructores
	 *            Instructores
	 * 
	 * @return List<Instructores>
	 */
	@Transactional(readOnly = true)
	public List<Instructores> cargarCombo(Instructores instructores) {
		StringBuilder query = new StringBuilder();
		List<Object> params = new ArrayList<Object>();

		query.append("SELECT  ID_INSTRUCTOR IDINSTRUCTOR, NOMBRE_INSTRUCTOR NOMBREINSTRUCTOR");
		query.append(" FROM INSTRUCTORES");
		query.append(" WHERE 1 = 1");
		if (instructores != null && instructores.getBaja() != null) {
			if (instructores.getBaja() == Constantes.ESTADO_BAJA) {
				query.append(" AND BAJA = ?");
				params.add(instructores.getBaja());
			} else {
				query.append(" AND (BAJA = ? OR BAJA IS NULL)");
				params.add(instructores.getBaja());
			}
		}
		if (instructores != null && instructores.getIdInstructor() != null) {
			query.append(" OR ID_INSTRUCTOR = ?");
			params.add(instructores.getIdInstructor());
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMapCombo, params.toArray());
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
