package com.ejie.ab59.dao.tablasMaestras;

import java.util.List;

import com.ejie.ab59.model.tablasMaestras.Instructores;
import com.ejie.x38.dto.TableRequestDto;

/**
 * 
 *  
 *
 */

public interface InstructoresDao {

	/**
	 * Inserts a single row in the Instructores table.
	 *
	 * @param instructor
	 *            Instructores
	 * @return Instructores
	 */
	Instructores add(Instructores instructor);

	/**
	 * Updates a single row in the Instructores table.
	 *
	 * @param instructor
	 *            Instructores
	 * @return Instructores
	 */
	Instructores update(Instructores instructor);

	/**
	 * Baja lógica del registro.
	 *
	 * @param instructor
	 *            Instructores
	 * @return Instructores
	 */
	void remove(Instructores instructor);

	/**
	 * Finds a single row in the Instructores table.
	 *
	 * @param instructor
	 *            Instructores
	 * @return Instructores
	 */
	Instructores find(Instructores instructor);

	/**
	 * Finds a List of rows in the Instructores table.
	 *
	 * @param instructores
	 *            Instructores
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<Instructores> findAll(Instructores instructores, TableRequestDto tableRequestDto);

	/**
	 * Counts rows in the Instructores table.
	 *
	 * @param instructores
	 *            Instructores
	 * @return Long
	 */
	Long findAllCount(Instructores instructores);

	/**
	 * Finds a List of rows in the Instructores table.
	 *
	 * @param instructores
	 *            Instructores
	 * 
	 * @return List
	 */
	List<Instructores> cargarCombo(Instructores instructores);

}
