package com.ejie.ab59.dao.tablasMaestras;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.model.procedimientos.Procedimientos;
import com.ejie.ab59.model.propuestasSancion.RelArtInfProSan;
import com.ejie.ab59.model.tablasMaestras.Calificaciones;
import com.ejie.ab59.model.tablasMaestras.Infracciones;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class InfraccionesDaoImpl implements InfraccionesDao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Infracciones> rwMapCombo = new RowMapper<Infracciones>() {
		public Infracciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Infracciones infracciones = new Infracciones();
			infracciones.setIdInfraccion(resultSet.getInt("IDINFRACCION"));
			infracciones.setArticulo(resultSet.getString("ARTICULO"));

			return infracciones;
		}
	};

	private RowMapper<Infracciones> rwMapFilter = new RowMapper<Infracciones>() {
		public Infracciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Infracciones infracciones = new Infracciones();
			infracciones.setIdInfraccion(resultSet.getInt("IDINFRACCION"));
			Procedimientos procedimientoAux = new Procedimientos();
			procedimientoAux.setIdProcedimiento(resultSet.getInt("IDPROCEDIMIENTO"));
			procedimientoAux.setDescripcionEs(resultSet.getString("DESCPROCEDIMIENTOCAS"));
			procedimientoAux.setDescripcionEu(resultSet.getString("DESCPROCEDIMIENTOEUS"));
			infracciones.setProcedimiento(procedimientoAux);
			Calificaciones calificacionAux = new Calificaciones();
			calificacionAux.setIdCalificacion(resultSet.getLong("IDCALIFICACION"));
			calificacionAux.setDescripcionCastellano(resultSet.getString("DESCCALIFICACIONCAS"));
			calificacionAux.setDescripcionEuskera(resultSet.getString("DESCCALIFICACIONEUS"));
			infracciones.setCalificaciones(calificacionAux);
			infracciones.setArticulo(resultSet.getString("ARTICULO"));
			infracciones.setDescripcionCastellano(resultSet.getString("DESCINFRACCIONCAS"));
			infracciones.setDescripcionEuskera(resultSet.getString("DESCINFRACCIONEUS"));

			return infracciones;
		}
	};

	private RowMapper<Infracciones> rwMapFind = new RowMapper<Infracciones>() {
		public Infracciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Infracciones infracciones = new Infracciones();
			infracciones.setIdInfraccion(resultSet.getInt("IDINFRACCION"));
			Procedimientos procedimientoAux = new Procedimientos();
			procedimientoAux.setIdProcedimiento(resultSet.getInt("IDPROCEDIMIENTO"));
			infracciones.setProcedimiento(procedimientoAux);
			Calificaciones calificacionAux = new Calificaciones();
			calificacionAux.setIdCalificacion(resultSet.getLong("IDCALIFICACION"));
			infracciones.setCalificaciones(calificacionAux);
			infracciones.setArticulo(resultSet.getString("ARTICULO"));
			infracciones.setDescripcionCastellano(resultSet.getString("DESCRIPCIONCASTELLANO"));
			infracciones.setDescripcionEuskera(resultSet.getString("DESCRIPCIONEUSKERA"));

			return infracciones;
		}
	};

	private RowMapper<Infracciones> rwMapArticulo = new RowMapper<Infracciones>() {
		public Infracciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Infracciones infracciones = new Infracciones();
			infracciones.setArticulo(resultSet.getString("ARTICULO"));
			infracciones.setDescripcionCastellano(resultSet.getString("DESCCASTELLANO"));
			infracciones.setDescripcionEuskera(resultSet.getString("DESCEUSKERA"));

			return infracciones;
		}
	};

	private RowMapper<RelArtInfProSan> rwMapInfraccionesByPropuestaSancion = new RowMapper<RelArtInfProSan>() {
		public RelArtInfProSan mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			RelArtInfProSan relArtInfProSan = new RelArtInfProSan();

			relArtInfProSan.setIdRelArtInfProSan(resultSet.getInt("IDRELARTINFPROSAN"));
			Infracciones infraccionAux = new Infracciones();
			infraccionAux.setArticulo(resultSet.getString("ARTICULOINFRACCION"));
			infraccionAux.setDescripcionCastellano(resultSet.getString("DESCINFRACCIONCAS"));
			infraccionAux.setDescripcionEuskera(resultSet.getString("DESCINFRACCIONEUS"));
			Calificaciones calificacionAux = new Calificaciones();
			calificacionAux.setDescripcionCastellano(resultSet.getString("DESCCALIFICACIONCAS"));
			calificacionAux.setDescripcionEuskera(resultSet.getString("DESCCALIFICACIONEUS"));
			infraccionAux.setCalificaciones(calificacionAux);
			relArtInfProSan.setInfraccion(infraccionAux);
			relArtInfProSan.setNotasArticulo(resultSet.getString("NOTASARTICULO"));
			relArtInfProSan.setFechaHecho(resultSet.getDate("FECHAHECHO"));
			relArtInfProSan.setDescripcionHecho(resultSet.getString("DESCRIPCIONHECHO"));

			relArtInfProSan.setArticulosDerechosInf(resultSet.getString("ARTDERECHOS"));
			relArtInfProSan.setDescripcionDerechosInfCas(resultSet.getString("DESCDERECHOSCAS"));
			relArtInfProSan.setDescripcionDerechosInfEus(resultSet.getString("DESCDERECHOSEUS"));

			return relArtInfProSan;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a list of rows in the Infracciones table.
	 *
	 * @param infracciones
	 *            Infracciones
	 * 
	 * @return List<Infracciones>
	 */
	@Transactional(readOnly = true)
	public List<Infracciones> cargarCombo(Infracciones infracciones) {

		StringBuilder query = new StringBuilder();
		List<Object> params = new ArrayList<Object>();

		query.append("SELECT t1.ID_INFRACCION IDINFRACCION, t1.ARTICULO");
		query.append(" FROM INFRACCIONES t1, PROCEDIMIENTOS t2");
		query.append(" WHERE 1 = 1 AND t1.ID_PROCEDIMIENTO = T2.ID_PROCEDIMIENTO ");
		if (infracciones != null && infracciones.getBaja() != null) {
			if (infracciones.getBaja() == Constantes.ESTADO_BAJA) {
				query.append(" AND t1.BAJA = ?");
				params.add(infracciones.getBaja());
			} else {
				query.append(" AND (t1.BAJA = ? OR t1.BAJA IS NULL)");
				params.add(infracciones.getBaja());
			}
		}
		if (infracciones != null && infracciones.getIdInfraccion() != null) {
			query.append(" OR t1.ID_INFRACCION = ?");
			params.add(infracciones.getIdInfraccion());
		}
		if (infracciones != null && infracciones.getProcedimiento() != null
				&& infracciones.getProcedimiento().getIdProcedimiento() != null) {
			query.append(" AND t1.ID_PROCEDIMIENTO = ?");
			params.add(infracciones.getProcedimiento().getIdProcedimiento());
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMapCombo, params.toArray());
	}

	/**
	 * Finds a list of rows in the Infracciones table.
	 *
	 * @param infracciones
	 *            Infracciones
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Infracciones>
	 */
	@Transactional(readOnly = true)
	public List<Infracciones> findAll(Infracciones infracciones, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder();

		query.append(
				"SELECT t09.ID_INFRACCION IDINFRACCION, t6101.ID_PROCEDIMIENTO IDPROCEDIMIENTO, t6101.DESCRIPCION_CASTELLANO DESCPROCEDIMIENTOCAS, t6101.DESCRIPCION_EUSKERA DESCPROCEDIMIENTOEUS");
		query.append(
				", t04.ID_CALIFICACION IDCALIFICACION, t04.DESCRIPCION_CASTELLANO DESCCALIFICACIONCAS, t04.DESCRIPCION_EUSKERA DESCCALIFICACIONEUS");
		query.append(",t09.ARTICULO ARTICULO");
		query.append(", t09.DESCRIPCION_CASTELLANO DESCINFRACCIONCAS, t09.DESCRIPCION_EUSKERA DESCINFRACCIONEUS");
		query.append(" FROM INFRACCIONES t09");
		query.append(" INNER JOIN PROCEDIMIENTOS t6101 ON t09.ID_PROCEDIMIENTO = t6101.ID_PROCEDIMIENTO");
		query.append(" INNER JOIN CALIFICACIONES t04 ON t09.ID_CALIFICACION = t04.ID_CALIFICACION ");
		query.append(" INNER JOIN APLICACIONES t6146 ON t6101.ID_APLICACION = t6146.ID_APLICACION ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(infracciones);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMapFilter, params.toArray());
	}

	@Override
	public List<Infracciones> findByIds(String idsInfracciones) {
		String query = "SELECT T09.ARTICULO ARTICULO, T09.DESCRIPCION_CASTELLANO DESCCASTELLANO, T09.DESCRIPCION_EUSKERA DESCEUSKERA FROM INFRACCIONES T09 WHERE T09.ID_INFRACCION IN("
				+ idsInfracciones + ")";
		return this.jdbcTemplate.query(query.toString(), this.rwMapArticulo);
	}

	/**
	 * Counts rows in the Infracciones table.
	 *
	 * @param infracciones
	 *            Infracciones
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Infracciones infracciones) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1)");
		query.append(" FROM INFRACCIONES t09");
		query.append(" INNER JOIN PROCEDIMIENTOS t6101 ON t09.ID_PROCEDIMIENTO = t6101.ID_PROCEDIMIENTO");
		query.append(" INNER JOIN CALIFICACIONES t04 ON t09.ID_CALIFICACION = t04.ID_CALIFICACION ");
		query.append(" INNER JOIN APLICACIONES t6146 ON t6101.ID_APLICACION = t6146.ID_APLICACION ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(infracciones);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Infracciones entity
	 *
	 * @param infracciones
	 *            Infracciones Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Infracciones infracciones) {

		StringBuilder where = new StringBuilder(CalificacionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (infracciones != null && infracciones.getProcedimiento() != null
				&& infracciones.getProcedimiento().getInicioOficio() != null) {
			where.append(" AND t6101.INICIO_OFICIO = ?");
			params.add(infracciones.getProcedimiento().getInicioOficio());
		}

		if (infracciones != null && infracciones.getProcedimiento() != null
				&& infracciones.getProcedimiento().getAplicacion() != null
				&& infracciones.getProcedimiento().getAplicacion().getCodigoAplicacion() != null) {
			where.append(" AND t6146.CODIGO_APLICACION = ?");
			params.add(infracciones.getProcedimiento().getAplicacion().getCodigoAplicacion());
		}

		if (infracciones != null && infracciones.getBaja() != null) {
			if (infracciones.getBaja() == Constantes.ESTADO_BAJA) {
				where.append(" AND BAJA = ?");
				params.add(infracciones.getBaja());
			} else {
				where.append(" AND (BAJA = ? OR BAJA IS NULL)");
				params.add(infracciones.getBaja());
			}
		}

		/* Procedimiento */
		if (infracciones != null && infracciones.getProcedimiento() != null
				&& infracciones.getProcedimiento().getIdProcedimiento() != null) {
			where.append(" AND t09.ID_PROCEDIMIENTO = ?");
			params.add(infracciones.getProcedimiento().getIdProcedimiento());
		}

		/* Calificación */
		if (infracciones != null && infracciones.getCalificaciones() != null
				&& infracciones.getCalificaciones().getIdCalificacion() != null) {
			where.append(" AND t09.ID_CALIFICACION = ?");
			params.add(infracciones.getCalificaciones().getIdCalificacion());
		}

		/* Artículo */
		if (infracciones != null && infracciones.getArticulo() != null) {
			where.append(" AND UPPER(t09.ARTICULO) LIKE ? ESCAPE '\\'");
			params.add("%" + infracciones.getArticulo().toUpperCase() + "%");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Inserts a single row in the Infracciones table.
	 *
	 * @param infraccion
	 *            Infracciones
	 * @return Infracciones
	 */
	public Infracciones add(Infracciones infraccion) {
		String query = "INSERT INTO INFRACCIONES (ID_INFRACCION, ID_PROCEDIMIENTO, ID_CALIFICACION, ARTICULO, DESCRIPCION_CASTELLANO, DESCRIPCION_EUSKERA, BAJA, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (?,?,?,?,?,?,?,?,?)";

		infraccion.setIdInfraccion(
				this.jdbcTemplate.queryForObject("SELECT AB59.S_AB5909T00.NEXTVAL FROM DUAL", Integer.class));

		Object getCalificaciones = null;
		if (infraccion.getCalificaciones() != null && infraccion.getCalificaciones().getIdCalificacion() != null) {
			getCalificaciones = infraccion.getCalificaciones().getIdCalificacion();
		}

		this.jdbcTemplate.update(query, infraccion.getIdInfraccion(),
				infraccion.getProcedimiento().getIdProcedimiento(), getCalificaciones, infraccion.getArticulo(),
				infraccion.getDescripcionCastellano(), infraccion.getDescripcionEuskera(), infraccion.getBaja(),
				infraccion.getFechaRegistro(), infraccion.getUsuarioRegistro());

		return infraccion;
	}

	/**
	 * Finds a single row in the Infracciones table.
	 *
	 * @param infraccion
	 *            Infracciones
	 * @return Infracciones
	 */
	@Transactional(readOnly = true)
	public Infracciones find(Infracciones infraccion) {
		StringBuilder query = new StringBuilder();

		query.append(
				"SELECT ID_INFRACCION IDINFRACCION, ID_PROCEDIMIENTO IDPROCEDIMIENTO, ID_CALIFICACION IDCALIFICACION, ARTICULO ARTICULO, DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA");
		query.append(" FROM INFRACCIONES");
		query.append(" WHERE ID_INFRACCION = ?");

		List<Infracciones> infraccionesList = this.jdbcTemplate.query(query.toString(), this.rwMapFind,
				infraccion.getIdInfraccion());
		return DataAccessUtils.uniqueResult(infraccionesList);
	}

	/**
	 * Updates a single row in the Infracciones table.
	 *
	 * @param infraccion
	 *            Infracciones
	 * @return Infracciones
	 */
	public Infracciones update(Infracciones infraccion) {
		String query = "UPDATE INFRACCIONES SET ID_PROCEDIMIENTO = ?, ID_CALIFICACION = ?, ARTICULO = ?, DESCRIPCION_CASTELLANO = ?, DESCRIPCION_EUSKERA = ?, FECHA_ULTMODIFICACION = ?, USUARIO_ULTMODIFICACION = ? WHERE ID_INFRACCION = ?";

		Object getCalificaciones = null;
		if (infraccion.getCalificaciones() != null && infraccion.getCalificaciones().getIdCalificacion() != null) {
			getCalificaciones = infraccion.getCalificaciones().getIdCalificacion();
		}

		this.jdbcTemplate.update(query, infraccion.getProcedimiento().getIdProcedimiento(), getCalificaciones,
				infraccion.getArticulo(), infraccion.getDescripcionCastellano(), infraccion.getDescripcionEuskera(),
				infraccion.getFechaUltmodificacion(), infraccion.getUsuarioUltmodificacion(),
				infraccion.getIdInfraccion());

		return infraccion;
	}

	/**
	 * Baja lógica del registro.
	 *
	 * @param infraccion
	 *            Infracciones
	 * @return Infracciones
	 */
	public void remove(Infracciones infraccion) {
		String query = "UPDATE INFRACCIONES SET BAJA = ?, FECHA_ULTMODIFICACION = ?, USUARIO_ULTMODIFICACION = ? WHERE ID_INFRACCION = ?";
		this.jdbcTemplate.update(query, infraccion.getBaja(), infraccion.getFechaUltmodificacion(),
				infraccion.getUsuarioUltmodificacion(), infraccion.getIdInfraccion());

	}

	/**
	 * Finds a list of rows in the RelArtInfProSan table.
	 *
	 * @param relArtInfProSan
	 *            RelArtInfProSan
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<RelArtInfProSan>
	 */
	@Transactional(readOnly = true)
	public List<RelArtInfProSan> findInfraccionesByPropuestaSancion(RelArtInfProSan relArtInfProSan,
			TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder();

		query.append("SELECT t10.ID_REL_ART_INF_PRO_SAN IDRELARTINFPROSAN, t09.ARTICULO ARTICULOINFRACCION");
		query.append(", t09.DESCRIPCION_CASTELLANO DESCINFRACCIONCAS, t09.DESCRIPCION_EUSKERA DESCINFRACCIONEUS");
		query.append(", t04.DESCRIPCION_CASTELLANO DESCCALIFICACIONCAS, t04.DESCRIPCION_EUSKERA DESCCALIFICACIONEUS");
		query.append(", T10.FECHA_HECHO FECHAHECHO, t10.DESCRIPCION_HECHO DESCRIPCIONHECHO");
		query.append(", t10.NOTAS_ARTICULO NOTASARTICULO");
		query.append(
				", LISTAGG (t08.ARTICULO, '#') WITHIN GROUP (ORDER BY t10.ID_REL_ART_INF_PRO_SAN, t10.ID_INFRACCION, t06.ID_DERECHO) ARTDERECHOS");
		query.append(
				", LISTAGG (t08.DESCRIPCION_CASTELLANO, '#') WITHIN GROUP (ORDER BY t10.ID_REL_ART_INF_PRO_SAN, t10.ID_INFRACCION, t06.ID_DERECHO) DESCDERECHOSCAS");
		query.append(
				", LISTAGG (t08.DESCRIPCION_EUSKERA, '#') WITHIN GROUP (ORDER BY t10.ID_REL_ART_INF_PRO_SAN, t10.ID_INFRACCION, t06.ID_DERECHO) DESCDERECHOSEUS");
		query.append(" FROM REL_ART_INF_PRO_SAN t10");
		query.append(" INNER JOIN INFRACCIONES t09 ON t10.ID_INFRACCION = t09.ID_INFRACCION");
		query.append(" INNER JOIN CALIFICACIONES t04 ON t09.ID_CALIFICACION = t04.ID_CALIFICACION ");
		query.append(
				" INNER JOIN REL_ART_INF_PRO_SAN_DER t06 ON t10.ID_REL_ART_INF_PRO_SAN = t06.ID_REL_ART_INF_PRO_SAN");
		query.append(" INNER JOIN DERECHOS t08 ON t06.ID_DERECHO = t08.ID_DERECHO");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapInfraccionesByPropuestaSancion(relArtInfProSan);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		query.append(
				" GROUP BY  t10.ID_REL_ART_INF_PRO_SAN, t09.ARTICULO,  t09.DESCRIPCION_CASTELLANO,  t09.DESCRIPCION_EUSKERA");
		query.append(
				", t04.DESCRIPCION_CASTELLANO,  t04.DESCRIPCION_EUSKERA,  T10.FECHA_HECHO,  t10.DESCRIPCION_HECHO,  t10.NOTAS_ARTICULO");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMapInfraccionesByPropuestaSancion, params.toArray());
	}

	/**
	 * Counts rows in the RelArtInfProSan table.
	 *
	 * @param relArtInfProSan
	 *            RelArtInfProSan
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findInfraccionesByPropuestaSancionCount(RelArtInfProSan relArtInfProSan) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1)");
		query.append(" FROM REL_ART_INF_PRO_SAN t10");
		query.append(" INNER JOIN INFRACCIONES t09 ON t10.ID_INFRACCION = t09.ID_INFRACCION");
		query.append(" INNER JOIN CALIFICACIONES t04 ON t09.ID_CALIFICACION = t04.ID_CALIFICACION ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapInfraccionesByPropuestaSancion(relArtInfProSan);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the ArtInfProSan entity
	 *
	 * @param artInfProSan
	 *            ArtInfProSan Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMapInfraccionesByPropuestaSancion(RelArtInfProSan artInfProSan) {

		StringBuilder where = new StringBuilder(CalificacionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (artInfProSan != null && artInfProSan.getPropuestaSancion() != null
				&& artInfProSan.getPropuestaSancion().getIdPropuestaSancion() != null) {
			where.append(" AND t10.ID_PROPUESTA_SANCION = ?");
			params.add(artInfProSan.getPropuestaSancion().getIdPropuestaSancion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
