package com.ejie.ab59.dao.tablasMaestras;

import java.util.List;

import com.ejie.ab59.model.propuestasSancion.RelArtInfProSan;
import com.ejie.ab59.model.tablasMaestras.Infracciones;
import com.ejie.x38.dto.TableRequestDto;

/**
 * InfraccionesDao  
 * 
 *  
 */

public interface InfraccionesDao {

	/**
	 * Finds a List of rows in the Infracciones table.
	 *
	 * @param infracciones
	 *            Infracciones
	 * 
	 * @return List
	 */
	List<Infracciones> cargarCombo(Infracciones infracciones);

	/**
	 * Finds a List of rows in the Infracciones table.
	 *
	 * @param infracciones
	 *            Infracciones
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<Infracciones> findAll(Infracciones infracciones, TableRequestDto tableRequestDto);

	/**
	 * Counts rows in the Infracciones table.
	 *
	 * @param infracciones
	 *            Infracciones
	 * @return Long
	 */
	Long findAllCount(Infracciones infracciones);

	/**
	 * Inserts a single row in the Infracciones table.
	 *
	 * @param infraccion
	 *            Infracciones
	 * @return Infracciones
	 */
	Infracciones add(Infracciones infraccion);

	/**
	 * Finds a single row in the Infracciones table.
	 *
	 * @param infraccion
	 *            Infracciones
	 * @return Infracciones
	 */
	Infracciones find(Infracciones infraccion);

	/**
	 * Updates a single row in the Infracciones table.
	 *
	 * @param infraccion
	 *            Infracciones
	 * @return Infracciones
	 */
	Infracciones update(Infracciones infraccion);

	/**
	 * Baja lógica del registro.
	 *
	 * @param infraccion
	 *            Infracciones
	 */
	void remove(Infracciones infraccion);

	/**
	 * Finds a list of rows in the RelArtInfProSan table.
	 *
	 * @param relArtInfProSan
	 *            RelArtInfProSan
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<RelArtInfProSan>
	 */
	List<RelArtInfProSan> findInfraccionesByPropuestaSancion(RelArtInfProSan relArtInfProSan,
			TableRequestDto tableRequestDto);

	/**
	 * Counts rows in the RelArtInfProSan table.
	 *
	 * @param relArtInfProSan
	 *            RelArtInfProSan
	 * @return Long
	 */
	Long findInfraccionesByPropuestaSancionCount(RelArtInfProSan relArtInfProSan);

	List<Infracciones> findByIds(String idsInfracciones);
}
