package com.ejie.ab59.dao.tablasMaestras;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.model.procedimientos.Procedimientos;
import com.ejie.ab59.model.tablasMaestras.Derechos;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class DerechosDaoImpl implements DerechosDao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Derechos> rwMapFilter = new RowMapper<Derechos>() {
		public Derechos mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Derechos derecho = new Derechos();
			derecho.setIdDerecho(resultSet.getInt("IDDERECHO"));
			derecho.setArticulo(resultSet.getString("ARTICULO"));
			derecho.setDescripcionCastellano(resultSet.getString("DESCDERECHOCAS"));
			derecho.setDescripcionEuskera(resultSet.getString("DESCDERECHOEUS"));

			Procedimientos procedimiento = new Procedimientos();
			procedimiento.setIdProcedimiento(resultSet.getInt("IDPROCEDIMIENTO"));
			procedimiento.setDescripcionEs(resultSet.getString("PROCEDIMIENTODESCES"));
			procedimiento.setDescripcionEu(resultSet.getString("PROCEDIMIENTODESCEU"));
			derecho.setProcedimiento(procedimiento);

			return derecho;
		}
	};

	private RowMapper<Derechos> rwMapFind = new RowMapper<Derechos>() {
		public Derechos mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Derechos derecho = new Derechos();
			derecho.setIdDerecho(resultSet.getInt("IDDERECHO"));
			derecho.setArticulo(resultSet.getString("ARTICULO"));
			derecho.setDescripcionCastellano(resultSet.getString("DESCRIPCIONCASTELLANO"));
			derecho.setDescripcionEuskera(resultSet.getString("DESCRIPCIONEUSKERA"));

			return derecho;
		}
	};

	private RowMapper<Derechos> rwMapCombo = new RowMapper<Derechos>() {
		public Derechos mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Derechos derechos = new Derechos();
			derechos.setIdDerecho(resultSet.getInt("IDDERECHO"));
			derechos.setArticulo(resultSet.getString("ARTICULO"));

			return derechos;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a list of rows in the Derechos table.
	 *
	 * @param derechos
	 *            Derechos
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Derechos>
	 */
	@Transactional(readOnly = true)
	public List<Derechos> findAll(Derechos derechos, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder();

		query.append("SELECT t08.ID_DERECHO IDDERECHO");
		query.append(", t08.ARTICULO ARTICULO");
		query.append(", t08.DESCRIPCION_CASTELLANO DESCDERECHOCAS, t08.DESCRIPCION_EUSKERA DESCDERECHOEUS");
		query.append(
				", t6101.ID_PROCEDIMIENTO IDPROCEDIMIENTO, t6101.DESCRIPCION_CASTELLANO PROCEDIMIENTODESCES, t6101.DESCRIPCION_EUSKERA PROCEDIMIENTODESCEU");
		query.append(" FROM DERECHOS t08, PROCEDIMIENTOS T6101, APLICACIONES t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(derechos);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t08.ID_PROCEDIMIENTO = T6101.ID_PROCEDIMIENTO AND T6101.ID_APLICACION = t3.ID_APLICACION(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMapFilter, params.toArray());
	}

	/**
	 * Counts rows in the Derechos table.
	 *
	 * @param derechos
	 *            Derechos
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Derechos derechos) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1)");
		query.append(" FROM DERECHOS t08, PROCEDIMIENTOS t6101, APLICACIONES t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(derechos);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t08.ID_PROCEDIMIENTO = T6101.ID_PROCEDIMIENTO AND T6101.ID_APLICACION = t3.ID_APLICACION(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Derechos entity
	 *
	 * @param derechos
	 *            Derechos Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Derechos derechos) {

		StringBuilder where = new StringBuilder(CalificacionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (derechos != null && derechos.getBaja() != null) {
			if (derechos.getBaja() == Constantes.ESTADO_BAJA) {
				where.append(" AND t08.BAJA = ?");
				params.add(derechos.getBaja());
			} else {
				where.append(" AND (t08.BAJA = ? OR t08.BAJA IS NULL)");
				params.add(derechos.getBaja());
			}
		}

		if (derechos != null && derechos.getProcedimiento() != null
				&& derechos.getProcedimiento().getIdProcedimiento() != null) {
			where.append(" AND t08.ID_PROCEDIMIENTO = ?");
			params.add(derechos.getProcedimiento().getIdProcedimiento());
		}

		/* Infracción */
		if (derechos != null && derechos.getInfraccion() != null
				&& derechos.getInfraccion().getIdInfraccion() != null) {
			where.append(
					" AND ? IN (SELECT t17.ID_INFRACCION FROM REL_INF_DER t17 WHERE t08.ID_DERECHO = t17.ID_DERECHO)");
			params.add(derechos.getInfraccion().getIdInfraccion());
		}

		/* Artículo */
		if (derechos != null && derechos.getArticulo() != null) {
			where.append(" AND UPPER(t08.ARTICULO) LIKE ? ESCAPE '\\'");
			params.add("%" + derechos.getArticulo().toUpperCase() + "%");
		}

		if (derechos != null && derechos.getProcedimiento() != null
				&& derechos.getProcedimiento().getInicioOficio() != null) {
			where.append(" AND t6101.INICIO_OFICIO = ?");
			params.add(derechos.getProcedimiento().getInicioOficio());
		}

		if (derechos != null && derechos.getProcedimiento() != null
				&& derechos.getProcedimiento().getAplicacion() != null
				&& derechos.getProcedimiento().getAplicacion().getCodigoAplicacion() != null) {
			where.append(" AND t3.CODIGO_APLICACION = ?");
			params.add(derechos.getProcedimiento().getAplicacion().getCodigoAplicacion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Inserts a single row in the Derechos table.
	 *
	 * @param derechos
	 *            Derechos
	 * @return Derechos
	 */
	public Derechos add(Derechos derechos) {
		String query = "INSERT INTO DERECHOS (ID_DERECHO, ARTICULO, DESCRIPCION_CASTELLANO, DESCRIPCION_EUSKERA, BAJA, FECHA_REGISTRO, USUARIO_REGISTRO, ID_PROCEDIMIENTO) VALUES (?,?,?,?,?,?,?,?)";

		derechos.setIdDerecho(
				this.jdbcTemplate.queryForObject("SELECT AB59.S_AB5908T00.NEXTVAL FROM DUAL", Integer.class));

		this.jdbcTemplate.update(query, derechos.getIdDerecho(), derechos.getArticulo(),
				derechos.getDescripcionCastellano(), derechos.getDescripcionEuskera(), derechos.getBaja(),
				derechos.getFechaRegistro(), derechos.getUsuarioRegistro(),
				derechos.getProcedimiento().getIdProcedimiento());
		return derechos;
	}

	/**
	 * Finds a single row in the Derechos table.
	 *
	 * @param derecho
	 *            Derechos
	 * @return Derechos
	 */
	@Transactional(readOnly = true)
	public Derechos find(Derechos derecho) {
		StringBuilder query = new StringBuilder();

		query.append(
				"SELECT ID_DERECHO IDDERECHO, ARTICULO ARTICULO, DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA");
		query.append(" FROM DERECHOS");
		query.append(" WHERE ID_DERECHO = ?");

		List<Derechos> derechosList = this.jdbcTemplate.query(query.toString(), this.rwMapFind, derecho.getIdDerecho());
		return DataAccessUtils.uniqueResult(derechosList);
	}

	@Override
	public List<Derechos> findDescripciones(String derechosString) {
		StringBuilder query = new StringBuilder();

		query.append(
				"SELECT ID_DERECHO IDDERECHO, ARTICULO ARTICULO, DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA");
		query.append(" FROM DERECHOS");
		query.append(" WHERE ID_DERECHO IN (" + derechosString + ")");

		return this.jdbcTemplate.query(query.toString(), this.rwMapFind);
	}

	/**
	 * Updates a single row in the Derechos table.
	 *
	 * @param derecho
	 *            Derechos
	 * @return Derechos
	 */
	public Derechos update(Derechos derecho) {
		String query = "UPDATE DERECHOS SET ARTICULO = ?, DESCRIPCION_CASTELLANO = ?, DESCRIPCION_EUSKERA = ?, FECHA_ULTMODIFICACION = ?, USUARIO_ULTMODIFICACION = ?, ID_PROCEDIMIENTO = ? WHERE ID_DERECHO = ?";

		this.jdbcTemplate.update(query, derecho.getArticulo(), derecho.getDescripcionCastellano(),
				derecho.getDescripcionEuskera(), derecho.getFechaUltmodificacion(), derecho.getUsuarioUltmodificacion(),
				derecho.getProcedimiento().getIdProcedimiento(), derecho.getIdDerecho());
		return derecho;
	}

	/**
	 * Baja lógica del registro.
	 *
	 * @param derecho
	 *            Derechos
	 * @return Derechos
	 */
	public void remove(Derechos derecho) {
		String query = "UPDATE DERECHOS SET BAJA = ?, FECHA_ULTMODIFICACION = ?, USUARIO_ULTMODIFICACION = ? WHERE ID_DERECHO = ?";
		this.jdbcTemplate.update(query, derecho.getBaja(), derecho.getFechaUltmodificacion(),
				derecho.getUsuarioUltmodificacion(), derecho.getIdDerecho());

	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a list of rows in the Derechos table.
	 *
	 * @param derechos
	 *            Derechos
	 * 
	 * @return List<Derechos>
	 */
	public List<Derechos> cargarCombo(Derechos derechos) {

		StringBuilder query = new StringBuilder();
		List<Object> params = new ArrayList<Object>();

		query.append("SELECT t08.ID_DERECHO IDDERECHO, t08.ARTICULO");
		query.append(" FROM DERECHOS t08");
		query.append(
				" WHERE ? IN (SELECT t17.ID_INFRACCION FROM REL_INF_DER t17 WHERE t08.ID_DERECHO = t17.ID_DERECHO)");
		params.add(derechos.getInfraccion().getIdInfraccion());
		if (derechos != null && derechos.getBaja() != null) {
			if (derechos.getBaja() == Constantes.ESTADO_BAJA) {
				query.append(" AND t08.BAJA = ?");
				params.add(derechos.getBaja());
			} else {
				query.append(" AND (t08.BAJA = ? OR t08.BAJA IS NULL)");
				params.add(derechos.getBaja());
			}
		}
		if (derechos != null && derechos.getListaIdsDerechos() != null) {
			String[] idDerechos = derechos.getListaIdsDerechos().split("\\#");
			query.append(" OR t08.ID_DERECHO IN (");
			for (int i = 0; i < idDerechos.length; i++) {
				if (i == 0) {
					query.append("?");
				} else if (i != idDerechos.length) {
					query.append(", ?");
				}

				params.add(idDerechos[i]);
			}
			query.append(")");
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMapCombo, params.toArray());
	}

	/**
	 * Finds a list of rows in the Derechos table.
	 *
	 * @param derechos
	 *            Derechos
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Derechos>
	 */
	@Transactional(readOnly = true)
	public List<Derechos> cargarComboDerechos(Derechos derechos, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder();

		query.append("SELECT distinct(t08.ARTICULO)");
		query.append(", t08.ID_DERECHO IDDERECHO");
		query.append(", t08.DESCRIPCION_CASTELLANO DESCDERECHOCAS, t08.DESCRIPCION_EUSKERA DESCDERECHOEUS");
		query.append(
				", t6101.ID_PROCEDIMIENTO IDPROCEDIMIENTO, t6101.DESCRIPCION_CASTELLANO PROCEDIMIENTODESCES, t6101.DESCRIPCION_EUSKERA PROCEDIMIENTODESCEU");
		query.append(" FROM DERECHOS t08, PROCEDIMIENTOS T6101, APLICACIONES t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(derechos);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t08.ID_PROCEDIMIENTO = T6101.ID_PROCEDIMIENTO AND T6101.ID_APLICACION = t3.ID_APLICACION(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMapFilter, params.toArray());
	}
}
