package com.ejie.ab59.dao.tablasMaestras;

import java.util.List;

import com.ejie.ab59.model.tablasMaestras.Derechos;
import com.ejie.x38.dto.TableRequestDto;

/**
 * 
 *  
 *
 */

public interface DerechosDao {

	/**
	 * Finds a List of rows in the Derechos table.
	 *
	 * @param derechos
	 *            Derechos
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<Derechos> findAll(Derechos derechos, TableRequestDto tableRequestDto);

	/**
	 * Counts rows in the Derechos table.
	 *
	 * @param derechos
	 *            Derechos
	 * @return Long
	 */
	Long findAllCount(Derechos derechos);

	/**
	 * Inserts a single row in the Derechos table.
	 *
	 * @param derecho
	 *            Derechos
	 * @return Derechos
	 */
	Derechos add(Derechos derecho);

	/**
	 * Finds a single row in the Derechos table.
	 *
	 * @param infraccion
	 *            Derechos
	 * @return Derechos
	 */
	Derechos find(Derechos infraccion);

	/**
	 * Updates a single row in the Derechos table.
	 *
	 * @param derecho
	 *            Derechos
	 * @return Derechos
	 */
	Derechos update(Derechos derecho);

	/**
	 * Baja lógica del registro.
	 *
	 * @param derecho
	 *            Derechos
	 */
	void remove(Derechos derecho);

	/**
	 * Finds a list of rows in the Derechos table.
	 *
	 * @param derechos
	 *            Derechos
	 * 
	 * @return List<Derechos>
	 */
	List<Derechos> cargarCombo(Derechos derechos);

	List<Derechos> findDescripciones(String derechosString);

	List<Derechos> cargarComboDerechos(Derechos derechos, TableRequestDto tableRequestDto);
}
