package com.ejie.ab59.dao.tablasMaestras;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.clientesWS.ab61WebService.Firmantes;
import com.ejie.ab59.comun.UtilsConfig;
import com.ejie.ab59.model.procedimientos.Procedimientos;
import com.ejie.ab59.model.tablasMaestras.ConfIniOfi;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class ConfIniOfiDaoImpl implements ConfIniOfiDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDCONFINIOFI", "IDPROCEDIMIENTO",
			"PUBLICARTABLON", "PLAZOTABLON", "TIPOPLAZOTABLON", "TIPOREDACCIONTABLON", "PLAZORESOLUCION",
			"TIPOPLAZORESOLUCION", "FECHAACUERDOINICIO", "CODIGODEPEXP", "FECHAREGISTRO", "USUARIOREGISTRO",
			"FECHAULTMODIFICACION", "USUARIOULTMODIFICACION" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<ConfIniOfi> rwMap = new RowMapper<ConfIniOfi>() {
		public ConfIniOfi mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			ConfIniOfi confIniOfi = new ConfIniOfi();
			confIniOfi.setIdConfiguracion(resultSet.getLong("IDCONFINIOFI"));

			Procedimientos procedimiento = new Procedimientos();
			procedimiento.setIdProcedimiento(resultSet.getInt("IDPROCEDIMIENTO"));
			procedimiento.setDescripcionEs(resultSet.getString("PROCEDIMIENTODESCES"));
			procedimiento.setDescripcionEu(resultSet.getString("PROCEDIMIENTODESCEU"));

			confIniOfi.setProcedimiento(procedimiento);
			confIniOfi.setPlazotablon(resultSet.getInt("PLAZOTABLON"));
			confIniOfi.setPublicarTablon(resultSet.getBoolean("PUBLICARTABLON"));
			confIniOfi.setTipoPlazoTablon(resultSet.getString("TIPOPLAZOTABLON"));
			confIniOfi.setTipoRedaccionTablon(resultSet.getString("TIPOREDACCIONTABLON"));
			confIniOfi.setPlazoResolucion(resultSet.getInt("PLAZORESOLUCION"));
			confIniOfi.setTipoPlazoResolucion(resultSet.getString("TIPOPLAZORESOLUCION"));
			confIniOfi.setFechaAcuerdoInicio(resultSet.getDate("FECHAACUERDOINICIO"));
			confIniOfi.setCodigoDepartExpiente(resultSet.getString("CODIGODEPEXP"));
			confIniOfi.setUsuarioRegistro(resultSet.getString("USUARIOREGISTRO"));
			confIniOfi.setUsuarioUltmodificacion(resultSet.getString("USUARIOULTMODIFICACION"));

			Firmantes firmante = new Firmantes();
			firmante.setIdFirmante(resultSet.getInt("IDFIRMANTE"));
			firmante.setIdentificador(resultSet.getString("IDENTIFICADOR"));
			firmante.setNombreFirmante(resultSet.getString("NOMBRE"));

			confIniOfi.setFirmantes(firmante);
			return confIniOfi;
		}
	};

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<ConfIniOfi> rwMapFindByProcedimiento = new RowMapper<ConfIniOfi>() {
		public ConfIniOfi mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			ConfIniOfi confIniOfi = new ConfIniOfi();
			confIniOfi.setIdConfiguracion(resultSet.getLong("IDCONFINIOFI"));

			Procedimientos procedimiento = new Procedimientos();
			procedimiento.setIdProcedimiento(resultSet.getInt("IDPROCEDIMIENTO"));
			procedimiento.setDescripcionEs(resultSet.getString("PROCEDIMIENTODESCES"));
			procedimiento.setDescripcionEu(resultSet.getString("PROCEDIMIENTODESCEU"));

			Firmantes firmante = new Firmantes();
			firmante.setIdFirmante(resultSet.getInt("IDFIRMANTE"));
			firmante.setIdTerritorioHistorico(resultSet.getInt("IDTERRITORIOHISTORICO"));
			firmante.setApellido1(resultSet.getString("APELLIDO1"));
			firmante.setApellido2(resultSet.getString("APELLIDO2"));
			firmante.setBuzon(resultSet.getString("BUZON"));
			firmante.setNombreFirmante(resultSet.getString("NOMBRE"));
			firmante.setIdentificador(resultSet.getString("IDENTIFICADOR"));
			firmante.setUsuarioRegistro(resultSet.getString("USUARIOREGISTROFIRMANTES"));
			firmante.setUsuarioUltmodificacion(resultSet.getString("USUARIOULTMODIFFIRMANTES"));
			firmante.setDescProvincia(resultSet.getString("DESCPROVINCIA"));

			confIniOfi.setProcedimiento(procedimiento);
			confIniOfi.setPlazotablon(resultSet.getInt("PLAZOTABLON"));
			if (resultSet.wasNull()) {
				confIniOfi.setPlazotablon(null);
			}
			confIniOfi.setPublicarTablon(resultSet.getBoolean("PUBLICARTABLON"));
			confIniOfi.setTipoPlazoTablon(resultSet.getString("TIPOPLAZOTABLON"));
			confIniOfi.setTipoRedaccionTablon(resultSet.getString("TIPOREDACCIONTABLON"));
			confIniOfi.setCodigoDepExp(resultSet.getString("CODIGODEPEXP"));
			confIniOfi.setUsuarioRegistro(resultSet.getString("USUARIOREGISTRO"));
			confIniOfi.setUsuarioUltmodificacion(resultSet.getString("USUARIOULTMODIFICACION"));
			confIniOfi.setFechaAcuerdoInicio(resultSet.getDate("FECHAACUERDOINICIO"));
			confIniOfi.setPlazoResolucion(resultSet.getInt("PLAZORESOLUCION"));
			if (resultSet.wasNull()) {
				confIniOfi.setPlazoResolucion(null);
			}
			confIniOfi.setTipoPlazoResolucion(resultSet.getString("TIPOPLAZORESOLUCION"));
			confIniOfi.setFirmante(firmante);

			return confIniOfi;
		}
	};

	private RowMapper<String> rwMapTipoAlcanceResolucion = new RowMapper<String>() {
		public String mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			return resultSet.getString("DESCRIPCIONCASTELLANO");
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	@Override
	public ConfIniOfi add(ConfIniOfi confiniofi) {

		String query = "INSERT INTO CONF_INI_OFI (ID_CONF_INI_OFI, ID_PROCEDIMIENTO, PUBLICAR_TABLON, PLAZO_TABLON, TIPO_PLAZO_TABLON, TIPO_REDACCION_TABLON,"
				+ " PLAZO_RESOLUCION, TIPO_PLAZO_RESOLUCION, FECHA_ACUERDO_INICIO, CODIGO_DEP_EXP, ID_FIR_RESOLUCION, "
				+ " FECHA_REGISTRO, USUARIO_REGISTRO, USUARIO_ULTMODIFICACION) VALUES (?,?,?,?,?,?,?,?,?,?,?,SYSDATE,?,?)";

		confiniofi.setIdConfiguracion(
				this.jdbcTemplate.queryForObject("SELECT AB59.S_AB5920T00.NEXTVAL FROM DUAL", Long.class));

		this.jdbcTemplate.update(query, confiniofi.getIdConfiguracion(),
				confiniofi.getProcedimiento().getIdProcedimiento(), confiniofi.getPublicarTablon(),
				confiniofi.getPlazotablon(), confiniofi.getTipoPlazoTablon(), confiniofi.getTipoRedaccionTablon(),
				confiniofi.getPlazoResolucion(), confiniofi.getTipoPlazoResolucion(),
				confiniofi.getFechaAcuerdoInicio(), confiniofi.getCodigoDepartExpiente(),
				confiniofi.getFirmantes().getIdFirmante(), confiniofi.getUsuarioRegistro(),
				confiniofi.getUsuarioUltmodificacion());
		return confiniofi;
	}

	@Override
	public ConfIniOfi update(ConfIniOfi confiniofi) {
		String query = "UPDATE CONF_INI_OFI SET ID_PROCEDIMIENTO = ?, PUBLICAR_TABLON = ?, PLAZO_TABLON = ?, TIPO_PLAZO_TABLON = ?, TIPO_REDACCION_TABLON = ?,"
				+ " PLAZO_RESOLUCION = ?, TIPO_PLAZO_RESOLUCION = ?, FECHA_ACUERDO_INICIO = ?, CODIGO_DEP_EXP = ?, ID_FIR_RESOLUCION = ?, "
				+ " FECHA_ULTMODIFICACION = SYSDATE, USUARIO_ULTMODIFICACION = ? WHERE ID_CONF_INI_OFI = ?";
		this.jdbcTemplate.update(query, confiniofi.getProcedimiento().getIdProcedimiento(),
				confiniofi.getPublicarTablon(), confiniofi.getPlazotablon(), confiniofi.getTipoPlazoTablon(),
				confiniofi.getTipoRedaccionTablon(), confiniofi.getPlazoResolucion(),
				confiniofi.getTipoPlazoResolucion(), confiniofi.getFechaAcuerdoInicio(),
				confiniofi.getCodigoDepartExpiente(), confiniofi.getFirmantes().getIdFirmante(),
				confiniofi.getUsuarioUltmodificacion(), confiniofi.getIdConfiguracion());
		return confiniofi;
	}

	@Override
	public void remove(ConfIniOfi confiniofi) {
		String query = "DELETE FROM CONF_INI_OFI WHERE ID_CONF_INI_OFI = ?";
		this.jdbcTemplate.update(query, confiniofi.getIdConfiguracion());
	}

	@Override
	@Transactional(readOnly = true)
	public ConfIniOfi find(ConfIniOfi confiniofi) {
		String query = "SELECT t5920.ID_CONF_INI_OFI IDCONFINIOFI, t5920.ID_PROCEDIMIENTO IDPROCEDIMIENTO, t5920.PUBLICAR_TABLON PUBLICARTABLON, "
				+ " t5920.PLAZO_TABLON PLAZOTABLON, t5920.TIPO_PLAZO_TABLON TIPOPLAZOTABLON, t5920.TIPO_REDACCION_TABLON TIPOREDACCIONTABLON, "
				+ " t5920.PLAZO_RESOLUCION PLAZORESOLUCION, t5920.TIPO_PLAZO_RESOLUCION TIPOPLAZORESOLUCION, t5920.FECHA_ACUERDO_INICIO FECHAACUERDOINICIO, t5920.CODIGO_DEP_EXP CODIGODEPEXP, "
				+ " t5920.FECHA_REGISTRO FECHAREGISTRO, t5920.USUARIO_REGISTRO USUARIOREGISTRO, t5920.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, t5920.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, "
				+ " t6101.ID_PROCEDIMIENTO IDPROCEDIMIENTO, t6101.DESCRIPCION_CASTELLANO PROCEDIMIENTODESCES, t6101.DESCRIPCION_EUSKERA PROCEDIMIENTODESCEU, "
				+ " t6156.ID_FIRMANTE IDFIRMANTE, t6156.IDENTIFICADOR, t6156.NOMBRE "
				+ " FROM CONF_INI_OFI t5920, PROCEDIMIENTOS t6101, FIRMANTES t6156  "
				+ " WHERE t5920.ID_CONF_INI_OFI = ?  AND t5920.ID_PROCEDIMIENTO = t6101.ID_PROCEDIMIENTO AND t5920.ID_FIR_RESOLUCION = t6156.ID_FIRMANTE";

		List<ConfIniOfi> confiniofiList = this.jdbcTemplate.query(query, this.rwMap, confiniofi.getIdConfiguracion());
		return (ConfIniOfi) DataAccessUtils.uniqueResult(confiniofiList);
	}

	@Override
	public ConfIniOfi findByProcedimiento(Procedimientos procedimiento) {
		String query = "SELECT t5920.ID_CONF_INI_OFI IDCONFINIOFI, t5920.ID_PROCEDIMIENTO IDPROCEDIMIENTO, t5920.CODIGO_DEP_EXP CODIGODEPEXP, t5920.PUBLICAR_TABLON PUBLICARTABLON, "
				+ " t5920.PLAZO_TABLON PLAZOTABLON, t5920.TIPO_PLAZO_TABLON TIPOPLAZOTABLON, t5920.TIPO_REDACCION_TABLON TIPOREDACCIONTABLON, t5920.FECHA_REGISTRO FECHAREGISTRO, "
				+ " t5920.USUARIO_REGISTRO USUARIOREGISTRO, t5920.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, t5920.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, t5920.PLAZO_RESOLUCION PLAZORESOLUCION, t5920.TIPO_PLAZO_RESOLUCION TIPOPLAZORESOLUCION, t5920.FECHA_ACUERDO_INICIO FECHAACUERDOINICIO, "
				+ " t6101.ID_PROCEDIMIENTO IDPROCEDIMIENTO, t6101.DESCRIPCION_CASTELLANO PROCEDIMIENTODESCES, t6101.DESCRIPCION_EUSKERA PROCEDIMIENTODESCEU, t6156.ID_FIRMANTE IDFIRMANTE, t6156.APELLIDO1 APELLIDO1, t6156.APELLIDO2 APELLIDO2, t6156.BUZON BUZON, t6156.NOMBRE NOMBRE, t6156.IDENTIFICADOR IDENTIFICADOR, t6156.ID_TERRITORIO_HISTORICO IDTERRITORIOHISTORICO, t6156.USUARIO_REGISTRO USUARIOREGISTROFIRMANTES, t6156.USUARIO_ULTMODIFICACION USUARIOULTMODIFFIRMANTES, PROV.DS_O DESCPROVINCIA "
				+ " FROM CONF_INI_OFI t5920, PROCEDIMIENTOS T6101, FIRMANTES t6156, "
				+ UtilsConfig.getAppProperties().getProperty("NORA.DB")
				+ ".T17_PROVINCIA PROV  WHERE t5920.ID_PROCEDIMIENTO = ?  AND t5920.ID_PROCEDIMIENTO = t6101.ID_PROCEDIMIENTO AND t5920.ID_FIR_RESOLUCION = t6156.ID_FIRMANTE AND t6156.ID_TERRITORIO_HISTORICO = PROV.ID(+) ";

		List<ConfIniOfi> confiniofiList = this.jdbcTemplate.query(query, this.rwMapFindByProcedimiento,
				procedimiento.getIdProcedimiento());
		return (ConfIniOfi) DataAccessUtils.uniqueResult(confiniofiList);
	}

	@Override
	@Transactional(readOnly = true)
	public List<ConfIniOfi> findAll(ConfIniOfi confiniofi, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder();

		query.append("SELECT t5920.ID_CONF_INI_OFI IDCONFINIOFI, t5920.PUBLICAR_TABLON PUBLICARTABLON, "
				+ " t5920.PLAZO_TABLON PLAZOTABLON, t5920.TIPO_PLAZO_TABLON TIPOPLAZOTABLON, t5920.TIPO_REDACCION_TABLON TIPOREDACCIONTABLON, "
				+ " t5920.PLAZO_RESOLUCION PLAZORESOLUCION, t5920.TIPO_PLAZO_RESOLUCION TIPOPLAZORESOLUCION, t5920.FECHA_ACUERDO_INICIO FECHAACUERDOINICIO, t5920.CODIGO_DEP_EXP CODIGODEPEXP, "
				+ " t5920.FECHA_REGISTRO FECHAREGISTRO, t5920.USUARIO_REGISTRO USUARIOREGISTRO, t5920.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, t5920.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, "
				+ " t6101.ID_PROCEDIMIENTO IDPROCEDIMIENTO, t6101.DESCRIPCION_CASTELLANO PROCEDIMIENTODESCES, t6101.DESCRIPCION_EUSKERA PROCEDIMIENTODESCEU, "
				+ " t6156.ID_FIRMANTE IDFIRMANTE, t6156.IDENTIFICADOR, t6156.NOMBRE ");
		query.append(" FROM CONF_INI_OFI t5920 , PROCEDIMIENTOS t6101, FIRMANTES t6156");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(confiniofi);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t5920.ID_PROCEDIMIENTO = t6101.ID_PROCEDIMIENTO AND t5920.ID_FIR_RESOLUCION = t6156.ID_FIRMANTE");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, ConfIniOfiDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	@Override
	@Transactional(readOnly = true)
	public Long findAllCount(ConfIniOfi confiniofi) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM CONF_INI_OFI t5920 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(confiniofi);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	private Map<String, ?> getWhereMap(ConfIniOfi confIniOfi) {

		StringBuilder where = new StringBuilder(ConfIniOfiDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (confIniOfi != null && confIniOfi.getIdConfiguracion() != null) {
			where.append(" AND t5920.ID_CONF_INI_OFI = ?");
			params.add(confIniOfi.getIdConfiguracion());
		}
		if (confIniOfi != null && confIniOfi.getProcedimiento() != null
				&& confIniOfi.getProcedimiento().getIdProcedimiento() != null) {
			where.append(" AND t5920.ID_PROCEDIMIENTO = ?");
			params.add(confIniOfi.getProcedimiento().getIdProcedimiento());
		}
		if (confIniOfi != null && confIniOfi.getPublicarTablon() != null) {
			where.append(" AND t5920.PUBLICAR_TABLON = ?");
			params.add(confIniOfi.getPublicarTablon());
		}
		if (confIniOfi != null && confIniOfi.getPlazotablon() != null) {
			where.append(" AND t5920.PLAZO_TABLON = ?");
			params.add(confIniOfi.getPlazotablon());
		}
		if (confIniOfi != null && confIniOfi.getTipoPlazoTablon() != null) {
			where.append(" AND t5920.TIPO_PLAZO_TABLON = ?");
			params.add(confIniOfi.getTipoPlazoTablon());
		}
		if (confIniOfi != null && confIniOfi.getTipoRedaccionTablon() != null) {
			where.append(" AND t5920.TIPO_REDACCION_TABLON = ?");
			params.add(confIniOfi.getTipoRedaccionTablon());
		}
		if (confIniOfi != null && confIniOfi.getPlazoResolucion() != null) {
			where.append(" AND t5920.PLAZO_RESOLUCION = ?");
			params.add(confIniOfi.getPlazoResolucion());
		}
		if (confIniOfi != null && confIniOfi.getTipoPlazoResolucion() != null) {
			where.append(" AND t5920.TIPO_PLAZO_RESOLUCION = ?");
			params.add(confIniOfi.getTipoPlazoResolucion());
		}
		if (confIniOfi != null && confIniOfi.getFechaAcuerdoInicio() != null) {
			where.append(" AND t5920.FECHA_ACUERDO_INICIO = ?");
			params.add(confIniOfi.getFechaAcuerdoInicio());
		}
		if (confIniOfi != null && confIniOfi.getCodigoDepartExpiente() != null) {
			where.append(" AND t5920.CODIGO_DEP_EXP = ?");
			params.add(confIniOfi.getCodigoDepartExpiente());
		}
		if (confIniOfi != null && confIniOfi.getFirmantes() != null
				&& confIniOfi.getFirmantes().getIdFirmante() != null) {
			where.append(" AND t5920.ID_FIR_RESOLUCION = ?");
			params.add(confIniOfi.getFirmantes().getIdFirmante());
		}
		if (confIniOfi != null && confIniOfi.getUsuarioRegistro() != null) {
			where.append(" AND t5920.USUARIO_REGISTRO = ?");
			params.add(confIniOfi.getUsuarioRegistro());
		}
		if (confIniOfi != null && confIniOfi.getUsuarioUltmodificacion() != null) {
			where.append(" AND t5920.USUARIO_ULTMODIFICACION = ?");
			params.add(confIniOfi.getUsuarioUltmodificacion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public List<String> findTiposAlcanceResolucion(Procedimientos procedimiento) {
		String query = "SELECT t5921.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO FROM CONF_INI_OFI t5920, ALCANCES_RESOLUCION t5921, REL_INI_OFI_ALC_RES t5922 WHERE t5920.ID_CONF_INI_OFI = t5922.ID_CONF_INI_OFI AND t5922.ID_ALCANCE_RESOLUCION = t5921.ID_ALCANCE_RESOLUCION AND t5920.ID_PROCEDIMIENTO = ?";

		List<String> tipoAlcanceResolucionList = this.jdbcTemplate.query(query, this.rwMapTipoAlcanceResolucion,
				procedimiento.getIdProcedimiento());

		if (!tipoAlcanceResolucionList.isEmpty()) {
			return tipoAlcanceResolucionList;
		} else {
			return new ArrayList<String>();
		}
	}

}
