package com.ejie.ab59.dao.tablasMaestras;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.model.procedimientos.Procedimientos;
import com.ejie.ab59.model.propuestasSancion.PropuestasSancion;
import com.ejie.ab59.model.tablasMaestras.Calificaciones;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * CalificacionesDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class CalificacionesDaoImpl implements CalificacionesDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDCALIFICACION", "DESCRIPCIONCASTELLANO",
			"DESCRIPCIONEUSKERA", "PLAZO", "FECHAREGISTRO", "USUARIOREGISTRO", "FECHAULTMODIFICACION",
			"USUARIOULTMODIFICACION", "PROCEDIMIENTODESCES", "PROCEDIMIENTODESCEU" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Calificaciones> rwMap = new RowMapper<Calificaciones>() {
		@Override
		public Calificaciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Calificaciones calificaciones = new Calificaciones();
			calificaciones.setIdCalificacion(resultSet.getLong("IDCALIFICACION"));
			calificaciones.setDescripcionCastellano(resultSet.getString("DESCRIPCIONCASTELLANO"));
			calificaciones.setDescripcionEuskera(resultSet.getString("DESCRIPCIONEUSKERA"));
			calificaciones.setPlazo(resultSet.getLong("PLAZO"));
			calificaciones.setGravedad(resultSet.getInt("GRAVEDAD"));
			calificaciones.setImporte(resultSet.getBigDecimal("IMPORTE"));

			Procedimientos procedimiento = new Procedimientos();
			procedimiento.setIdProcedimiento(resultSet.getInt("IDPROCEDIMIENTO"));
			procedimiento.setDescripcionEs(resultSet.getString("PROCEDIMIENTODESCES"));
			procedimiento.setDescripcionEu(resultSet.getString("PROCEDIMIENTODESCEU"));
			calificaciones.setProcedimiento(procedimiento);

			return calificaciones;
		}
	};

	private RowMapper<Calificaciones> rwMapCalificacionGrave = new RowMapper<Calificaciones>() {
		@Override
		public Calificaciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Calificaciones calificacion = new Calificaciones();
			calificacion.setIdCalificacion(resultSet.getLong("IDCALIFICACION"));
			calificacion.setDescripcionCastellano(resultSet.getString("DESCRIPCIONCASTELLANO"));
			calificacion.setPlazo(resultSet.getLong("PLAZO"));
			if (resultSet.wasNull()) {
				calificacion.setPlazo(null);
			}

			return calificacion;
		}
	};

	private RowMapper<Calificaciones> rwMapCombo = new RowMapper<Calificaciones>() {
		@Override
		public Calificaciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Calificaciones calificaciones = new Calificaciones();
			calificaciones.setIdCalificacion(resultSet.getLong("IDCALIFICACION"));
			calificaciones.setDescripcionCastellano(resultSet.getString("DESCRIPCIONCASTELLANO"));
			calificaciones.setDescripcionEuskera(resultSet.getString("DESCRIPCIONEUSKERA"));

			return calificaciones;
		}
	};

	private RowMapper<Calificaciones> rwMapByInfraccion = new RowMapper<Calificaciones>() {
		@Override
		public Calificaciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Calificaciones calificaciones = new Calificaciones();
			calificaciones.setDescripcionCastellano(resultSet.getString("DESCRIPCIONCASTELLANO"));
			calificaciones.setDescripcionEuskera(resultSet.getString("DESCRIPCIONEUSKERA"));
			calificaciones.setPlazo(resultSet.getLong("PLAZO"));
			calificaciones.setImporte(resultSet.getBigDecimal("IMPORTE"));

			return calificaciones;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Calificaciones table.
	 *
	 * @param calificaciones
	 *            Calificaciones
	 * @return Calificaciones
	 */
	@Override
	public Calificaciones add(Calificaciones calificaciones) {
		String query = "INSERT INTO CALIFICACIONES (ID_CALIFICACION, DESCRIPCION_CASTELLANO, DESCRIPCION_EUSKERA, PLAZO, GRAVEDAD, FECHA_REGISTRO, USUARIO_REGISTRO, ID_PROCEDIMIENTO, IMPORTE) VALUES (?,?,?,?,?,SYSDATE,?,?,?)";
		calificaciones.setIdCalificacion(
				this.jdbcTemplate.queryForObject("SELECT AB59.S_AB5904T00.NEXTVAL FROM DUAL", Long.class));
		this.jdbcTemplate.update(query, calificaciones.getIdCalificacion(), calificaciones.getDescripcionCastellano(),
				calificaciones.getDescripcionEuskera(), calificaciones.getPlazo(), calificaciones.getGravedad(),
				calificaciones.getUsuarioRegistro(), calificaciones.getProcedimiento().getIdProcedimiento(),
				calificaciones.getImporte());
		return calificaciones;
	}

	/**
	 * Updates a single row in the Calificaciones table.
	 *
	 * @param calificaciones
	 *            Calificaciones
	 * @return Calificaciones
	 */
	@Override
	public Calificaciones update(Calificaciones calificaciones) {
		String query = "UPDATE CALIFICACIONES SET DESCRIPCION_CASTELLANO = ?, DESCRIPCION_EUSKERA = ?, PLAZO = ?, GRAVEDAD = ?, FECHA_ULTMODIFICACION = SYSDATE, USUARIO_ULTMODIFICACION = ?, ID_PROCEDIMIENTO = ?, IMPORTE = ? WHERE ID_CALIFICACION = ?";
		this.jdbcTemplate.update(query, calificaciones.getDescripcionCastellano(),
				calificaciones.getDescripcionEuskera(), calificaciones.getPlazo(), calificaciones.getGravedad(),
				calificaciones.getUsuarioUltmodificacion(), calificaciones.getProcedimiento().getIdProcedimiento(),
				calificaciones.getImporte(), calificaciones.getIdCalificacion());
		return calificaciones;
	}

	/**
	 * Finds a single row in the Calificaciones table.
	 *
	 * @param calificaciones
	 *            Calificaciones
	 * @return Calificaciones
	 */
	@Override
	@Transactional(readOnly = true)
	public Calificaciones find(Calificaciones calificaciones) {
		String query = "SELECT t1.ID_CALIFICACION IDCALIFICACION, t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA, t1.PLAZO PLAZO, t1.GRAVEDAD GRAVEDAD, t1.IMPORTE, t2.ID_PROCEDIMIENTO IDPROCEDIMIENTO, t2.DESCRIPCION_CASTELLANO PROCEDIMIENTODESCES, t2.DESCRIPCION_EUSKERA PROCEDIMIENTODESCEU FROM CALIFICACIONES t1, PROCEDIMIENTOS t2 WHERE t1.ID_CALIFICACION = ? AND t1.ID_PROCEDIMIENTO = t2.ID_PROCEDIMIENTO ";

		List<Calificaciones> calificacionesList = this.jdbcTemplate.query(query, this.rwMap,
				calificaciones.getIdCalificacion());

		return DataAccessUtils.uniqueResult(calificacionesList);
	}

	/**
	 * Finds a list of rows in the Calificaciones table.
	 *
	 * @param calificaciones
	 *            Calificaciones
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Calificaciones>
	 */
	@Override
	@Transactional(readOnly = true)
	public List<Calificaciones> findAll(Calificaciones calificaciones, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_CALIFICACION IDCALIFICACION,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.PLAZO PLAZO, t1.GRAVEDAD GRAVEDAD, t1.IMPORTE, t2.ID_PROCEDIMIENTO IDPROCEDIMIENTO, t2.DESCRIPCION_CASTELLANO PROCEDIMIENTODESCES, t2.DESCRIPCION_EUSKERA PROCEDIMIENTODESCEU");
		query.append(" FROM CALIFICACIONES t1, PROCEDIMIENTOS t2, APLICACIONES t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(calificaciones);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ID_PROCEDIMIENTO = t2.ID_PROCEDIMIENTO AND t2.ID_APLICACION = t3.ID_APLICACION(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, CalificacionesDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Calificaciones table.
	 *
	 * @param calificaciones
	 *            Calificaciones
	 * @return Long
	 */
	@Override
	@Transactional(readOnly = true)
	public Long findAllCount(Calificaciones calificaciones) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM CALIFICACIONES t1, PROCEDIMIENTOS t2, APLICACIONES t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(calificaciones);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ID_PROCEDIMIENTO = t2.ID_PROCEDIMIENTO AND t2.ID_APLICACION = t3.ID_APLICACION(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Calificaciones entity
	 *
	 * @param calificaciones
	 *            Calificaciones Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Calificaciones calificaciones) {

		StringBuilder where = new StringBuilder(CalificacionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (calificaciones != null && calificaciones.getProcedimiento() != null
				&& calificaciones.getProcedimiento().getInicioOficio() != null) {
			where.append(" AND t2.INICIO_OFICIO = ?");
			params.add(calificaciones.getProcedimiento().getInicioOficio());
		}

		if (calificaciones != null && calificaciones.getProcedimiento() != null
				&& calificaciones.getProcedimiento().getAplicacion() != null
				&& calificaciones.getProcedimiento().getAplicacion().getCodigoAplicacion() != null) {
			where.append(" AND t3.CODIGO_APLICACION = ?");
			params.add(calificaciones.getProcedimiento().getAplicacion().getCodigoAplicacion());
		}

		if (calificaciones != null && calificaciones.getIdCalificacion() != null) {
			where.append(" AND t1.ID_CALIFICACION = ?");
			params.add(calificaciones.getIdCalificacion());
		}
		if (calificaciones != null && calificaciones.getDescripcionCastellano() != null) {
			where.append(" AND t1.DESCRIPCION_CASTELLANO = ?");
			params.add(calificaciones.getDescripcionCastellano());
		}
		if (calificaciones != null && calificaciones.getDescripcionEuskera() != null) {
			where.append(" AND t1.DESCRIPCION_EUSKERA = ?");
			params.add(calificaciones.getDescripcionEuskera());
		}
		if (calificaciones != null && calificaciones.getPlazo() != null) {
			where.append(" AND t1.PLAZO = ?");
			params.add(calificaciones.getPlazo());
		}
		if (calificaciones != null && calificaciones.getUsuarioRegistro() != null) {
			where.append(" AND t1.USUARIO_REGISTRO = ?");
			params.add(calificaciones.getUsuarioRegistro());
		}
		if (calificaciones != null && calificaciones.getUsuarioUltmodificacion() != null) {
			where.append(" AND t1.USUARIO_ULTMODIFICACION = ?");
			params.add(calificaciones.getUsuarioUltmodificacion());
		}
		if (calificaciones != null && calificaciones.getProcedimiento() != null
				&& calificaciones.getProcedimiento().getIdProcedimiento() != null) {
			where.append(" AND t1.ID_PROCEDIMIENTO = ?");
			params.add(calificaciones.getProcedimiento().getIdProcedimiento());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Obtener la calificación más grave entra las infracciones pasadas
	 * 
	 * @param idsInfracciones
	 *            String
	 * @return Calificaciones
	 */
	@Override
	public Calificaciones obtenerCalificacionGraveInfracciones(String infracciones) {

		StringBuilder query = new StringBuilder();
		List<Object> params = new ArrayList<Object>();
		String[] idsInfracciones = infracciones.split(",");

		query.append(
				"SELECT ID_CALIFICACION AS IDCALIFICACION, DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, PLAZO PLAZO");
		query.append(" FROM CALIFICACIONES");
		query.append(" WHERE GRAVEDAD = (SELECT MAX(t04.GRAVEDAD)");
		query.append(" FROM CALIFICACIONES t04, INFRACCIONES t09");
		query.append(" WHERE t04.ID_CALIFICACION = t09.ID_CALIFICACION");
		query.append(" AND t09.ID_INFRACCION IN (?");
		params.add(idsInfracciones[0]);
		for (int i = 1; i < idsInfracciones.length; i++) {
			query.append(",?");
			params.add(idsInfracciones[i]);
		}
		query.append("))");

		List<Calificaciones> calificacionesList = this.jdbcTemplate.query(query.toString(), this.rwMapCalificacionGrave,
				idsInfracciones);
		return DataAccessUtils.uniqueResult(calificacionesList);
	}

	/**
	 * Finds a list of rows in the Calificaciones table.
	 *
	 * @param calificaciones
	 *            Calificaciones
	 * 
	 * @return List<Calificaciones>
	 */
	@Override
	@Transactional(readOnly = true)
	public List<Calificaciones> cargarCombo(Calificaciones calificaciones) {
		StringBuilder query = new StringBuilder();
		query.append(
				"SELECT  t1.ID_CALIFICACION IDCALIFICACION, t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA");
		query.append(" FROM CALIFICACIONES t1, PROCEDIMIENTOS t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(calificaciones);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.ID_PROCEDIMIENTO = t2.ID_PROCEDIMIENTO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(), this.rwMapCombo, params.toArray());
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a single row in the Calificaciones table.
	 *
	 * @param idInfraccion
	 *            Integer
	 * 
	 * @return Calificaciones
	 */
	@Override
	@Transactional(readOnly = true)
	public Calificaciones findCalificacionByInfraccion(Integer idInfraccion) {

		StringBuilder query = new StringBuilder();

		query.append(
				"SELECT t04.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t04.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA");
		query.append(", t04.PLAZO PLAZO, t04.IMPORTE");
		query.append(" FROM CALIFICACIONES t04");
		query.append(" INNER JOIN INFRACCIONES t09 ON t04.ID_CALIFICACION = t09.ID_CALIFICACION");
		query.append(" WHERE t09.ID_INFRACCION = ?");

		List<Calificaciones> calificacionesList = this.jdbcTemplate.query(query.toString(), this.rwMapByInfraccion,
				idInfraccion);

		return DataAccessUtils.uniqueResult(calificacionesList);
	}

	@Override
	public Calificaciones findMasGraveDePropuestaSancion(PropuestasSancion propuestaSancion) {
		String query = "SELECT t5904.ID_CALIFICACION IDCALIFICACION, t5904.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t5904.PLAZO PLAZO "
				+ " FROM CALIFICACIONES t5904, REL_ART_INF_PRO_SAN t5910, INFRACCIONES t5909 "
				+ " WHERE t5910.ID_PROPUESTA_SANCION = ?  AND t5909.ID_INFRACCION = t5910.ID_INFRACCION "
				+ " AND t5904.ID_CALIFICACION = t5909.ID_CALIFICACION  ORDER BY t5904.GRAVEDAD DESC";

		List<Calificaciones> calificacionesList = this.jdbcTemplate.query(query, this.rwMapCalificacionGrave,
				propuestaSancion.getIdPropuestaSancion());

		if (!calificacionesList.isEmpty()) {
			return calificacionesList.get(0);
		} else {
			return null;
		}
	}

}
