package com.ejie.ab59.dao.tablasMaestras;

import java.util.List;

import com.ejie.ab59.model.propuestasSancion.PropuestasSancion;
import com.ejie.ab59.model.tablasMaestras.Calificaciones;
import com.ejie.x38.dto.TableRequestDto;

/**
 * CalificacionesDao  
 * 
 *  
 */

public interface CalificacionesDao {

	/**
	 * Inserts a single row in the Calificaciones table.
	 *
	 * @param calificaciones
	 *            Calificaciones
	 * @return Calificaciones
	 */
	Calificaciones add(Calificaciones calificaciones);

	/**
	 * Updates a single row in the Calificaciones table.
	 *
	 * @param calificaciones
	 *            Calificaciones
	 * @return Calificaciones
	 */
	Calificaciones update(Calificaciones calificaciones);

	/**
	 * Finds a single row in the Calificaciones table.
	 *
	 * @param calificaciones
	 *            Calificaciones
	 * @return Calificaciones
	 */
	Calificaciones find(Calificaciones calificaciones);

	/**
	 * Finds a List of rows in the Calificaciones table.
	 *
	 * @param calificaciones
	 *            Calificaciones
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<Calificaciones> findAll(Calificaciones calificaciones, TableRequestDto tableRequestDto);

	/**
	 * Counts rows in the Calificaciones table.
	 *
	 * @param calificaciones
	 *            Calificaciones
	 * @return Long
	 */
	Long findAllCount(Calificaciones calificaciones);

	/**
	 * Obtener la calificación más grave entra las infracciones pasadas
	 * 
	 * @param idsInfracciones
	 *            String
	 * @return Calificaciones
	 */
	Calificaciones obtenerCalificacionGraveInfracciones(String infracciones);

	/**
	 * Finds a List of rows in the Calificaciones table.
	 *
	 * @param calificaciones
	 *            Calificaciones
	 * 
	 * @return List
	 */
	List<Calificaciones> cargarCombo(Calificaciones calificaciones);

	/**
	 * Finds a single row in the Calificaciones table.
	 *
	 * @param idInfraccion
	 *            Integer
	 * 
	 * @return Calificaciones
	 */
	Calificaciones findCalificacionByInfraccion(Integer idInfraccion);

	Calificaciones findMasGraveDePropuestaSancion(PropuestasSancion propuestaSancion);
}
