package com.ejie.ab59.dao.sanciones;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.model.expedientes.DatosTerceros;
import com.ejie.ab59.model.expedientes.Expedientes;
import com.ejie.ab59.model.procedimientos.Direcciones;
import com.ejie.ab59.model.procedimientos.Procedimientos;
import com.ejie.ab59.model.sanciones.Sanciones;
import com.ejie.ab59.model.tablasMaestras.Instructores;
import com.ejie.ab59.model.tablasMaestras.TiposFinalizacion;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class SancionesDaoImpl implements SancionesDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "FOLDERNUMBER", "TITULO", "IMPORTESANCION",
			"FECHASANCIONFIRME" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Sanciones> rwMap = new RowMapper<Sanciones>() {
		public Sanciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Sanciones sancion = new Sanciones();

			Expedientes expedienteAux = new Expedientes();

			DatosTerceros datosTercero = new DatosTerceros();
			datosTercero.setNombre(resultSet.getString("NOMBRETITULAR"));
			datosTercero.setApellido1(resultSet.getString("APELLIDO1TITULAR"));
			datosTercero.setApellido2(resultSet.getString("APELLIDO2TITULAR"));
			datosTercero.setDocumento(resultSet.getString("DNITITULAR"));

			expedienteAux.setDatosTerceros(datosTercero);
			sancion.setExpediente(expedienteAux);

			return sancion;
		}
	};

	private RowMapper<Sanciones> rwMapAll = new RowMapper<Sanciones>() {
		public Sanciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Sanciones sancion = new Sanciones();
			sancion.setIdSancion(resultSet.getInt("IDSANCION"));

			Expedientes expedienteAux = new Expedientes();
			expedienteAux.setFolderNumber(resultSet.getString("FOLDERNUMBER"));
			expedienteAux.setTitulo(resultSet.getString("TITULO"));
			sancion.setExpediente(expedienteAux);

			sancion.setImporteSancion(resultSet.getBigDecimal("IMPORTESANCION"));
			sancion.setFechaSancionFirme(resultSet.getDate("FECHASANCIONFIRME"));

			return sancion;
		}
	};

	private RowMapper<Sanciones> rwMapDatosSancion = new RowMapper<Sanciones>() {
		public Sanciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Sanciones sancion = new Sanciones();

			sancion.setIdSancion(resultSet.getInt("IDSANCION"));
			sancion.setObservacionesCastellano(resultSet.getString("OBSERVACIONESCASTELLANO"));
			sancion.setObservacionesEuskera(resultSet.getString("OBSERVACIONESEUSKERA"));
			sancion.setImporteResolucion(resultSet.getBigDecimal("IMPORTERESOLUCION"));

			Instructores instructorAux = new Instructores();
			instructorAux.setIdInstructor(resultSet.getLong("IDINSTRUCTOR"));
			sancion.setInstructor(instructorAux);

			TiposFinalizacion tipoFinalizacionAux = new TiposFinalizacion();
			tipoFinalizacionAux.setIdTipoFinalizacion(resultSet.getLong("IDTIPOFINALIZACION"));
			if (resultSet.wasNull()) {
				tipoFinalizacionAux.setIdTipoFinalizacion(null);
			}
			sancion.setTipoFinalizacion(tipoFinalizacionAux);

			Expedientes expediente = null;
			if (resultSet.getObject("IDEXPEDIENTE") != null) {
				expediente = new Expedientes();
				expediente.setIdExpediente(resultSet.getInt("IDEXPEDIENTE"));
			}
			sancion.setExpediente(expediente);

			// DatosDirecciones datosDireccion = new DatosDirecciones();
			// datosDireccion.setIdDireccion(resultSet.getInt("IDDIRECCION"));
			// sancion.setDireccion(datosDireccion);

			return sancion;
		}
	};

	private RowMapper<Sanciones> rwMapCabeceraSancion = new RowMapper<Sanciones>() {
		public Sanciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Sanciones sancion = new Sanciones();
			sancion.setIdSancion(resultSet.getInt("IDSANCION"));

			Expedientes expedienteAux = new Expedientes();
			expedienteAux.setFolderNumber(resultSet.getString("FOLDERNUMBER"));
			expedienteAux.setTitulo(resultSet.getString("TITULO"));
			expedienteAux.setFolderId(resultSet.getString("FOLDERID"));
			expedienteAux.setIdExpediente(resultSet.getInt("IDEXPEDIENTE"));

			Procedimientos procedimientoAux = new Procedimientos();
			procedimientoAux.setIdProcedimiento(resultSet.getInt("IDPROCEDIMIENTO"));
			procedimientoAux.setCodProcedureId(resultSet.getString("CODPROCEDUREID"));
			procedimientoAux.setDescripcionEs(resultSet.getString("DESCPROCEDIMIENTOCAS"));
			procedimientoAux.setDescripcionEu(resultSet.getString("DESCPROCEDIMIENTOEUS"));
			expedienteAux.setProcedimiento(procedimientoAux);

			sancion.setExpediente(expedienteAux);

			return sancion;
		}
	};

	private RowMapper<Sanciones> rwMapParteInculpada = new RowMapper<Sanciones>() {
		public Sanciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Sanciones sanciones = new Sanciones();
			sanciones.setIdSancion(resultSet.getInt("IDSANCION"));

			Expedientes expedientes = new Expedientes();
			expedientes.setIdExpediente(resultSet.getInt("IDEXPEDIENTE"));
			expedientes.setFolderNumber(resultSet.getString("FOLDERNUMBER"));
			expedientes.setTitulo(resultSet.getString("TITULO"));
			expedientes.setFechaExpediente(resultSet.getDate("FECHAEXPEDIENTE"));

			sanciones.setExpediente(expedientes);

			return sanciones;
		}
	};

	private RowMapper<Integer> rwMapIdTercero = new RowMapper<Integer>() {
		public Integer mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			return resultSet.getInt("IDTERCERO");
		}
	};

	private RowMapper<Sanciones> rwMapByFolderId = new RowMapper<Sanciones>() {
		public Sanciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Sanciones sancion = new Sanciones();
			sancion.setIdSancion(resultSet.getInt("IDSANCION"));

			return sancion;
		}
	};

	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	public Sanciones add(Sanciones sancion) {
		String query = "INSERT INTO SANCIONES (ID_SANCION, ID_EXPEDIENTE, OBSERVACIONES_CASTELLANO, OBSERVACIONES_EUSKERA, IMPORTE_SANCION, "
				+ " FECHA_ENVIO_ASE_JUR, ID_INSTRUCTOR, FECHA_REC_CON_ADM, ID_TIPO_FINALIZACION, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";

		sancion.setIdSancion(
				this.jdbcTemplate.queryForObject("SELECT AB59.S_AB5901T00.NEXTVAL FROM DUAL", Integer.class));

		Object getExpediente = null;
		if (sancion.getExpediente() != null && sancion.getExpediente().getIdExpediente() != null) {
			getExpediente = sancion.getExpediente().getIdExpediente();
		}

		this.jdbcTemplate.update(query, sancion.getIdSancion(), getExpediente, sancion.getObservacionesCastellano(),
				sancion.getObservacionesEuskera(), sancion.getImporteSancion(), sancion.getFechaEnvioAseJur(),
				sancion.getInstructor(), sancion.getFechaRecConAdm(), sancion.getTipoFinalizacion(),
				sancion.getFechaRegistro(), sancion.getUsuarioRegistro());
		return sancion;
	}

	@Transactional(readOnly = true)
	public Sanciones find(Sanciones sanciones) {
		StringBuilder query = new StringBuilder();

		query.append(
				"SELECT t6135.NOMBRE NOMBRETITULAR, t6135.APELLIDO1 APELLIDO1TITULAR, t6135.APELLIDO2 APELLIDO2TITULAR, t6135.DOCUMENTO DNITITULAR");
		query.append(" FROM SANCIONES t01");
		query.append(" INNER JOIN EXPEDIENTES t6102 ON t01.ID_EXPEDIENTE = t6102.ID_EXPEDIENTE");
		query.append(
				" INNER JOIN REL_EXP_TER t6134 ON t01.ID_EXPEDIENTE = t6134.ID_EXPEDIENTE AND t6134.ID_SUBTIPO_TERCERO = "
						+ Constantes.PARTE_INCULPADA);
		query.append(
				" INNER JOIN DATOS_TERCEROS t6135 ON t6134.ID_TERCERO = t6135.ID_TERCERO AND t6135.TIPO_PARTICIPANTE = "
						+ Constantes.PARTICIPANTE_TITULAR);

		query.append(" WHERE ID_SANCION = ?");

		List<Sanciones> sancionesList = this.jdbcTemplate.query(query.toString(), this.rwMap, sanciones.getIdSancion());

		List<Sanciones> sancionesNewList = new ArrayList<Sanciones>();
		if (!sancionesList.isEmpty()) {
			sancionesNewList.add(sancionesList.get(0));
		}

		return DataAccessUtils.uniqueResult(sancionesNewList);
	}

	public void remove(Sanciones sancion) {
		String query = "DELETE FROM SANCIONES WHERE ID_SANCION = ?";
		this.jdbcTemplate.update(query, sancion.getIdSancion());
	}

	@Transactional(readOnly = true)
	public List<Sanciones> findAll(Sanciones sanciones, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder();

		/*
		 * Hacemos el distinct porque un expediente puede tener varios terceros
		 * titulares
		 */
		query.append("SELECT DISTINCT(t01.ID_SANCION) IDSANCION");
		query.append(", t6102.FOLDER_NUMBER FOLDERNUMBER, t6102.TITULO TITULO");
		query.append(", t01.IMPORTE_SANCION IMPORTESANCION, t01.FECHA_SANCION_FIRME FECHASANCIONFIRME");
		query.append(" FROM SANCIONES t01");
		query.append(" INNER JOIN EXPEDIENTES t6102 ON t01.ID_EXPEDIENTE = t6102.ID_EXPEDIENTE");
		query.append(" INNER JOIN REL_EXP_TER t6134 ON t01.ID_EXPEDIENTE = t6134.ID_EXPEDIENTE");
		query.append(" INNER JOIN DATOS_TERCEROS t6135 ON t6134.ID_TERCERO = t6135.ID_TERCERO ");
		query.append(" LEFT OUTER JOIN REL_EXP_DIR t6151 ON t6151.ID_EXPEDIENTE = t01.ID_EXPEDIENTE");
		query.append(" LEFT OUTER JOIN DATOS_DIRECCIONES t6136 ON t6151.ID_DIRECCION = t6136.ID_DIRECCION");
		query.append(" INNER JOIN PROCEDIMIENTOS t6101 ON t6102.ID_PROCEDIMIENTO = t6101.ID_PROCEDIMIENTO");

		if (sanciones != null && sanciones.getExpedientesCerrados() != null
				&& sanciones.getExpedientesCerrados() == Constantes.MAGIC_NUMBER_1) {
			query.append(" LEFT JOIN REL_EXP_FECH t6142 ON t6102.ID_EXPEDIENTE = t6142.ID_EXPEDIENTE");
			query.append(
					" LEFT JOIN FECHAS_EXPEDIENTE t6144 ON t6142.ID_FECHA_EXPEDIENTE = t6144.ID_FECHA_EXPEDIENTE AND t6144.ETIQUETA_FECHA = '"
							+ Constantes.FECHA_CIERRE + "'");
		}

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sanciones);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMapAll, params.toArray());
	}

	@Override
	public List<Sanciones> findExpedientesPartesInculpadas(List<String> documentos, Integer idExpediente,
			Direcciones direccion) {
		String condicion = "";
		for (int i = 0; i < documentos.size(); i++) {
			condicion = condicion + "?,";
		}
		if (condicion.length() > 0) {
			condicion = condicion.substring(0, condicion.length() - 1);
		}

		StringBuilder query = new StringBuilder();
		query.append(
				"SELECT DISTINCT t6102.ID_EXPEDIENTE IDEXPEDIENTE, t6102.FOLDER_NUMBER FOLDERNUMBER, t6102.TITULO TITULO, t5901.ID_SANCION IDSANCION, "
						+ " (SELECT MAX(t6142.FECHA_EXPEDIENTE) FROM REL_EXP_FECH t6142, FECHAS_EXPEDIENTE t6144 WHERE t6142.ID_FECHA_EXPEDIENTE = t6144.ID_FECHA_EXPEDIENTE AND t6142.ID_EXPEDIENTE = t6102.ID_EXPEDIENTE AND t6144.ETIQUETA_FECHA = ?) FECHAEXPEDIENTE");
		query.append(
				" FROM EXPEDIENTES t6102, REL_EXP_TER T6134, DATOS_TERCEROS t6135, SANCIONES T5901, PROCEDIMIENTOS t6101");
		query.append(
				" WHERE t6102.ID_EXPEDIENTE = t6134.ID_EXPEDIENTE AND t6134.ID_TERCERO = t6135.ID_TERCERO AND t6102.ID_EXPEDIENTE = T5901.ID_EXPEDIENTE AND t6102.ID_PROCEDIMIENTO = t6101.ID_PROCEDIMIENTO AND t6101.COD_PROCEDURE_ID IN(?, ?) ");
		query.append(" AND t6134.ID_SUBTIPO_TERCERO = ? AND t6102.ID_EXPEDIENTE <> ? AND t6135.DOCUMENTO IN ("
				+ condicion + ")");

		List<Object> params = new ArrayList<Object>();
		params.add(Constantes.FECHA_APERTURA);
		params.add(Constantes.COD_PROCEDURE_SANCIONES_TURISMO);
		params.add(Constantes.COD_PROCEDURE_SANCIONES_COMERCIO);
		params.add(Constantes.PARTE_INCULPADA);
		params.add(idExpediente);

		for (int i = 0; i < documentos.size(); i++) {
			params.add(documentos.get(i));
		}

		if (direccion != null && direccion.getIdDireccion() != null) {
			query.append(" AND t6101.ID_DIRECCION = ? ");
			params.add(direccion.getIdDireccion());
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMapParteInculpada, params.toArray());
	}

	@Transactional(readOnly = true)
	public Long findAllCount(Sanciones sanciones) {
		StringBuilder query = new StringBuilder("SELECT COUNT(DISTINCT(t01.ID_SANCION))");
		query.append(" FROM SANCIONES t01");
		query.append(" INNER JOIN EXPEDIENTES t6102 ON t01.ID_EXPEDIENTE = t6102.ID_EXPEDIENTE");
		query.append(" INNER JOIN REL_EXP_TER t6134 ON t01.ID_EXPEDIENTE = t6134.ID_EXPEDIENTE");
		query.append(
				" INNER JOIN DATOS_TERCEROS t6135 ON t6134.ID_TERCERO = t6135.ID_TERCERO AND t6135.TIPO_PARTICIPANTE = ");
		query.append(Constantes.PARTICIPANTE_TITULAR);
		query.append(" LEFT OUTER JOIN REL_EXP_DIR t6151 ON t6151.ID_EXPEDIENTE = t01.ID_EXPEDIENTE");
		query.append(" LEFT OUTER JOIN DATOS_DIRECCIONES t6136 ON t6151.ID_DIRECCION = t6136.ID_DIRECCION");
		query.append(" INNER JOIN PROCEDIMIENTOS t6101 ON t6102.ID_PROCEDIMIENTO = t6101.ID_PROCEDIMIENTO");

		if (sanciones != null && sanciones.getExpedientesCerrados() != null
				&& sanciones.getExpedientesCerrados() == Constantes.MAGIC_NUMBER_1) {
			query.append(" INNER JOIN REL_EXP_FECH t6142 ON t6102.ID_EXPEDIENTE = t6142.ID_EXPEDIENTE");
			query.append(
					" LEFT JOIN FECHAS_EXPEDIENTE t6144 ON t6142.ID_FECHA_EXPEDIENTE = t6144.ID_FECHA_EXPEDIENTE AND t6144.ETIQUETA_FECHA = '"
							+ Constantes.FECHA_CIERRE + "'");
		}

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sanciones);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	private Map<String, ?> getWhereMap(Sanciones sanciones) {

		StringBuilder where = new StringBuilder(SancionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		/* Nº Expediente */
		if (sanciones != null && sanciones.getExpediente() != null
				&& sanciones.getExpediente().getFolderNumber() != null) {
			where.append(" AND UPPER(t6102.FOLDER_NUMBER) like ? ESCAPE  '\\'");
			params.add("%" + sanciones.getExpediente().getFolderNumber().toUpperCase() + "%");
		}

		/* Título Expdiente */
		if (sanciones != null && sanciones.getExpediente() != null && sanciones.getExpediente().getTitulo() != null) {
			where.append(" AND UPPER(t6102.TITULO) like ? ESCAPE  '\\'");
			params.add("%" + sanciones.getExpediente().getTitulo().toUpperCase() + "%");
		}

		/* Datos titular */
		if (sanciones != null && sanciones.getExpediente() != null
				&& sanciones.getExpediente().getDatosTerceros() != null) {
			/* Nombre titular */
			if (sanciones.getExpediente().getDatosTerceros().getNombre() != null) {
				where.append(" AND UPPER(t6135.NOMBRE) LIKE ? ESCAPE '\\'");
				params.add("%" + sanciones.getExpediente().getDatosTerceros().getNombre().toUpperCase() + "%");
			}
			/* Apellido1 titular */
			if (sanciones.getExpediente().getDatosTerceros().getApellido1() != null) {
				where.append(" AND UPPER(t6135.APELLIDO1) LIKE ? ESCAPE '\\'");
				params.add("%" + sanciones.getExpediente().getDatosTerceros().getApellido1().toUpperCase() + "%");
			}
			/* Apellido2 Titular */
			if (sanciones.getExpediente().getDatosTerceros().getApellido2() != null) {
				where.append(" AND UPPER(t6135.APELLIDO2) LIKE ? ESCAPE '\\'");
				params.add("%" + sanciones.getExpediente().getDatosTerceros().getApellido2().toUpperCase() + "%");
			}
			/* DNI titular */
			if (sanciones.getExpediente().getDatosTerceros().getDocumento() != null) {
				where.append(" AND UPPER(t6135.DOCUMENTO) LIKE ? ESCAPE '\\'");
				params.add("%" + sanciones.getExpediente().getDatosTerceros().getDocumento().toUpperCase() + "%");
			}
		}

		/* Importe Sancin */
		/* Desde */
		if (sanciones != null && sanciones.getImporteSancionDesde() != null) {
			where.append(" AND t01.IMPORTE_SANCION >= ?");
			params.add(sanciones.getImporteSancionDesde());
		}
		/* Hasta */
		if (sanciones != null && sanciones.getImporteSancionHasta() != null) {
			where.append(" AND t01.IMPORTE_SANCION <= ?");
			params.add(sanciones.getImporteSancionHasta());
		}

		/* Ubicación de la actividad */
		if (sanciones != null && sanciones.getExpediente() != null
				&& sanciones.getExpediente().getDatosDirecciones() != null) {
			/* Provincia */
			if (sanciones.getExpediente().getDatosDirecciones().getProvincia() != null
					&& sanciones.getExpediente().getDatosDirecciones().getProvincia().getId() != null) {
				where.append(" AND t6136.ID_PROVINCIA = ?");
				params.add(sanciones.getExpediente().getDatosDirecciones().getProvincia().getId());
			}
			/* Municipio */
			if (sanciones.getExpediente().getDatosDirecciones().getMunicipio() != null
					&& sanciones.getExpediente().getDatosDirecciones().getMunicipio().getId() != null) {
				where.append(" AND t6136.ID_MUNICIPIO = ?");
				params.add(sanciones.getExpediente().getDatosDirecciones().getMunicipio().getId());
			}
			/* Localidad */
			if (sanciones.getExpediente().getDatosDirecciones().getLocalidad() != null
					&& sanciones.getExpediente().getDatosDirecciones().getLocalidad().getId() != null) {
				where.append(" AND t6136.ID_LOCALIDAD = ?");
				params.add(sanciones.getExpediente().getDatosDirecciones().getLocalidad().getId());
			}
			/* Calle */
			if (sanciones.getExpediente().getDatosDirecciones().getDireccion() != null) {
				where.append(" AND UPPER(t6136.DIRECCION) LIKE ? ESCAPE '\\'");
				params.add("%" + sanciones.getExpediente().getDatosDirecciones().getDireccion().toUpperCase() + "%");
			}
			/* Número */
			if (sanciones.getExpediente().getDatosDirecciones().getNumero() != null) {
				where.append(" AND t6136.NUMERO = ?");
				params.add(sanciones.getExpediente().getDatosDirecciones().getNumero());
			}
			/* Escalera */
			if (sanciones.getExpediente().getDatosDirecciones().getEscalera() != null) {
				where.append(" AND UPPER(t6136.ESCALERA) LIKE ? ESCAPE '\\'");
				params.add("%" + sanciones.getExpediente().getDatosDirecciones().getEscalera().toUpperCase() + "%");
			}
			/* Piso */
			if (sanciones.getExpediente().getDatosDirecciones().getPiso() != null) {
				where.append(" AND t6136.PISO = ?");
				params.add(sanciones.getExpediente().getDatosDirecciones().getPiso());
			}
			/* Letra */
			if (sanciones.getExpediente().getDatosDirecciones().getLetra() != null) {
				where.append(" AND UPPER(t6136.LETRA) LIKE ? ESCAPE '\\'");
				params.add("%" + sanciones.getExpediente().getDatosDirecciones().getLetra().toUpperCase() + "%");
			}
			/* Código postal */
			if (sanciones.getExpediente().getDatosDirecciones().getCodigoPostal() != null) {
				where.append(" AND t6136.CODIGO_POSTAL = ?");
				params.add(sanciones.getExpediente().getDatosDirecciones().getCodigoPostal());
			}
		}
		/* Direccin */
		if (sanciones != null && sanciones.getExpediente() != null
				&& sanciones.getExpediente().getProcedimiento() != null
				&& sanciones.getExpediente().getProcedimiento().getDirecciones() != null
				&& sanciones.getExpediente().getProcedimiento().getDirecciones().getIdDireccion() != null) {
			where.append(" AND t6101.ID_DIRECCION = ?");
			params.add(sanciones.getExpediente().getProcedimiento().getDirecciones().getIdDireccion());
		}

		/* Fecha acuse acuerdo incoación */
		/* Desde */
		/* Hasta */

		/* Fecha sanción firme */
		/* Desde */
		if (sanciones != null && sanciones.getFechaSancionFirmeDesde() != null) {
			where.append(" AND TO_CHAR(t01.FECHA_SANCION_FIRME, '" + Constantes.FORMATO_FECHA_ES + "') >= TO_DATE('"
					+ new SimpleDateFormat(Constantes.FORMATO_FECHA_ES).format(sanciones.getFechaSancionFirmeDesde())
					+ "','" + Constantes.FORMATO_FECHA_ES + "')");
		}
		/* Hasta */
		if (sanciones != null && sanciones.getFechaSancionFirmeHasta() != null) {
			where.append(" AND TO_CHAR(t01.FECHA_SANCION_FIRME, '" + Constantes.FORMATO_FECHA_ES + "') <= TO_DATE('"
					+ new SimpleDateFormat(Constantes.FORMATO_FECHA_ES).format(sanciones.getFechaSancionFirmeHasta())
					+ "','" + Constantes.FORMATO_FECHA_ES + "')");
		}

		/* Pendientes de ingreso */
		/* Cerradas */

		/* Tipo de finalización */
		if (sanciones != null && sanciones.getTipoFinalizacion() != null
				&& sanciones.getTipoFinalizacion().getIdTipoFinalizacion() != null) {
			where.append(" AND t01.ID_TIPO_FINALIZACION = ?");
			params.add(sanciones.getTipoFinalizacion().getIdTipoFinalizacion());
		}

		/* Mostrar expedientes */
		if (sanciones != null && sanciones.getExpedientesSinPropuesta() != null
				&& sanciones.getExpedientesSinPropuesta() == Constantes.MAGIC_NUMBER_1) {
			where.append(" AND (SELECT COUNT(1)  FROM REL_SAN_PRO_SAN t06  WHERE t01.ID_SANCION = t06.ID_SANCION) = 0");
		}

		if (sanciones != null && sanciones.getExpedientesCerrados() != null
				&& sanciones.getExpedientesCerrados() != Constantes.MAGIC_NUMBER_1) {
			where.append(
					" AND (SELECT COUNT(1) FROM REL_EXP_FECH t6142, FECHAS_EXPEDIENTE t6144 WHERE t6102.ID_EXPEDIENTE = t6142.ID_EXPEDIENTE AND t6142.ID_FECHA_EXPEDIENTE = t6144.ID_FECHA_EXPEDIENTE AND t6144.ETIQUETA_FECHA = ?) = 0");
			params.add(Constantes.FECHA_CIERRE);
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	public static final int STRING_BUILDER_INIT = 4096;

	public Sanciones findDatosSancion(Sanciones sanciones) {
		StringBuilder query = new StringBuilder();

		query.append("SELECT t1.ID_SANCION IDSANCION");
		query.append(", t1.ID_INSTRUCTOR IDINSTRUCTOR, t1.ID_TIPO_FINALIZACION IDTIPOFINALIZACION");
		query.append(", t1.ID_EXPEDIENTE IDEXPEDIENTE ");
		query.append(", t1.IMPORTE_RESOLUCION IMPORTERESOLUCION ");
		query.append(
				", t1.OBSERVACIONES_CASTELLANO OBSERVACIONESCASTELLANO, t1.OBSERVACIONES_EUSKERA OBSERVACIONESEUSKERA");
		query.append(" FROM SANCIONES t1");
		query.append(" WHERE ID_SANCION = ?");

		List<Sanciones> sancionesList = this.jdbcTemplate.query(query.toString(), this.rwMapDatosSancion,
				sanciones.getIdSancion());
		return DataAccessUtils.uniqueResult(sancionesList);
	}

	public Sanciones updateDatosSancion(Sanciones sancion) {

		Object getTipoFinalizacion = null;
		if (sancion.getTipoFinalizacion() != null && sancion.getTipoFinalizacion().getIdTipoFinalizacion() != null) {
			getTipoFinalizacion = sancion.getTipoFinalizacion().getIdTipoFinalizacion();
		}
		Object getInstructor = null;
		if (sancion.getInstructor() != null && sancion.getInstructor().getIdInstructor() != null) {
			getInstructor = sancion.getInstructor().getIdInstructor();
		}

		StringBuilder query = new StringBuilder();

		query.append("UPDATE SANCIONES SET");
		query.append(" ID_INSTRUCTOR = ?, ID_TIPO_FINALIZACION = ?");
		query.append(", OBSERVACIONES_CASTELLANO = ?, OBSERVACIONES_EUSKERA = ?");
		if (getTipoFinalizacion != null && Constantes.TIPO_FINALIZACION_ARCHIVO.equals(getTipoFinalizacion)) {
			query.append(", FECHA_SANCION_FIRME = NULL");
		}
		query.append(", FECHA_ULTMODIFICACION = ?, USUARIO_ULTMODIFICACION = ?");
		query.append(" WHERE ID_SANCION = ?");

		this.jdbcTemplate.update(query.toString(), getInstructor, getTipoFinalizacion,
				sancion.getObservacionesCastellano(), sancion.getObservacionesEuskera(),
				sancion.getFechaUltmodificacion(), sancion.getUsuarioUltmodificacion(), sancion.getIdSancion());
		return sancion;
	}

	@Override
	public Sanciones updateImportes(Sanciones sancion) {
		StringBuilder query = new StringBuilder();

		query.append(
				"UPDATE SANCIONES t1 SET t1.IMPORTE_SANCION = (SELECT SUM(t2.IMPORTE_SANCION_ART) SUMAIMPORTESANCION FROM REL_ART_INF_SAN t2 WHERE t1.ID_SANCION = t2.ID_SANCION), t1.IMPORTE_RESOLUCION = (SELECT SUM(t2.IMPORTE_RESOLUCION_ART) SUMAIMPORTERESOLUCION FROM REL_ART_INF_SAN t2 WHERE t1.ID_SANCION = t2.ID_SANCION) WHERE t1.ID_SANCION = ?");

		this.jdbcTemplate.update(query.toString(), sancion.getIdSancion());
		return sancion;
	}

	@Transactional(readOnly = true)
	public Boolean tieneDireccion(Sanciones sanciones) {

		List<Object> params = new ArrayList<Object>();

		StringBuilder query = new StringBuilder("SELECT COUNT(1)");
		query.append(" FROM SANCIONES t1, REL_EXP_DIR t2");
		query.append(" WHERE t1.ID_SANCION = ?");
		params.add(sanciones.getIdSancion());
		query.append(" AND t1.ID_EXPEDIENTE = t2.ID_EXPEDIENTE");

		Long count = this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);

		if (count > 0) {
			return true;
		} else {
			return false;
		}
	}

	@Transactional(readOnly = true)
	public List<Integer> findIdTercero(Integer idSancion) {

		StringBuilder query = new StringBuilder();

		query.append("SELECT t6134.ID_TERCERO IDTERCERO");
		query.append(" FROM SANCIONES t01");
		query.append(" INNER JOIN REL_EXP_TER t6134 ON t01.ID_EXPEDIENTE = t6134.ID_EXPEDIENTE");
		query.append(
				" INNER JOIN DATOS_TERCEROS t6135 ON t6134.ID_TERCERO = t6135.ID_TERCERO AND t6135.TIPO_PARTICIPANTE = ");
		query.append(Constantes.PARTICIPANTE_TITULAR);
		query.append(" WHERE t01.ID_SANCION = ?");

		return this.jdbcTemplate.query(query.toString(), this.rwMapIdTercero, idSancion);
	}

	@Transactional(readOnly = true)
	public Sanciones obtenerCabeceraSancion(Integer idSancion) {

		StringBuilder query = new StringBuilder();

		query.append("SELECT t6102.FOLDER_NUMBER FOLDERNUMBER, t6102.TITULO TITULO");
		query.append(", t6102.FOLDER_ID FOLDERID");
		query.append(", t6102.ID_EXPEDIENTE IDEXPEDIENTE, t6102.ID_PROCEDIMIENTO IDPROCEDIMIENTO");
		query.append(", t01.ID_SANCION IDSANCION");
		query.append(", t6101.COD_PROCEDURE_ID CODPROCEDUREID");
		query.append(
				", t6101.DESCRIPCION_CASTELLANO DESCPROCEDIMIENTOCAS, t6101.DESCRIPCION_EUSKERA DESCPROCEDIMIENTOEUS");
		query.append(" FROM SANCIONES t01");
		query.append(" INNER JOIN EXPEDIENTES t6102 ON t01.ID_EXPEDIENTE = t6102.ID_EXPEDIENTE");
		query.append(" INNER JOIN PROCEDIMIENTOS t6101 ON t6102.ID_PROCEDIMIENTO = t6101.ID_PROCEDIMIENTO");
		query.append(" WHERE t01.ID_SANCION = ?");

		List<Sanciones> sancionesList = this.jdbcTemplate.query(query.toString(), this.rwMapCabeceraSancion, idSancion);

		return DataAccessUtils.uniqueResult(sancionesList);
	}

	@Override
	public Sanciones obtenerCabeceraSancionByExpediente(Expedientes expediente) {
		StringBuilder query = new StringBuilder();

		query.append("SELECT t6102.FOLDER_NUMBER FOLDERNUMBER, t6102.TITULO TITULO");
		query.append(", t6102.FOLDER_ID FOLDERID");
		query.append(", t6102.ID_EXPEDIENTE IDEXPEDIENTE, t6102.ID_PROCEDIMIENTO IDPROCEDIMIENTO");
		query.append(", t01.ID_SANCION IDSANCION");
		query.append(", t6101.COD_PROCEDURE_ID CODPROCEDUREID");
		query.append(
				", t6101.DESCRIPCION_CASTELLANO DESCPROCEDIMIENTOCAS, t6101.DESCRIPCION_EUSKERA DESCPROCEDIMIENTOEUS");
		query.append(" FROM SANCIONES t01");
		query.append(" INNER JOIN EXPEDIENTES t6102 ON t01.ID_EXPEDIENTE = t6102.ID_EXPEDIENTE");
		query.append(" INNER JOIN PROCEDIMIENTOS t6101 ON t6102.ID_PROCEDIMIENTO = t6101.ID_PROCEDIMIENTO");
		query.append(" WHERE t01.ID_EXPEDIENTE = ?");

		List<Sanciones> sancionesList = this.jdbcTemplate.query(query.toString(), this.rwMapCabeceraSancion,
				expediente.getIdExpediente());

		return DataAccessUtils.uniqueResult(sancionesList);
	}

	@Transactional(readOnly = true)
	public Sanciones findByFolderId(Sanciones sanciones) {
		StringBuilder query = new StringBuilder();

		query.append("SELECT t01.ID_SANCION IDSANCION");
		query.append(" FROM SANCIONES t01");
		query.append(" INNER JOIN EXPEDIENTES t6102 ON t01.ID_EXPEDIENTE = t6102.ID_EXPEDIENTE");
		query.append(" WHERE t6102.FOLDER_ID = ?");

		List<Sanciones> sancionesList = this.jdbcTemplate.query(query.toString(), this.rwMapByFolderId,
				sanciones.getExpediente().getFolderId());

		return DataAccessUtils.uniqueResult(sancionesList);
	}

}
