package com.ejie.ab59.dao.sanciones;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.apache.commons.collections.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.model.expedientes.DatosDirecciones;
import com.ejie.ab59.model.expedientes.Expedientes;
import com.ejie.ab59.model.expedientes.TiposDireccion;
import com.ejie.ab59.model.nora.T17Localidad;
import com.ejie.ab59.model.nora.T17Municipio;
import com.ejie.ab59.model.nora.T17Pais;
import com.ejie.ab59.model.nora.T17Provincia;
import com.ejie.ab59.model.procedimientos.Aplicaciones;
import com.ejie.ab59.model.procedimientos.Procedimientos;
import com.ejie.ab59.model.propuestasSancion.PropuestasSancion;
import com.ejie.ab59.model.sanciones.RelSanProSan;
import com.ejie.ab59.model.sanciones.Sanciones;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class RelSanProSanDaoImpl implements RelSanProSanDao {

	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory.getLogger(RelSanProSanDaoImpl.class);

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<RelSanProSan> rwMapAll = new RowMapper<RelSanProSan>() {
		public RelSanProSan mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			RelSanProSan relSanProSan = new RelSanProSan();
			relSanProSan.setIdRelSanProSan(resultSet.getInt("IDRELSANPROSAN"));

			PropuestasSancion propuestaSancionAux = new PropuestasSancion();
			propuestaSancionAux.setIdPropuestaSancion(resultSet.getInt("IDPROPUESTASANCION"));
			propuestaSancionAux.setNotasRespOfi(resultSet.getString("NOTASINTERNASRESP"));
			propuestaSancionAux.setIdentificadorInspeccion(resultSet.getString("IDENTIFICADORINSPECCION"));
			propuestaSancionAux.setIdentificadorProSan(resultSet.getString("IDENTIFICADORPROSAN"));

			Expedientes expedienteAux = new Expedientes();
			expedienteAux.setIdExpediente(resultSet.getInt("IDEXPEDIENTE"));
			if (resultSet.wasNull()) {
				expedienteAux.setIdExpediente(null);
			}
			expedienteAux.setFolderNumber(resultSet.getString("FOLDERNUMBER"));
			expedienteAux.setTitulo(resultSet.getString("TITULO"));
			expedienteAux.setFolderId(resultSet.getString("FOLDERID"));

			Procedimientos procedimientoAux = new Procedimientos();
			Aplicaciones aplicacionAux = new Aplicaciones();
			aplicacionAux.setUrlAplicacion(resultSet.getString("URLAPLICACION"));
			procedimientoAux.setAplicacion(aplicacionAux);
			expedienteAux.setProcedimiento(procedimientoAux);

			DatosDirecciones datosDireccionAux = new DatosDirecciones();
			datosDireccionAux.setIdDireccion(resultSet.getInt("IDDIRECCION"));
			datosDireccionAux.setDireccion(resultSet.getString("DIRECCION"));
			datosDireccionAux.setNumero(resultSet.getString("NUMERO"));
			datosDireccionAux.setEscalera(resultSet.getString("ESCALERA"));
			datosDireccionAux.setPiso(resultSet.getString("PISO"));
			datosDireccionAux.setLetra(resultSet.getString("LETRA"));
			datosDireccionAux.setDescripcionMunicipio(resultSet.getString("MUNICIPIO"));
			datosDireccionAux.setDescripcionLocalidad(resultSet.getString("LOCALIDAD"));

			TiposDireccion tipoDireccion = new TiposDireccion();
			tipoDireccion.setIdTipoDireccion(resultSet.getLong("IDTIPODIRECCION"));
			datosDireccionAux.setTipoDireccion(tipoDireccion);

			datosDireccionAux.setCodigoPostal(resultSet.getString("CODIGOPOSTAL"));
			T17Provincia provinciaAux = new T17Provincia();
			provinciaAux.setId(resultSet.getString("IDPROVINCIA"));
			datosDireccionAux.setProvincia(provinciaAux);
			T17Municipio municipioAux = new T17Municipio();
			municipioAux.setId(resultSet.getString("IDMUNICIPIO"));
			datosDireccionAux.setMunicipio(municipioAux);
			T17Localidad localidadAux = new T17Localidad();
			localidadAux.setId(resultSet.getString("IDLOCALIDAD"));
			datosDireccionAux.setLocalidad(localidadAux);
			datosDireccionAux.setEstablecimiento(resultSet.getString("ESTABLECIMIENTO"));
			datosDireccionAux.setIdentificadorEstablecimiento(resultSet.getString("IDENTIFICADORESTABLECIMIENTO"));
			datosDireccionAux.setDescripcionCiudad(resultSet.getString("DESCCIUDAD"));
			datosDireccionAux.setDescripcionProvincia(resultSet.getString("DESCPROVINCIA"));
			T17Pais paisAux = new T17Pais();
			paisAux.setId(resultSet.getString("IDPAIS"));
			datosDireccionAux.setPais(paisAux);

			expedienteAux.setDatosDirecciones(datosDireccionAux);
			propuestaSancionAux.setExpedienteOrigen(expedienteAux);

			relSanProSan.setPropuestaSancion(propuestaSancionAux);

			return relSanProSan;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the RelSanProSan table.
	 *
	 * @param relSanProSan
	 *            RelSanProSan
	 * @return RelSanProSan
	 */
	public RelSanProSan add(RelSanProSan relSanProSan) {
		String query = "INSERT INTO REL_SAN_PRO_SAN (ID_REL_SAN_PRO_SAN, ID_PROPUESTA_SANCION, ID_SANCION, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (?,?,?,?,?)";

		relSanProSan.setIdRelSanProSan(
				this.jdbcTemplate.queryForObject("SELECT AB59.S_AB5906T00.NEXTVAL FROM DUAL", Integer.class));

		Object getPropuestaSancion = null;
		if (relSanProSan.getPropuestaSancion() != null
				&& relSanProSan.getPropuestaSancion().getIdPropuestaSancion() != null) {
			getPropuestaSancion = relSanProSan.getPropuestaSancion().getIdPropuestaSancion();
		}
		Object getSancion = null;
		if (relSanProSan.getSancion() != null && relSanProSan.getSancion().getIdSancion() != null) {
			getSancion = relSanProSan.getSancion().getIdSancion();
		}

		this.jdbcTemplate.update(query, relSanProSan.getIdRelSanProSan(), getPropuestaSancion, getSancion,
				relSanProSan.getFechaRegistro(), relSanProSan.getUsuarioRegistro());
		return relSanProSan;
	}

	/**
	 * Removes a single row in the RelSanProSan table.
	 *
	 * @param relSanProSan
	 *            RelSanProSan
	 * @return
	 */
	public void remove(RelSanProSan relSanProSan) {
		String query = "DELETE FROM REL_SAN_PRO_SAN WHERE ID_REL_SAN_PRO_SAN = ?";
		this.jdbcTemplate.update(query, relSanProSan.getIdRelSanProSan());
	}

	@Override
	public void removeByPropuestaSancion(Integer idPropuestaSancion) {
		String query = "DELETE FROM REL_SAN_PRO_SAN WHERE ID_PROPUESTA_SANCION = ?";
		this.jdbcTemplate.update(query, idPropuestaSancion);
	}

	/**
	 * Finds a list of rows in the RelSanProSan table.
	 *
	 * @param relSanProSan
	 *            RelSanProSan
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<RelSanProSan>
	 */
	@Transactional(readOnly = true)
	public List<RelSanProSan> findAll(RelSanProSan relSanProSan, TableRequestDto tableRequestDto) {

		RelSanProSanDaoImpl.logger.info("RelSanProSanDaoImpl.findAll");
		StringBuilder query = new StringBuilder();

		/*
		 * Se hace select distinct porque una propuesta puede tener varias
		 * infracciones
		 */
		query.append("SELECT distinct(t06.ID_REL_SAN_PRO_SAN) IDRELSANPROSAN, t6102.FOLDER_NUMBER FOLDERNUMBER");
		query.append(", t6102.TITULO TITULO, t6102.ID_EXPEDIENTE IDEXPEDIENTE");
		query.append(", t02.NOTAS_RESP_OFI NOTASINTERNASRESP");
		query.append(", t6136.ID_DIRECCION IDDIRECCION, t6136.DIRECCION DIRECCION, t6136.NUMERO NUMERO");
		query.append(", t6136.ESCALERA ESCALERA, t6136.PISO PISO, t6136.LETRA LETRA");
		query.append(", t6136.ID_TIPO_DIRECCION IDTIPODIRECCION, t6136.CODIGO_POSTAL CODIGOPOSTAL");
		query.append(
				", t6136.ID_PROVINCIA IDPROVINCIA, t6136.ID_MUNICIPIO IDMUNICIPIO, t6136.ID_LOCALIDAD IDLOCALIDAD");
		query.append(
				", t6136.ESTABLECIMIENTO ESTABLECIMIENTO, t6136.IDENTIFICADOR_ESTABLECIMIENTO IDENTIFICADORESTABLECIMIENTO");
		query.append(
				", t6136.DESCRIPCION_CIUDAD DESCCIUDAD, t6136.DESCRIPCION_PROVINCIA DESCPROVINCIA, t6136.ID_PAIS IDPAIS");
		query.append(", MUNI.DS_O MUNICIPIO, LOCA.DS_O LOCALIDAD, t02.ID_PROPUESTA_SANCION IDPROPUESTASANCION");
		query.append(
				" , t6146.URL_APLICACION URLAPLICACION, t6102.FOLDER_ID FOLDERID, t02.IDENTIFICADOR_INSPECCION IDENTIFICADORINSPECCION, t02.IDENTIFICADOR_PRO_SAN IDENTIFICADORPROSAN");
		query.append(" FROM REL_SAN_PRO_SAN t06");
		query.append(" INNER JOIN PROPUESTAS_SANCION t02 ON t06.ID_PROPUESTA_SANCION = t02.ID_PROPUESTA_SANCION");
		query.append(" INNER JOIN EXPEDIENTES t6102 ON t02.ID_EXPEDIENTE_ORIGEN = t6102.ID_EXPEDIENTE");
		query.append(" INNER JOIN REL_EXP_TER t6134 ON t02.ID_EXPEDIENTE_ORIGEN = t6134.ID_EXPEDIENTE");
		query.append(
				" INNER JOIN DATOS_TERCEROS t6135 ON t6134.ID_TERCERO = t6135.ID_TERCERO AND t6135.TIPO_PARTICIPANTE = "
						+ Constantes.PARTICIPANTE_TITULAR);
		query.append(" INNER JOIN REL_EXP_DIR t6151 ON t02.ID_EXPEDIENTE_ORIGEN = t6151.ID_EXPEDIENTE");
		query.append(
				" INNER JOIN DATOS_DIRECCIONES t6136 ON T6151.ID_DIRECCION = t6136.ID_DIRECCION AND t6136.ID_TIPO_DIRECCION = ");
		query.append(Constantes.UBICACION_ACTIVIDAD);
		query.append(
				" LEFT OUTER JOIN MUNICIPIOS MUNI ON t6136.ID_MUNICIPIO = MUNI.ID AND t6136.ID_PROVINCIA = MUNI.PROVINCIA_ID");
		query.append(
				" LEFT OUTER JOIN LOCALIDADES LOCA ON t6136.ID_LOCALIDAD = LOCA.ID AND t6136.ID_MUNICIPIO = LOCA.MUNICIPIO_ID AND t6136.ID_PROVINCIA = LOCA.PROVINCIA_ID");
		query.append(" INNER JOIN PROCEDIMIENTOS t6101 ON t6102.ID_PROCEDIMIENTO = t6101.ID_PROCEDIMIENTO");
		query.append(" LEFT OUTER JOIN APLICACIONES t6146 ON t6101.ID_APLICACION = t6146.ID_APLICACION");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(relSanProSan);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		query.append(
				" UNION SELECT DISTINCT ( t06.ID_REL_SAN_PRO_SAN ) IDRELSANPROSAN, '' FOLDERNUMBER, '' TITULO, NULL IDEXPEDIENTE, t02.NOTAS_RESP_OFI NOTASINTERNASRESP, t6136.ID_DIRECCION IDDIRECCION, t6136.DIRECCION DIRECCION, t6136.NUMERO NUMERO, t6136.ESCALERA ESCALERA, t6136.PISO PISO, t6136.LETRA LETRA, t6136.ID_TIPO_DIRECCION IDTIPODIRECCION, t6136.CODIGO_POSTAL CODIGOPOSTAL, t6136.ID_PROVINCIA IDPROVINCIA, t6136.ID_MUNICIPIO IDMUNICIPIO, t6136.ID_LOCALIDAD IDLOCALIDAD, t6136.ESTABLECIMIENTO ESTABLECIMIENTO, t6136.IDENTIFICADOR_ESTABLECIMIENTO IDENTIFICADORESTABLECIMIENTO, t6136.DESCRIPCION_CIUDAD DESCCIUDAD, t6136.DESCRIPCION_PROVINCIA DESCPROVINCIA, t6136.ID_PAIS IDPAIS, MUNI.DS_O MUNICIPIO, LOCA.DS_O LOCALIDAD, t02.ID_PROPUESTA_SANCION IDPROPUESTASANCION, '' URLAPLICACION, '' FOLDERID, t02.IDENTIFICADOR_INSPECCION IDENTIFICADORINSPECCION, t02.IDENTIFICADOR_PRO_SAN IDENTIFICADORPROSAN FROM REL_SAN_PRO_SAN t06, PROPUESTAS_SANCION t02, DATOS_TERCEROS t6135, DATOS_DIRECCIONES t6136, MUNICIPIOS MUNI, LOCALIDADES LOCA WHERE 1 = 1 AND t06.ID_PROPUESTA_SANCION = t02.ID_PROPUESTA_SANCION AND t02.ID_TERCERO = t6135.ID_TERCERO AND t6135.TIPO_PARTICIPANTE = "
						+ Constantes.PARTICIPANTE_TITULAR
						+ " AND t02.ID_DIRECCION = t6136.ID_DIRECCION AND t6136.ID_TIPO_DIRECCION = "
						+ Constantes.UBICACION_ACTIVIDAD
						+ " AND t6136.ID_MUNICIPIO = MUNI.ID (+) AND t6136.ID_PROVINCIA = MUNI.PROVINCIA_ID (+) AND t6136.ID_LOCALIDAD = LOCA.ID (+) AND t6136.ID_MUNICIPIO = LOCA.MUNICIPIO_ID (+) AND t6136.ID_PROVINCIA = LOCA.PROVINCIA_ID (+) ");

		// Where clause & Params
		Map<String, ?> mapaWhereSinExp = this.getWhereMap(relSanProSan);
		StringBuilder whereSinExp = new StringBuilder(" ");
		whereSinExp.append(mapaWhereSinExp.get("query"));
		query.append(whereSinExp);

		List<?> paramsSinExp = (List<?>) mapaWhereSinExp.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query);
		}

		List<String> paramsAll = ListUtils.union(params, paramsSinExp);

		RelSanProSanDaoImpl.logger.info("sql = " + query.toString());
		RelSanProSanDaoImpl.logger.info("parametros = " + paramsAll.toArray());
		return this.jdbcTemplate.query(query.toString(), this.rwMapAll, paramsAll.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the RelSanProSan table.
	 *
	 * @param relSanProSan
	 *            RelSanProSan
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(RelSanProSan relSanProSan) {
		StringBuilder query = new StringBuilder(
				"SELECT SUM (IDRELSANPROSAN) SUMARELSANPROSAN FROM ( SELECT COUNT(1) AS IDRELSANPROSAN ");
		query.append(" FROM REL_SAN_PRO_SAN t06");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(relSanProSan);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		query.append(" UNION SELECT COUNT(1) AS IDRELSANPROSAN FROM REL_SAN_PRO_SAN t06 WHERE 1 = 1 ");

		// Where clause & Params
		Map<String, ?> mapaWhereSinExp = this.getWhereMap(relSanProSan);
		StringBuilder whereSinExp = new StringBuilder(" ");
		whereSinExp.append(mapaWhereSinExp.get("query"));
		query.append(whereSinExp);
		query.append(" ) ");

		List<?> paramsSinExp = (List<?>) mapaWhereSinExp.get("params");

		List<String> paramsAll = ListUtils.union(params, paramsSinExp);

		return this.jdbcTemplate.queryForObject(query.toString(), paramsAll.toArray(), Long.class);
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the RelSanProSan entity
	 *
	 * @param relSanProSan
	 *            RelSanProSan Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generacin de cdigo de UDA
	private Map<String, ?> getWhereMap(RelSanProSan relSanProSan) {

		StringBuilder where = new StringBuilder(RelSanProSanDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		/* Sanción */
		if (relSanProSan != null && relSanProSan.getSancion() != null
				&& relSanProSan.getSancion().getIdSancion() != null) {
			where.append(" AND t06.ID_SANCION = ?");
			params.add(relSanProSan.getSancion().getIdSancion());
		}

		/* Identificador de la Propuesta de Sancin */
		if (relSanProSan != null && relSanProSan.getPropuestaSancion() != null
				&& relSanProSan.getPropuestaSancion().getIdentificadorProSan() != null) {
			where.append(" AND (t02.IDENTIFICADOR_PRO_SAN) = ? ");
			params.add(relSanProSan.getPropuestaSancion().getIdentificadorProSan());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public Boolean esLaPrimera(Sanciones sancionAux) {
		List<Object> params = new ArrayList<Object>();

		StringBuilder query = new StringBuilder("SELECT COUNT(1)");
		query.append(" FROM REL_SAN_PRO_SAN");
		query.append(" WHERE ID_SANCION = ?");
		params.add(sancionAux.getIdSancion());

		Long count = this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);

		if (count == 1) {
			return true;
		} else {
			return false;
		}
	}
}
