package com.ejie.ab59.dao.sanciones;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.model.sanciones.RelArtInfSan;
import com.ejie.ab59.model.sanciones.RelArtInfSanDer;
import com.ejie.ab59.model.tablasMaestras.Derechos;
import com.ejie.ab59.model.tablasMaestras.Infracciones;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class RelArtInfSanDerDaoImpl implements RelArtInfSanDerDao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<RelArtInfSanDer> rwMapAll = new RowMapper<RelArtInfSanDer>() {
		public RelArtInfSanDer mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			RelArtInfSanDer relArtInfSanDer = new RelArtInfSanDer();

			RelArtInfSan relArtInfSanAux = new RelArtInfSan();
			Infracciones infraccionAux = new Infracciones();
			infraccionAux.setIdInfraccion(resultSet.getInt("IDINFRACCION"));
			relArtInfSanAux.setInfraccion(infraccionAux);
			relArtInfSanDer.setRelArtInfSan(relArtInfSanAux);

			Derechos derechoAux = new Derechos();
			derechoAux.setIdDerecho(resultSet.getInt("IDDERECHO"));
			relArtInfSanDer.setDerecho(derechoAux);

			return relArtInfSanDer;
		}
	};

	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	public RelArtInfSanDer add(RelArtInfSanDer relArtInfSanDer) {
		String query = "INSERT INTO REL_ART_INF_SAN_DER (ID_REL_ART_INF_SAN_DER, ID_REL_ART_INF_SAN, ID_DERECHO, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (?,?,?,SYSDATE,?)";

		relArtInfSanDer.setIdRelArtInfSanDer(
				this.jdbcTemplate.queryForObject("SELECT AB59.S_AB5914T00.NEXTVAL FROM DUAL", Integer.class));

		Object getRelArtInfSan = null;
		if (relArtInfSanDer.getRelArtInfSan() != null
				&& relArtInfSanDer.getRelArtInfSan().getIdRelArtInfSan() != null) {
			getRelArtInfSan = relArtInfSanDer.getRelArtInfSan().getIdRelArtInfSan();
		}
		Object getDerecho = null;
		if (relArtInfSanDer.getDerecho() != null && relArtInfSanDer.getDerecho().getIdDerecho() != null) {
			getDerecho = relArtInfSanDer.getDerecho().getIdDerecho();
		}

		this.jdbcTemplate.update(query, relArtInfSanDer.getIdRelArtInfSanDer(), getRelArtInfSan, getDerecho,
				relArtInfSanDer.getUsuarioRegistro());
		return relArtInfSanDer;
	}

	@Transactional(readOnly = true)
	public List<RelArtInfSanDer> findAll(Integer idSancion) {

		StringBuilder query = new StringBuilder();
		List<Object> params = new ArrayList<Object>();

		query.append("SELECT t11.ID_INFRACCION IDINFRACCION, t14.ID_DERECHO IDDERECHO");
		query.append(" FROM REL_ART_INF_SAN_DER t14");
		query.append(" INNER JOIN REL_ART_INF_SAN t11 ON t14.ID_REL_ART_INF_SAN = t11.ID_REL_ART_INF_SAN");
		query.append(" WHERE t11.ID_SANCION = ?");
		params.add(idSancion);
		query.append(" ORDER BY IDINFRACCION");

		return this.jdbcTemplate.query(query.toString(), this.rwMapAll, params.toArray());
	}

	public static final int STRING_BUILDER_INIT = 4096;

	public void remove(RelArtInfSanDer relArtInfSanDer) {

		String query = "DELETE FROM REL_ART_INF_SAN_DER WHERE ID_REL_ART_INF_SAN = ?";
		this.jdbcTemplate.update(query, relArtInfSanDer.getRelArtInfSan().getIdRelArtInfSan());
	}
}
