package com.ejie.ab59.dao.sanciones;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.model.sanciones.RelArtInfSan;
import com.ejie.ab59.model.sanciones.Sanciones;
import com.ejie.ab59.model.tablasMaestras.Calificaciones;
import com.ejie.ab59.model.tablasMaestras.Infracciones;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class RelArtInfSanDaoImpl implements RelArtInfSanDao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<RelArtInfSan> rwMapAll = new RowMapper<RelArtInfSan>() {
		@Override
		public RelArtInfSan mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			RelArtInfSan relArtInfSan = new RelArtInfSan();
			relArtInfSan.setIdRelArtInfSan(resultSet.getInt("IDRELARTINFSAN"));
			relArtInfSan.setImporteSancionArt(resultSet.getBigDecimal("IMPORTESANCIONART"));
			relArtInfSan.setImporteResolucionArt(resultSet.getBigDecimal("IMPORTERESOLUCIONART"));
			relArtInfSan.setFechaHecho(resultSet.getDate("FECHAHECHO"));
			relArtInfSan.setDescripcionHecho(resultSet.getString("DESCRIPCIONHECHO"));
			relArtInfSan.setFechaPrescripcion(resultSet.getDate("FECHAPRESCRIPCION"));
			relArtInfSan.setIdDerechosInf(resultSet.getString("IDDERECHOS"));
			relArtInfSan.setArticulosDerechosInf(resultSet.getString("ARTDERECHOS"));

			Infracciones infraccionAux = new Infracciones();
			infraccionAux.setIdInfraccion(resultSet.getInt("IDINFRACCION"));
			infraccionAux.setArticulo(resultSet.getString("ARTICULOINFRACCION"));
			infraccionAux.setDescripcionCastellano(resultSet.getString("DESCINFRACCIONCAS"));
			infraccionAux.setDescripcionEuskera(resultSet.getString("DESCINFRACCIONEUS"));

			Calificaciones calificacionAux = new Calificaciones();
			calificacionAux.setDescripcionCastellano(resultSet.getString("DESCCALIFICACIONCAS"));
			calificacionAux.setDescripcionEuskera(resultSet.getString("DESCCALIFICACIONEUS"));
			infraccionAux.setCalificaciones(calificacionAux);
			relArtInfSan.setInfraccion(infraccionAux);

			Sanciones sancionAux = new Sanciones();
			sancionAux.setIdSancion(resultSet.getInt("IDSANCION"));
			relArtInfSan.setSancion(sancionAux);

			return relArtInfSan;
		}
	};

	private RowMapper<RelArtInfSan> rwMapFind = new RowMapper<RelArtInfSan>() {
		@Override
		public RelArtInfSan mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			RelArtInfSan relArtInfSan = new RelArtInfSan();
			relArtInfSan.setIdRelArtInfSan(resultSet.getInt("IDRELARTINFSAN"));
			relArtInfSan.setImporteSancionArt(resultSet.getBigDecimal("IMPORTESANCIONART"));
			relArtInfSan.setImporteResolucionArt(resultSet.getBigDecimal("IMPORTERESOLUCIONART"));
			relArtInfSan.setFechaHecho(resultSet.getDate("FECHAHECHO"));
			relArtInfSan.setDescripcionHecho(resultSet.getString("DESCRIPCIONHECHO"));
			relArtInfSan.setFechaPrescripcion(resultSet.getDate("FECHAPRESCRIPCION"));
			relArtInfSan.setIdDerechosInf(resultSet.getString("IDDERECHOS"));

			Infracciones infraccionAux = new Infracciones();
			infraccionAux.setIdInfraccion(resultSet.getInt("IDINFRACCION"));
			Calificaciones calificacionAux = new Calificaciones();
			calificacionAux.setDescripcionCastellano(resultSet.getString("DESCCALIFICACIONCAS"));
			calificacionAux.setDescripcionEuskera(resultSet.getString("DESCCALIFICACIONEUS"));
			calificacionAux.setPlazo(resultSet.getLong("PLAZO"));
			calificacionAux.setImporte(resultSet.getBigDecimal("IMPORTE"));
			infraccionAux.setCalificaciones(calificacionAux);
			relArtInfSan.setInfraccion(infraccionAux);

			Sanciones sancionAux = new Sanciones();
			sancionAux.setIdSancion(resultSet.getInt("IDSANCION"));
			relArtInfSan.setSancion(sancionAux);

			return relArtInfSan;
		}
	};

	private RowMapper<RelArtInfSan> rwMapTotales = new RowMapper<RelArtInfSan>() {
		@Override
		public RelArtInfSan mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			RelArtInfSan relArtInfSan = new RelArtInfSan();
			relArtInfSan.setTotalSancion(resultSet.getBigDecimal("TOTALSANCION"));
			relArtInfSan.setTotalResolucion(resultSet.getBigDecimal("TOTALRESOLUCION"));

			return relArtInfSan;
		}
	};

	private RowMapper<RelArtInfSan> rwMapFindInfraccionInfringida = new RowMapper<RelArtInfSan>() {
		@Override
		public RelArtInfSan mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			RelArtInfSan relArtInfSan = new RelArtInfSan();

			relArtInfSan.setIdRelArtInfSan(resultSet.getInt("IDRELARTINFSAN"));

			return relArtInfSan;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the RelArtInfSan table.
	 *
	 * @param relArtInfSan
	 *            RelArtInfSan
	 * @return RelArtInfSan
	 */
	@Override
	public RelArtInfSan add(RelArtInfSan relArtInfSan) {
		String query = "INSERT INTO REL_ART_INF_SAN (ID_REL_ART_INF_SAN, ID_INFRACCION, ID_SANCION, FECHA_HECHO, DESCRIPCION_HECHO, FECHA_PRESCRIPCION, "
				+ " IMPORTE_SANCION_ART, IMPORTE_RESOLUCION_ART, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (?,?,?,?,?,?,?,?,SYSDATE,?)";

		relArtInfSan.setIdRelArtInfSan(
				this.jdbcTemplate.queryForObject("SELECT AB59.S_AB5911T00.NEXTVAL FROM DUAL", Integer.class));

		Object getInfraccion = null;
		if (relArtInfSan.getInfraccion() != null && relArtInfSan.getInfraccion().getIdInfraccion() != null) {
			getInfraccion = relArtInfSan.getInfraccion().getIdInfraccion();
		}
		Object getSancion = null;
		if (relArtInfSan.getSancion() != null && relArtInfSan.getSancion().getIdSancion() != null) {
			getSancion = relArtInfSan.getSancion().getIdSancion();
		}

		this.jdbcTemplate.update(query, relArtInfSan.getIdRelArtInfSan(), getInfraccion, getSancion,
				relArtInfSan.getFechaHecho(), relArtInfSan.getDescripcionHecho(), relArtInfSan.getFechaPrescripcion(),
				relArtInfSan.getImporteSancionArt(), relArtInfSan.getImporteResolucionArt(),
				relArtInfSan.getUsuarioRegistro());
		return relArtInfSan;
	}

	/**
	 * Updates a single row in the RelArtInfSan table.
	 *
	 * @param relArtInfSan
	 *            RelArtInfSan
	 * @return RelArtInfSan
	 */
	@Override
	public RelArtInfSan update(RelArtInfSan relArtInfSan) {
		String query = "UPDATE REL_ART_INF_SAN SET ID_INFRACCION = ?, FECHA_HECHO = ?, DESCRIPCION_HECHO = ?, FECHA_PRESCRIPCION = ?, IMPORTE_SANCION_ART = ?, "
				+ " IMPORTE_RESOLUCION_ART = ?, FECHA_ULTMODIFICACION = SYSDATE, USUARIO_ULTMODIFICACION = ? WHERE ID_REL_ART_INF_SAN = ?";

		Object getInfraccion = null;
		if (relArtInfSan.getInfraccion() != null && relArtInfSan.getInfraccion().getIdInfraccion() != null) {
			getInfraccion = relArtInfSan.getInfraccion().getIdInfraccion();
		}

		this.jdbcTemplate.update(query, getInfraccion, relArtInfSan.getFechaHecho(), relArtInfSan.getDescripcionHecho(),
				relArtInfSan.getFechaPrescripcion(), relArtInfSan.getImporteSancionArt(),
				relArtInfSan.getImporteResolucionArt(), relArtInfSan.getUsuarioUltModificacion(),
				relArtInfSan.getIdRelArtInfSan());
		return relArtInfSan;
	}

	/**
	 * Removes a single row in the RelArtInfSan table.
	 *
	 * @param relArtInfSan
	 *            RelArtInfSan
	 * @return
	 */
	@Override
	public void remove(RelArtInfSan relArtInfSan) {
		String query = "DELETE FROM REL_ART_INF_SAN WHERE ID_REL_ART_INF_SAN = ?";
		this.jdbcTemplate.update(query, relArtInfSan.getIdRelArtInfSan());
	}

	/**
	 * Finds a list of rows in the RelArtInfSan table.
	 *
	 * @param relArtInfSan
	 *            RelArtInfSan
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<RelArtInfSan>
	 */
	@Override
	@Transactional(readOnly = true)
	public List<RelArtInfSan> findAll(RelArtInfSan relArtInfSan, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder();
		List<Object> params = new ArrayList<Object>();

		query.append("SELECT t11.ID_REL_ART_INF_SAN IDRELARTINFSAN, t11.ID_SANCION IDSANCION");
		query.append(", t04.DESCRIPCION_CASTELLANO DESCCALIFICACIONCAS, t04.DESCRIPCION_EUSKERA DESCCALIFICACIONEUS");
		query.append(", t09.ID_INFRACCION IDINFRACCION, t09.ARTICULO ARTICULOINFRACCION");
		query.append(", t09.DESCRIPCION_CASTELLANO DESCINFRACCIONCAS, t09.DESCRIPCION_EUSKERA DESCINFRACCIONEUS");
		query.append(", t11.IMPORTE_SANCION_ART IMPORTESANCIONART, t11.IMPORTE_RESOLUCION_ART IMPORTERESOLUCIONART");
		query.append(
				" , t11.FECHA_HECHO FECHAHECHO, t11.DESCRIPCION_HECHO DESCRIPCIONHECHO, t11.FECHA_PRESCRIPCION FECHAPRESCRIPCION");
		query.append(
				", LISTAGG (t08.ID_DERECHO, '#') WITHIN GROUP (ORDER BY t11.ID_REL_ART_INF_SAN, t11.ID_INFRACCION, t14.ID_DERECHO) IDDERECHOS");
		query.append(
				", LISTAGG (t08.ARTICULO, '#') WITHIN GROUP (ORDER BY t11.ID_REL_ART_INF_SAN, t11.ID_INFRACCION, t14.ID_DERECHO) ARTDERECHOS");
		query.append(" FROM REL_ART_INF_SAN t11");
		query.append(" INNER JOIN INFRACCIONES t09 ON t11.ID_INFRACCION = t09.ID_INFRACCION");
		query.append(" INNER JOIN CALIFICACIONES t04 ON t09.ID_CALIFICACION = t04.ID_CALIFICACION");
		query.append(" INNER JOIN REL_ART_INF_SAN_DER t14 ON t11.ID_REL_ART_INF_SAN = t14.ID_REL_ART_INF_SAN");
		query.append(" INNER JOIN DERECHOS t08 ON t14.ID_DERECHO = t08.ID_DERECHO");
		query.append(" WHERE t11.ID_SANCION = ?");
		params.add(relArtInfSan.getSancion().getIdSancion());
		query.append(
				" GROUP BY  t11.ID_REL_ART_INF_SAN, t11.ID_SANCION, t04.DESCRIPCION_CASTELLANO, t04.DESCRIPCION_EUSKERA");
		query.append(", t09.ID_INFRACCION, t09.ARTICULO, t09.DESCRIPCION_CASTELLANO, t09.DESCRIPCION_EUSKERA");
		query.append(", t11.IMPORTE_SANCION_ART, t11.IMPORTE_RESOLUCION_ART");
		query.append(", t11.FECHA_HECHO, t11.DESCRIPCION_HECHO, t11.FECHA_PRESCRIPCION");
		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMapAll, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the RelArtInfSan table.
	 *
	 * @param relArtInfSan
	 *            RelArtInfSan
	 * @return Long
	 */
	@Override
	@Transactional(readOnly = true)
	public Long findAllCount(RelArtInfSan relArtInfSan) {
		StringBuilder query = new StringBuilder();
		List<Object> params = new ArrayList<Object>();

		query.append("SELECT COUNT(1)");
		query.append(" FROM REL_ART_INF_SAN t11");
		query.append(" WHERE t11.ID_SANCION = ?");
		params.add(relArtInfSan.getSancion().getIdSancion());

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a single row in the RelArtInfSan table.
	 *
	 * @param relArtInfSan
	 *            RelArtInfSan
	 * @return RelArtInfSan
	 */
	@Override
	@Transactional(readOnly = true)
	public RelArtInfSan find(RelArtInfSan relArtInfSan) {
		StringBuilder query = new StringBuilder();

		query.append("SELECT t11.ID_REL_ART_INF_SAN IDRELARTINFSAN, t11.ID_SANCION IDSANCION");
		query.append(", t09.ID_INFRACCION IDINFRACCION");
		query.append(", t11.IMPORTE_SANCION_ART IMPORTESANCIONART, t11.IMPORTE_RESOLUCION_ART IMPORTERESOLUCIONART");
		query.append(", t11.FECHA_HECHO FECHAHECHO, t11.DESCRIPCION_HECHO DESCRIPCIONHECHO");
		query.append(", t11.FECHA_PRESCRIPCION FECHAPRESCRIPCION");
		query.append(", t04.DESCRIPCION_CASTELLANO DESCCALIFICACIONCAS, t04.DESCRIPCION_EUSKERA DESCCALIFICACIONEUS");
		query.append(
				", t04.PLAZO PLAZO, t04.IMPORTE, LISTAGG (t14.ID_DERECHO, '#') WITHIN GROUP (ORDER BY t11.ID_REL_ART_INF_SAN, t11.ID_INFRACCION, t14.ID_DERECHO) IDDERECHOS");
		query.append(" FROM REL_ART_INF_SAN t11");
		query.append(" INNER JOIN INFRACCIONES t09 ON t11.ID_INFRACCION = t09.ID_INFRACCION");
		query.append(" INNER JOIN CALIFICACIONES t04 ON t09.ID_CALIFICACION = t04.ID_CALIFICACION");
		query.append(" INNER JOIN REL_ART_INF_SAN_DER t14 ON t11.ID_REL_ART_INF_SAN = t14.ID_REL_ART_INF_SAN");
		query.append(" WHERE t11.ID_REL_ART_INF_SAN = ?");
		query.append(" GROUP BY t11.ID_REL_ART_INF_SAN, t11.ID_SANCION, t09.ID_INFRACCION, t11.IMPORTE_SANCION_ART");
		query.append(", t11.IMPORTE_RESOLUCION_ART, t11.FECHA_HECHO, t11.DESCRIPCION_HECHO, t11.FECHA_PRESCRIPCION");
		query.append(", t04.DESCRIPCION_CASTELLANO, t04.DESCRIPCION_EUSKERA, t04.PLAZO, t04.IMPORTE");

		List<RelArtInfSan> relArtInfSanList = this.jdbcTemplate.query(query.toString(), this.rwMapFind,
				relArtInfSan.getIdRelArtInfSan());
		return DataAccessUtils.uniqueResult(relArtInfSanList);
	}

	/**
	 * Calcular el total de sanción y el total de resolución para una sanción
	 *
	 * @param relArtInfSan
	 *            RelArtInfSan
	 * @return RelArtInfSan
	 */
	@Override
	@Transactional(readOnly = true)
	public RelArtInfSan totales(RelArtInfSan relArtInfSan) {
		StringBuilder query = new StringBuilder();

		query.append("SELECT SUM(IMPORTE_SANCION_ART) TOTALSANCION, SUM(IMPORTE_RESOLUCION_ART) TOTALRESOLUCION");
		query.append(" FROM REL_ART_INF_SAN");
		query.append(" WHERE ID_SANCION = ?");

		List<RelArtInfSan> relArtInfSanList = this.jdbcTemplate.query(query.toString(), this.rwMapTotales,
				relArtInfSan.getSancion().getIdSancion());
		return DataAccessUtils.uniqueResult(relArtInfSanList);
	}

	/**
	 * Finds a single row in the RelArtInfSan table.
	 *
	 * @param idSancion
	 *            Integer
	 * @param idInfraccion
	 *            Integer
	 * 
	 * @return RelArtInfSan
	 */
	@Override
	@Transactional(readOnly = true)
	public RelArtInfSan findInfraccionInfringida(Integer idSancion, Integer idInfraccion) {

		StringBuilder query = new StringBuilder();
		List<Object> params = new ArrayList<Object>();

		query.append("SELECT ID_REL_ART_INF_SAN IDRELARTINFSAN");
		query.append(" FROM REL_ART_INF_SAN");
		query.append(" WHERE ID_SANCION = ?");
		params.add(idSancion);
		query.append(" AND ID_INFRACCION = ?");
		params.add(idInfraccion);

		List<RelArtInfSan> relArtInfSanList = this.jdbcTemplate.query(query.toString(),
				this.rwMapFindInfraccionInfringida, params.toArray());

		return DataAccessUtils.uniqueResult(relArtInfSanList);
	}

	/**
	 * Updates a single row in the RelArtInfSan table.
	 *
	 * @param relArtInfSan
	 *            RelArtInfSan
	 * @return RelArtInfSan
	 */
	@Override
	public RelArtInfSan updatePagos(RelArtInfSan relArtInfSan) {

		StringBuilder query = new StringBuilder();

		query.append("UPDATE REL_ART_INF_SAN SET");
		query.append(" IMPORTE_SANCION_ART = ?, IMPORTE_RESOLUCION_ART = ?");
		query.append(", FECHA_ULTMODIFICACION = SYSDATE, USUARIO_ULTMODIFICACION = ?");
		query.append(" WHERE ID_REL_ART_INF_SAN = ?");

		this.jdbcTemplate.update(query.toString(), relArtInfSan.getImporteSancionArt(),
				relArtInfSan.getImporteResolucionArt(), relArtInfSan.getUsuarioUltModificacion(),
				relArtInfSan.getIdRelArtInfSan());

		return relArtInfSan;
	}
}
