package com.ejie.ab59.dao.sanciones;

import java.util.List;

import com.ejie.ab59.model.sanciones.RelArtInfSan;
import com.ejie.x38.dto.TableRequestDto;

/**
 * 
 *  
 *
 */

public interface RelArtInfSanDao {

	/**
	 * Inserts a single row in the RelArtInfSan table.
	 *
	 * @param relArtInfSan
	 *            RelArtInfSan
	 * @return RelArtInfSan
	 */
	RelArtInfSan add(RelArtInfSan relArtInfSan);

	/**
	 * Updates a single row in the RelArtInfSan table.
	 *
	 * @param relArtInfSan
	 *            RelArtInfSan
	 * @return RelArtInfSan
	 */
	RelArtInfSan update(RelArtInfSan relArtInfSan);

	/**
	 * Removes a single row in the RelArtInfSan table.
	 *
	 * @param relArtInfSan
	 *            RelArtInfSan
	 */
	void remove(RelArtInfSan relArtInfSan);

	/**
	 * Finds a List of rows in the RelArtInfSan table.
	 *
	 * @param relArtInfSan
	 *            RelArtInfSan
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<RelArtInfSan> findAll(RelArtInfSan relArtInfSan, TableRequestDto tableRequestDto);

	/**
	 * Counts rows in the RelArtInfSan table.
	 *
	 * @param relArtInfSan
	 *            RelArtInfSan
	 * @return Long
	 */
	Long findAllCount(RelArtInfSan relArtInfSan);

	/**
	 * Finds a single row in the RelArtInfSan table.
	 *
	 * @param relArtInfSan
	 *            RelArtInfSan
	 * @return RelArtInfSan
	 */
	RelArtInfSan find(RelArtInfSan relArtInfSan);

	/**
	 * Calcular el total de sanción y el total de resolución para una sanción
	 *
	 * @param relArtInfSan
	 *            RelArtInfSan
	 * @return RelArtInfSan
	 */
	RelArtInfSan totales(RelArtInfSan relArtInfSan);

	/**
	 * Finds a single row in the RelArtInfSan table.
	 *
	 * @param idSancion
	 *            Integer
	 * @param idInfraccion
	 *            Integer
	 * 
	 * @return RelArtInfSan
	 */
	RelArtInfSan findInfraccionInfringida(Integer idSancion, Integer idInfraccion);

	/**
	 * Updates a single row in the RelArtInfSan table.
	 *
	 * @param relArtInfSan
	 *            RelArtInfSan
	 * @return RelArtInfSan
	 */
	RelArtInfSan updatePagos(RelArtInfSan relArtInfSan);
}
