package com.ejie.ab59.dao.sanciones;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.model.sanciones.ControlFechas;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class ControlFechasDaoImpl implements ControlFechasDao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<ControlFechas> rwMap = new RowMapper<ControlFechas>() {
		public ControlFechas mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			ControlFechas controlFechas = new ControlFechas();

			controlFechas.setIdSancion(resultSet.getInt("IDSANCION"));

			controlFechas.setFechaResolucionIncoacion(resultSet.getDate("FECHARESOLUCIONINCOACION"));
			controlFechas.setFechaAcuseElecResInc(resultSet.getDate("FECHAACUSEELECRESINC"));
			controlFechas.setFechaAcusePostalResInc(resultSet.getDate("FECHAACUSEPOSTALRESINC"));
			controlFechas.setFechaPresAlegacionesResInc(resultSet.getDate("FECHAPRESALEGACIONESRESINC"));
			controlFechas.setApePerProResInc(resultSet.getInt("APEPERPRORESINC"));

			controlFechas.setFechaPropuestaResolucion(resultSet.getDate("FECHAPROPUESTARESOLUCION"));
			controlFechas.setFechaAcuseElecProRes(resultSet.getDate("FECHAACUSEELECPRORES"));
			controlFechas.setFechaAcusePostalProRes(resultSet.getDate("FECHAACUSEPOSTALPRORES"));
			controlFechas.setFechaPresAlegacionesProRes(resultSet.getDate("FECHAPRESALEGACIONESPRORES"));

			controlFechas.setFechaResolucion(resultSet.getDate("FECHARESOLUCION"));
			controlFechas.setFechaAcuseResolucion(resultSet.getDate("FECHAACUSERESOLUCION"));
			controlFechas.setFechaRecursoAlzada(resultSet.getDate("FECHARECURSOALZADA"));
			controlFechas.setFechaResRecursoAlzada(resultSet.getDate("FECHARESRECURSOALZADA"));
			controlFechas.setFechaAcuseElecResRecAlz(resultSet.getDate("FECHAACUSEELECRESRECALZ"));
			controlFechas.setFechaAcusePostalResRecAlz(resultSet.getDate("FECHAACUSEPOSTALRESRECALZ"));
			controlFechas.setFechaRecConAdm(resultSet.getDate("FECHARECCONADM"));
			controlFechas.setFechaResRecConAdm(resultSet.getDate("FECHARESRECCONADM"));
			controlFechas.setFechaSancionFirme(resultSet.getDate("FECHASANCIONFIRME"));

			controlFechas.setFechaRecursoPotestativoReposicion(resultSet.getDate("FECHARECPOTREP"));
			controlFechas.setFechaResolucionRecursoPotestativoReposicion(resultSet.getDate("FECHARESRECPOTREP"));

			return controlFechas;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Finds a single row in the ControlFechas table.
	 *
	 * @param idSancion
	 *            Integer
	 * @return ControlFechas
	 */
	public ControlFechas find(Integer idSancion) {

		StringBuilder query = new StringBuilder();
		List<Object> params = new ArrayList<Object>();

		query.append("SELECT t01.ID_SANCION IDSANCION");
		query.append(", FECHA_RESOLUCION_INCOACION.FECHARESOLUCIONINCOACION");
		query.append(", FECHA_ACUSE_ELEC_RES_INC.FECHAACUSEELECRESINC");
		query.append(", FECHA_ACUSE_POSTAL_RES_INC.FECHAACUSEPOSTALRESINC");
		query.append(", FECHA_PRES_ALEGACIONES_RES_INC.FECHAPRESALEGACIONESRESINC");
		query.append(", t01.APE_PER_PRO_RES_INC APEPERPRORESINC");
		query.append(", FECHA_PROPUESTA_RESOLUCION.FECHAPROPUESTARESOLUCION");
		query.append(", FECHA_ACUSE_ELEC_PRO_RES.FECHAACUSEELECPRORES");
		query.append(", FECHA_ACUSE_POSTAL_PRO_RES.FECHAACUSEPOSTALPRORES");
		query.append(", FECHA_PRES_ALEGACIONES_PRO_RES.FECHAPRESALEGACIONESPRORES");
		query.append(", FECHA_RESOLUCION.FECHARESOLUCION");
		query.append(", FECHA_ACUSE_RESOLUCION.FECHAACUSERESOLUCION");
		query.append(", FECHA_RECURSO_ALZADA.FECHARECURSOALZADA");
		query.append(", FECHA_RES_RECURSO_ALZADA.FECHARESRECURSOALZADA");
		query.append(", FECHA_ACUSE_ELEC_RES_REC_ALZ.FECHAACUSEELECRESRECALZ");
		query.append(", FECHA_ACUSE_POSTAL_RES_REC_ALZ.FECHAACUSEPOSTALRESRECALZ");
		query.append(", t01.FECHA_REC_CON_ADM FECHARECCONADM");
		query.append(", t01.FECHA_RES_REC_CON_ADM FECHARESRECCONADM");
		query.append(", t01.FECHA_SANCION_FIRME FECHASANCIONFIRME");
		query.append(", t01.FECHA_REC_POT_REP FECHARECPOTREP");
		query.append(", t01.FECHA_RES_REC_POT_REP FECHARESRECPOTREP");

		query.append(" FROM SANCIONES t01");
		query.append(" LEFT OUTER JOIN (");
		query.append(" SELECT t6142.ID_EXPEDIENTE, t6142.FECHA_EXPEDIENTE FECHARESOLUCIONINCOACION");
		query.append(" FROM   REL_EXP_FECH t6142");
		query.append(" INNER JOIN FECHAS_EXPEDIENTE t6144 ON t6142.ID_FECHA_EXPEDIENTE = t6144.ID_FECHA_EXPEDIENTE");
		query.append(" AND t6144.ETIQUETA_FECHA     = '" + Constantes.FECHA_RESOLUCION_INCOACION + "'");
		query.append(" ORDER BY FECHARESOLUCIONINCOACION DESC");
		query.append(" ) FECHA_RESOLUCION_INCOACION ON t01.ID_EXPEDIENTE = FECHA_RESOLUCION_INCOACION.ID_EXPEDIENTE");
		query.append(" LEFT OUTER JOIN (");
		query.append(" SELECT t6142.ID_EXPEDIENTE, t6142.FECHA_EXPEDIENTE FECHAACUSEELECRESINC");
		query.append(" FROM   REL_EXP_FECH t6142");
		query.append(" INNER JOIN FECHAS_EXPEDIENTE t6144 ON t6142.ID_FECHA_EXPEDIENTE = t6144.ID_FECHA_EXPEDIENTE");
		query.append(" AND t6144.ETIQUETA_FECHA     = '" + Constantes.FECHA_ACUSE_ELEC_RES_INC + "'");
		query.append(" ORDER BY FECHAACUSEELECRESINC DESC");
		query.append(" ) FECHA_ACUSE_ELEC_RES_INC ON t01.ID_EXPEDIENTE = FECHA_ACUSE_ELEC_RES_INC.ID_EXPEDIENTE");
		query.append(" LEFT OUTER JOIN (");
		query.append(" SELECT t6142.ID_EXPEDIENTE, t6142.FECHA_EXPEDIENTE FECHAACUSEPOSTALRESINC");
		query.append(" FROM   REL_EXP_FECH t6142");
		query.append(" INNER JOIN FECHAS_EXPEDIENTE t6144 ON t6142.ID_FECHA_EXPEDIENTE = t6144.ID_FECHA_EXPEDIENTE");
		query.append(" AND t6144.ETIQUETA_FECHA     = '" + Constantes.FECHA_ACUSE_POSTAL_RES_INC + "'");
		query.append(" ORDER BY FECHAACUSEPOSTALRESINC DESC");
		query.append(" ) FECHA_ACUSE_POSTAL_RES_INC ON t01.ID_EXPEDIENTE = FECHA_ACUSE_POSTAL_RES_INC.ID_EXPEDIENTE");
		query.append(" LEFT OUTER JOIN (");
		query.append(" SELECT t6142.ID_EXPEDIENTE, t6142.FECHA_EXPEDIENTE FECHAPRESALEGACIONESRESINC");
		query.append(" FROM   REL_EXP_FECH t6142");
		query.append(" INNER JOIN FECHAS_EXPEDIENTE t6144 ON t6142.ID_FECHA_EXPEDIENTE = t6144.ID_FECHA_EXPEDIENTE");
		query.append(" AND t6144.ETIQUETA_FECHA     = '" + Constantes.FECHA_PRES_ALEGACIONES_RES_INC + "'");
		query.append(" ORDER BY FECHAPRESALEGACIONESRESINC DESC");
		query.append(
				" ) FECHA_PRES_ALEGACIONES_RES_INC ON t01.ID_EXPEDIENTE = FECHA_PRES_ALEGACIONES_RES_INC.ID_EXPEDIENTE");
		query.append(" LEFT OUTER JOIN (");
		query.append(" SELECT t6142.ID_EXPEDIENTE, t6142.FECHA_EXPEDIENTE FECHAPROPUESTARESOLUCION");
		query.append(" FROM   REL_EXP_FECH t6142");
		query.append(" INNER JOIN FECHAS_EXPEDIENTE t6144 ON t6142.ID_FECHA_EXPEDIENTE = t6144.ID_FECHA_EXPEDIENTE");
		query.append(" AND t6144.ETIQUETA_FECHA     = '" + Constantes.FECHA_PROPUESTA_RESOLUCION + "'");
		query.append(" ORDER BY FECHAPROPUESTARESOLUCION DESC");
		query.append(" ) FECHA_PROPUESTA_RESOLUCION ON t01.ID_EXPEDIENTE = FECHA_PROPUESTA_RESOLUCION.ID_EXPEDIENTE");
		query.append(" LEFT OUTER JOIN (");
		query.append(" SELECT t6142.ID_EXPEDIENTE, t6142.FECHA_EXPEDIENTE FECHAACUSEELECPRORES");
		query.append(" FROM   REL_EXP_FECH t6142");
		query.append(" INNER JOIN FECHAS_EXPEDIENTE t6144 ON t6142.ID_FECHA_EXPEDIENTE = t6144.ID_FECHA_EXPEDIENTE");
		query.append(" AND t6144.ETIQUETA_FECHA     = '" + Constantes.FECHA_ACUSE_ELEC_PRO_RES + "'");
		query.append(" ORDER BY FECHAACUSEELECPRORES DESC");
		query.append(" ) FECHA_ACUSE_ELEC_PRO_RES ON t01.ID_EXPEDIENTE = FECHA_ACUSE_ELEC_PRO_RES.ID_EXPEDIENTE");
		query.append(" LEFT OUTER JOIN (");
		query.append(" SELECT t6142.ID_EXPEDIENTE, t6142.FECHA_EXPEDIENTE FECHAACUSEPOSTALPRORES");
		query.append(" FROM   REL_EXP_FECH t6142");
		query.append(" INNER JOIN FECHAS_EXPEDIENTE t6144 ON t6142.ID_FECHA_EXPEDIENTE = t6144.ID_FECHA_EXPEDIENTE");
		query.append(" AND t6144.ETIQUETA_FECHA     = '" + Constantes.FECHA_ACUSE_POSTAL_PRO_RES + "'");
		query.append(" ORDER BY FECHAACUSEPOSTALPRORES DESC");
		query.append(" ) FECHA_ACUSE_POSTAL_PRO_RES ON t01.ID_EXPEDIENTE = FECHA_ACUSE_POSTAL_PRO_RES.ID_EXPEDIENTE");
		query.append(" LEFT OUTER JOIN (");
		query.append(" SELECT t6142.ID_EXPEDIENTE, t6142.FECHA_EXPEDIENTE FECHAPRESALEGACIONESPRORES");
		query.append(" FROM   REL_EXP_FECH t6142");
		query.append(" INNER JOIN FECHAS_EXPEDIENTE t6144 ON t6142.ID_FECHA_EXPEDIENTE = t6144.ID_FECHA_EXPEDIENTE");
		query.append(" AND t6144.ETIQUETA_FECHA     = '" + Constantes.FECHA_PRES_ALEGACIONES_PRO_RES + "'");
		query.append(" ORDER BY FECHAPRESALEGACIONESPRORES DESC");
		query.append(
				" ) FECHA_PRES_ALEGACIONES_PRO_RES ON t01.ID_EXPEDIENTE = FECHA_PRES_ALEGACIONES_PRO_RES.ID_EXPEDIENTE");
		query.append(" LEFT OUTER JOIN (");
		query.append(" SELECT t6142.ID_EXPEDIENTE, t6142.FECHA_EXPEDIENTE FECHARESOLUCION");
		query.append(" FROM   REL_EXP_FECH t6142");
		query.append(" INNER JOIN FECHAS_EXPEDIENTE t6144 ON t6142.ID_FECHA_EXPEDIENTE = t6144.ID_FECHA_EXPEDIENTE");
		query.append(" AND t6144.ETIQUETA_FECHA     = '" + Constantes.FECHA_RESOLUCION + "'");
		query.append(" ORDER BY FECHARESOLUCION DESC");
		query.append(" ) FECHA_RESOLUCION ON t01.ID_EXPEDIENTE = FECHA_RESOLUCION.ID_EXPEDIENTE");
		query.append(" LEFT OUTER JOIN (");
		query.append(" SELECT t6142.ID_EXPEDIENTE, t6142.FECHA_EXPEDIENTE FECHAACUSERESOLUCION");
		query.append(" FROM   REL_EXP_FECH t6142");
		query.append(" INNER JOIN FECHAS_EXPEDIENTE t6144 ON t6142.ID_FECHA_EXPEDIENTE = t6144.ID_FECHA_EXPEDIENTE");
		query.append(" AND t6144.ETIQUETA_FECHA     = '" + Constantes.FECHA_ACUSE_RESOLUCION + "'");
		query.append(" ORDER BY FECHAACUSERESOLUCION DESC");
		query.append(" ) FECHA_ACUSE_RESOLUCION ON t01.ID_EXPEDIENTE = FECHA_ACUSE_RESOLUCION.ID_EXPEDIENTE");
		query.append(" LEFT OUTER JOIN (");
		query.append(" SELECT t6142.ID_EXPEDIENTE, t6142.FECHA_EXPEDIENTE FECHARECURSOALZADA");
		query.append(" FROM   REL_EXP_FECH t6142");
		query.append(" INNER JOIN FECHAS_EXPEDIENTE t6144 ON t6142.ID_FECHA_EXPEDIENTE = t6144.ID_FECHA_EXPEDIENTE");
		query.append(" AND t6144.ETIQUETA_FECHA     = '" + Constantes.FECHA_RECURSO_ALZADA + "'");
		query.append(" ORDER BY FECHARECURSOALZADA DESC");
		query.append(" ) FECHA_RECURSO_ALZADA ON t01.ID_EXPEDIENTE = FECHA_RECURSO_ALZADA.ID_EXPEDIENTE");
		query.append(" LEFT OUTER JOIN (");
		query.append(" SELECT t6142.ID_EXPEDIENTE, t6142.FECHA_EXPEDIENTE FECHARESRECURSOALZADA");
		query.append(" FROM   REL_EXP_FECH t6142");
		query.append(" INNER JOIN FECHAS_EXPEDIENTE t6144 ON t6142.ID_FECHA_EXPEDIENTE = t6144.ID_FECHA_EXPEDIENTE");
		query.append(" AND t6144.ETIQUETA_FECHA     = '" + Constantes.FECHA_RES_RECURSO_ALZADA + "'");
		query.append(" ORDER BY FECHARESRECURSOALZADA DESC");
		query.append(" ) FECHA_RES_RECURSO_ALZADA ON t01.ID_EXPEDIENTE = FECHA_RES_RECURSO_ALZADA.ID_EXPEDIENTE");
		query.append(" LEFT OUTER JOIN (");
		query.append(" SELECT t6142.ID_EXPEDIENTE, t6142.FECHA_EXPEDIENTE FECHAACUSEELECRESRECALZ");
		query.append(" FROM   REL_EXP_FECH t6142");
		query.append(" INNER JOIN FECHAS_EXPEDIENTE t6144 ON t6142.ID_FECHA_EXPEDIENTE = t6144.ID_FECHA_EXPEDIENTE");
		query.append(" AND t6144.ETIQUETA_FECHA     = '" + Constantes.FECHA_ACUSE_ELEC_RES_REC_ALZ + "'");
		query.append(" ORDER BY FECHAACUSEELECRESRECALZ DESC");
		query.append(
				" ) FECHA_ACUSE_ELEC_RES_REC_ALZ ON t01.ID_EXPEDIENTE = FECHA_ACUSE_ELEC_RES_REC_ALZ.ID_EXPEDIENTE");
		query.append(" LEFT OUTER JOIN (");
		query.append(" SELECT t6142.ID_EXPEDIENTE, t6142.FECHA_EXPEDIENTE FECHAACUSEPOSTALRESRECALZ");
		query.append(" FROM   REL_EXP_FECH t6142");
		query.append(" INNER JOIN FECHAS_EXPEDIENTE t6144 ON t6142.ID_FECHA_EXPEDIENTE = t6144.ID_FECHA_EXPEDIENTE");
		query.append(" AND t6144.ETIQUETA_FECHA     = '" + Constantes.FECHA_ACUSE_POSTAL_RES_REC_ALZ + "'");
		query.append(" ORDER BY FECHAACUSEPOSTALRESRECALZ DESC");
		query.append(
				" ) FECHA_ACUSE_POSTAL_RES_REC_ALZ ON t01.ID_EXPEDIENTE = FECHA_ACUSE_POSTAL_RES_REC_ALZ.ID_EXPEDIENTE");

		query.append(" WHERE t01.ID_SANCION = ?");
		query.append(" AND ROWNUM = 1");
		params.add(idSancion);

		List<ControlFechas> controlFechasList = this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
		return DataAccessUtils.uniqueResult(controlFechasList);
	}

	/**
	 * Updates a single row in the ControlFechas table.
	 *
	 * @param controlFechas
	 *            ControlFechas
	 * @return ControlFechas
	 */
	public ControlFechas update(ControlFechas controlFechas) {

		StringBuilder query = new StringBuilder();

		query.append("UPDATE SANCIONES SET");
		query.append(" APE_PER_PRO_RES_INC = ?");
		query.append(", FECHA_REC_CON_ADM = ?");
		query.append(", FECHA_RES_REC_CON_ADM = ?, FECHA_SANCION_FIRME = ?");
		query.append(", FECHA_ULTMODIFICACION = ?, USUARIO_ULTMODIFICACION = ?");
		query.append(", FECHA_REC_POT_REP = ?, FECHA_RES_REC_POT_REP = ?");
		query.append(" WHERE ID_SANCION = ?");

		this.jdbcTemplate.update(query.toString(), controlFechas.getApePerProResInc(), controlFechas.getFechaRecConAdm(), controlFechas.getFechaResRecConAdm(),
				controlFechas.getFechaSancionFirme(), controlFechas.getFechaUltmodificacion(),
				controlFechas.getUsuarioUltmodificacion(), controlFechas.getFechaRecursoPotestativoReposicion(),
				controlFechas.getFechaResolucionRecursoPotestativoReposicion(), controlFechas.getIdSancion());

		return controlFechas;
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

}
