package com.ejie.ab59.dao.propuestasSancion;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.model.propuestasSancion.RelProSanSan;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class RelProSanSanDaoImpl implements RelProSanSanDao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the RelProSanSan table.
	 *
	 * @param relProSanSan
	 *            RelProSanSan
	 * 
	 * @return RelProSanSan
	 */
	public RelProSanSan add(RelProSanSan relProSanSan) {
		String query = "INSERT INTO REL_PRO_SAN_SAN (ID_REL_PRO_SAN_SAN, IDENTIFICADOR_INSPECCION, ID_PROPUESTA_SANCION, ID_ESTADO_PRO_SAN, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (?,?,?,?,SYSDATE,?)";

		relProSanSan.setIdRelProSanSan(
				this.jdbcTemplate.queryForObject("SELECT AB61.S_AB6128T00.NEXTVAL FROM DUAL", Integer.class));

		Object getPropuestaSancion = null;
		if (relProSanSan.getPropuestaSancion() != null
				&& relProSanSan.getPropuestaSancion().getIdPropuestaSancion() != null) {
			getPropuestaSancion = relProSanSan.getPropuestaSancion().getIdPropuestaSancion();
		}

		this.jdbcTemplate.update(query, relProSanSan.getIdRelProSanSan(), relProSanSan.getIdentificadorInspeccion(),
				getPropuestaSancion, relProSanSan.getEstado(), relProSanSan.getUsuarioRegistro());

		return relProSanSan;
	}

	/**
	 * Updates a single row in the RelProSanSan table.
	 *
	 * @param relProSanSan
	 *            RelProSanSan
	 * 
	 * @return RelProSanSan
	 */
	public RelProSanSan updateByPropuestaSancion(RelProSanSan relProSanSan) {

		String query = "UPDATE REL_PRO_SAN_SAN SET ID_ESTADO_PRO_SAN = ?, FECHA_ULTMODIFICACION = SYSDATE, USUARIO_ULTMODIFICACION = ? WHERE ID_PROPUESTA_SANCION = ?";

		Object getPropuestaSancion = null;
		if (relProSanSan.getPropuestaSancion() != null
				&& relProSanSan.getPropuestaSancion().getIdPropuestaSancion() != null) {
			getPropuestaSancion = relProSanSan.getPropuestaSancion().getIdPropuestaSancion();
		}

		this.jdbcTemplate.update(query, relProSanSan.getEstado(), relProSanSan.getUsuarioUltModificacion(),
				getPropuestaSancion);

		return relProSanSan;
	}

	/**
	 * Removes a single row in the RelProSanSan table.
	 *
	 * @param idPropuestaSancion
	 *            Integer
	 * 
	 */
	public void removeByPropuestaSancion(Integer idPropuestaSancion) {

		String query = "DELETE FROM REL_PRO_SAN_SAN WHERE ID_PROPUESTA_SANCION = ?";

		this.jdbcTemplate.update(query, idPropuestaSancion);
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
