package com.ejie.ab59.dao.propuestasSancion;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.model.propuestasSancion.RelProSanFec;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

@Repository
@Transactional
public class RelProSanFecDaoImpl implements RelProSanFecDao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<RelProSanFec> rwMap = new RowMapper<RelProSanFec>() {
		public RelProSanFec mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			RelProSanFec relProSanFec = new RelProSanFec();
			relProSanFec.setIdRelProSanFec(resultSet.getInt("IDRELPROSANFEC"));
			relProSanFec.setFechaProSan(resultSet.getDate("FECHAPROSAN"));
			relProSanFec.setTipoFecha(resultSet.getInt("TIPOFECHA"));

			return relProSanFec;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the RelProSanFec table.
	 *
	 * @param relProSanFec
	 *            RelProSanFec
	 * 
	 * @return RelProSanFec
	 */
	@Override
	public RelProSanFec add(RelProSanFec relProSanFec) {
		String query = "INSERT INTO REL_PRO_SAN_FEC (ID_REL_PRO_SAN_FEC, ID_PROPUESTA_SANCION, FECHA_PRO_SAN, TIPO_FECHA, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (?,?,sysdate,?,sysdate,?)";

		relProSanFec.setIdRelProSanFec(
				this.jdbcTemplate.queryForObject("SELECT AB59.S_AB5919T00.NEXTVAL FROM DUAL", Integer.class));

		this.jdbcTemplate.update(query, relProSanFec.getIdRelProSanFec(), relProSanFec.getIdPropuestaSancion(),
				relProSanFec.getTipoFecha(), relProSanFec.getUsuarioRegistro());

		return relProSanFec;
	}

	@Override
	public List<RelProSanFec> findAllLike(RelProSanFec filterRelProSanFec, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder();

		query.append(
				"SELECT t19.ID_REL_PRO_SAN_FEC IDRELPROSANFEC, t19.FECHA_PRO_SAN FECHAPROSAN, t19.TIPO_FECHA TIPOFECHA");
		query.append(" FROM REL_PRO_SAN_FEC t19");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterRelProSanFec);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	@Override
	public Long findAllLikeCount(RelProSanFec relProSanFec) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1)");
		query.append(" FROM REL_PRO_SAN_FEC t19");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(relProSanFec);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	@Override
	public void removeByPropuestaSancion(Integer idPropuestaSancion) {
		String query = "DELETE FROM REL_PRO_SAN_FEC WHERE ID_PROPUESTA_SANCION = ?";
		this.jdbcTemplate.update(query, idPropuestaSancion);
	}

	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(RelProSanFec relProSanFec) {

		StringBuilder where = new StringBuilder(PropuestasSancionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		/* idSancion */
		if (relProSanFec != null && relProSanFec.getIdPropuestaSancion() != null) {
			where.append(" AND t19.ID_PROPUESTA_SANCION = ?");
			params.add(relProSanFec.getIdPropuestaSancion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

}
