package com.ejie.ab59.dao.propuestasSancion;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.model.propuestasSancion.RelArtInfProSan;
import com.ejie.ab59.model.propuestasSancion.RelArtInfProSanDer;
import com.ejie.ab59.model.tablasMaestras.Calificaciones;
import com.ejie.ab59.model.tablasMaestras.Derechos;
import com.ejie.ab59.model.tablasMaestras.Infracciones;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class RelArtInfProSanDerDaoImpl implements RelArtInfProSanDerDao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<RelArtInfProSanDer> rwMapAll = new RowMapper<RelArtInfProSanDer>() {
		@Override
		public RelArtInfProSanDer mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			RelArtInfProSanDer relArtInfProSanDer = new RelArtInfProSanDer();

			RelArtInfProSan relArtInfProSanAux = new RelArtInfProSan();
			relArtInfProSanAux.setFechaHecho(resultSet.getDate("FECHAHECHO"));
			relArtInfProSanAux.setDescripcionHecho(resultSet.getString("DESCRIPCIONHECHO"));
			Infracciones infraccionAux = new Infracciones();
			infraccionAux.setIdInfraccion(resultSet.getInt("IDINFRACCION"));
			Calificaciones calificacionAux = new Calificaciones();
			calificacionAux.setPlazo(resultSet.getLong("PLAZO"));
			calificacionAux.setImporte(resultSet.getBigDecimal("IMPORTE"));
			infraccionAux.setCalificaciones(calificacionAux);
			relArtInfProSanAux.setInfraccion(infraccionAux);
			relArtInfProSanDer.setRelArtInfProSan(relArtInfProSanAux);

			Derechos derechoAux = new Derechos();
			derechoAux.setIdDerecho(resultSet.getInt("IDDERECHO"));
			relArtInfProSanDer.setDerecho(derechoAux);

			return relArtInfProSanDer;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the RelArtInfProSanDer table.
	 *
	 * @param derechoInfringido
	 *            RelArtInfProSanDer
	 * @return RelArtInfProSanDer
	 */
	@Override
	public RelArtInfProSanDer add(RelArtInfProSanDer derechoInfringido) {
		String query = "INSERT INTO REL_ART_INF_PRO_SAN_DER (ID_REL_ART_INF_PRO_SAN_DER, ID_REL_ART_INF_PRO_SAN, ID_DERECHO, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (?,?,?,?,?)";

		derechoInfringido.setIdRelArtInfProSanDer(
				this.jdbcTemplate.queryForObject("SELECT AB59.S_AB5916T00.NEXTVAL FROM DUAL", Integer.class));

		Object getArticuloInfringido = null;
		if (derechoInfringido.getRelArtInfProSan() != null
				&& derechoInfringido.getRelArtInfProSan().getIdRelArtInfProSan() != null) {
			getArticuloInfringido = derechoInfringido.getRelArtInfProSan().getIdRelArtInfProSan();
		}
		Object getDerecho = null;
		if (derechoInfringido.getDerecho() != null && derechoInfringido.getDerecho().getIdDerecho() != null) {
			getDerecho = derechoInfringido.getDerecho().getIdDerecho();
		}

		this.jdbcTemplate.update(query, derechoInfringido.getIdRelArtInfProSanDer(), getArticuloInfringido, getDerecho,
				derechoInfringido.getFechaRegistro(), derechoInfringido.getUsuarioRegistro());

		return derechoInfringido;
	}

	/**
	 * Finds a list of rows in the RelArtInfProSanDer table.
	 *
	 * @param idSancion
	 *            Integer
	 * 
	 * @return List<RelArtInfProSanDer>
	 */
	@Override
	@Transactional(readOnly = true)
	public List<RelArtInfProSanDer> findAll(Integer idSancion) {

		StringBuilder query = new StringBuilder();
		List<Object> params = new ArrayList<Object>();

		query.append("SELECT t16.ID_DERECHO IDDERECHO, t10.ID_INFRACCION IDINFRACCION");
		query.append(", t10.FECHA_HECHO FECHAHECHO, t10.DESCRIPCION_HECHO DESCRIPCIONHECHO");
		query.append(", t04.PLAZO PLAZO, t04.IMPORTE");
		query.append(" FROM REL_ART_INF_PRO_SAN_DER t16");
		query.append(" INNER JOIN REL_ART_INF_PRO_SAN t10 ON t16.ID_REL_ART_INF_PRO_SAN = t10.ID_REL_ART_INF_PRO_SAN");
		query.append(" INNER JOIN INFRACCIONES t09 ON t10.ID_INFRACCION = t09.ID_INFRACCION");
		query.append(" INNER JOIN CALIFICACIONES t04 ON t09.ID_CALIFICACION = t04.ID_CALIFICACION");
		query.append(" WHERE t10.ID_PROPUESTA_SANCION = ?");
		params.add(idSancion);
		query.append(" ORDER BY IDINFRACCION");

		return this.jdbcTemplate.query(query.toString(), this.rwMapAll, params.toArray());
	}

	/**
	 * Removes a single row in the RelArtInfProSanDer table.
	 *
	 * @param idPropuestaSancion
	 *            Integer
	 * 
	 * @return
	 */
	@Override
	public void removeByPropuestaSancion(Integer idPropuestaSancion) {

		String query = "DELETE FROM REL_ART_INF_PRO_SAN_DER WHERE ID_REL_ART_INF_PRO_SAN IN (SELECT ID_REL_ART_INF_PRO_SAN FROM REL_ART_INF_PRO_SAN WHERE ID_PROPUESTA_SANCION = ?)";
		this.jdbcTemplate.update(query, idPropuestaSancion);
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
