package com.ejie.ab59.dao.propuestasSancion;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.model.propuestasSancion.PropuestasSancion;
import com.ejie.ab59.model.propuestasSancion.RelArtInfProSan;
import com.ejie.ab59.model.tablasMaestras.Infracciones;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * ArtInfProSanDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class RelArtInfProSanDaoImpl implements RelArtInfProSanDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDRELARTINFPROSAN", "IDINFRACCION",
			"IDPROPUESTASANCION", "NOTASARTICULO", "FECHAREGISTRO", "USUARIOREGISTRO", "FECHAPROPUESTAOT",
			"FECHAVALIDACION", "FECHARECHAZO", "FECHAREQUERIMIENTO" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<RelArtInfProSan> rwMap = new RowMapper<RelArtInfProSan>() {
		public RelArtInfProSan mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new RelArtInfProSan(resultSet.getInt("ID_REL_ART_INF_PRO_SAN"),
					new Infracciones(resultSet.getInt("ID_INFRACCION")),
					new PropuestasSancion(resultSet.getInt("ID_PROPUESTA_SANCION")),
					resultSet.getString("NOTAS_ARTICULO"), resultSet.getString("USUARIO_REGISTRO"));
		}
	};

	private RowMapper<RelArtInfProSan> rwMapAllControlFechas = new RowMapper<RelArtInfProSan>() {
		public RelArtInfProSan mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			RelArtInfProSan relArtInfProSan = new RelArtInfProSan();
			relArtInfProSan.setFechaHecho(resultSet.getDate("FECHAINFRACCION"));
			relArtInfProSan.setFechaPrescripcion(resultSet.getDate("FECHAPRESCRIPCION"));

			PropuestasSancion propuestaSancionAux = new PropuestasSancion();
			propuestaSancionAux.setIdPropuestaSancion(resultSet.getInt("IDPROPUESTASANCION"));
			propuestaSancionAux.setIdentificadorInspeccion(resultSet.getString("IDENTIFICADORINSPECCION"));
			propuestaSancionAux.setFechaPropuestaOT(resultSet.getDate("FECHAPROPUESTAOT"));
			propuestaSancionAux.setFechaValidacion(resultSet.getDate("FECHAVALIDACION"));
			propuestaSancionAux.setFechaRechazo(resultSet.getDate("FECHARECHAZO"));
			propuestaSancionAux.setFechaRequerimiento(resultSet.getDate("FECHAREQUERIMIENTO"));
			relArtInfProSan.setPropuestaSancion(propuestaSancionAux);

			return relArtInfProSan;
		}
	};

	private RowMapper<RelArtInfProSan> rwMapFechaHecho = new RowMapper<RelArtInfProSan>() {
		public RelArtInfProSan mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			RelArtInfProSan relArtInfProSan = new RelArtInfProSan();
			relArtInfProSan.setIdRelArtInfProSan(resultSet.getInt("IDRELARTINFPROSAN"));
			relArtInfProSan.setFechaHecho(resultSet.getDate("FECHAHECHO"));

			return relArtInfProSan;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the ArtInfProSan table.
	 *
	 * @param artinfprosan
	 *            ArtInfProSan
	 * @return ArtInfProSan
	 */
	public RelArtInfProSan add(RelArtInfProSan artinfprosan) {
		String query = "INSERT INTO REL_ART_INF_PRO_SAN (ID_REL_ART_INF_PRO_SAN, ID_INFRACCION, ID_PROPUESTA_SANCION, FECHA_HECHO, DESCRIPCION_HECHO, NOTAS_ARTICULO, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (?,?,?,?,?,?,SYSDATE,?)";

		artinfprosan.setIdRelArtInfProSan(
				this.jdbcTemplate.queryForObject("SELECT AB59.S_AB5902T00.NEXTVAL FROM DUAL", Integer.class));

		Object getInfraccion = null;
		if (artinfprosan.getInfraccion() != null && artinfprosan.getInfraccion().getIdInfraccion() != null) {
			getInfraccion = artinfprosan.getInfraccion().getIdInfraccion();
		}
		Object getPropuestaSancion = null;
		if (artinfprosan.getPropuestaSancion() != null
				&& artinfprosan.getPropuestaSancion().getIdPropuestaSancion() != null) {
			getPropuestaSancion = artinfprosan.getPropuestaSancion().getIdPropuestaSancion();
		}

		this.jdbcTemplate.update(query, artinfprosan.getIdRelArtInfProSan(), getInfraccion, getPropuestaSancion,
				artinfprosan.getFechaHecho(), artinfprosan.getDescripcionHecho(), artinfprosan.getNotasArticulo(),
				artinfprosan.getUsuarioRegistro());

		return artinfprosan;
	}

	/**
	 * Updates a single row in the ArtInfProSan table.
	 *
	 * @param artinfprosan
	 *            ArtInfProSan
	 * @return ArtInfProSan
	 */
	public RelArtInfProSan update(RelArtInfProSan artinfprosan) {
		String query = "UPDATE REL_ART_INF_PRO_SAN SET ID_INFRACCION=?, ID_PROPUESTA_SANCION=?, NOTAS_ARTICULO=?, FECHA_REGISTRO=SYSDATE, USUARIO_REGISTRO=? WHERE ID_REL_ART_INF_PRO_SAN=?";
		this.jdbcTemplate.update(query, artinfprosan.getInfraccion(), artinfprosan.getPropuestaSancion(),
				artinfprosan.getNotasArticulo(), artinfprosan.getUsuarioRegistro(),
				artinfprosan.getIdRelArtInfProSan());
		return artinfprosan;
	}

	/**
	 * Finds a single row in the ArtInfProSan table.
	 *
	 * @param artinfprosan
	 *            ArtInfProSan
	 * @return ArtInfProSan
	 */
	@Transactional(readOnly = true)
	public RelArtInfProSan find(RelArtInfProSan artinfprosan) {
		String query = "SELECT t1.ID_REL_ART_INF_PRO_SAN IDRELARTINFPROSAN, t1.ID_INFRACCION IDINFRACCION, t1.ID_PROPUESTA_SANCION IDPROPUESTASANCION, t1.NOTAS_ARTICULO NOTASARTICULO, t1.FECHA_REGISTRO FECHAREGISTRO, t1.USUARIO_REGISTRO USUARIOREGISTRO FROM ID_REL_ART_INF_PRO_SAN t1  WHERE t1.ID_REL_ART_INF_PRO_SAN = ?  ";

		List<RelArtInfProSan> artinfprosanList = this.jdbcTemplate.query(query, this.rwMap,
				artinfprosan.getIdRelArtInfProSan());
		return (RelArtInfProSan) DataAccessUtils.uniqueResult(artinfprosanList);
	}

	/**
	 * Removes a single row in the ArtInfProSan table.
	 *
	 * @param artinfprosan
	 *            ArtInfProSan
	 * @return
	 */
	public void remove(RelArtInfProSan artinfprosan) {
		String query = "DELETE FROM ID_REL_ART_INF_PRO_SAN WHERE ID_REL_ART_INF_PRO_SAN=?";
		this.jdbcTemplate.update(query, artinfprosan.getIdRelArtInfProSan());
	}

	/**
	 * Finds a list of rows in the ArtInfProSan table.
	 *
	 * @param artinfprosan
	 *            ArtInfProSan
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<ArtInfProSan>
	 */
	@Transactional(readOnly = true)
	public List<RelArtInfProSan> findAll(RelArtInfProSan artinfprosan, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_REL_ART_INF_PRO_SAN IDRELARTINFPROSAN,t1.ID_INFRACCION IDINFRACCION,t1.ID_PROPUESTA_SANCION IDPROPUESTASANCION,t1.NOTAS_ARTICULO NOTASARTICULO,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		query.append("FROM ID_REL_ART_INF_PRO_SAN t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(artinfprosan);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, RelArtInfProSanDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<RelArtInfProSan>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the ArtInfProSan table.
	 *
	 * @param artinfprosan
	 *            ArtInfProSan
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(RelArtInfProSan artinfprosan) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ID_REL_ART_INF_PRO_SAN t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(artinfprosan);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the ArtInfProSan entity
	 *
	 * @param artinfprosan
	 *            ArtInfProSan Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(RelArtInfProSan artinfprosan) {

		StringBuilder where = new StringBuilder(RelArtInfProSanDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (artinfprosan != null && artinfprosan.getIdRelArtInfProSan() != null) {
			where.append(" AND t1.ID_REL_ART_INF_PRO_SAN = ?");
			params.add(artinfprosan.getIdRelArtInfProSan());
		}
		if (artinfprosan != null && artinfprosan.getInfraccion() != null) {
			where.append(" AND t1.ID_INFRACCION = ?");
			params.add(artinfprosan.getInfraccion());
		}
		if (artinfprosan != null && artinfprosan.getPropuestaSancion() != null) {
			where.append(" AND t1.ID_PROPUESTA_SANCION = ?");
			params.add(artinfprosan.getPropuestaSancion());
		}
		if (artinfprosan != null && artinfprosan.getNotasArticulo() != null) {
			where.append(" AND t1.NOTAS_ARTICULO = ?");
			params.add(artinfprosan.getNotasArticulo());
		}
		if (artinfprosan != null && artinfprosan.getUsuarioRegistro() != null) {
			where.append(" AND t1.USUARIO_REGISTRO = ?");
			params.add(artinfprosan.getUsuarioRegistro());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Removes a single row in the ArtInfProSan table.
	 *
	 * @param idPropuestaSancion
	 *            Integer
	 * @return
	 */
	public void removeByPropuestaSancion(Integer idPropuestaSancion) {

		String query = "DELETE FROM REL_ART_INF_PRO_SAN WHERE ID_PROPUESTA_SANCION = ?";
		this.jdbcTemplate.update(query, idPropuestaSancion);

	}

	/**
	 * Finds a list of rows in the RelArtInfProSan table.
	 *
	 * @param relArtInfProSan
	 *            RelArtInfProSan
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<RelArtInfProSan>
	 */
	@Transactional(readOnly = true)
	public List<RelArtInfProSan> findControlFechas(RelArtInfProSan relArtInfProSan, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder();

		/*
		 * Se hace select distinct porque una propuesta puede tener varias
		 * infracciones
		 */
		query.append("SELECT DISTINCT t02.IDENTIFICADOR_INSPECCION IDENTIFICADORINSPECCION");
		query.append(
				", (SELECT MIN(t10.FECHA_HECHO) FROM REL_ART_INF_PRO_SAN t10 WHERE t02.ID_PROPUESTA_SANCION = t10.ID_PROPUESTA_SANCION) FECHAINFRACCION");
		query.append(
				", (SELECT MAX(ADD_MONTHS( t10.FECHA_HECHO, t04.PLAZO*12)) FROM REL_ART_INF_PRO_SAN t10, CALIFICACIONES t04, INFRACCIONES t09 WHERE t02.ID_PROPUESTA_SANCION = t10.ID_PROPUESTA_SANCION AND t10.ID_INFRACCION = t09.ID_INFRACCION AND t09.ID_CALIFICACION = t04.ID_CALIFICACION) FECHAPRESCRIPCION");
		query.append(
				", (SELECT MAX(t19.FECHA_PRO_SAN) FROM REL_PRO_SAN_FEC t19 WHERE t19.TIPO_FECHA = 1 AND t19.ID_PROPUESTA_SANCION = t02.ID_PROPUESTA_SANCION) FECHAPROPUESTAOT");
		query.append(
				", (SELECT MAX(t19.FECHA_PRO_SAN) FROM REL_PRO_SAN_FEC t19 WHERE t19.TIPO_FECHA = 2 AND t19.ID_PROPUESTA_SANCION = t02.ID_PROPUESTA_SANCION) FECHAVALIDACION");
		query.append(
				", (SELECT MAX(t19.FECHA_PRO_SAN) FROM REL_PRO_SAN_FEC t19 WHERE t19.TIPO_FECHA = 3 AND t19.ID_PROPUESTA_SANCION = t02.ID_PROPUESTA_SANCION) FECHARECHAZO");
		query.append(
				", (SELECT MAX(t19.FECHA_PRO_SAN) FROM REL_PRO_SAN_FEC t19 WHERE t19.TIPO_FECHA = 4 AND t19.ID_PROPUESTA_SANCION = t02.ID_PROPUESTA_SANCION) FECHAREQUERIMIENTO");
		query.append(", T02.ID_PROPUESTA_SANCION IDPROPUESTASANCION");
		query.append(" FROM PROPUESTAS_SANCION t02");
		query.append(" INNER JOIN REL_SAN_PRO_SAN t06 ON t02.ID_PROPUESTA_SANCION = t06.ID_PROPUESTA_SANCION");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapControlFechas(relArtInfProSan);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMapAllControlFechas, params.toArray());
	}

	/**
	 * Counts rows in the RelArtInfProSan table.
	 *
	 * @param relArtInfProSan
	 *            RelArtInfProSan
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findControlFechasCount(RelArtInfProSan relArtInfProSan) {

		StringBuilder query = new StringBuilder("SELECT DISTINCT COUNT(1)");
		query.append(" FROM PROPUESTAS_SANCION t02");
		query.append(" INNER JOIN REL_SAN_PRO_SAN t06 ON t02.ID_PROPUESTA_SANCION = t06.ID_PROPUESTA_SANCION");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapControlFechas(relArtInfProSan);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the PropuestasSancion entity
	 *
	 * @param relArtInfProSan
	 *            RelArtInfProSan Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMapControlFechas(RelArtInfProSan relArtInfProSan) {

		StringBuilder where = new StringBuilder(PropuestasSancionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		/* idSancion */
		if (relArtInfProSan != null && relArtInfProSan.getPropuestaSancion() != null
				&& relArtInfProSan.getPropuestaSancion().getIdSancionFind() != null) {
			where.append(" AND t06.ID_SANCION = ?");
			params.add(relArtInfProSan.getPropuestaSancion().getIdSancionFind());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	@Override
	public RelArtInfProSan findFechaHechoMasAntigua(PropuestasSancion propuestaSancion) {
		String query = "SELECT t5910.ID_REL_ART_INF_PRO_SAN IDRELARTINFPROSAN, t5910.FECHA_HECHO FECHAHECHO FROM REL_ART_INF_PRO_SAN t5910 WHERE t5910.ID_PROPUESTA_SANCION = ? ORDER BY t5910.FECHA_HECHO ASC";

		List<RelArtInfProSan> relArtInfProSanList = this.jdbcTemplate.query(query, this.rwMapFechaHecho,
				propuestaSancion.getIdPropuestaSancion());

		if (!relArtInfProSanList.isEmpty()) {
			return relArtInfProSanList.get(0);
		} else {
			return null;
		}
	}
}
