package com.ejie.ab59.dao.propuestasSancion;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.comun.SeguridadAplicacion;
import com.ejie.ab59.model.expedientes.DatosDirecciones;
import com.ejie.ab59.model.expedientes.Expedientes;
import com.ejie.ab59.model.procedimientos.Aplicaciones;
import com.ejie.ab59.model.procedimientos.Direcciones;
import com.ejie.ab59.model.procedimientos.Procedimientos;
import com.ejie.ab59.model.propuestasSancion.PropuestasSancion;
import com.ejie.ab59.model.sanciones.RelSanProSan;
import com.ejie.ab59.model.sanciones.Sanciones;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * PropuestasSancionDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class PropuestasSancionDaoImpl implements PropuestasSancionDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "FOLDERNUMBER", "TITULO",
			"UBICACIONESTABLECIMIENTO", "MUNICIPIO", "NOTASINTERNASRESP", "NUMEXPEDIENTESANCIONADOR" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<PropuestasSancion> rwMap = new RowMapper<PropuestasSancion>() {
		public PropuestasSancion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			PropuestasSancion propuestaSancion = new PropuestasSancion();
			propuestaSancion.setIdPropuestaSancion(resultSet.getInt("IDPROPUESTASANCION"));
			propuestaSancion.setNotasRespOfi(resultSet.getString("NOTASINTERNASRESP"));
			propuestaSancion.setNotas(resultSet.getString("NOTAS"));
			propuestaSancion.setEstado(resultSet.getInt("IDESTADOPROSAN"));
			propuestaSancion.setAsociadoSancion(resultSet.getInt("ASOCIADOSANCION"));
			propuestaSancion.setIdOrigenProSancion(resultSet.getInt("IDORIGENPROSANCION"));

			Expedientes expedienteAux = new Expedientes();
			expedienteAux.setIdExpediente(resultSet.getInt("IDEXPEDIENTE"));
			expedienteAux.setFolderNumber(resultSet.getString("FOLDERNUMBER"));
			expedienteAux.setTitulo(resultSet.getString("TITULO"));
			expedienteAux.setFolderId(resultSet.getString("FOLDERID"));

			Procedimientos procedimiento = new Procedimientos();
			procedimiento.setDirecciones(new Direcciones(resultSet.getInt("IDDIRECCION")));
			expedienteAux.setProcedimiento(procedimiento);

			DatosDirecciones datosDireccionAux = new DatosDirecciones();
			datosDireccionAux.setIdProvincia(resultSet.getInt("IDPROVINCIA"));
			datosDireccionAux.setDescripcionProvincia(resultSet.getString("PROVINCIA"));
			datosDireccionAux.setDescripcionMunicipio(resultSet.getString("MUNICIPIO"));
			datosDireccionAux.setDescripcionLocalidad(resultSet.getString("LOCALIDAD"));
			datosDireccionAux.setDireccion(resultSet.getString("DIRECCION"));
			datosDireccionAux.setNumero(resultSet.getString("NUMERO"));
			datosDireccionAux.setEscalera(resultSet.getString("ESCALERA"));
			datosDireccionAux.setPiso(resultSet.getString("PISO"));
			datosDireccionAux.setLetra(resultSet.getString("LETRA"));
			datosDireccionAux.setCodigoPostal(resultSet.getString("CODIGOPOSTAL"));
			datosDireccionAux.setEstablecimiento(resultSet.getString("ESTABLECIMIENTO"));
			datosDireccionAux.setIdentificadorEstablecimiento(resultSet.getString("IDENTESTABLECIMIENTO"));

			expedienteAux.setDatosDirecciones(datosDireccionAux);
			propuestaSancion.setExpedienteOrigen(expedienteAux);
			propuestaSancion.setDatosDirecciones(datosDireccionAux);

			return propuestaSancion;
		}
	};

	private RowMapper<PropuestasSancion> rwMapIdentificadorProSan = new RowMapper<PropuestasSancion>() {
		public PropuestasSancion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			PropuestasSancion propuestaSancion = new PropuestasSancion();
			propuestaSancion.setIdPropuestaSancion(resultSet.getInt("IDPROPUESTASANCION"));
			propuestaSancion.setIdentificadorProSan(resultSet.getString("IDENTIFICADORPROSAN"));

			return propuestaSancion;
		}
	};

	private RowMapper<Date> rwMapFechaAperturaMasActual = new RowMapper<Date>() {
		public Date mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return resultSet.getDate("FECHAAPERTURAACTUAL");
		}
	};

	private RowMapper<RelSanProSan> rwMapCabecera = new RowMapper<RelSanProSan>() {
		public RelSanProSan mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			RelSanProSan relSanProSan = new RelSanProSan();

			Sanciones sancion = new Sanciones();
			sancion.setIdSancion(resultSet.getInt("IDSANCION"));

			PropuestasSancion propuestaSancion = new PropuestasSancion();
			propuestaSancion.setIdPropuestaSancion(resultSet.getInt("IDPROPUESTASANCION"));
			propuestaSancion.setIdentificadorProSan(resultSet.getString("IDENTIFICADORPROSAN"));
			propuestaSancion.setEstado(resultSet.getInt("IDESTADOPROSAN"));

			Expedientes expedienteAux = new Expedientes();
			expedienteAux.setIdExpediente(resultSet.getInt("IDEXPEDIENTE"));
			expedienteAux.setFolderNumber(resultSet.getString("FOLDERNUMBER"));
			expedienteAux.setTitulo(resultSet.getString("TITULO"));
			expedienteAux.setFolderId(resultSet.getString("FOLDERID"));

			Expedientes expedienteSancionador = new Expedientes();
			expedienteSancionador.setIdExpediente(resultSet.getInt("IDEXPEDIENTESANCIONADOR"));
			if (resultSet.wasNull()) {
				expedienteSancionador.setIdExpediente(null);
			}
			expedienteSancionador.setFolderNumber(resultSet.getString("FOLDERNUMBERSANCIONADOR"));
			sancion.setExpediente(expedienteSancionador);

			propuestaSancion.setExpedienteOrigen(expedienteAux);

			relSanProSan.setPropuestaSancion(propuestaSancion);
			relSanProSan.setSancion(sancion);

			return relSanProSan;
		}
	};

	private RowMapper<PropuestasSancion> rwMapAll = new RowMapper<PropuestasSancion>() {
		public PropuestasSancion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			PropuestasSancion propuestaSancion = new PropuestasSancion();
			propuestaSancion.setIdPropuestaSancion(resultSet.getInt("IDPROPUESTASANCION"));
			propuestaSancion.setNotasRespOfi(resultSet.getString("NOTASINTERNASRESP"));
			propuestaSancion.setIdentificadorInspeccion(resultSet.getString("IDENTIFICADORINSPECCION"));
			propuestaSancion.setIdentificadorProSan(resultSet.getString("IDENTIFICADORPROSAN"));

			Expedientes expedienteSancionador = new Expedientes();
			expedienteSancionador.setFolderNumber(resultSet.getString("NUMEXPEDIENTESANCIONADOR"));
			expedienteSancionador.setFolderId(resultSet.getString("FOLDERIDEXPEDIENTESANCIONADOR"));

			Procedimientos procedimientoExpSancionador = new Procedimientos();
			Aplicaciones aplicacionExpSancionador = new Aplicaciones();
			aplicacionExpSancionador.setUrlAplicacion(resultSet.getString("EXPEDIENTESANCIONADORAPP"));
			procedimientoExpSancionador.setAplicacion(aplicacionExpSancionador);
			expedienteSancionador.setProcedimiento(procedimientoExpSancionador);
			propuestaSancion.setExpedienteSancionador(expedienteSancionador);

			Expedientes expedienteAux = new Expedientes();
			expedienteAux.setIdExpediente(resultSet.getInt("IDEXPEDIENTEORIGEN"));
			if (resultSet.wasNull()) {
				expedienteAux.setIdExpediente(null);
			}
			expedienteAux.setFolderNumber(resultSet.getString("FOLDERNUMBER"));
			expedienteAux.setTitulo(resultSet.getString("TITULO"));
			expedienteAux.setFolderId(resultSet.getString("FOLDERID"));

			Procedimientos procedimientoAux = new Procedimientos();
			Aplicaciones aplicacionAux = new Aplicaciones();
			aplicacionAux.setUrlAplicacion(resultSet.getString("URLAPLICACION"));
			procedimientoAux.setAplicacion(aplicacionAux);
			expedienteAux.setProcedimiento(procedimientoAux);

			DatosDirecciones datosDireccionAux = new DatosDirecciones();
			datosDireccionAux.setDireccion(resultSet.getString("DIRECCION"));
			datosDireccionAux.setNumero(resultSet.getString("NUMERO"));
			datosDireccionAux.setEscalera(resultSet.getString("ESCALERA"));
			datosDireccionAux.setPiso(resultSet.getString("PISO"));
			datosDireccionAux.setLetra(resultSet.getString("LETRA"));
			datosDireccionAux.setDescripcionMunicipio(resultSet.getString("MUNICIPIO"));
			datosDireccionAux.setDescripcionLocalidad(resultSet.getString("LOCALIDAD"));

			expedienteAux.setDatosDirecciones(datosDireccionAux);
			propuestaSancion.setExpedienteOrigen(expedienteAux);

			return propuestaSancion;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the PropuestasSancion table.
	 *
	 * @param propuestassancion
	 *            PropuestasSancion
	 * @return PropuestasSancion
	 */
	public PropuestasSancion add(PropuestasSancion propuestassancion) {
		String query = "INSERT INTO PROPUESTAS_SANCION (ID_PROPUESTA_SANCION, IDENTIFICADOR_INSPECCION, IDENTIFICADOR_PRO_SAN, ID_EXPEDIENTE_ORIGEN, ID_TIPO_ESTABLECIMIENTO, ID_ORIGEN_PRO_SANCION, NOTAS_RESP_OFI, FECHA_REGISTRO, USUARIO_REGISTRO, NOTAS, ID_ESTADO_PRO_SAN, ID_TERCERO, ID_DIRECCION) VALUES (?,?,?,?,?,?,?,SYSDATE,?,?,?,?,?)";

		propuestassancion.setIdPropuestaSancion(
				this.jdbcTemplate.queryForObject("SELECT AB59.S_AB5902T00.NEXTVAL FROM DUAL", Integer.class));

		Object getExpedienteOrigen = null;
		if (propuestassancion.getExpedienteOrigen() != null
				&& propuestassancion.getExpedienteOrigen().getIdExpediente() != null) {
			getExpedienteOrigen = propuestassancion.getExpedienteOrigen().getIdExpediente();
		}

		this.jdbcTemplate.update(query, propuestassancion.getIdPropuestaSancion(),
				propuestassancion.getIdentificadorInspeccion(), propuestassancion.getIdentificadorProSan(),
				getExpedienteOrigen, propuestassancion.getIdTipoEstablecimiento(),
				propuestassancion.getIdOrigenProSancion(), propuestassancion.getNotasRespOfi(),
				propuestassancion.getUsuarioRegistro(), propuestassancion.getNotas(), propuestassancion.getEstado(),
				propuestassancion.getIdTercero(), propuestassancion.getIdDireccion());
		return propuestassancion;
	}

	/**
	 * Updates a single row in the PropuestasSancion table.
	 *
	 * @param propuestassancion
	 *            PropuestasSancion
	 * @return PropuestasSancion
	 */
	public PropuestasSancion update(PropuestasSancion propuestassancion) {
		String query = "UPDATE PROPUESTAS_SANCION SET NOTAS = ?, ID_ESTADO_PRO_SAN = ?, FECHA_ULTMODIFICACION = SYSDATE, USUARIO_ULTMODIFICACION = ? WHERE ID_PROPUESTA_SANCION = ?";
		this.jdbcTemplate.update(query, propuestassancion.getNotas(), propuestassancion.getEstado(),
				propuestassancion.getUsuarioUltmodificacion(), propuestassancion.getIdPropuestaSancion());
		return propuestassancion;
	}

	@Override
	public PropuestasSancion updateFolderIdEstado(PropuestasSancion propuestaSancion) {
		String query = "UPDATE PROPUESTAS_SANCION SET FOLDER_ID = ?, ID_ESTADO_PRO_SAN = ?, FECHA_ULTMODIFICACION = SYSDATE, USUARIO_ULTMODIFICACION = ? WHERE ID_PROPUESTA_SANCION = ?";
		this.jdbcTemplate.update(query, propuestaSancion.getFolderId(), propuestaSancion.getEstado(),
				propuestaSancion.getUsuarioUltmodificacion(), propuestaSancion.getIdPropuestaSancion());
		return propuestaSancion;
	}

	/**
	 * Finds a single row in the PropuestasSancion table.
	 *
	 * @param propuestassancion
	 *            PropuestasSancion
	 * @return PropuestasSancion
	 */
	@Transactional(readOnly = true)
	public PropuestasSancion find(PropuestasSancion propuestassancion) {

		StringBuilder query = new StringBuilder();

		query.append("SELECT distinct(t02.ID_PROPUESTA_SANCION) IDPROPUESTASANCION, t6102.FOLDER_NUMBER FOLDERNUMBER");
		query.append(", t6102.TITULO TITULO, t6102.FOLDER_ID FOLDERID");
		query.append(", PROV.ID IDPROVINCIA, PROV.DS_O PROVINCIA, MUNI.DS_O MUNICIPIO, LOCA.DS_O LOCALIDAD");
		query.append(
				", t6136.ESTABLECIMIENTO ESTABLECIMIENTO, t6136.IDENTIFICADOR_ESTABLECIMIENTO IDENTESTABLECIMIENTO, t6136.DIRECCION DIRECCION, t6136.NUMERO NUMERO, t6136.ESCALERA ESCALERA, t6136.PISO PISO, t6136.LETRA LETRA, t6136.CODIGO_POSTAL CODIGOPOSTAL");
		query.append(
				", t02.NOTAS_RESP_OFI NOTASINTERNASRESP, t02.NOTAS NOTAS, t02.ID_ESTADO_PRO_SAN IDESTADOPROSAN, t02.ID_ORIGEN_PRO_SANCION IDORIGENPROSANCION ");

		query.append(", (SELECT count(*) FROM REL_SAN_PRO_SAN where id_propuesta_sancion = "
				+ propuestassancion.getIdPropuestaSancion() + ")  ASOCIADOSANCION");
		query.append(", t6102.ID_EXPEDIENTE IDEXPEDIENTE, t6101.ID_DIRECCION IDDIRECCION");
		query.append(" FROM PROPUESTAS_SANCION t02");
		query.append(" INNER JOIN EXPEDIENTES t6102 ON t02.ID_EXPEDIENTE_ORIGEN = t6102.ID_EXPEDIENTE");
		query.append(" INNER JOIN PROCEDIMIENTOS t6101 ON t6102.ID_PROCEDIMIENTO = t6101.ID_PROCEDIMIENTO");
		query.append(" INNER JOIN REL_EXP_DIR t6151 ON t02.ID_EXPEDIENTE_ORIGEN = t6151.ID_EXPEDIENTE");
		query.append(
				" INNER JOIN DATOS_DIRECCIONES t6136 ON T6151.ID_DIRECCION = t6136.ID_DIRECCION AND t6136.ID_TIPO_DIRECCION = ");
		query.append(Constantes.UBICACION_ACTIVIDAD);
		query.append(" LEFT OUTER JOIN PROVINCIAS PROV ON t6136.ID_PROVINCIA = PROV.ID");
		query.append(
				" LEFT OUTER JOIN MUNICIPIOS MUNI ON t6136.ID_MUNICIPIO = MUNI.ID AND t6136.ID_PROVINCIA = MUNI.PROVINCIA_ID");
		query.append(
				" LEFT OUTER JOIN LOCALIDADES LOCA ON t6136.ID_LOCALIDAD = LOCA.ID AND t6136.ID_MUNICIPIO = LOCA.MUNICIPIO_ID AND t6136.ID_PROVINCIA = LOCA.PROVINCIA_ID");
		query.append(" WHERE t02.ID_PROPUESTA_SANCION = ?");

		List<PropuestasSancion> propuestassancionList = this.jdbcTemplate.query(query.toString(), this.rwMap,
				propuestassancion.getIdPropuestaSancion());
		return DataAccessUtils.uniqueResult(propuestassancionList);
	}

	@Override
	public PropuestasSancion findByAnio(String anio) {
		StringBuilder query = new StringBuilder(
				"SELECT t5902.ID_PROPUESTA_SANCION IDPROPUESTASANCION, t5902.IDENTIFICADOR_PRO_SAN IDENTIFICADORPROSAN FROM PROPUESTAS_SANCION t5902 WHERE t5902.IDENTIFICADOR_PRO_SAN like ? ORDER BY t5902.IDENTIFICADOR_PRO_SAN DESC");

		List<Object> params = new ArrayList<Object>();
		params.add("%-" + anio + "-%");

		List<PropuestasSancion> propuestassancionList = this.jdbcTemplate.query(query.toString(),
				this.rwMapIdentificadorProSan, params.toArray());

		if (!propuestassancionList.isEmpty()) {
			return propuestassancionList.get(0);
		} else {
			return null;
		}
	}

	@Override
	public PropuestasSancion findSinExpediente(PropuestasSancion propuestaSancion) {
		StringBuilder query = new StringBuilder();

		query.append("SELECT distinct(t02.ID_PROPUESTA_SANCION) IDPROPUESTASANCION, '' FOLDERNUMBER");
		query.append(", '' TITULO, '' FOLDERID");
		query.append(", PROV.ID IDPROVINCIA, PROV.DS_O PROVINCIA, MUNI.DS_O MUNICIPIO, LOCA.DS_O LOCALIDAD");
		query.append(
				", t6136.ESTABLECIMIENTO ESTABLECIMIENTO, t6136.IDENTIFICADOR_ESTABLECIMIENTO IDENTESTABLECIMIENTO, t6136.DIRECCION DIRECCION, t6136.NUMERO NUMERO, t6136.ESCALERA ESCALERA, t6136.PISO PISO, t6136.LETRA LETRA, t6136.CODIGO_POSTAL CODIGOPOSTAL");
		query.append(
				", t02.NOTAS_RESP_OFI NOTASINTERNASRESP, t02.NOTAS NOTAS, t02.ID_ESTADO_PRO_SAN IDESTADOPROSAN, t02.ID_ORIGEN_PRO_SANCION IDORIGENPROSANCION, t6135.ID_TERCERO IDTERCERO");

		query.append(", (SELECT count(*) FROM REL_SAN_PRO_SAN where id_propuesta_sancion = "
				+ propuestaSancion.getIdPropuestaSancion() + ")  ASOCIADOSANCION");
		query.append(", '' IDEXPEDIENTE, '' IDDIRECCION");
		query.append(
				" FROM PROPUESTAS_SANCION t02, DATOS_TERCEROS t6135, DATOS_DIRECCIONES t6136, PROVINCIAS PROV, MUNICIPIOS MUNI, LOCALIDADES LOCA");
		query.append(" WHERE t02.ID_PROPUESTA_SANCION = ?");
		query.append("AND t02.ID_TERCERO = t6135.ID_TERCERO AND t6135.TIPO_PARTICIPANTE = "
				+ Constantes.PARTICIPANTE_TITULAR
				+ " AND t02.ID_DIRECCION = t6136.ID_DIRECCION AND t6136.ID_TIPO_DIRECCION = "
				+ Constantes.UBICACION_ACTIVIDAD
				+ " AND t6136.ID_PROVINCIA = PROV.ID (+) AND t6136.ID_MUNICIPIO = MUNI.ID (+) AND t6136.ID_PROVINCIA = MUNI.PROVINCIA_ID (+) AND t6136.ID_LOCALIDAD = LOCA.ID (+) AND t6136.ID_MUNICIPIO = LOCA.MUNICIPIO_ID (+) AND t6136.ID_PROVINCIA = LOCA.PROVINCIA_ID (+)");

		List<PropuestasSancion> propuestassancionList = this.jdbcTemplate.query(query.toString(), this.rwMap,
				propuestaSancion.getIdPropuestaSancion());
		return DataAccessUtils.uniqueResult(propuestassancionList);
	}

	/**
	 * Removes a single row in the PropuestasSancion table.
	 *
	 * @param propuestassancion
	 *            PropuestasSancion
	 * @return
	 */
	public void remove(PropuestasSancion propuestassancion) {
		String query = "DELETE FROM PROPUESTAS_SANCION WHERE ID_PROPUESTA_SANCION=?";
		this.jdbcTemplate.update(query, propuestassancion.getIdPropuestaSancion());
	}

	/**
	 * Finds a list of rows in the PropuestasSancion table.
	 *
	 * @param propuestassancion
	 *            PropuestasSancion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<PropuestasSancion>
	 */
	@Transactional(readOnly = true)
	public List<PropuestasSancion> findAll(PropuestasSancion propuestassancion, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder();
		StringBuilder queryDireccion = new StringBuilder();

		query.append("SELECT DISTINCT(t02.ID_PROPUESTA_SANCION) IDPROPUESTASANCION, "
				+ " t6102.FOLDER_NUMBER FOLDERNUMBER, t6102.TITULO TITULO, t6102.FOLDER_ID FOLDERID, "
				+ " tdirecciones.DIRECCION DIRECCION, tdirecciones.NUMERO NUMERO, tdirecciones.ESCALERA ESCALERA, tdirecciones.PISO PISO, tdirecciones.LETRA LETRA, "
				+ " t02.NOTAS_RESP_OFI NOTASINTERNASRESP, t02.ID_EXPEDIENTE_ORIGEN IDEXPEDIENTEORIGEN, t02.IDENTIFICADOR_INSPECCION IDENTIFICADORINSPECCION, "
				+ " t02.IDENTIFICADOR_PRO_SAN IDENTIFICADORPROSAN, MUNIDSO MUNICIPIO, LOCADSO LOCALIDAD, "
				+ " t6146.URL_APLICACION URLAPLICACION, " + " (SELECT DISTINCT t6102.FOLDER_NUMBER "
				+ " FROM REL_SAN_PRO_SAN t06, " + " SANCIONES t01, " + " EXPEDIENTES t6102 " + " WHERE 1 = 1 "
				+ " AND t06.ID_SANCION    		= t01.ID_SANCION "
				+ " AND t01.ID_EXPEDIENTE 		= t6102.ID_EXPEDIENTE "
				+ " AND t02.ID_PROPUESTA_SANCION = t06.ID_PROPUESTA_SANCION " + " ) NUMEXPEDIENTESANCIONADOR, "
				+ " (SELECT DISTINCT t6102.FOLDER_ID " + " FROM REL_SAN_PRO_SAN t06, " + " SANCIONES t01, "
				+ " EXPEDIENTES t6102 " + " WHERE 1 = 1 " + " AND t06.ID_SANCION 			= t01.ID_SANCION "
				+ " AND t01.ID_EXPEDIENTE  		= t6102.ID_EXPEDIENTE "
				+ " AND t02.ID_PROPUESTA_SANCION = t06.ID_PROPUESTA_SANCION " + " ) FOLDERIDEXPEDIENTESANCIONADOR, "
				+ " (SELECT DISTINCT t6146.URL_APLICACION " + " FROM REL_SAN_PRO_SAN t06, " + " SANCIONES t01, "
				+ " EXPEDIENTES t6102, " + " PROCEDIMIENTOS t6101, " + " APLICACIONES t6146 " + " WHERE 1 = 1 "
				+ " AND t06.ID_SANCION 			= t01.ID_SANCION "
				+ " AND t01.ID_EXPEDIENTE		= t6102.ID_EXPEDIENTE "
				+ " AND t6102.ID_PROCEDIMIENTO 	= t6101.ID_PROCEDIMIENTO "
				+ " AND  t6101.ID_APLICACION     = t6146.ID_APLICACION "
				+ " AND t02.ID_PROPUESTA_SANCION = t06.ID_PROPUESTA_SANCION " + " ) EXPEDIENTESANCIONADORAPP "
				+ " FROM " + " PROPUESTAS_SANCION t02 " + " , EXPEDIENTES t6102 " + " , REL_EXP_TER t6134 "
				+ " , DATOS_TERCEROS t6135 " + " , PROCEDIMIENTOS t6101 " + " , APLICACIONES t6146 "
				+ " , REL_ART_INF_PRO_SAN t10 " + " , INFRACCIONES t09 " + " , ESTADOS_PRO_SAN T18 ");

		queryDireccion.append(" , (SELECT t6151.*, t6136.*, MUNI.DS_O MUNIDSO, LOCA.DS_O LOCADSO "
				+ " FROM REL_EXP_DIR t6151, DATOS_DIRECCIONES t6136, MUNICIPIOS MUNI, LOCALIDADES LOCA  "
				+ " WHERE 1 = 1 " + " AND t6151.ID_DIRECCION = t6136.ID_DIRECCION  " + " AND t6136.ID_TIPO_DIRECCION = "
				+ Constantes.UBICACION_ACTIVIDAD + " AND t6136.ID_LOCALIDAD  = LOCA.ID(+) "
				+ " AND t6136.ID_MUNICIPIO  = LOCA.MUNICIPIO_ID(+) "
				+ " AND t6136.ID_PROVINCIA  = LOCA.PROVINCIA_ID(+) " + " AND t6136.ID_MUNICIPIO  = MUNI.ID(+) "
				+ " AND t6136.ID_PROVINCIA  = MUNI.PROVINCIA_ID(+)  ");
		Map<String, ?> mapaWhereDireccion = this.getWhereMapUbicacion(propuestassancion);
		queryDireccion.append(mapaWhereDireccion.get("query"));
		queryDireccion.append(" ) tdirecciones ");
		List<?> paramsDireccion = (List<?>) mapaWhereDireccion.get("params");

		// Se aade al query principal
		query.append(queryDireccion);

		query.append(" WHERE 1 = 1 " + " AND t02.ID_EXPEDIENTE_ORIGEN = t6102.ID_EXPEDIENTE "
				+ " AND t02.ID_EXPEDIENTE_ORIGEN = t6134.ID_EXPEDIENTE "
				+ " AND t6134.ID_TERCERO         = t6135.ID_TERCERO " + " AND t6135.TIPO_PARTICIPANTE  = "
				+ Constantes.PARTICIPANTE_TITULAR + " AND t6102.ID_PROCEDIMIENTO   = t6101.ID_PROCEDIMIENTO "
				+ " AND t6101.ID_APLICACION      = t6146.ID_APLICACION(+) "
				+ " AND t02.ID_PROPUESTA_SANCION = t10.ID_PROPUESTA_SANCION(+) "
				+ " AND t10.ID_INFRACCION        = t09.ID_INFRACCION(+) "
				+ " AND t02.ID_ESTADO_PRO_SAN    = t18.ID_ESTADO_PRO_SAN "
				+ " AND t02.ID_EXPEDIENTE_ORIGEN = tdirecciones.ID_EXPEDIENTE ");

		Map<String, ?> mapaWhere = this.getWhereMap(propuestassancion);
		query.append(mapaWhere.get("query"));
		List<?> paramsQuery = (List<?>) mapaWhere.get("params");

		List<Object> params = new ArrayList<Object>();
		params.addAll(paramsDireccion);
		params.addAll(paramsQuery);

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query);
		}
		return this.jdbcTemplate.query(query.toString(), this.rwMapAll, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the PropuestasSancion table.
	 *
	 * @param propuestassancion
	 *            PropuestasSancion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(PropuestasSancion propuestassancion) {
		StringBuilder queryCount = new StringBuilder();
		StringBuilder query = new StringBuilder();
		StringBuilder queryDireccion = new StringBuilder();

		queryCount.append("SELECT COUNT(1) FROM ( ");

		query.append("SELECT DISTINCT(t02.ID_PROPUESTA_SANCION) IDPROPUESTASANCION, "
				+ " t6102.FOLDER_NUMBER FOLDERNUMBER, t6102.TITULO TITULO, t6102.FOLDER_ID FOLDERID, "
				+ " tdirecciones.DIRECCION DIRECCION, tdirecciones.NUMERO NUMERO, tdirecciones.ESCALERA ESCALERA, tdirecciones.PISO PISO, tdirecciones.LETRA LETRA, "
				+ " t02.NOTAS_RESP_OFI NOTASINTERNASRESP, t02.ID_EXPEDIENTE_ORIGEN IDEXPEDIENTEORIGEN, t02.IDENTIFICADOR_INSPECCION IDENTIFICADORINSPECCION, "
				+ " t02.IDENTIFICADOR_PRO_SAN IDENTIFICADORPROSAN, MUNIDSO MUNICIPIO, LOCADSO LOCALIDAD, "
				+ " t6146.URL_APLICACION URLAPLICACION, " + " (SELECT DISTINCT t6102.FOLDER_NUMBER "
				+ " FROM REL_SAN_PRO_SAN t06, " + " SANCIONES t01, " + " EXPEDIENTES t6102 " + " WHERE 1 = 1 "
				+ " AND t06.ID_SANCION    		= t01.ID_SANCION "
				+ " AND t01.ID_EXPEDIENTE 		= t6102.ID_EXPEDIENTE "
				+ " AND t02.ID_PROPUESTA_SANCION = t06.ID_PROPUESTA_SANCION " + " ) NUMEXPEDIENTESANCIONADOR, "
				+ " (SELECT DISTINCT t6102.FOLDER_ID " + " FROM REL_SAN_PRO_SAN t06, " + " SANCIONES t01, "
				+ " EXPEDIENTES t6102 " + " WHERE 1 = 1 " + " AND t06.ID_SANCION 			= t01.ID_SANCION "
				+ " AND t01.ID_EXPEDIENTE  		= t6102.ID_EXPEDIENTE "
				+ " AND t02.ID_PROPUESTA_SANCION = t06.ID_PROPUESTA_SANCION " + " ) FOLDERIDEXPEDIENTESANCIONADOR, "
				+ " (SELECT DISTINCT t6146.URL_APLICACION " + " FROM REL_SAN_PRO_SAN t06, " + " SANCIONES t01, "
				+ " EXPEDIENTES t6102, " + " PROCEDIMIENTOS t6101, " + " APLICACIONES t6146 " + " WHERE 1 = 1 "
				+ " AND t06.ID_SANCION 			= t01.ID_SANCION "
				+ " AND t01.ID_EXPEDIENTE		= t6102.ID_EXPEDIENTE "
				+ " AND t6102.ID_PROCEDIMIENTO 	= t6101.ID_PROCEDIMIENTO "
				+ " AND  t6101.ID_APLICACION     = t6146.ID_APLICACION "
				+ " AND t02.ID_PROPUESTA_SANCION = t06.ID_PROPUESTA_SANCION " + " ) EXPEDIENTESANCIONADORAPP "
				+ " FROM " + " PROPUESTAS_SANCION t02 " + " , EXPEDIENTES t6102 " + " , REL_EXP_TER t6134 "
				+ " , DATOS_TERCEROS t6135 " + " , PROCEDIMIENTOS t6101 " + " , APLICACIONES t6146 "
				+ " , REL_ART_INF_PRO_SAN t10 " + " , INFRACCIONES t09 " + " , ESTADOS_PRO_SAN T18 ");

		queryDireccion.append(" , (SELECT t6151.*, t6136.*, MUNI.DS_O MUNIDSO, LOCA.DS_O LOCADSO "
				+ " FROM REL_EXP_DIR t6151, DATOS_DIRECCIONES t6136, MUNICIPIOS MUNI, LOCALIDADES LOCA  "
				+ " WHERE 1 = 1 " + " AND t6151.ID_DIRECCION = t6136.ID_DIRECCION  " + " AND t6136.ID_TIPO_DIRECCION = "
				+ Constantes.UBICACION_ACTIVIDAD + " AND t6136.ID_LOCALIDAD  = LOCA.ID(+) "
				+ " AND t6136.ID_MUNICIPIO  = LOCA.MUNICIPIO_ID(+) "
				+ " AND t6136.ID_PROVINCIA  = LOCA.PROVINCIA_ID(+) " + " AND t6136.ID_MUNICIPIO  = MUNI.ID(+) "
				+ " AND t6136.ID_PROVINCIA  = MUNI.PROVINCIA_ID(+)  ");
		Map<String, ?> mapaWhereDireccion = this.getWhereMapUbicacion(propuestassancion);
		queryDireccion.append(mapaWhereDireccion.get("query"));
		queryDireccion.append(" ) tdirecciones ");
		List<?> paramsDireccion = (List<?>) mapaWhereDireccion.get("params");

		// Se aade al query principal
		query.append(queryDireccion);

		query.append(" WHERE 1 = 1 " + " AND t02.ID_EXPEDIENTE_ORIGEN = t6102.ID_EXPEDIENTE "
				+ " AND t02.ID_EXPEDIENTE_ORIGEN = t6134.ID_EXPEDIENTE "
				+ " AND t6134.ID_TERCERO         = t6135.ID_TERCERO " + " AND t6135.TIPO_PARTICIPANTE  = "
				+ Constantes.PARTICIPANTE_TITULAR + " AND t6102.ID_PROCEDIMIENTO   = t6101.ID_PROCEDIMIENTO "
				+ " AND t6101.ID_APLICACION      = t6146.ID_APLICACION(+) "
				+ " AND t02.ID_PROPUESTA_SANCION = t10.ID_PROPUESTA_SANCION(+) "
				+ " AND t10.ID_INFRACCION        = t09.ID_INFRACCION(+) "
				+ " AND t02.ID_ESTADO_PRO_SAN    = t18.ID_ESTADO_PRO_SAN "
				+ " AND t02.ID_EXPEDIENTE_ORIGEN = tdirecciones.ID_EXPEDIENTE ");

		Map<String, ?> mapaWhere = this.getWhereMap(propuestassancion);
		query.append(mapaWhere.get("query"));
		List<?> paramsQuery = (List<?>) mapaWhere.get("params");

		List<Object> params = new ArrayList<Object>();
		params.addAll(paramsDireccion);
		params.addAll(paramsQuery);

		queryCount.append(query);
		queryCount.append(")");

		return this.jdbcTemplate.queryForObject(queryCount.toString(), params.toArray(), Long.class);
	}

	private Map<String, ?> getWhereMap(PropuestasSancion propuestassancion) {

		StringBuilder where = new StringBuilder(PropuestasSancionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		/* Nº Expediente Origen */
		if (propuestassancion != null && propuestassancion.getExpedienteOrigen() != null
				&& propuestassancion.getExpedienteOrigen().getFolderNumber() != null) {
			where.append(" AND UPPER(t6102.FOLDER_NUMBER) like ? ESCAPE  '\\'");
			params.add("%" + propuestassancion.getExpedienteOrigen().getFolderNumber().toUpperCase() + "%");
		}

		/* Ttulo Expdiente Origen */
		if (propuestassancion != null && propuestassancion.getExpedienteOrigen() != null
				&& propuestassancion.getExpedienteOrigen().getTitulo() != null) {
			where.append(" AND UPPER(t6102.TITULO) like ? ESCAPE  '\\'");
			params.add("%" + propuestassancion.getExpedienteOrigen().getTitulo().toUpperCase() + "%");
		}
		/* Fecha hecho */
		if (propuestassancion != null && propuestassancion.getFechaHechoFind() != null) {
			where.append(" AND TO_CHAR(t10.FECHA_HECHO, '" + Constantes.FORMATO_FECHA_ES + "') = TO_DATE('"
					+ new SimpleDateFormat(Constantes.FORMATO_FECHA_ES).format(propuestassancion.getFechaHechoFind())
					+ "','" + Constantes.FORMATO_FECHA_ES + "')");
		}
		/* Fecha Creacion */
		if (propuestassancion != null && propuestassancion.getFechaRegistro() != null) {
			where.append(" AND TO_CHAR(t02.FECHA_REGISTRO, '" + Constantes.FORMATO_FECHA_ES + "') = TO_DATE('"
					+ new SimpleDateFormat(Constantes.FORMATO_FECHA_ES).format(propuestassancion.getFechaRegistro())
					+ "','" + Constantes.FORMATO_FECHA_ES + "')");
		}
		/* Calificacin */
		if (propuestassancion != null && propuestassancion.getCalificacionFind() != null
				&& propuestassancion.getCalificacionFind().getIdCalificacion() != null) {
			where.append(" AND t09.ID_CALIFICACION = ?");
			params.add(propuestassancion.getCalificacionFind().getIdCalificacion());
		}

		/* Infraccin */
		if (propuestassancion != null && propuestassancion.getIdInfraccionFind() != null) {
			where.append(" AND t09.ID_INFRACCION = ?");
			params.add(propuestassancion.getIdInfraccionFind());
		}

		/* Estado */
		if (propuestassancion != null && propuestassancion.getEstado() != null
				&& propuestassancion.getEstado() != Constantes.MAGIC_NUMBER_0) {
			where.append(" AND t02.ID_ESTADO_PRO_SAN = ?");
			params.add(propuestassancion.getEstado());
		}

		/* Dirección */
		if (propuestassancion != null && propuestassancion.getExpedienteOrigen() != null
				&& propuestassancion.getExpedienteOrigen().getProcedimiento() != null
				&& propuestassancion.getExpedienteOrigen().getProcedimiento().getDirecciones() != null
				&& propuestassancion.getExpedienteOrigen().getProcedimiento().getDirecciones()
						.getIdDireccion() != null) {
			where.append(" AND t6101.ID_DIRECCION = ?");
			params.add(propuestassancion.getExpedienteOrigen().getProcedimiento().getDirecciones().getIdDireccion());
		}

		/* Titular */
		if (propuestassancion != null && propuestassancion.getExpedienteOrigen() != null
				&& propuestassancion.getExpedienteOrigen().getDatosTerceros() != null) {
			// Nombre
			if (propuestassancion.getExpedienteOrigen().getDatosTerceros().getNombre() != null) {
				where.append(" AND UPPER(t6135.NOMBRE) LIKE ? ESCAPE '\\'");
				params.add("%" + propuestassancion.getExpedienteOrigen().getDatosTerceros().getNombre().toUpperCase()
						+ "%");
			}
			// Apellido 1
			if (propuestassancion.getExpedienteOrigen().getDatosTerceros().getApellido1() != null) {
				where.append(" AND UPPER(t6135.APELLIDO1) LIKE ? ESCAPE '\\'");
				params.add("%" + propuestassancion.getExpedienteOrigen().getDatosTerceros().getApellido1().toUpperCase()
						+ "%");
			}
			// Apellido 2
			if (propuestassancion.getExpedienteOrigen().getDatosTerceros().getApellido2() != null) {
				where.append(" AND UPPER(t6135.APELLIDO2) LIKE ? ESCAPE '\\'");
				params.add("%" + propuestassancion.getExpedienteOrigen().getDatosTerceros().getApellido2().toUpperCase()
						+ "%");
			}
			// DNI
			if (propuestassancion.getExpedienteOrigen().getDatosTerceros().getDocumento() != null) {
				where.append(" AND UPPER(t6135.DOCUMENTO) LIKE ? ESCAPE '\\'");
				params.add("%" + propuestassancion.getExpedienteOrigen().getDatosTerceros().getDocumento().toUpperCase()
						+ "%");
			}
		}

		/* Sanción */
		if (propuestassancion != null && propuestassancion.getIdSancionFind() != null) {
			where.append(" AND t02.ID_PROPUESTA_SANCION NOT IN (SELECT ID_PROPUESTA_SANCION FROM REL_SAN_PRO_SAN)");
		}

		/* Identificador inspeccion */
		if (propuestassancion != null && propuestassancion.getIdentificadorInspeccion() != null) {
			where.append(" AND UPPER(t02.IDENTIFICADOR_INSPECCION) LIKE ? ESCAPE '\\'");
			params.add("%" + propuestassancion.getIdentificadorInspeccion() + "%");
		}

		/* Identificador de la Propuesta de Sancin */
		if (propuestassancion != null && propuestassancion.getIdentificadorProSan() != null) {
			where.append(" AND (t02.IDENTIFICADOR_PRO_SAN) LIKE ? ESCAPE '\\'");
			params.add("%" + propuestassancion.getIdentificadorProSan() + "%");
		}
		/* ************************* */
		/* *** FICHA DE LA SANCION *** */
		/* ************************* */

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	private Map<String, ?> getWhereMapUbicacion(PropuestasSancion propuestassancion) {

		StringBuilder where = new StringBuilder(PropuestasSancionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		/* Ubicacin de la actividad */
		if (propuestassancion != null && propuestassancion.getExpedienteOrigen() != null
				&& propuestassancion.getExpedienteOrigen().getDatosDirecciones() != null) {
			// Nombre Comercial
			if (propuestassancion.getExpedienteOrigen().getDatosDirecciones().getEstablecimiento() != null) {
				where.append(" AND UPPER(t6136.ESTABLECIMIENTO) LIKE ? ESCAPE '\\'");
				params.add("%" + propuestassancion.getExpedienteOrigen().getDatosDirecciones().getEstablecimiento()
						.toUpperCase() + "%");
			}

			// Identificador Establecimiento
			if (propuestassancion.getExpedienteOrigen().getDatosDirecciones()
					.getIdentificadorEstablecimientoUno() != null) {
				where.append(" AND t6136.IDENTIFICADOR_ESTABLECIMIENTO LIKE ? ESCAPE '\\'");
				params.add(propuestassancion.getExpedienteOrigen().getDatosDirecciones()
						.getIdentificadorEstablecimientoUno() + "%");
			}
			if (propuestassancion.getExpedienteOrigen().getDatosDirecciones()
					.getIdentificadorEstablecimientoDos() != null) {
				where.append(" AND t6136.IDENTIFICADOR_ESTABLECIMIENTO LIKE ? ESCAPE '\\'");
				params.add("%" + propuestassancion.getExpedienteOrigen().getDatosDirecciones()
						.getIdentificadorEstablecimientoDos() + "%");
			}
			if (propuestassancion.getExpedienteOrigen().getDatosDirecciones()
					.getIdentificadorEstablecimientoTres() != null) {
				where.append(" AND t6136.IDENTIFICADOR_ESTABLECIMIENTO LIKE ? ESCAPE '\\'");
				params.add("%" + propuestassancion.getExpedienteOrigen().getDatosDirecciones()
						.getIdentificadorEstablecimientoTres());
			}

			// Provincia
			if (propuestassancion.getExpedienteOrigen().getDatosDirecciones().getProvincia() != null) {
				where.append(" AND t6136.ID_PROVINCIA = ?");
				params.add(propuestassancion.getExpedienteOrigen().getDatosDirecciones().getProvincia().getId());
			}
			// Municipio
			if (propuestassancion.getExpedienteOrigen().getDatosDirecciones().getMunicipio() != null) {
				where.append(" AND t6136.ID_MUNICIPIO = ?");
				params.add(propuestassancion.getExpedienteOrigen().getDatosDirecciones().getMunicipio().getId());
			}
			// Localidad
			if (propuestassancion.getExpedienteOrigen().getDatosDirecciones().getLocalidad() != null) {
				where.append(" AND t6136.ID_LOCALIDAD = ?");
				params.add(propuestassancion.getExpedienteOrigen().getDatosDirecciones().getLocalidad().getId());
			}
			// Calle
			if (propuestassancion.getExpedienteOrigen().getDatosDirecciones().getDireccion() != null) {
				where.append(" AND UPPER(t6136.DIRECCION) LIKE ? ESCAPE '\\'");
				params.add(
						"%" + propuestassancion.getExpedienteOrigen().getDatosDirecciones().getDireccion().toUpperCase()
								+ "%");
			}
			// Número
			if (propuestassancion.getExpedienteOrigen().getDatosDirecciones().getNumero() != null) {
				where.append(" AND t6136.NUMERO = ?");
				params.add(propuestassancion.getExpedienteOrigen().getDatosDirecciones().getNumero());
			}
			// Escalera
			if (propuestassancion.getExpedienteOrigen().getDatosDirecciones().getEscalera() != null) {
				where.append(" AND UPPER(t6136.ESCALERA) = ?");
				params.add(propuestassancion.getExpedienteOrigen().getDatosDirecciones().getEscalera().toUpperCase());
			}
			// Piso
			if (propuestassancion.getExpedienteOrigen().getDatosDirecciones().getPiso() != null) {
				where.append(" AND t6136.PISO = ?");
				params.add(propuestassancion.getExpedienteOrigen().getDatosDirecciones().getPiso());
			}
			// Letra
			if (propuestassancion.getExpedienteOrigen().getDatosDirecciones().getLetra() != null) {
				where.append(" AND UPPER(t6136.LETRA) = ?");
				params.add(propuestassancion.getExpedienteOrigen().getDatosDirecciones().getLetra().toUpperCase());
			}
			// Código postal
			if (propuestassancion.getExpedienteOrigen().getDatosDirecciones().getCodigoPostal() != null) {
				where.append(" AND t6136.CODIGO_POSTAL = ?");
				params.add(propuestassancion.getExpedienteOrigen().getDatosDirecciones().getCodigoPostal());
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	public static final int STRING_BUILDER_INIT = 4096;

	public Long validarEstadoValidadaOSancionador(Integer idPropuestasSancion) {

		List<Object> params = new ArrayList<Object>();

		StringBuilder query = new StringBuilder("SELECT COUNT(*)");
		query.append(" FROM PROPUESTAS_SANCION");
		query.append(" WHERE ID_PROPUESTA_SANCION = ?");
		params.add(idPropuestasSancion);
		query.append(" AND ID_ESTADO_PRO_SAN NOT IN (?,?,?,?)");
		params.add(Constantes.ESTADO_PROPUESTA_VALIDADO_DIRECCION_TURISMO);
		params.add(Constantes.ESTADO_PROPUESTA_EXPEDIENTE_SANCIONADOR_TURISMO);
		params.add(Constantes.ESTADO_PROPUESTA_VALIDADO_DIRECCION_COMERCIO);
		params.add(Constantes.ESTADO_PROPUESTA_EXPEDIENTE_SANCIONADOR_COMERCIO);

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	public Long validarExistePropuesta(Integer idPropuestasSancion) {

		List<Object> params = new ArrayList<Object>();

		StringBuilder query = new StringBuilder("SELECT COUNT(*)");
		query.append(" FROM PROPUESTAS_SANCION");
		query.append(" WHERE ID_PROPUESTA_SANCION = ?");
		params.add(idPropuestasSancion);

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	public PropuestasSancion updatePropuestaSancion(PropuestasSancion propuestassancion) {

		StringBuilder query = new StringBuilder();

		query.append(
				"UPDATE PROPUESTAS_SANCION SET NOTAS_RESP_OFI = ?, FECHA_ULTMODIFICACION = SYSDATE, USUARIO_ULTMODIFICACION = ?, ID_TERCERO = ?, ID_DIRECCION = ? WHERE ID_PROPUESTA_SANCION = ?");

		this.jdbcTemplate.update(query.toString(), propuestassancion.getNotasRespOfi(),
				propuestassancion.getUsuarioUltmodificacion(), propuestassancion.getIdTercero(),
				propuestassancion.getIdDireccion(), propuestassancion.getIdPropuestaSancion());
		return propuestassancion;
	}

	@Override
	public PropuestasSancion updateEstadoProSan(PropuestasSancion propuestasSancion) {
		StringBuilder query = new StringBuilder(
				"UPDATE PROPUESTAS_SANCION SET ID_ESTADO_PRO_SAN = ?, FECHA_ULTMODIFICACION = sysdate, USUARIO_ULTMODIFICACION = ? WHERE ID_PROPUESTA_SANCION = ?");

		this.jdbcTemplate.update(query.toString(), propuestasSancion.getEstado(),
				propuestasSancion.getUsuarioUltmodificacion(), propuestasSancion.getIdPropuestaSancion());
		return propuestasSancion;
	}

	@Override
	public RelSanProSan obtenerCabeceraPropuestaSancion(Integer idPropuestaSancion) {
		String query = "SELECT t5902.ID_PROPUESTA_SANCION IDPROPUESTASANCION,t5902.IDENTIFICADOR_PRO_SAN IDENTIFICADORPROSAN,t5902.ID_ESTADO_PRO_SAN IDESTADOPROSAN,t6102.ID_EXPEDIENTE IDEXPEDIENTE,t6102.FOLDER_NUMBER FOLDERNUMBER,t6102.FOLDER_ID FOLDERID,t6102.TITULO TITULO, t5906.ID_SANCION IDSANCION, t6102B.ID_EXPEDIENTE IDEXPEDIENTESANCIONADOR, t6102B.FOLDER_NUMBER FOLDERNUMBERSANCIONADOR FROM PROPUESTAS_SANCION t5902, EXPEDIENTES t6102, REL_SAN_PRO_SAN t5906, SANCIONES t5901, EXPEDIENTES t6102B WHERE t5902.ID_EXPEDIENTE_ORIGEN = t6102.ID_EXPEDIENTE(+) AND t5902.ID_PROPUESTA_SANCION = ? AND t5902.ID_PROPUESTA_SANCION = t5906.ID_PROPUESTA_SANCION(+) AND t5906.ID_SANCION = t5901.ID_SANCION(+) AND t5901.ID_EXPEDIENTE = t6102B.ID_EXPEDIENTE(+)";

		List<RelSanProSan> propuestasSancionList = this.jdbcTemplate.query(query, this.rwMapCabecera,
				idPropuestaSancion);
		return DataAccessUtils.uniqueResult(propuestasSancionList);
	}

	@Override
	public Date findFechaAperturaMasActual(Integer idExpediente) {
		String query = "SELECT t6142.FECHA_EXPEDIENTE FECHAAPERTURAACTUAL FROM REL_EXP_FECH t6142, FECHAS_EXPEDIENTE t6144 WHERE t6142.ID_FECHA_EXPEDIENTE = t6144.ID_FECHA_EXPEDIENTE AND t6142.ID_EXPEDIENTE = ? AND t6144.ETIQUETA_FECHA = 'FECHA_APERTURA' ORDER BY FECHAAPERTURAACTUAL DESC";

		List<Date> fechasAperturaList = this.jdbcTemplate.query(query, this.rwMapFechaAperturaMasActual, idExpediente);

		if (!fechasAperturaList.isEmpty()) {
			return fechasAperturaList.get(0);
		} else {
			return null;
		}
	}

	@Override
	public SqlRowSet findPropuestasPendientesMismoTitular(Integer idPropuestaSancion) {

		String direccion = SeguridadAplicacion.precargarDireccion();
		if (direccion.equals("")) {
			direccion = Constantes.ID_TURISMO_DIRECCION + "," + Constantes.ID_COMERCIO_DIRECCION;
		}
		String query = "SELECT propuestaSancion.IDENTIFICADOR_PRO_SAN " + " , situacionSancion.DESCRIPCION_CASTELLANO "
				+ " , situacionSancion.DESCRIPCION_EUSKERA " + " , expediente.FOLDER_NUMBER, expediente.TITULO "
				+ " FROM  " + " AB59.AB5902T00 propuestaSancion " + ", AB59.AB5918T00 situacionSancion "
				+ " , EXPEDIENTES expediente " + " WHERE 1 = 1 "
				+ " AND situacionSancion.ID_ESTADO_PRO_SAN = propuestaSancion.ID_ESTADO_PRO_SAN "
				+ " AND expediente.ID_EXPEDIENTE = propuestaSancion.ID_EXPEDIENTE_ORIGEN "
				+ " AND propuestaSancion.ID_EXPEDIENTE_ORIGEN IN ( "
				+ "   SELECT ID_EXPEDIENTE FROM REL_EXP_TER WHERE ID_TERCERO IN ( "
				+ "       SELECT ID_TERCERO FROM DATOS_TERCEROS WHERE DOCUMENTO IN ( "
				+ "           SELECT DOCUMENTO FROM REL_EXP_TER, DATOS_TERCEROS WHERE REL_EXP_TER.ID_TERCERO = DATOS_TERCEROS.ID_TERCERO AND ID_EXPEDIENTE = ( "
				+ "               SELECT ID_EXPEDIENTE_ORIGEN FROM AB59.AB5902T00 WHERE ID_PROPUESTA_SANCION = ? "
				+ "           ) " + "       ) AND TIPO_PARTICIPANTE = " + Constantes.PARTICIPANTE_TITULAR
				+ "  ) AND ID_SUBTIPO_TERCERO =  " + Constantes.PARTE_INCULPADA + " ) "
				+ " AND propuestaSancion.ID_ESTADO_PRO_SAN IN ( "
				+ "   SELECT ID_ESTADO_PRO_SAN FROM AB59.AB5918T00 WHERE ID_PROCEDIMIENTO IN ( "
				+ "     SELECT ID_PROCEDIMIENTO FROM PROCEDIMIENTOS WHERE COD_PROCEDURE_ID IN (?, ?) AND ID_DIRECCION IN ("
				+ direccion + ") "
				+ "   ) AND (UPPER(DESCRIPCION_CASTELLANO) LIKE '%VALIDADA%' OR UPPER(DESCRIPCION_CASTELLANO) LIKE '%PENDIENTE%') "
				+ " ) " + " AND propuestaSancion.ID_PROPUESTA_SANCION <> ? ";

		return this.jdbcTemplate.queryForRowSet(query,
				new Object[] { idPropuestaSancion, Constantes.COD_PROCEDURE_SANCIONES_TURISMO,
						Constantes.COD_PROCEDURE_SANCIONES_COMERCIO, idPropuestaSancion },
				new int[] { Types.INTEGER, Types.VARCHAR, Types.VARCHAR, Types.INTEGER });

	}

	@Override
	public SqlRowSet findPropuestasPendientesMismoTitularBySancion(Integer idSancion) {

		String query = "SELECT propuestaSancion.IDENTIFICADOR_PRO_SAN " + " , situacionSancion.DESCRIPCION_CASTELLANO "
				+ " , situacionSancion.DESCRIPCION_EUSKERA " + " , expediente.FOLDER_NUMBER, expediente.TITULO "
				+ " FROM  " + " AB59.AB5902T00 propuestaSancion " + ", AB59.AB5918T00 situacionSancion "
				+ " , EXPEDIENTES expediente " + " WHERE 1 = 1 "
				+ " AND situacionSancion.ID_ESTADO_PRO_SAN = propuestaSancion.ID_ESTADO_PRO_SAN "
				+ " AND expediente.ID_EXPEDIENTE = propuestaSancion.ID_EXPEDIENTE_ORIGEN "
				+ " AND propuestaSancion.ID_EXPEDIENTE_ORIGEN IN ( "
				+ "   SELECT ID_EXPEDIENTE FROM REL_EXP_TER WHERE ID_TERCERO IN ( "
				+ "       SELECT ID_TERCERO FROM DATOS_TERCEROS WHERE DOCUMENTO IN ( "
				+ "           SELECT DOCUMENTO FROM REL_EXP_TER, DATOS_TERCEROS WHERE REL_EXP_TER.ID_TERCERO = DATOS_TERCEROS.ID_TERCERO AND ID_EXPEDIENTE = ( "
				+ "               SELECT ID_EXPEDIENTE FROM AB59.AB5901T00 WHERE ID_SANCION = ? " + "           ) "
				+ "       ) AND TIPO_PARTICIPANTE = 0 " + "   ) " + " ) "
				+ " AND propuestaSancion.ID_ESTADO_PRO_SAN IN ( "
				+ "   SELECT ID_ESTADO_PRO_SAN FROM AB59.AB5918T00 WHERE ID_PROCEDIMIENTO IN ( "
				+ "     SELECT ID_PROCEDIMIENTO FROM PROCEDIMIENTOS WHERE COD_PROCEDURE_ID IN (?, ?)"
				+ "   ) AND (UPPER(DESCRIPCION_CASTELLANO) LIKE '%VALIDADA%' OR UPPER(DESCRIPCION_CASTELLANO) LIKE '%PENDIENTE%') "
				+ " ) "
				+ " AND propuestaSancion.ID_PROPUESTA_SANCION NOT IN (SELECT ID_PROPUESTA_SANCION FROM AB5906T00 WHERE ID_SANCION = ?) ";

		return this.jdbcTemplate.queryForRowSet(query,
				new Object[] { idSancion, Constantes.COD_PROCEDURE_SANCIONES_TURISMO,
						Constantes.COD_PROCEDURE_SANCIONES_COMERCIO, idSancion },
				new int[] { Types.INTEGER, Types.VARCHAR, Types.VARCHAR, Types.INTEGER });

	}

}
