package com.ejie.ab59.dao.propuestasSancion;

import java.util.Date;
import java.util.List;

import org.springframework.jdbc.support.rowset.SqlRowSet;

import com.ejie.ab59.model.propuestasSancion.PropuestasSancion;
import com.ejie.ab59.model.sanciones.RelSanProSan;
import com.ejie.x38.dto.TableRequestDto;

/**
 * PropuestasSancionDao  
 * 
 *  
 */

public interface PropuestasSancionDao {

	/**
	 * Inserts a single row in the PropuestasSancion table.
	 *
	 * @param propuestassancion
	 *            PropuestasSancion
	 * @return PropuestasSancion
	 */
	PropuestasSancion add(PropuestasSancion propuestassancion);

	/**
	 * Updates a single row in the PropuestasSancion table.
	 *
	 * @param propuestassancion
	 *            PropuestasSancion
	 * @return PropuestasSancion
	 */
	PropuestasSancion update(PropuestasSancion propuestassancion);

	/**
	 * Finds a single row in the PropuestasSancion table.
	 *
	 * @param propuestassancion
	 *            PropuestasSancion
	 * @return PropuestasSancion
	 */
	PropuestasSancion find(PropuestasSancion propuestassancion);

	PropuestasSancion findSinExpediente(PropuestasSancion propuestaSancion);

	/**
	 * Removes a single row in the PropuestasSancion table.
	 *
	 * @param propuestassancion
	 *            PropuestasSancion
	 */
	void remove(PropuestasSancion propuestassancion);

	/**
	 * Finds a List of rows in the PropuestasSancion table.
	 *
	 * @param propuestassancion
	 *            PropuestasSancion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<PropuestasSancion> findAll(PropuestasSancion propuestassancion, TableRequestDto tableRequestDto);

	/**
	 * Counts rows in the PropuestasSancion table.
	 *
	 * @param propuestassancion
	 *            PropuestasSancion
	 * @return Long
	 */
	Long findAllCount(PropuestasSancion propuestassancion);

	/**
	 * Counts rows in the PropuestasSancion table.
	 *
	 * @param idPropuestasSancion
	 *            Integer
	 * 
	 * @return Long
	 */
	Long validarEstadoValidadaOSancionador(Integer idPropuestasSancion);

	/**
	 * Counts rows in the PropuestasSancion table.
	 *
	 * @param idPropuestasSancion
	 *            Integer
	 * 
	 * @return Long
	 */
	Long validarExistePropuesta(Integer idPropuestasSancion);

	/**
	 * Updates a single row in the PropuestasSancion table.
	 *
	 * @param propuestassancion
	 *            PropuestasSancion
	 * 
	 * @return PropuestasSancion
	 */
	PropuestasSancion updatePropuestaSancion(PropuestasSancion propuestasSancion);

	PropuestasSancion updateEstadoProSan(PropuestasSancion propuestasSancion);

	RelSanProSan obtenerCabeceraPropuestaSancion(Integer idPropuestaSancion);

	PropuestasSancion updateFolderIdEstado(PropuestasSancion propuestaSancion);

	Date findFechaAperturaMasActual(Integer idExpediente);

	PropuestasSancion findByAnio(String anio);

	/**
	 * Busqueda de propuestas de sancion pendientes de decision o validada por
	 * direccion de un mismo titular
	 */
	SqlRowSet findPropuestasPendientesMismoTitular(Integer idPropuestaSancion);

	SqlRowSet findPropuestasPendientesMismoTitularBySancion(Integer idSancion);
}
