package com.ejie.ab59.dao.propuestasSancion;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.model.procedimientos.Procedimientos;
import com.ejie.ab59.model.propuestasSancion.EstadosProSan;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * EstadosProSanDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class EstadosProSanDaoImpl implements EstadosProSanDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDESTADOPROSAN", "DESCRIPCIONCASTELLANO",
			"DESCRIPCIONEUSKERA", "DESCPROCEDIMIENTOCAS", "DESCPROCEDIMIENTOEUS", "PORDEFECTO" };

	private JdbcTemplate jdbcTemplate;

	private RowMapper<EstadosProSan> rwMap = new RowMapper<EstadosProSan>() {
		public EstadosProSan mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			EstadosProSan estadoProSan = new EstadosProSan();
			estadoProSan.setIdEstadoProSan(resultSet.getInt("IDESTADOPROSAN"));
			estadoProSan.setDescripcionCastellano(resultSet.getString("DESCRIPCIONCASTELLANO"));
			estadoProSan.setDescripcionEuskera(resultSet.getString("DESCRIPCIONEUSKERA"));
			estadoProSan.setPorDefecto(resultSet.getInt("PORDEFECTO"));

			Procedimientos procedimiento = new Procedimientos();
			procedimiento.setIdProcedimiento(resultSet.getInt("IDPROCEDIMIENTO"));
			estadoProSan.setProcedimiento(procedimiento);

			return estadoProSan;
		}
	};

	private RowMapper<EstadosProSan> rwMapFilter = new RowMapper<EstadosProSan>() {
		public EstadosProSan mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			EstadosProSan estadoProSan = new EstadosProSan();
			estadoProSan.setIdEstadoProSan(resultSet.getInt("IDESTADOPROSAN"));
			estadoProSan.setDescripcionCastellano(resultSet.getString("DESCRIPCIONCASTELLANO"));
			estadoProSan.setDescripcionEuskera(resultSet.getString("DESCRIPCIONEUSKERA"));
			estadoProSan.setPorDefecto(resultSet.getInt("PORDEFECTO"));
			estadoProSan.setProteger(resultSet.getInt("PROTEGER"));

			Procedimientos procedimiento = new Procedimientos();
			procedimiento.setIdProcedimiento(resultSet.getInt("IDPROCEDIMIENTO"));
			procedimiento.setDescripcionEs(resultSet.getString("DESCPROCEDIMIENTOCAS"));
			procedimiento.setDescripcionEu(resultSet.getString("DESCPROCEDIMIENTOEUS"));
			estadoProSan.setProcedimiento(procedimiento);

			return estadoProSan;
		}
	};

	private RowMapper<EstadosProSan> rwMapPK = new RowMapper<EstadosProSan>() {
		public EstadosProSan mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new EstadosProSan(resultSet.getInt("IDESTADOPROSAN"));
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	@Override
	public List<EstadosProSan> cargarCombo(EstadosProSan estadosProSan) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_ESTADO_PRO_SAN IDESTADOPROSAN, t1.ID_PROCEDIMIENTO IDPROCEDIMIENTO, t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA, t1.POR_DEFECTO PORDEFECTO ");
		query.append("FROM ESTADOS_PRO_SAN t1");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(estadosProSan);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<EstadosProSan>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	@Override
	public List<EstadosProSan> findAll(EstadosProSan filterEstadosProSan, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder();

		query.append(
				"SELECT t1.ID_ESTADO_PRO_SAN IDESTADOPROSAN, t6101.ID_PROCEDIMIENTO IDPROCEDIMIENTO, t6101.DESCRIPCION_CASTELLANO DESCPROCEDIMIENTOCAS, t6101.DESCRIPCION_EUSKERA DESCPROCEDIMIENTOEUS");
		query.append(
				", t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA, t1.POR_DEFECTO PORDEFECTO, t1.PROTEGER PROTEGER");
		query.append(" FROM ESTADOS_PRO_SAN t1");
		query.append(" INNER JOIN PROCEDIMIENTOS t6101 ON t1.ID_PROCEDIMIENTO = t6101.ID_PROCEDIMIENTO");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(filterEstadosProSan);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMapFilter, params.toArray());
	}

	@Override
	public Long findAllCount(EstadosProSan estadosProSan) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1)");
		query.append(" FROM ESTADOS_PRO_SAN t1");
		query.append(" INNER JOIN PROCEDIMIENTOS t6101 ON t1.ID_PROCEDIMIENTO = t6101.ID_PROCEDIMIENTO");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(estadosProSan);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	@Override
	public Integer comprobarPorDefecto(Integer idProcedimiento) {
		String query = "SELECT COUNT(1) FROM ESTADOS_PRO_SAN WHERE ID_PROCEDIMIENTO = ? AND POR_DEFECTO = ?";

		return this.jdbcTemplate.queryForInt(query, idProcedimiento, Constantes.ESTADO_POR_DEFECTO);
	}

	@Override
	public EstadosProSan findPorDefecto(Procedimientos procedimiento) {
		String query = "SELECT ID_ESTADO_PRO_SAN IDESTADOPROSAN FROM ESTADOS_PRO_SAN WHERE ID_PROCEDIMIENTO = ? AND POR_DEFECTO = ?";

		List<EstadosProSan> listaEstadosProSan = this.jdbcTemplate.query(query, this.rwMapPK,
				procedimiento.getIdProcedimiento(), Constantes.ESTADO_POR_DEFECTO);

		if (!listaEstadosProSan.isEmpty()) {
			return DataAccessUtils.uniqueResult(listaEstadosProSan);
		} else {
			return null;
		}

	}

	public EstadosProSan add(EstadosProSan estadoProSan) {
		String query = "INSERT INTO ESTADOS_PRO_SAN (ID_ESTADO_PRO_SAN, ID_PROCEDIMIENTO, DESCRIPCION_CASTELLANO, DESCRIPCION_EUSKERA, FECHA_REGISTRO, USUARIO_REGISTRO, POR_DEFECTO) VALUES (?,?,?,?,?,?,?)";

		estadoProSan.setIdEstadoProSan(
				this.jdbcTemplate.queryForObject("SELECT AB59.S_AB5918T00.NEXTVAL FROM DUAL", Integer.class));

		this.jdbcTemplate.update(query, estadoProSan.getIdEstadoProSan(),
				estadoProSan.getProcedimiento().getIdProcedimiento(), estadoProSan.getDescripcionCastellano(),
				estadoProSan.getDescripcionEuskera(), estadoProSan.getFechaRegistro(),
				estadoProSan.getUsuarioRegistro(), estadoProSan.getPorDefecto());
		return estadoProSan;
	}

	public EstadosProSan update(EstadosProSan estadoProSan) {
		String query = "UPDATE ESTADOS_PRO_SAN SET ID_PROCEDIMIENTO = ?, DESCRIPCION_CASTELLANO = ?, DESCRIPCION_EUSKERA = ?, POR_DEFECTO = ? WHERE ID_ESTADO_PRO_SAN = ?";
		this.jdbcTemplate.update(query, estadoProSan.getProcedimiento().getIdProcedimiento(),
				estadoProSan.getDescripcionCastellano(), estadoProSan.getDescripcionEuskera(),
				estadoProSan.getPorDefecto(), estadoProSan.getIdEstadoProSan());
		return estadoProSan;
	}

	public void remove(EstadosProSan estadoProSan) {
		String query = "DELETE FROM ESTADOS_PRO_SAN WHERE ID_ESTADO_PRO_SAN=?";
		this.jdbcTemplate.update(query, estadoProSan.getIdEstadoProSan());

	}

	@Override
	public EstadosProSan find(EstadosProSan estadoProSan) {
		String query = "SELECT t1.ID_ESTADO_PRO_SAN IDESTADOPROSAN, t1.ID_PROCEDIMIENTO IDPROCEDIMIENTO, t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA, t1.POR_DEFECTO PORDEFECTO FROM ESTADOS_PRO_SAN t1 WHERE t1.ID_ESTADO_PRO_SAN = ?";

		List<EstadosProSan> estadosProSanList = this.jdbcTemplate.query(query, this.rwMap,
				estadoProSan.getIdEstadoProSan());

		return DataAccessUtils.uniqueResult(estadosProSanList);
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the PropuestasSancion entity
	 *
	 * @param propuestassancion
	 *            RelExpDir Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(EstadosProSan estadosProSan) {

		StringBuilder where = new StringBuilder(EstadosProSanDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		/* ID PROCEDIMIENTO */
		if (estadosProSan != null && estadosProSan.getProcedimiento() != null
				&& estadosProSan.getProcedimiento().getIdProcedimiento() != null) {
			where.append(" AND t1.ID_PROCEDIMIENTO = ? ");
			params.add(estadosProSan.getProcedimiento().getIdProcedimiento());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
