package com.ejie.ab59.dao.propuestasSancion;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.dao.tablasMaestras.CalificacionesDaoImpl;
import com.ejie.ab59.model.plantillas.Plantillas;
import com.ejie.ab59.model.propuestasSancion.DocProSan;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class DocProSanDaoImpl implements DocProSanDao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<DocProSan> rwMapByPropuestaSancion = new RowMapper<DocProSan>() {
		public DocProSan mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			DocProSan docProSan = new DocProSan();

			docProSan.setIdDocumento(resultSet.getInt("IDDOCUMENTO"));
			docProSan.setOidPID(resultSet.getString("OIDPID"));
			docProSan.setOidDokusi(resultSet.getString("OIDDOKUSI"));
			docProSan.setNombreDocumento(resultSet.getString("NOMBREDOCUMENTO"));
			docProSan.setAportadoExpediente(resultSet.getInt("APORTADOEXPEDIENTE"));

			Plantillas plantilla = new Plantillas();
			plantilla.setIdPlantilla(resultSet.getInt("IDPLANTILLA"));
			if (resultSet.wasNull()) {
				plantilla.setDescripcionCastellano(resultSet.getString("DESCTIPODOCUMENTO"));
				plantilla.setDescripcionEuskera(resultSet.getString("DESCTIPODOCUMENTO"));
			} else {
				plantilla.setDescripcionCastellano(resultSet.getString("DESCPLANTILLACAS"));
				plantilla.setDescripcionEuskera(resultSet.getString("DESCPLANTILLAEUS"));
			}

			docProSan.setPlantilla(plantilla);

			return docProSan;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the DocProSan table.
	 *
	 * @param docProSan
	 *            DocProSan
	 * @return DocProSan
	 */
	public DocProSan add(DocProSan docProSan) {

		String query = "INSERT INTO DOC_PRO_SAN (ID_DOCUMENTO, ID_PROPUESTA_SANCION, OID_PID, APORTADO_EXPEDIENTE, NOMBRE_DOCUMENTO, OID_DOKUSI, DESC_TIPO_DOCUMENTO, ID_PLANTILLA, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (?,?,?,?,?,?,?,?,SYSDATE,?)";

		docProSan.setIdDocumento(
				this.jdbcTemplate.queryForObject("SELECT AB59.S_AB5915T00.NEXTVAL FROM DUAL", Integer.class));

		Object getPropuestaSancion = null;
		if (docProSan.getPropuestaSancion() != null
				&& docProSan.getPropuestaSancion().getIdPropuestaSancion() != null) {
			getPropuestaSancion = docProSan.getPropuestaSancion().getIdPropuestaSancion();
		}
		Object getPlantilla = null;
		if (docProSan.getPlantilla() != null && docProSan.getPlantilla().getIdPlantilla() != null) {
			getPlantilla = docProSan.getPlantilla().getIdPlantilla();
		}

		this.jdbcTemplate.update(query, docProSan.getIdDocumento(), getPropuestaSancion, docProSan.getOidPID(),
				docProSan.getAportadoExpediente(), docProSan.getNombreDocumento(), docProSan.getOidDokusi(),
				docProSan.getDescTipoDocumento(), getPlantilla, docProSan.getUsuarioRegistro());

		return docProSan;
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Removes a single row in the ArtInfProSan table.
	 *
	 * @param idPropuestaSancion
	 *            Integer
	 * @return
	 */
	public void removeByPropuestaSancion(Integer idPropuestaSancion) {

		String query = "DELETE FROM DOC_PRO_SAN WHERE ID_PROPUESTA_SANCION = ?";
		this.jdbcTemplate.update(query, idPropuestaSancion);

	}

	/**
	 * Finds a list of rows in the DocProSan table.
	 *
	 * @param docProSan
	 *            DocProSan
	 * @param tableRequestDto
	 *            TableRequestDto
	 * 
	 * @return List<DocProSan>
	 */
	@Transactional(readOnly = true)
	public List<DocProSan> findByPropuestaSancion(DocProSan docProSan, TableRequestDto tableRequestDto) {

		StringBuilder query = new StringBuilder();

		query.append("SELECT t5915.ID_DOCUMENTO IDDOCUMENTO, t5915.OID_PID OIDPID, t5915.OID_DOKUSI OIDDOKUSI");
		query.append(", t5915.NOMBRE_DOCUMENTO NOMBREDOCUMENTO, t5915.APORTADO_EXPEDIENTE APORTADOEXPEDIENTE");
		query.append(
				", t5915.ID_PLANTILLA IDPLANTILLA, t5915.DESC_TIPO_DOCUMENTO DESCTIPODOCUMENTO, t6110.DESCRIPCION_CASTELLANO DESCPLANTILLACAS, t6110.DESCRIPCION_EUSKERA DESCPLANTILLAEUS");
		query.append(" FROM DOC_PRO_SAN t5915");
		query.append(" LEFT OUTER JOIN PLANTILLAS t6110 ON t5915.ID_PLANTILLA = t6110.ID_PLANTILLA");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapByPropuestaSancion(docProSan);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMapByPropuestaSancion, params.toArray());
	}

	/**
	 * Counts rows in the DocProSan table.
	 *
	 * @param docProSan
	 *            DocProSan
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findByPropuestaSancionCount(DocProSan docProSan) {

		StringBuilder query = new StringBuilder();

		query.append("SELECT COUNT(1)");
		query.append(" FROM DOC_PRO_SAN t5915");
		query.append(" LEFT OUTER JOIN PLANTILLAS t6110 ON t5915.ID_PLANTILLA = t6110.ID_PLANTILLA");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapByPropuestaSancion(docProSan);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the DocProSan entity
	 *
	 * @param docProSan
	 *            DocProSan Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMapByPropuestaSancion(DocProSan docProSan) {

		StringBuilder where = new StringBuilder(CalificacionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (docProSan != null && docProSan.getPropuestaSancion() != null
				&& docProSan.getPropuestaSancion().getIdPropuestaSancion() != null) {
			where.append(" AND t5915.ID_PROPUESTA_SANCION = ?");
			params.add(docProSan.getPropuestaSancion().getIdPropuestaSancion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Updates a single row in the DocProSan table.
	 *
	 * @param docProSan
	 *            DocProSan
	 * 
	 * @return DocProSan
	 */
	public DocProSan updateAportadoExpediente(DocProSan docProSan) {

		String query = "UPDATE DOC_PRO_SAN SET APORTADO_EXPEDIENTE = ?, FECHA_ULTMODIFICACION = SYSDATE, USUARIO_ULTMODIFICACION = ? WHERE ID_DOC_PRO_SAN = ?";

		this.jdbcTemplate.update(query, docProSan.getAportadoExpediente(), docProSan.getUsuarioUltmodificacion(),
				docProSan.getIdDocumento());

		return docProSan;
	}
}
