package com.ejie.ab59.dao.procedimientos;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.model.procedimientos.Aplicaciones;
import com.ejie.ab59.model.procedimientos.Direcciones;
import com.ejie.ab59.model.procedimientos.Procedimientos;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class ProcedimientosDaoImpl implements ProcedimientosDao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Procedimientos> rwMapCombo = new RowMapper<Procedimientos>() {
		public Procedimientos mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Procedimientos procedimientos = new Procedimientos();
			procedimientos.setIdProcedimiento(resultSet.getInt("IDPROCEDIMIENTO"));
			procedimientos.setDescripcionEs(resultSet.getString("DESCRIPCIONCASTELLANO"));
			procedimientos.setDescripcionEu(resultSet.getString("DESCRIPCIONEUSKERA"));
			procedimientos.setCodProcedureId(resultSet.getString("CODPROCEDUREID"));

			return procedimientos;
		}
	};

	private RowMapper<Procedimientos> rwMap = new RowMapper<Procedimientos>() {
		public Procedimientos mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Procedimientos(resultSet.getInt("IDPROCEDIMIENTO"), resultSet.getString("CODPROCEDUREID"),
					resultSet.getString("CAMPOSTITULOEXPEDIENTE"), resultSet.getString("USUARIOREGISTRO"),
					new Direcciones(resultSet.getInt("IDDIRECCION")), resultSet.getString("DESCRIPCIONCASTELLANO"),
					resultSet.getString("DESCRIPCIONEUSKERA"),
					new Aplicaciones(null, null, null, resultSet.getString("URLAPLICACION")));
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a list of rows in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * 
	 * @return List<Procedimientos>
	 */
	@Transactional(readOnly = true)
	public List<Procedimientos> cargarComboProcedimientosInicioOficio(Procedimientos procedimientos) {
		StringBuilder query = new StringBuilder();
		List<Object> params = new ArrayList<Object>();

		query.append(
				"SELECT  t1.ID_PROCEDIMIENTO IDPROCEDIMIENTO, t1.COD_PROCEDURE_ID CODPROCEDUREID, t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA");
		query.append(" FROM PROCEDIMIENTOS t1, APLICACIONES t2 ");
		query.append(
				" WHERE 1=1 AND t1.ID_APLICACION = t2.ID_APLICACION(+) AND t1.INICIO_OFICIO = ? AND t2.CODIGO_APLICACION = ? ");
		params.add(procedimientos.getInicioOficio());
		params.add(procedimientos.getAplicacion().getCodigoAplicacion());

		return this.jdbcTemplate.query(query.toString(), this.rwMapCombo, params.toArray());
	}

	@Transactional(readOnly = true)
	public List<Procedimientos> cargarComboProcedimientos(Procedimientos procedimientos) {
		StringBuilder query = new StringBuilder();
		List<Object> params = new ArrayList<Object>();

		query.append(
				"SELECT  t1.ID_PROCEDIMIENTO IDPROCEDIMIENTO, t1.COD_PROCEDURE_ID CODPROCEDUREID, t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA");
		query.append(" FROM PROCEDIMIENTOS t1, APLICACIONES t2 ");
		query.append(" WHERE 1=1 AND t1.ID_APLICACION = t2.ID_APLICACION(+) AND t2.CODIGO_APLICACION = ? ");
		params.add(procedimientos.getAplicacion().getCodigoAplicacion());

		return this.jdbcTemplate.query(query.toString(), this.rwMapCombo, params.toArray());
	}

	@Override
	public Procedimientos obtenerProcedimientos(Integer idDireccion) {
		String query = "SELECT t1.ID_PROCEDIMIENTO IDPROCEDIMIENTO, t1.ID_DIRECCION IDDIRECCION, t1.COD_PROCEDURE_ID CODPROCEDUREID, "
				+ " t1.CAMPOS_TITULO_EXPEDIENTE CAMPOSTITULOEXPEDIENTE, t1.FECHA_REGISTRO FECHAREGISTRO, t1.USUARIO_REGISTRO USUARIOREGISTRO, "
				+ " t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA, "
				+ " t2.URL_APLICACION URLAPLICACION FROM PROCEDIMIENTOS t1, APLICACIONES t2 "
				+ " WHERE t1.ID_APLICACION = t2.ID_APLICACION(+) AND t1.ID_DIRECCION = ? AND t2.CODIGO_APLICACION = ? ";

		List<Object> params = new ArrayList<Object>();
		params.add(idDireccion);
		params.add(Constantes.CODIGO_APLICACION.toUpperCase());

		List<Procedimientos> procedimientosList = this.jdbcTemplate.query(query, this.rwMap, params.toArray());
		return DataAccessUtils.uniqueResult(procedimientosList);
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public Procedimientos find(Procedimientos procedimiento) {
		String query = "SELECT t6101.ID_PROCEDIMIENTO IDPROCEDIMIENTO, t6101.ID_DIRECCION IDDIRECCION, t6101.COD_PROCEDURE_ID CODPROCEDUREID, t6101.CAMPOS_TITULO_EXPEDIENTE CAMPOSTITULOEXPEDIENTE, t6101.FECHA_REGISTRO FECHAREGISTRO, t6101.USUARIO_REGISTRO USUARIOREGISTRO, t6101.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t6101.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA, t6146.URL_APLICACION URLAPLICACION FROM PROCEDIMIENTOS t6101, APLICACIONES t6146 WHERE t6101.ID_APLICACION = t6146.ID_APLICACION(+) AND t6101.ID_PROCEDIMIENTO = ? ";

		List<Procedimientos> listaProcedimientos = this.jdbcTemplate.query(query, this.rwMap,
				procedimiento.getIdProcedimiento());
		return DataAccessUtils.uniqueResult(listaProcedimientos);
	}
}
