package com.ejie.ab59.dao.procedimientos;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.model.procedimientos.Direcciones;

/**
 * DireccionesDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class DireccionesDaoImpl implements DireccionesDao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */

	private RowMapper<Direcciones> rwMap = new RowMapper<Direcciones>() {
		@Override
		public Direcciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Direcciones direcciones = new Direcciones();
			direcciones.setIdDireccion(resultSet.getInt("IDDIRECCION"));

			return direcciones;
		}
	};

	private RowMapper<Direcciones> rwMapCombo = new RowMapper<Direcciones>() {
		@Override
		public Direcciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Direcciones direcciones = new Direcciones();
			direcciones.setIdDireccion(resultSet.getInt("IDDIRECCION"));
			direcciones.setDescripcionCastellano(resultSet.getString("DESCRIPCIONCASTELLANO"));
			direcciones.setDescripcionEuskera(resultSet.getString("DESCRIPCIONEUSKERA"));

			return direcciones;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a list of rows in the Direcciones table.
	 *
	 * @param direcciones
	 *            Direcciones
	 * 
	 * @return List<Infracciones>
	 */
	@Override
	@Transactional(readOnly = true)
	public List<Direcciones> cargarCombo(Direcciones direcciones) {
		StringBuilder query = new StringBuilder(
				"SELECT t6113.ID_DIRECCION IDDIRECCION, t6113.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t6113.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA FROM DIRECCIONES t6113 WHERE t6113.FECHA_BAJA IS NULL");

		return this.jdbcTemplate.query(query.toString(), this.rwMapCombo);
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public Direcciones findByIdExpediente(Integer idExpediente) {
		String query = "SELECT t6101.ID_DIRECCION IDDIRECCION FROM PROCEDIMIENTOS t6101, EXPEDIENTES t6102 WHERE t6102.ID_PROCEDIMIENTO = t6101.ID_PROCEDIMIENTO AND t6102.ID_EXPEDIENTE = ?";

		List<Direcciones> direccionesList = this.jdbcTemplate.query(query, this.rwMap, idExpediente);

		if (!direccionesList.isEmpty()) {
			return DataAccessUtils.uniqueResult(direccionesList);
		} else {
			return null;
		}

	}
}
