package com.ejie.ab59.dao.plantillas;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.model.plantillas.Plantillas;
import com.ejie.ab59.model.plantillas.RelExpPla;
import com.ejie.ab59.model.sanciones.TiposPlantilla;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class RelExpPlaDaoImpl implements RelExpPlaDao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<RelExpPla> rwMap = new RowMapper<RelExpPla>() {
		public RelExpPla mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			RelExpPla relExpPla = new RelExpPla();
			relExpPla.setRuta(resultSet.getString("RUTA"));

			Plantillas plantillaAux = new Plantillas();
			plantillaAux.setIdPlantilla(resultSet.getInt("IDPLANTILLA"));
			plantillaAux.setDescripcionCastellano(resultSet.getString("DESCPLANTILLACAS"));
			plantillaAux.setDescripcionEuskera(resultSet.getString("DESCPLANTILLAEUS"));
			TiposPlantilla tipoPlantillaAux = new TiposPlantilla();
			tipoPlantillaAux.setTaskId(resultSet.getString("TASKID"));
			plantillaAux.setTipoPlantilla(tipoPlantillaAux);
			relExpPla.setPlantilla(plantillaAux);

			return relExpPla;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a list of rows in the RelExpPla table.
	 *
	 * @param relExpPla
	 *            RelExpPla
	 * @param tableRequestDto
	 *            TableRequestDto
	 * 
	 * @return List<RelExpPla>
	 */
	public List<RelExpPla> findAll(RelExpPla relExpPla, TableRequestDto tableRequestDto) {

		StringBuilder query = new StringBuilder();
		List<Object> params = new ArrayList<Object>();

		query.append(
				"SELECT t6110.ID_PLANTILLA IDPLANTILLA, t6110.DESCRIPCION_CASTELLANO DESCPLANTILLACAS, t6110.DESCRIPCION_EUSKERA DESCPLANTILLAEUS");
		query.append(", t6133.RUTA RUTA, t6111.TASK_ID TASKID");
		query.append(" FROM REL_EXP_PLA t6133");
		query.append(" RIGHT OUTER JOIN PLANTILLAS t6110  ON t6133.ID_PLANTILLA = t6110.ID_PLANTILLA");
		query.append(" AND t6133.IDENTIFICADOR = ?");
		params.add(relExpPla.getIdentificador());
		query.append(" INNER JOIN TIPOS_PLANTILLA t6111 ON t6110.ID_TIPO_PLANTILLA = t6111.ID_TIPO_PLANTILLA");
		query.append(" WHERE t6110.ID_PROCEDIMIENTO = ?");
		params.add(relExpPla.getProcedimiento().getIdProcedimiento());
		query.append(" AND t6110.ORIGEN = ?");
		params.add(relExpPla.getPlantilla().getOrigen());

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the RelExpPla table.
	 *
	 * @param relExpPla
	 *            RelExpPla
	 * 
	 * @return Long
	 */
	public Long findAllCount(RelExpPla relExpPla) {

		StringBuilder query = new StringBuilder();
		List<Object> params = new ArrayList<Object>();

		query.append("SELECT COUNT(1)");
		query.append(" FROM REL_EXP_PLA t6133");
		query.append(" RIGHT OUTER JOIN PLANTILLAS t6110  ON t6133.ID_PLANTILLA = t6110.ID_PLANTILLA");
		query.append(" AND t6133.ID_EXPEDIENTE = ?");
		params.add(relExpPla.getExpediente().getIdExpediente());
		query.append(" WHERE t6110.ID_PROCEDIMIENTO = ?");
		params.add(relExpPla.getProcedimiento().getIdProcedimiento());
		query.append(" AND t6110.ORIGEN = ?");
		params.add(relExpPla.getPlantilla().getOrigen());

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}
}
