package com.ejie.ab59.dao.plantillas;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.model.plantillas.ParametrosConfig;

/**
 * 
 *  
 *
 */

@Repository
@Transactional
public class ParametrosConfigDaoImpl implements ParametrosConfigDao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<ParametrosConfig> rwMap = new RowMapper<ParametrosConfig>() {
		public ParametrosConfig mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			ParametrosConfig parametrosConfig = new ParametrosConfig();
			parametrosConfig.setValor(resultSet.getString("VALOR"));

			return parametrosConfig;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Buscamos el valor para saber la configuacion de la vista de plantilla
	 * 
	 * @return ParametrosConfig parametrosConfig
	 */
	public ParametrosConfig find(ParametrosConfig parametrosConfig) {

		String query = "SELECT VALOR AS VALOR FROM PARAMETROS_CONFIG WHERE  DESCRIPCION = ?";

		List<ParametrosConfig> parametrosConfigList = this.jdbcTemplate.query(query, this.rwMap,
				parametrosConfig.getDescripcion());

		return DataAccessUtils.uniqueResult(parametrosConfigList);

	}
}
