package com.ejie.ab59.dao.pagos;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.model.expedientes.Expedientes;
import com.ejie.ab59.model.pagos.SituacionExpediente;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * SituacionExpedienteDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class SituacionExpedienteDaoImpl implements SituacionExpedienteDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDSITUACIONEXPEDIENTE", "IDEXPEDIENTE",
			"ENVIARCARTAPAGO", "IDTIPOLIQUIDACION" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<SituacionExpediente> rwMap = new RowMapper<SituacionExpediente>() {
		public SituacionExpediente mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			SituacionExpediente retorno = new SituacionExpediente();
			retorno.setIdSituacionExpediente((resultSet.getObject("IDSITUACIONEXPEDIENTE") != null
					? resultSet.getInt("IDSITUACIONEXPEDIENTE") : null));
			retorno.setIdTipoLiquidacion(
					(resultSet.getObject("IDTIPOLIQUIDACION") != null ? resultSet.getInt("IDTIPOLIQUIDACION") : null));
			retorno.setEnviarCartaPago(
					(resultSet.getObject("ENVIARCARTAPAGO") != null ? resultSet.getInt("ENVIARCARTAPAGO") : null));

			Expedientes expediente = null;
			if (resultSet.getObject("IDEXPEDIENTE") != null) {

				expediente = new Expedientes();
				expediente.setIdExpediente(resultSet.getInt("IDEXPEDIENTE"));
			}
			retorno.setExpediente(expediente);

			return retorno;
		}
	};

	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	public SituacionExpediente add(SituacionExpediente situacionExpediente) {
		String query = "INSERT INTO SITUACION_EXPEDIENTE (ID_SITUACION_EXPEDIENTE, ID_EXPEDIENTE, ENVIAR_CARTA_PAGO, ID_TIPO_LIQUIDACION, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (?,?,?,?,SYSDATE,?)";

		situacionExpediente.setIdSituacionExpediente(
				this.jdbcTemplate.queryForObject("SELECT AB61.S_AB6193T00.NEXTVAL FROM DUAL", Integer.class));

		Object getExpediente = null;
		if (situacionExpediente.getExpediente() != null
				&& situacionExpediente.getExpediente().getIdExpediente() != null) {
			getExpediente = situacionExpediente.getExpediente().getIdExpediente();
		}

		this.jdbcTemplate.update(query, situacionExpediente.getIdSituacionExpediente(), getExpediente,
				situacionExpediente.getEnviarCartaPago(), situacionExpediente.getIdTipoLiquidacion(),
				situacionExpediente.getUsuarioRegistro());
		return situacionExpediente;
	}

	@Override
	public SituacionExpediente update(SituacionExpediente situacionExpediente) {
		String query = "UPDATE SITUACION_EXPEDIENTE SET ENVIAR_CARTA_PAGO = ?, ID_TIPO_LIQUIDACION = ?, FECHA_ULTMODIFICACION = SYSDATE, USUARIO_ULTMODIFICACION = ? WHERE ID_SITUACION_EXPEDIENTE = ?";
		this.jdbcTemplate.update(query, situacionExpediente.getEnviarCartaPago(),
				situacionExpediente.getIdTipoLiquidacion(), situacionExpediente.getUsuarioUltmodificacion(),
				situacionExpediente.getIdSituacionExpediente());
		return situacionExpediente;
	}

	@Transactional(readOnly = true)
	public SituacionExpediente find(SituacionExpediente situacionexpediente) {
		String query = "SELECT t1.ID_SITUACION_EXPEDIENTE IDSITUACIONEXPEDIENTE, t1.ID_EXPEDIENTE IDEXPEDIENTE, t1.ENVIAR_CARTA_PAGO ENVIARCARTAPAGO, "
				+ " t1.ID_TIPO_LIQUIDACION IDTIPOLIQUIDACION, t1.FECHA_REGISTRO FECHAREGISTRO, t1.USUARIO_REGISTRO USUARIOREGISTRO, "
				+ " t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION "
				+ " FROM SITUACION_EXPEDIENTE t1 " + " WHERE t1.ID_SITUACION_EXPEDIENTE = ?  ";

		List<SituacionExpediente> situacionexpedienteList = this.jdbcTemplate.query(query, this.rwMap,
				situacionexpediente.getIdSituacionExpediente());
		return DataAccessUtils.uniqueResult(situacionexpedienteList);
	}

	@Transactional(readOnly = true)
	public List<SituacionExpediente> findAllLike(SituacionExpediente situacionexpediente,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_SITUACION_EXPEDIENTE IDSITUACIONEXPEDIENTE,t1.ID_EXPEDIENTE IDEXPEDIENTE,t1.ENVIAR_CARTA_PAGO ENVIARCARTAPAGO,"
						+ " t1.ID_TIPO_LIQUIDACION IDTIPOLIQUIDACION,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,"
						+ " t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		query.append("FROM SITUACION_EXPEDIENTE t1 ");

		Map<String, ?> mapaWhere = this.getWhereLikeMap(situacionexpediente, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query,
					SituacionExpedienteDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	@Transactional(readOnly = true)
	public Long findAllLikeCount(SituacionExpediente situacionexpediente, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM SITUACION_EXPEDIENTE t1 ");

		Map<String, ?> mapaWhere = this.getWhereLikeMap(situacionexpediente, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	private Map<String, Object> getWhereLikeMap(SituacionExpediente situacionexpediente, Boolean startsWith) {

		StringBuilder where = new StringBuilder(SituacionExpedienteDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (situacionexpediente != null && situacionexpediente.getIdSituacionExpediente() != null) {
			where.append(" AND t1.ID_SITUACION_EXPEDIENTE = ?");
			params.add(situacionexpediente.getIdSituacionExpediente());
		}
		if (situacionexpediente != null && situacionexpediente.getExpediente() != null
				&& situacionexpediente.getExpediente().getIdExpediente() != null) {
			where.append(" AND t1.ID_EXPEDIENTE = ?");
			params.add(situacionexpediente.getExpediente().getIdExpediente());
		}
		if (situacionexpediente != null && situacionexpediente.getEnviarCartaPago() != null) {
			where.append(" AND t1.ENVIAR_CARTA_PAGO = ?");
			params.add(situacionexpediente.getEnviarCartaPago());
		}
		if (situacionexpediente != null && situacionexpediente.getIdTipoLiquidacion() != null) {
			where.append(" AND t1.ID_TIPO_LIQUIDACION = ?");
			params.add(situacionexpediente.getIdTipoLiquidacion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	public static final int STRING_BUILDER_INIT = 4096;
}
